/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.fs;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.mgmt.arc.ArFSDirective;
import com.sun.netstorage.samqfs.mgmt.arc.Archiver;
import com.sun.netstorage.samqfs.mgmt.arc.Criteria;
import com.sun.netstorage.samqfs.mgmt.fs.DiskDev;
import com.sun.netstorage.samqfs.mgmt.fs.FS;
import com.sun.netstorage.samqfs.mgmt.fs.FSInfo;
import com.sun.netstorage.samqfs.mgmt.fs.MountOptions;
import com.sun.netstorage.samqfs.mgmt.fs.SamfsckJob;
import com.sun.netstorage.samqfs.mgmt.fs.StripedGrp;
import com.sun.netstorage.samqfs.web.model.ClusterNodeInfo;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.model.fs.SharedMember;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolCriteriaImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.fs.FileSystemMountPropertiesImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.fs.GenericFileSystemImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.DiskCacheImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.StripedGroupImpl;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;
import java.util.GregorianCalendar;

public class FileSystemImpl
extends GenericFileSystemImpl
implements FileSystem {
    private FSInfo fsInfo = null;
    private SamQFSSystemModelImpl model = null;
    private SamQFSAppModel app = null;
    private int fsType = -1;
    private String fsTypeName = "n/a";
    private int archType = -1;
    private int equipOrdinal = -1;
    private int shareStatus = -1;
    private String serverName = new String();
    private int dauSize = -1;
    private GregorianCalendar timeAboveHWM = null;
    private GregorianCalendar dateCreated = null;
    private FileSystemMountProperties mountProps = null;
    private DiskCache[] metaDevices = new DiskCache[0];
    private DiskCache[] dataDevices = new DiskCache[0];
    private StripedGroup[] stripedGrps = new StripedGroup[0];
    private String logfile = new String();

    public FileSystemImpl() {
    }

    public FileSystemImpl(SamQFSSystemModelImpl model, FSInfo fsInfo) throws SamFSException {
        if (model == null || fsInfo == null) {
            throw new SamFSException("logic.invalidFSParam");
        }
        this.app = SamQFSFactory.getSamQFSAppModel();
        if (this.app == null) {
            throw new SamFSException("internal error: null application model");
        }
        this.model = model;
        this.fsInfo = fsInfo;
        this.hostName = model.getServerHostname();
        this.setup();
    }

    public Ctx getJniContext() {
        return this.model.getJniContext();
    }

    public FSInfo getJniFSInfo() {
        return this.fsInfo;
    }

    public void setJniFSInfo(FSInfo fsInfo) {
        this.fsInfo = fsInfo;
        this.setup();
    }

    public int getFSTypeByProduct() {
        int type = 10;
        if (this.getFSType() == 0) {
            type = this.getArchivingType() == 2 ? 12 : 11;
        }
        return type;
    }

    public String getFSTypeName() {
        return this.fsTypeName;
    }

    public int getFSType() {
        return this.fsType;
    }

    public int getArchivingType() {
        return this.archType;
    }

    public int getEquipOrdinal() {
        return this.equipOrdinal;
    }

    public int getShareStatus() {
        return this.shareStatus;
    }

    public int getDAUSize() {
        return this.dauSize;
    }

    public GregorianCalendar getTimeAboveHWM() {
        return this.timeAboveHWM;
    }

    public void setTimeAboveHWM(GregorianCalendar timeAboveHWM) {
        this.timeAboveHWM = timeAboveHWM;
    }

    public GregorianCalendar getDateCreated() {
        return this.dateCreated;
    }

    public String getServerName() {
        return this.serverName;
    }

    public FileSystemMountProperties getMountProperties() {
        return this.mountProps;
    }

    public DiskCache[] getMetadataDevices() {
        return this.metaDevices;
    }

    public DiskCache[] getDataDevices() {
        return this.dataDevices;
    }

    public StripedGroup[] getStripedGroups() {
        return this.stripedGrps;
    }

    public GenericFileSystem[] getHAFSInstances() throws SamFSMultiHostException {
        ClusterNodeInfo[] nodes = null;
        try {
            nodes = this.model.getClusterNodes();
        }
        catch (SamFSException e) {
            throw new SamFSMultiHostException(e.getMessage());
        }
        ArrayList<FileSystem> fsList = new ArrayList<FileSystem>();
        ArrayList<String> errorHostNames = new ArrayList<String>();
        ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
        String nodeName = null;
        FileSystem fs2 = null;
        for (int n = 0; n < nodes.length; ++n) {
            SamQFSSystemModel sysm;
            try {
                nodeName = nodes[n].getName();
                if (nodeName == null) {
                    TraceUtil.trace1("no name for node " + nodeName);
                    continue;
                }
                sysm = this.app.getSamQFSSystemModel(nodeName);
            }
            catch (SamFSException e) {
                TraceUtil.trace1("no model found for node " + nodeName);
                continue;
            }
            try {
                SamQFSSystemFSManager fsMgr = sysm.getSamQFSSystemFSManager();
                fs2 = fsMgr.getFileSystem(this.getName());
            }
            catch (SamFSException e) {
                errorHostNames.add(nodeName);
                errorExceptions.add(e);
            }
            if (fs2 == null) continue;
            fsList.add(fs2);
        }
        GenericFileSystem[] fsArray = fsList.toArray(new FileSystem[0]);
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]), (Object)fsArray);
        }
        return fsArray;
    }

    public void addJob(BaseJob job) {
    }

    public void removeJob(BaseJob job) {
    }

    public void changeMountOptions() throws SamFSException {
        FS.setMountOpts((Ctx)this.getJniContext(), (String)this.getName(), (MountOptions)((FileSystemMountPropertiesImpl)this.getMountProperties()).getJniMountOptions());
        if (this.getState() == 0) {
            FS.setLiveMountOpts((Ctx)this.getJniContext(), (String)this.getName(), (MountOptions)((FileSystemMountPropertiesImpl)this.getMountProperties()).getJniMountOptions());
        }
        this.fsInfo = FS.get((Ctx)this.getJniContext(), (String)this.getName());
        this.mountProps = new FileSystemMountPropertiesImpl(this.fsInfo.getMountOptions());
        this.mountProps.setFileSystem(this);
    }

    public void mount() throws SamFSException {
        if (this.fsInfo.isShared() && !this.fsInfo.isMdServer()) {
            String serverName = this.fsInfo.getServerName();
            TraceUtil.trace3("Logic: get mdserver name " + serverName);
            if (!serverName.equals("")) {
                SamQFSSystemModel mdserver = this.app.getSamQFSSystemModel(serverName);
                if (mdserver == null) {
                    throw new SamFSException("logic.sharedUnMountedFS.null");
                }
                FSInfo mdsinfo = FS.get((Ctx)((SamQFSSystemModelImpl)mdserver).getJniContext(), (String)this.getName());
                if (!mdsinfo.isMounted()) {
                    throw new SamFSException("logic.sharedUnMountedFS");
                }
            }
        }
        TraceUtil.trace3("Logic: before mounting the fs ");
        FS.mount((Ctx)this.getJniContext(), (String)this.getName());
        this.fsInfo = FS.get((Ctx)this.getJniContext(), (String)this.getName());
        TraceUtil.trace3("Logic: after mounting the fs ");
        this.state = 0;
    }

    public void unmount() throws SamFSException {
        if (this.fsInfo.isShared() && this.fsInfo.isMdServer()) {
            SharedMember[] members;
            block6: {
                SamQFSSystemSharedFSManager fsm = this.app.getSamQFSSystemSharedFSManager();
                members = null;
                try {
                    members = fsm.getSharedMembers(this.model.getHostname(), this.getName());
                }
                catch (SamFSMultiHostException multiEx) {
                    SamFSException[] exs = multiEx.getExceptions();
                    String[] hosts = multiEx.getHostNames();
                    members = (SharedMember[])multiEx.getPartialResult();
                    if (members == null) break block6;
                    for (int i = 0; i < hosts.length; ++i) {
                        if (exs[i].getSAMerrno() == 30132 && !hosts[i].equals(this.fsInfo.getServerName())) continue;
                        throw multiEx;
                    }
                }
            }
            if (members == null) {
                throw new SamFSException("logic.sharedMountedFS.null");
            }
            for (int i = 0; i < members.length; ++i) {
                if (members[i].getType() == 0 || !members[i].isMounted()) continue;
                throw new SamFSException("logic.sharedMountedClient");
            }
        }
        FS.umount((Ctx)this.getJniContext(), (String)this.getName());
        this.fsInfo = FS.get((Ctx)this.getJniContext(), (String)this.getName());
        this.state = 1;
    }

    public void stopFSArchive() throws SamFSException {
        Archiver.stopForFS((Ctx)this.getJniContext(), (String)this.getName());
    }

    public void idleFSArchive() throws SamFSException {
        Archiver.idleForFS((Ctx)this.getJniContext(), (String)this.getName());
    }

    public void runFSArchive() throws SamFSException {
        Archiver.runForFS((Ctx)this.getJniContext(), (String)this.getName());
    }

    public void grow(DiskCache[] metadata, DiskCache[] data, StripedGroup[] groups) throws SamFSException {
        int i;
        DiskDev[] diskDevs = new DiskDev[]{};
        DiskDev[] metaDevs = new DiskDev[]{};
        StripedGrp[] grps = new StripedGrp[]{};
        if (data != null && data.length > 0) {
            diskDevs = new DiskDev[data.length];
            for (i = 0; i < data.length; ++i) {
                diskDevs[i] = ((DiskCacheImpl)data[i]).getJniDisk();
            }
        }
        if (metadata != null && metadata.length > 0) {
            metaDevs = new DiskDev[metadata.length];
            for (i = 0; i < metadata.length; ++i) {
                metaDevs[i] = ((DiskCacheImpl)metadata[i]).getJniDisk();
            }
        }
        if (groups != null && groups.length > 0) {
            grps = new StripedGrp[groups.length];
            for (i = 0; i < groups.length; ++i) {
                grps[i] = ((StripedGroupImpl)groups[i]).getJniStripedGroup();
            }
        }
        FS.grow((Ctx)this.getJniContext(), (FSInfo)this.getJniFSInfo(), (DiskDev[])metaDevs, (DiskDev[])diskDevs, (StripedGrp[])grps);
        this.fsInfo = FS.get((Ctx)this.getJniContext(), (String)this.getName());
        this.setup();
    }

    public long samfsck(boolean checkAndRepair, String logFilePath) throws SamFSException {
        FS.fsck((Ctx)this.getJniContext(), (String)this.getName(), (String)logFilePath, (boolean)checkAndRepair);
        long jobId = -1L;
        SamfsckJob[] jniJobs = null;
        try {
            jniJobs = SamfsckJob.getAll((Ctx)this.getJniContext());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (jniJobs != null && jniJobs.length > 0) {
            jobId = jniJobs[0].getID();
        }
        return jobId;
    }

    public String getFsckLogfileLocation() {
        return this.logfile;
    }

    public void setFsckLogfileLocation(String logfile) {
        this.logfile = logfile;
    }

    public String toString() {
        int i;
        long capacity = 0L;
        long availSpace = 0L;
        int consumedSpace = 0;
        try {
            capacity = this.getCapacity();
            availSpace = this.getAvailableSpace();
            consumedSpace = this.getConsumedSpacePercentage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Name: " + this.name + "\n");
        buf.append("FS Type: " + this.fsType + ", HA:" + this.ha + "\n");
        buf.append("Archiving Type: " + this.archType + "\n");
        buf.append("Equip Ordinal: " + this.equipOrdinal + "\n");
        buf.append("Mount Point: " + this.mountPoint + "\n");
        buf.append("State: " + this.state + "\n");
        buf.append("Share Status: " + this.shareStatus + "\n");
        buf.append("NFSShared: " + this.nfsShared + "\n");
        buf.append("Capacity: " + capacity + "\n");
        buf.append("Available Space: " + availSpace + "\n");
        buf.append("Consumed Space: " + consumedSpace + "% \n");
        buf.append("DAU Size: " + this.dauSize + "\n");
        buf.append("Time Above HWM: " + SamQFSUtil.dateTime(this.timeAboveHWM) + "\n");
        buf.append("Date Created: " + SamQFSUtil.dateTime(this.dateCreated) + "\n");
        buf.append("Server Name: " + this.serverName + "\n");
        buf.append("Mount Properties: \n" + this.mountProps.toString() + "\n");
        try {
            if (this.metaDevices != null) {
                for (i = 0; i < this.metaDevices.length; ++i) {
                    buf.append("Metadata Devices: \n" + this.metaDevices[i].toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.dataDevices != null) {
                for (i = 0; i < this.dataDevices.length; ++i) {
                    buf.append("Data Devices: \n" + this.dataDevices[i].toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.stripedGrps != null) {
                for (int i2 = 0; i2 < this.stripedGrps.length; ++i2) {
                    buf.append("Striped Groups: \n" + this.stripedGrps[i2].toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    private void setup() {
        StripedGrp[] jniList;
        int i;
        this.name = this.fsInfo.getName();
        this.archType = this.fsInfo.isArchiving() ? 2 : 3;
        this.equipOrdinal = this.fsInfo.getEqu();
        this.mountPoint = this.fsInfo.getMountPoint();
        this.state = this.fsInfo.isMounted() ? 0 : 1;
        if (this.fsInfo.isShared()) {
            this.shareStatus = this.fsInfo.isClient() ? 3 : (this.fsInfo.isMdServer() ? 1 : (this.fsInfo.isPotentialMdServer() ? 2 : 4));
            this.serverName = this.fsInfo.getServerName();
        } else {
            this.shareStatus = 0;
            this.serverName = new String();
        }
        this.capacity = this.fsInfo.getCapacity();
        this.avail = this.fsInfo.getAvailableSpace();
        int n = this.consumed = this.capacity != 0L ? (int)((this.capacity - this.avail) * 100L / this.capacity) : -1;
        if ("yes".equals(this.fsInfo.getNFSShareState())) {
            this.nfsShared = true;
        }
        this.dauSize = this.fsInfo.getDAUSize();
        this.timeAboveHWM = null;
        this.dateCreated = SamQFSUtil.convertTime(this.fsInfo.getCreationTime());
        this.mountProps = new FileSystemMountPropertiesImpl(this.fsInfo.getMountOptions());
        this.mountProps.setFileSystem(this);
        int dataCacheType = 2;
        DiskDev[] list = null;
        this.setHA(true);
        list = this.fsInfo.getMetadataDevices();
        if (list != null) {
            this.metaDevices = new DiskCache[list.length];
            if (list.length > 0) {
                dataCacheType = 3;
            }
            for (i = 0; i < list.length; ++i) {
                this.metaDevices[i] = new DiskCacheImpl(list[i]);
                ((DiskCacheImpl)this.metaDevices[i]).setDiskCacheType(1);
                if (!this.ha || this.metaDevices[i].getDevicePath().equals("nodev")) continue;
                this.setHA(this.metaDevices[i].isHA());
            }
        }
        if ((list = this.fsInfo.getDataDevices()) != null) {
            this.dataDevices = new DiskCache[list.length];
            for (i = 0; i < list.length; ++i) {
                this.dataDevices[i] = new DiskCacheImpl(list[i]);
                if (!this.ha) continue;
                this.setHA(this.dataDevices[i].isHA());
            }
        }
        if ((jniList = this.fsInfo.getStripedGroups()) != null) {
            this.stripedGrps = new StripedGroup[jniList.length];
            for (int i2 = 0; i2 < jniList.length; ++i2) {
                this.stripedGrps[i2] = new StripedGroupImpl(jniList[i2]);
            }
        }
        this.fsType = this.metaDevices != null && this.metaDevices.length > 0 ? 0 : 1;
    }

    public ArchivePolCriteria[] getArchivePolCriteriaForFS() throws SamFSException {
        TraceUtil.trace3("Logic: Enter getArchivePolCriteriaForFS()");
        ArrayList<ArchivePolCriteriaImpl> list = new ArrayList<ArchivePolCriteriaImpl>();
        if (this.model != null) {
            Criteria[] c;
            this.model.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
            ArFSDirective fsDir = Archiver.getArFSDirective((Ctx)this.getJniContext(), (String)this.getName());
            if (fsDir != null && (c = fsDir.getCriteria()) != null && c.length > 0) {
                for (int i = 0; i < c.length; ++i) {
                    ArchivePolCriteria[] polCrits;
                    com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolicyImpl pol;
                    String policyName = c[i].getSetName();
                    if (!SamQFSUtil.isValidString(policyName) || (pol = (com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolicyImpl)this.model.getSamQFSSystemArchiveManager43().getArchivePolicy(policyName)) == null || (polCrits = pol.getArchivePolCriteriaForFS(this.getName())) == null) continue;
                    for (int j = 0; j < polCrits.length; ++j) {
                        ArchivePolCriteriaImpl crit = (ArchivePolCriteriaImpl)polCrits[j];
                        if (!crit.isFSPresent(this.getName())) continue;
                        Criteria[] cList = crit.getJniCriteria();
                        boolean found = false;
                        if (cList != null) {
                            for (int k = 0; k < cList.length; ++k) {
                                if (!c[i].sameAs(cList[k])) continue;
                                found = true;
                                break;
                            }
                        }
                        if (!found) continue;
                        list.add(crit);
                    }
                }
            }
        }
        TraceUtil.trace3("Logic: Exit getArchivePolCriteriaForFS()");
        return list.toArray(new ArchivePolCriteria[0]);
    }

    public void addPolCriteria(ArchivePolCriteria[] newPolCriteriaList) throws SamFSException {
        TraceUtil.trace3("Logic: Enter addPolCriteria()");
        if (newPolCriteriaList != null) {
            for (int i = 0; i < newPolCriteriaList.length; ++i) {
                ((ArchivePolCriteriaImpl)newPolCriteriaList[i]).addFileSystemForCriteria(this.getName(), false);
            }
            Archiver.activateCfgThrowWarnings((Ctx)this.model.getJniContext());
            this.model.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
        }
        TraceUtil.trace3("Logic: Exit addPolCriteria()");
    }

    public void removePolCriteria(ArchivePolCriteria[] newPolCriteriaList) throws SamFSException {
        TraceUtil.trace3("Logic: Enter removePolCriteria()");
        if (newPolCriteriaList != null) {
            for (int i = 0; i < newPolCriteriaList.length; ++i) {
                ((ArchivePolCriteriaImpl)newPolCriteriaList[i]).deleteFileSystemForCriteria(this.getName(), false);
            }
            Archiver.activateCfgThrowWarnings((Ctx)this.model.getJniContext());
            this.model.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
        }
        TraceUtil.trace3("Logic: Exit removePolCriteria()");
    }

    public void reorderPolCriteria(ArchivePolCriteria[] reorderedList) throws SamFSException {
        TraceUtil.trace3("Logic: Enter reorderPolCriteria()");
        ArFSDirective fsDir = Archiver.getArFSDirective((Ctx)this.getJniContext(), (String)this.getName());
        if (reorderedList != null) {
            Criteria[] crit = new Criteria[reorderedList.length];
            for (int i = 0; i < reorderedList.length; ++i) {
                Criteria[] crits = ((ArchivePolCriteriaImpl)reorderedList[i]).getJniCriteria();
                crit[i] = new Criteria(this.getName(), crits[0]);
            }
            fsDir.setCriteria(crit);
            boolean resetCtx = false;
            Ctx ctx = this.getJniContext();
            String dumpPath = this.model.getDumpPath();
            if (SamQFSUtil.isValidString(dumpPath)) {
                ctx.setDumpPath(dumpPath);
                resetCtx = true;
            }
            Archiver.setArFSDirective((Ctx)ctx, (ArFSDirective)fsDir);
            this.model.setDumpPath(null);
            if (resetCtx) {
                ctx.setDumpPath(null);
            }
            Archiver.activateCfgThrowWarnings((Ctx)this.model.getJniContext());
            this.model.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
        }
        TraceUtil.trace3("Logic: Exit reorderPolCriteria()");
    }

    public ArchivePolicy[] getArchivePoliciesForFS() throws SamFSException {
        ArrayList<ArchivePolicy> list = new ArrayList<ArchivePolicy>();
        if (this.model != null) {
            Criteria[] c;
            this.model.getSamQFSSystemArchiveManager().getAllArchivePolicies();
            ArFSDirective fsDir = Archiver.getArFSDirective((Ctx)this.getJniContext(), (String)this.getName());
            ArrayList<String> polNames = new ArrayList<String>();
            if (fsDir != null && (c = fsDir.getCriteria()) != null && c.length > 0) {
                for (int i = 0; i < c.length; ++i) {
                    String policyName = c[i].getSetName();
                    if (!SamQFSUtil.isValidString(policyName) || polNames.contains(policyName)) continue;
                    polNames.add(policyName);
                }
            }
            if (polNames.size() > 0) {
                for (int i = 0; i < polNames.size(); ++i) {
                    ArchivePolicy pol = this.model.getSamQFSSystemArchiveManager().getArchivePolicy((String)polNames.get(i));
                    if (pol == null) continue;
                    list.add(pol);
                }
            }
        }
        return list.toArray(new ArchivePolicy[0]);
    }

    public void addPolicies(ArchivePolicy[] policies) throws SamFSException {
        if (policies != null && policies.length > 0) {
            int i;
            for (i = 0; i < policies.length; ++i) {
                ((ArchivePolicyImpl)policies[i]).addFileSystemForPolicy(this.getName());
            }
            policies[0] = this.rebuild(policies[0].getPolicyName());
            for (i = 1; i < policies.length; ++i) {
                policies[i] = this.model.getSamQFSSystemArchiveManager().getArchivePolicy(policies[i].getPolicyName());
            }
            Archiver.activateCfgThrowWarnings((Ctx)this.getJniContext());
        }
    }

    public void removePolicies(ArchivePolicy[] policies) throws SamFSException {
        if (policies != null && policies.length > 0) {
            int i;
            for (i = 0; i < policies.length; ++i) {
                ((ArchivePolicyImpl)policies[i]).deleteFileSystemForPolicy(this.getName());
            }
            policies[0] = this.rebuild(policies[0].getPolicyName());
            for (i = 1; i < policies.length; ++i) {
                policies[i] = this.model.getSamQFSSystemArchiveManager().getArchivePolicy(policies[i].getPolicyName());
            }
            Archiver.activateCfgThrowWarnings((Ctx)this.getJniContext());
        }
    }

    public void addPolicy(ArchivePolicy pol) throws SamFSException {
        if (pol != null) {
            ArchivePolicy[] pols = new ArchivePolicy[]{pol};
            this.addPolicies(pols);
        }
    }

    public void removePolicy(ArchivePolicy pol) throws SamFSException {
        if (pol != null) {
            ArchivePolicy[] pols = new ArchivePolicy[]{pol};
            this.removePolicies(pols);
        }
    }

    public void changePolicyOrdering(ArchivePolicy policy, int targetPosition) throws SamFSException {
        if (policy != null) {
            boolean resetCtx = false;
            ArFSDirective fsDir = Archiver.getArFSDirective((Ctx)this.getJniContext(), (String)this.getName());
            Criteria[] c = null;
            if (fsDir != null) {
                c = fsDir.getCriteria();
            }
            int currentPosition = -1;
            int currentLength = -1;
            if (c != null && c.length > 0) {
                currentLength = c.length;
                for (int i = 0; i < c.length; ++i) {
                    if (!policy.getPolicyName().equals(c[i].getSetName())) continue;
                    currentPosition = i;
                    break;
                }
            }
            if (currentLength == -1) {
                policy.addFileSystemForPolicy(this.getName());
                policy = this.rebuild(policy.getPolicyName());
            } else if (currentPosition == -1) {
                ((ArchivePolicyImpl)policy).addFileSystemForPolicy(this.getName(), fsDir, targetPosition - 1);
                policy = this.rebuild(policy.getPolicyName());
            } else {
                if (targetPosition == -1 || targetPosition > currentLength) {
                    targetPosition = currentLength - 1;
                } else if (--targetPosition < 0) {
                    targetPosition = 0;
                }
                if (currentPosition != targetPosition) {
                    Criteria[] newCrit = new Criteria[currentLength];
                    boolean moveUp = true;
                    if (currentPosition > targetPosition) {
                        moveUp = false;
                    }
                    Criteria current = c[currentPosition];
                    for (int i = 0; i < currentLength; ++i) {
                        if (i < targetPosition && i < currentPosition || i > targetPosition && i > currentPosition) {
                            newCrit[i] = c[i];
                            continue;
                        }
                        if (moveUp) {
                            if (i + 1 >= currentLength) continue;
                            newCrit[i] = c[i + 1];
                            continue;
                        }
                        if (moveUp || i < 1) continue;
                        newCrit[i] = c[i - 1];
                    }
                    newCrit[targetPosition] = current;
                    fsDir.setCriteria(newCrit);
                    Ctx ctx = this.getJniContext();
                    String dumpPath = this.model.getDumpPath();
                    if (SamQFSUtil.isValidString(dumpPath)) {
                        ctx.setDumpPath(dumpPath);
                        resetCtx = true;
                    }
                    Archiver.setArFSDirective((Ctx)ctx, (ArFSDirective)fsDir);
                    this.model.setDumpPath(null);
                    if (resetCtx) {
                        ctx.setDumpPath(null);
                    }
                    policy = this.rebuild(policy.getPolicyName());
                }
            }
            if (!resetCtx) {
                Archiver.activateCfgThrowWarnings((Ctx)this.getJniContext());
            }
        }
    }

    private ArchivePolicy rebuild(String policyName) throws SamFSException {
        this.model.getSamQFSSystemArchiveManager().getAllArchivePolicies();
        return this.model.getSamQFSSystemArchiveManager().getArchivePolicy(policyName);
    }
}

