/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive43;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.FileUtil;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.ArGlobalDirective;
import com.sun.netstorage.samqfs.mgmt.arc.Archiver;
import com.sun.netstorage.samqfs.mgmt.arc.BufDirective;
import com.sun.netstorage.samqfs.mgmt.arc.DrvDirective;
import com.sun.netstorage.samqfs.web.model.archive43.BufferDirective;
import com.sun.netstorage.samqfs.web.model.archive43.DriveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.GlobalArchiveDirective;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.BufferDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.DriveDirectiveImpl;
import java.util.ArrayList;

public class GlobalArchiveDirectiveImpl
implements GlobalArchiveDirective {
    private ArGlobalDirective globalDir = null;
    private SamQFSSystemModelImpl model = null;
    private ArrayList bufDir = new ArrayList();
    private ArrayList minFileSize = new ArrayList();
    private ArrayList bufSize = new ArrayList();
    private ArrayList driveDir = new ArrayList();
    private String archLogfile = new String();
    private long interval = -1L;
    private int unit = -1;
    private int archMethod = -1;
    private boolean bufTouched = false;
    private boolean minTouched = false;
    private boolean sizeTouched = false;
    private boolean drvTouched = false;
    private boolean intrvTouched = false;

    public GlobalArchiveDirectiveImpl() {
    }

    public GlobalArchiveDirectiveImpl(ArrayList bufDir, ArrayList minFileSize, ArrayList bufSize, ArrayList driveDir, String archLogfile, long interval, int unit, int archMethod) {
        this.bufDir = bufDir;
        this.minFileSize = minFileSize;
        this.bufSize = bufSize;
        this.driveDir = driveDir;
        this.archLogfile = archLogfile;
        this.interval = interval;
        this.unit = unit;
        this.archMethod = archMethod;
    }

    public GlobalArchiveDirectiveImpl(SamQFSSystemModelImpl model, ArGlobalDirective globalDir) throws SamFSException {
        this.model = model;
        this.globalDir = globalDir;
        if (globalDir != null) {
            BufDirective[] bufDirs1 = globalDir.getBufferDirectives();
            BufDirective[] bufDirs2 = globalDir.getMaxDirectives();
            BufDirective[] bufDirs3 = globalDir.getOverflowDirectives();
            DrvDirective[] drvDirs = globalDir.getDriveDirectives();
            this.archLogfile = globalDir.getLogFile();
            long sec = globalDir.getInterval();
            if (sec >= 0L) {
                String tmp = SamQFSUtil.longToInterval(sec);
                this.interval = SamQFSUtil.getLongValSecond(tmp);
                this.unit = SamQFSUtil.getTimeUnitInteger(tmp);
            }
            this.archMethod = SamQFSUtil.getLogicScanType(globalDir.getExamineMethod());
            if (bufDirs1 != null) {
                for (int i = 0; i < bufDirs1.length; ++i) {
                    this.bufSize.add(new BufferDirectiveImpl(bufDirs1[i]));
                }
            }
            if (bufDirs2 != null) {
                for (int i = 0; i < bufDirs2.length; ++i) {
                    this.bufDir.add(new BufferDirectiveImpl(bufDirs2[i]));
                }
            }
            if (bufDirs3 != null) {
                for (int i = 0; i < bufDirs3.length; ++i) {
                    this.minFileSize.add(new BufferDirectiveImpl(bufDirs3[i]));
                }
            }
            if (drvDirs != null) {
                for (int i = 0; i < drvDirs.length; ++i) {
                    this.driveDir.add(new DriveDirectiveImpl(model, drvDirs[i]));
                }
            }
        }
    }

    public BufferDirective[] getMaxFileSize() {
        return this.bufDir.toArray(new BufferDirective[0]);
    }

    public void addMaxFileSizeDirective(BufferDirective dir) {
        this.bufDir.add(dir);
        this.bufTouched = true;
    }

    public void deleteMaxFileSizeDirective(BufferDirective dir) {
        int index = this.bufDir.indexOf(dir);
        if (index != -1) {
            this.bufDir.remove(index);
            this.bufTouched = true;
        }
    }

    public BufferDirective[] getMinFileSizeForOverflow() {
        return this.minFileSize.toArray(new BufferDirective[0]);
    }

    public void addMinFileSizeForOverflow(BufferDirective dir) {
        this.minFileSize.add(dir);
        this.minTouched = true;
    }

    public void deleteMinFileSizeForOverflow(BufferDirective dir) {
        int index = this.minFileSize.indexOf(dir);
        if (index != -1) {
            this.minFileSize.remove(index);
            this.minTouched = true;
        }
    }

    public BufferDirective[] getBufferSize() {
        return this.bufSize.toArray(new BufferDirective[0]);
    }

    public void addBufferSize(BufferDirective dir) {
        this.bufSize.add(dir);
        this.sizeTouched = true;
    }

    public void deleteBufferSize(BufferDirective dir) {
        int index = this.bufSize.indexOf(dir);
        if (index != -1) {
            this.bufSize.remove(index);
            this.sizeTouched = true;
        }
    }

    public DriveDirective[] getDriveDirectives() {
        return this.driveDir.toArray(new DriveDirective[0]);
    }

    public void addDriveDirective(DriveDirective dir) {
        this.driveDir.add(dir);
        this.drvTouched = true;
    }

    public void deleteDriveDirective(DriveDirective dir) {
        int index = this.driveDir.indexOf(dir);
        if (index != -1) {
            this.driveDir.remove(index);
            this.drvTouched = true;
        }
    }

    public String getArchiveLogfile() {
        return this.archLogfile;
    }

    public void setArchiveLogfile(String logfile) {
        this.archLogfile = logfile;
        if (SamQFSUtil.isValidString(logfile)) {
            this.globalDir.setLogFile(logfile);
        } else {
            this.globalDir.resetLogFile();
        }
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
        this.intrvTouched = true;
    }

    public int getIntervalUnit() {
        return this.unit;
    }

    public void setIntervalUnit(int unit) {
        this.unit = unit;
        this.intrvTouched = true;
    }

    public int getArchiveScanMethod() {
        return this.archMethod;
    }

    public void setArchiveScanMethod(int method) {
        this.archMethod = method;
        if (method != -1) {
            this.globalDir.setExamineMethod(SamQFSUtil.getJniScanType(method));
        } else {
            this.globalDir.resetExamineMethod();
        }
    }

    public void changeGlobalDirective() throws SamFSException {
        int i;
        BufDirective[] buf;
        if (this.sizeTouched) {
            buf = new BufDirective[this.bufSize.size()];
            for (i = 0; i < this.bufSize.size(); ++i) {
                buf[i] = ((BufferDirectiveImpl)this.bufSize.get(i)).getJniBufferDirective();
            }
            this.globalDir.setBufferDirectives(buf);
        }
        if (this.minTouched) {
            buf = new BufDirective[this.minFileSize.size()];
            for (i = 0; i < this.minFileSize.size(); ++i) {
                buf[i] = ((BufferDirectiveImpl)this.minFileSize.get(i)).getJniBufferDirective();
            }
            this.globalDir.setOverflowDirectives(buf);
        }
        if (this.bufTouched) {
            buf = new BufDirective[this.bufDir.size()];
            for (i = 0; i < this.bufDir.size(); ++i) {
                buf[i] = ((BufferDirectiveImpl)this.bufDir.get(i)).getJniBufferDirective();
            }
            this.globalDir.setMaxDirectives(buf);
        }
        if (this.drvTouched) {
            DrvDirective[] drv = new DrvDirective[this.driveDir.size()];
            for (i = 0; i < this.driveDir.size(); ++i) {
                drv[i] = ((DriveDirectiveImpl)this.driveDir.get(i)).getJniDriveDirective();
            }
            this.globalDir.setDriveDirectives(drv);
        }
        if (this.intrvTouched) {
            if (this.interval != -1L && this.unit != -1) {
                this.globalDir.setInterval(SamQFSUtil.convertToSecond(this.interval, this.unit));
            } else {
                this.globalDir.resetInterval();
            }
        }
        if (SamQFSUtil.isValidString(this.globalDir.getLogFile())) {
            FileUtil.createFile((Ctx)this.model.getJniContext(), (String)this.globalDir.getLogFile());
        }
        Archiver.setArGlobalDirective((Ctx)this.model.getJniContext(), (ArGlobalDirective)this.globalDir);
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        buf.append("Maximum File Size: \n\n");
        try {
            if (this.bufDir != null) {
                for (i = 0; i < this.bufDir.size(); ++i) {
                    buf.append(((BufferDirective)this.bufDir.get(i)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buf.append("Minimum File Size For Overflow: \n\n");
        try {
            if (this.minFileSize != null) {
                for (i = 0; i < this.minFileSize.size(); ++i) {
                    buf.append(((BufferDirective)this.minFileSize.get(i)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buf.append("Buffer Size: \n\n");
        try {
            if (this.bufSize != null) {
                for (int i2 = 0; i2 < this.bufSize.size(); ++i2) {
                    buf.append(((BufferDirective)this.bufSize.get(i2)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buf.append("Drive Directive: \n\n");
        try {
            if (this.driveDir != null) {
                for (int i3 = 0; i3 < this.driveDir.size(); ++i3) {
                    buf.append(((DriveDirective)this.driveDir.get(i3)).toString() + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buf.append("Archive Logfile: " + this.archLogfile + "\n");
        buf.append("Interval: " + this.interval + "\n");
        buf.append("Archive Scan Method: " + this.archMethod + "\n");
        return buf.toString();
    }
}

