/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive43;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.BaseVSNPoolProps;
import com.sun.netstorage.samqfs.mgmt.arc.DiskVSNPoolProps;
import com.sun.netstorage.samqfs.mgmt.arc.DiskVol;
import com.sun.netstorage.samqfs.mgmt.arc.VSNMap;
import com.sun.netstorage.samqfs.mgmt.arc.VSNOp;
import com.sun.netstorage.samqfs.mgmt.arc.VSNPool;
import com.sun.netstorage.samqfs.mgmt.media.CatEntry;
import com.sun.netstorage.samqfs.mgmt.media.Media;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.VSNPoolImpl;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;

public class ArchiveVSNMapImpl
implements ArchiveVSNMap {
    private ArchiveCopy archCopy = null;
    private VSNMap map = null;
    private int archType = -1;
    private boolean rearchive = false;
    private String vsnExpression = new String();
    private String startVSNname = new String();
    private String endVSNname = new String();
    private String poolExpression = new String();
    private boolean mapUpdateNeeded = false;
    private boolean inheritedFromALLSETS = false;
    private boolean save = false;
    private boolean memberVSNsFetched = false;
    private ArrayList memberVSNNames = new ArrayList();
    private ArrayList memberVSNPools = new ArrayList();
    private long availableSpace = -1L;

    public ArchiveVSNMapImpl() {
        this.map = new VSNMap("Unknown", "Unknown", new String[0], new String[0]);
    }

    public ArchiveVSNMapImpl(String allSetsCopyName) {
        this.map = new VSNMap(allSetsCopyName, "Unknown", new String[0], new String[0]);
    }

    public ArchiveVSNMapImpl(ArchiveCopy archCopy, VSNMap map) throws SamFSException {
        this.archCopy = archCopy;
        this.map = map;
        if (this.map != null) {
            this.archType = SamQFSUtil.getMediaTypeInteger(map.getMediaType());
            this.vsnExpression = SamQFSUtil.createVSNExpressionFromStrings(map.getVSNNames());
            this.poolExpression = SamQFSUtil.createVSNExpressionFromStrings(map.getPoolNames());
            this.save = true;
        } else {
            this.map = new VSNMap("Unknown", "Unknown", new String[0], new String[0]);
        }
    }

    public ArchiveVSNMapImpl(ArchiveVSNMapImpl src, String copyName) {
        this.inheritedFromALLSETS = true;
        this.map = new VSNMap(copyName, src.map.getMediaType(), src.map.getVSNNames(), src.map.getPoolNames());
        this.archType = src.archType;
        this.vsnExpression = src.vsnExpression;
        this.startVSNname = src.startVSNname;
        this.endVSNname = src.endVSNname;
        this.poolExpression = src.poolExpression;
    }

    public boolean inheritedFromALLSETS() {
        return this.inheritedFromALLSETS;
    }

    public void setWillBeSaved(boolean save) {
        this.save = save;
    }

    public boolean getWillBeSaved() {
        return this.save;
    }

    public boolean isEmpty() {
        if (this.map == null) {
            return true;
        }
        return this.map.isEmpty();
    }

    private void updateVSNAndPoolInfo() throws SamFSException {
        this.availableSpace = 0L;
        this.memberVSNNames.clear();
        this.updatePoolsFromPoolNames(this.map.getPoolNames());
        this.updateVSNsFromExpressionList(this.map.getVSNNames());
    }

    public VSNMap getJniVSNMap() {
        String vsnCopyName;
        if (this.mapUpdateNeeded) {
            boolean commaNeeded = false;
            StringBuffer exp = new StringBuffer();
            if (SamQFSUtil.isValidString(this.vsnExpression)) {
                exp.append(this.vsnExpression);
                commaNeeded = true;
            }
            if (SamQFSUtil.isValidString(this.startVSNname) || SamQFSUtil.isValidString(this.endVSNname)) {
                if (commaNeeded) {
                    exp.append(",");
                }
                exp.append(SamQFSUtil.createExpression(this.startVSNname, this.endVSNname));
            }
            this.vsnExpression = exp.toString();
        }
        if ((vsnCopyName = this.map.getCopyName()).equals("Unknown")) {
            ArchivePolicy archPolicy = null;
            if (this.archCopy != null) {
                archPolicy = this.archCopy.getArchivePolicy();
            }
            if (archPolicy != null) {
                String RString = "";
                if (this.rearchive) {
                    RString = "R";
                }
                vsnCopyName = archPolicy.getPolicyName() + "." + this.archCopy.getCopyNumber() + RString;
            }
        }
        this.map.setCopyName(vsnCopyName);
        this.map.setMediaType(SamQFSUtil.getMediaTypeString(this.archType));
        this.map.setVSNNames(SamQFSUtil.getStringsFromCommaStream(this.getMapExpression()));
        this.map.setPoolNames(SamQFSUtil.getStringsFromCommaStream(this.getPoolExpression()));
        return this.map;
    }

    public ArchiveCopy getArchiveCopy() {
        return this.archCopy;
    }

    public void setArchiveCopy(ArchiveCopy copy) {
        this.archCopy = copy;
    }

    public boolean isRearchive() {
        return this.rearchive;
    }

    public void setRearchive(boolean rearchive) {
        this.rearchive = rearchive;
    }

    public int getArchiveMediaType() {
        return this.archType;
    }

    public void setArchiveMediaType(int type) {
        this.archType = type;
        this.map.setMediaType(SamQFSUtil.getMediaTypeString(type));
        this.mapUpdateNeeded = true;
        this.memberVSNsFetched = false;
    }

    public String getPoolExpression() {
        return this.poolExpression;
    }

    public void setPoolExpression(String poolExp) {
        if (poolExp != null) {
            this.poolExpression = poolExp;
            this.map.setPoolNames(SamQFSUtil.getStringsFromCommaStream(poolExp));
            this.mapUpdateNeeded = true;
            this.memberVSNsFetched = false;
        }
    }

    public String getMapExpression() {
        return this.vsnExpression;
    }

    public void setMapExpression(String expression) {
        if (expression != null) {
            this.vsnExpression = expression;
            this.map.setVSNNames(SamQFSUtil.getStringsFromCommaStream(expression));
            this.mapUpdateNeeded = true;
            this.memberVSNsFetched = false;
        }
    }

    public String getMapExpressionStartVSN() {
        return this.startVSNname;
    }

    public void setMapExpressionStartVSN(String expression) {
        if (expression != null & !this.startVSNname.equals(expression)) {
            this.startVSNname = expression;
            this.mapUpdateNeeded = true;
            this.memberVSNsFetched = false;
        }
    }

    public String getMapExpressionEndVSN() {
        return this.endVSNname;
    }

    public void setMapExpressionEndVSN(String expression) {
        if (expression != null & !this.endVSNname.equals(expression)) {
            this.endVSNname = expression;
            this.mapUpdateNeeded = true;
            this.memberVSNsFetched = false;
        }
    }

    public String[] getMemberVSNNames() throws SamFSException {
        if (!this.memberVSNsFetched) {
            this.updateVSNAndPoolInfo();
            this.memberVSNsFetched = true;
        }
        return this.memberVSNNames.toArray(new String[0]);
    }

    public long getAvailableSpace() throws SamFSException {
        if (!this.memberVSNsFetched) {
            this.updateVSNAndPoolInfo();
            this.memberVSNsFetched = true;
        }
        return this.availableSpace;
    }

    public String toString() {
        int i;
        StringBuffer buf = new StringBuffer();
        if (this.archCopy != null) {
            buf.append("Archive Copy Number: " + this.archCopy.getCopyNumber() + "\n");
        }
        buf.append("Archive Type: " + this.archType + "\n");
        buf.append("Rearchive: " + this.rearchive + "\n");
        if (this.memberVSNNames != null) {
            for (i = 0; i < this.memberVSNNames.size(); ++i) {
                buf.append("VSN: \n" + (String)this.memberVSNNames.get(i) + "\n");
            }
        }
        if (this.memberVSNPools != null) {
            for (i = 0; i < this.memberVSNPools.size(); ++i) {
                buf.append("VSN Pools: \n" + ((com.sun.netstorage.samqfs.web.model.archive43.VSNPool)this.memberVSNPools.get(i)).getPoolName() + "\n");
            }
        }
        buf.append("Space Available: " + this.availableSpace + "\n");
        buf.append("VSN Expression: " + this.getMapExpression() + "\n");
        buf.append("Pool Expression: " + this.getPoolExpression() + "\n");
        return buf.toString();
    }

    private void updateVSNsFromExpressionList(String[] vsnExpressions) throws SamFSException {
        block5: {
            Ctx ctx;
            block7: {
                SamQFSSystemModelImpl model;
                block6: {
                    model = null;
                    if (this.archCopy != null && this.archCopy.getArchivePolicy() != null) {
                        ArchivePolicyImpl policy = (ArchivePolicyImpl)this.archCopy.getArchivePolicy();
                        model = (SamQFSSystemModelImpl)policy.getModel();
                    }
                    ctx = null;
                    if (model != null) {
                        ctx = model.getJniContext();
                    }
                    if (vsnExpressions == null || ctx == null) break block5;
                    if (this.map.getMediaType().equals("dk")) break block6;
                    CatEntry[] vsnsFromCat = null;
                    CatEntry vsn = null;
                    for (int i = 0; i < vsnExpressions.length; ++i) {
                        vsnsFromCat = Media.getCatEntriesForRegexp((Ctx)ctx, (String)vsnExpressions[i], (int)-1, (int)-1, (short)4, (boolean)false);
                        if (vsnsFromCat == null) continue;
                        for (int j = 0; j < vsnsFromCat.length; ++j) {
                            vsn = vsnsFromCat[j];
                            if (vsn.getFreeSpace() <= 0L || vsn.isReserved() || this.memberVSNNames.contains(vsn.getVSN())) continue;
                            this.memberVSNNames.add(vsn.getVSN());
                            this.availableSpace += vsn.getFreeSpace();
                        }
                    }
                    break block5;
                }
                if ("1.3".compareTo(model.getServerAPIVersion()) <= 0) break block7;
                this.memberVSNNames.add(vsnExpressions[0]);
                this.availableSpace = -1L;
                break block5;
            }
            TraceUtil.trace3("getting map props for " + this.map);
            BaseVSNPoolProps mapProps = VSNOp.getPoolPropsByMap((Ctx)ctx, (VSNMap)this.map, (int)0, (int)-1, (short)4, (boolean)false);
            this.availableSpace = mapProps.getFreeSpace();
            DiskVol[] dvols = ((DiskVSNPoolProps)mapProps).getDiskEntries();
            if (dvols == null) break block5;
            for (int i = 0; i < dvols.length; ++i) {
                String name = dvols[i].getVolName();
                if (this.memberVSNNames.contains(name)) continue;
                this.memberVSNNames.add(name);
            }
        }
    }

    private void updatePoolsFromPoolNames(String[] poolNames) throws SamFSException {
        this.memberVSNPools.clear();
        SamQFSSystemModelImpl model = null;
        if (this.archCopy != null && this.archCopy.getArchivePolicy() != null) {
            ArchivePolicyImpl policy = (ArchivePolicyImpl)this.archCopy.getArchivePolicy();
            model = (SamQFSSystemModelImpl)policy.getModel();
        }
        Ctx ctx = null;
        if (model != null) {
            ctx = model.getJniContext();
        }
        if (ctx != null && poolNames != null && poolNames.length > 0) {
            for (int i = 0; i < poolNames.length; ++i) {
                VSNPool jniPool = VSNOp.getPool((Ctx)ctx, (String)poolNames[i]);
                if (jniPool == null) continue;
                VSNPoolImpl pool = new VSNPoolImpl(model, jniPool);
                this.memberVSNPools.add(pool);
                this.availableSpace += pool.getSpaceAvailable();
                String[] members = pool.getMemberVSNNames();
                if (members == null) continue;
                for (int j = 0; j < members.length; ++j) {
                    if (this.memberVSNNames.indexOf(members[j]) != -1) continue;
                    this.memberVSNNames.add(members[j]);
                }
            }
        }
    }

    public VSNMap getInternalVSNMap() {
        return this.map;
    }
}

