/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive43;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.ArSet;
import com.sun.netstorage.samqfs.mgmt.arc.Archiver;
import com.sun.netstorage.samqfs.mgmt.arc.CopyParams;
import com.sun.netstorage.samqfs.mgmt.arc.Criteria;
import com.sun.netstorage.samqfs.mgmt.arc.DiskVol;
import com.sun.netstorage.samqfs.mgmt.arc.VSNMap;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopyGUIWrapper;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemArchiveManager43Impl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchiveCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolCriteriaCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolCriteriaImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolCriteriaPropImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchiveVSNMapImpl;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;

public class ArchivePolicyImpl
implements ArchivePolicy {
    public static int MAX_COPY_REGULAR = 4;
    public static int MAX_COPY_ALLSETS = 5;
    private SamQFSSystemModelImpl model = null;
    private String policyName = new String();
    private int policyType = -1;
    private ArrayList polCriteriaList = new ArrayList();
    private ArrayList archiveCopyList = new ArrayList();
    private ArSet jniArchiveSet = null;

    private void diskCParams43ToMap44(ArchiveCopy archiveCopy, String cpName) throws SamFSException {
        String dvsn;
        if ("1.3".compareTo(this.model.getServerAPIVersion()) > 0 && archiveCopy != null && SamQFSUtil.isValidString(dvsn = archiveCopy.getDiskArchiveVSN())) {
            ArchiveVSNMapImpl map = new ArchiveVSNMapImpl(archiveCopy, new VSNMap(cpName, "dk", new String[]{dvsn}, new String[0]));
            archiveCopy.setArchiveVSNMap(map);
        }
    }

    public ArchivePolicyImpl(SamQFSSystemModelImpl model, ArSet jniArchiveSet) throws SamFSException {
        TraceUtil.trace3("Logic: Enter ArchivePolicyImpl()");
        this.model = model;
        this.jniArchiveSet = jniArchiveSet;
        if (model != null && jniArchiveSet != null) {
            this.policyName = jniArchiveSet.getArSetName();
            switch (jniArchiveSet.getArSetType()) {
                case 0: {
                    this.policyType = 1001;
                    break;
                }
                case 1: {
                    this.policyType = 1002;
                    break;
                }
                case 2: {
                    this.policyType = 1003;
                    break;
                }
                case 3: {
                    this.policyType = 1004;
                }
            }
            Criteria[] crits = jniArchiveSet.getCriteria();
            if (crits != null && crits.length > 0) {
                int i;
                ArrayList clusters = new ArrayList();
                for (i = 0; i < crits.length; ++i) {
                    if (crits[i] == null) continue;
                    ArrayList<Criteria> list = new ArrayList<Criteria>();
                    list.add(crits[i]);
                    for (int j = i + 1; j < crits.length; ++j) {
                        if (crits[j] == null || !crits[j].sameAs(crits[i])) continue;
                        list.add(crits[j]);
                        crits[j] = null;
                    }
                    clusters.add(list);
                }
                if (clusters.size() > 0) {
                    for (i = 0; i < clusters.size(); ++i) {
                        ArchivePolCriteriaImpl polCrit = new ArchivePolCriteriaImpl(this, i, (ArrayList)clusters.get(i));
                        this.polCriteriaList.add(polCrit);
                    }
                }
            }
            CopyParams[] cparamList = jniArchiveSet.getCopies();
            VSNMap[] mapList = jniArchiveSet.getMaps();
            ArchiveVSNMapImpl map = null;
            ArchiveCopyImpl archiveCopy = null;
            String cpName = null;
            for (int i = 0; i < MAX_COPY_ALLSETS; ++i) {
                TraceUtil.trace1("CP: " + cparamList[i] + "  map:" + mapList[i]);
                if (cparamList[i] != null && mapList[i] != null) {
                    map = new ArchiveVSNMapImpl(null, mapList[i]);
                    archiveCopy = new ArchiveCopyImpl(this, map, i + 1, cparamList[i]);
                    map.setArchiveCopy(archiveCopy);
                    this.archiveCopyList.add(archiveCopy);
                    continue;
                }
                if (cparamList[i] != null && mapList[i] == null) {
                    String dvsn;
                    switch (this.policyType) {
                        case 1004: {
                            cpName = "allsets" + (i == MAX_COPY_ALLSETS - 1 ? "" : "." + (i + 1));
                            map = new ArchiveVSNMapImpl(cpName);
                            TraceUtil.trace3("created allsets policy " + cpName);
                            break;
                        }
                        case 1001: 
                        case 1002: {
                            ArchivePolicy allsetsPolicy = model.getSamQFSSystemArchiveManager43().getArchivePolicy("allsets");
                            ArchiveCopy matchingAllsetsCopy = allsetsPolicy.getArchiveCopy(i + 1);
                            if (matchingAllsetsCopy == null) break;
                            ArchiveVSNMapImpl origMap = (ArchiveVSNMapImpl)matchingAllsetsCopy.getArchiveVSNMap();
                            if (origMap.isEmpty() && null != (matchingAllsetsCopy = allsetsPolicy.getArchiveCopy(5))) {
                                origMap = (ArchiveVSNMapImpl)matchingAllsetsCopy.getArchiveVSNMap();
                            }
                            cpName = this.policyName + "." + (i + 1);
                            map = new ArchiveVSNMapImpl(origMap, cpName);
                            break;
                        }
                        default: {
                            map = null;
                        }
                    }
                    archiveCopy = new ArchiveCopyImpl(this, map, i + 1, cparamList[i]);
                    if (map != null) {
                        map.setArchiveCopy(archiveCopy);
                    }
                    if (SamQFSUtil.isValidString(dvsn = archiveCopy.getDiskArchiveVSN())) {
                        DiskVol vol = DiskVol.get((Ctx)model.getJniContext(), (String)dvsn);
                        if (SamQFSUtil.isValidString(vol.getHost())) {
                            archiveCopy.setDiskArchiveVSNHost(vol.getHost());
                        }
                        if (SamQFSUtil.isValidString(vol.getPath())) {
                            archiveCopy.setDiskArchiveVSNPath(vol.getPath());
                        }
                        this.diskCParams43ToMap44(archiveCopy, cpName);
                    }
                    this.archiveCopyList.add(archiveCopy);
                    continue;
                }
                if (cparamList[i] != null || mapList[i] == null) continue;
                throw new SamFSException("logic.archiver.cmd.error");
            }
            this.diskCParams43ToMap44(archiveCopy, cpName);
        }
        TraceUtil.trace3("Logic: Exit ArchivePolicyImpl()");
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    public SamQFSSystemModel getModel() {
        return this.model;
    }

    public void setModel(SamQFSSystemModelImpl model) {
        this.model = model;
    }

    public int getPolicyType() {
        return this.policyType;
    }

    public ArchivePolCriteria[] getArchivePolCriteria() {
        return this.polCriteriaList.toArray(new ArchivePolCriteria[0]);
    }

    public ArchivePolCriteria getArchivePolCriteria(int index) {
        TraceUtil.trace3("Logic: Enter getArchivePolCriteria(index)");
        ArchivePolCriteria[] crits = this.getArchivePolCriteria();
        ArchivePolCriteria crit = null;
        if (crits != null && crits.length > 0) {
            for (int i = 0; i < crits.length; ++i) {
                if (crits[i].getIndex() != index) continue;
                crit = crits[i];
                break;
            }
        }
        TraceUtil.trace3("Logic: Exit getArchivePolCriteria(index)");
        return crit;
    }

    public ArchivePolCriteria getDefaultArchivePolCriteriaForPolicy() {
        TraceUtil.trace3("Logic: Enter getDefaultArchivePolCriteriaForPolicy()");
        ArchivePolCriteriaPropImpl prop = new ArchivePolCriteriaPropImpl(null, null);
        ArchiveCopy[] copies = this.getArchiveCopies();
        ArchivePolCriteriaCopyImpl[] critCopies = new ArchivePolCriteriaCopyImpl[copies.length];
        for (int i = 0; i < copies.length; ++i) {
            critCopies[i] = new ArchivePolCriteriaCopyImpl(null, null, copies[i].getCopyNumber());
        }
        TraceUtil.trace3("Logic: Exit getDefaultArchivePolCriteriaForPolicy()");
        return new ArchivePolCriteriaImpl(prop, critCopies);
    }

    public void addArchivePolCriteria(ArchivePolCriteria polCriteria, String[] fsNames) throws SamFSException {
        TraceUtil.trace3("Logic: Enter addArchivePolCriteria()");
        if (polCriteria != null && fsNames != null && fsNames.length > 0) {
            ArrayList<Criteria> newCrits = new ArrayList<Criteria>();
            Criteria[] jniCriteria = ((ArchivePolCriteriaImpl)polCriteria).getJniCriteria();
            for (int i = 0; i < fsNames.length; ++i) {
                Criteria crit = new Criteria(fsNames[i], jniCriteria[0]);
                crit.setSetName(this.getPolicyName());
                newCrits.add(crit);
            }
            ArchivePolCriteriaImpl policyCriteria = new ArchivePolCriteriaImpl(this, this.polCriteriaList.size(), newCrits);
            this.polCriteriaList.add(policyCriteria);
            this.updateCriteria();
            boolean dumpOn = false;
            if (SamQFSUtil.isValidString(this.model.getDumpPath())) {
                dumpOn = true;
            }
            if (dumpOn) {
                this.model.getJniContext().setDumpPath(this.model.getDumpPath());
            }
            try {
                Archiver.modifyArSet((Ctx)this.model.getJniContext(), (ArSet)this.jniArchiveSet);
            }
            catch (SamFSException e) {
                this.model.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
                throw e;
            }
            if (!dumpOn) {
                Archiver.activateCfgThrowWarnings((Ctx)this.model.getJniContext());
            }
            if (dumpOn) {
                this.model.setDumpPath(null);
                this.model.getJniContext().setDumpPath(null);
                this.model.getJniContext().setReadPath(null);
            }
            this.model.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
        }
        TraceUtil.trace3("Logic: Exit addArchivePolCriteria()");
    }

    public void deleteArchivePolCriteria(int criteriaIndex) throws SamFSException {
        TraceUtil.trace3("Logic: Enter deleteArchivePolCriteria()");
        for (int i = 0; i < this.polCriteriaList.size(); ++i) {
            ArchivePolCriteriaImpl polCrit = (ArchivePolCriteriaImpl)this.polCriteriaList.get(i);
            if (polCrit.getIndex() != criteriaIndex) continue;
            this.polCriteriaList.remove(i);
        }
        this.updateCriteria();
        Archiver.modifyArSet((Ctx)this.model.getJniContext(), (ArSet)this.jniArchiveSet);
        Archiver.activateCfgThrowWarnings((Ctx)this.model.getJniContext());
        TraceUtil.trace3("Logic: Exit deleteArchivePolCriteria()");
    }

    public ArchiveCopy[] getArchiveCopies() {
        return this.archiveCopyList.toArray(new ArchiveCopy[0]);
    }

    public ArchiveCopy getArchiveCopy(int copyNo) {
        TraceUtil.trace3("Logic: Enter getArchiveCopy(int)");
        ArchiveCopy target = null;
        for (int i = 0; i < this.archiveCopyList.size(); ++i) {
            ArchiveCopy copy = (ArchiveCopy)this.archiveCopyList.get(i);
            if (copy.getCopyNumber() != copyNo) continue;
            target = copy;
            break;
        }
        TraceUtil.trace3("Logic: Exit getArchiveCopy(int)");
        return target;
    }

    public void addArchiveCopy(ArchiveCopyGUIWrapper copyWrapper) throws SamFSException {
        boolean incorrectDiskVol;
        int i;
        TraceUtil.trace3("Logic: Enter addArchiveCopy()");
        ArchiveCopy copy = copyWrapper.getArchiveCopy();
        int[] possible = new int[MAX_COPY_REGULAR];
        for (i = 0; i < MAX_COPY_REGULAR; ++i) {
            possible[i] = i + 1;
        }
        for (i = 0; i < this.archiveCopyList.size(); ++i) {
            ArchiveCopy currentCopy = (ArchiveCopy)this.archiveCopyList.get(i);
            possible[currentCopy.getCopyNumber() - 1] = -1;
        }
        int available = -1;
        for (int i2 = MAX_COPY_REGULAR; i2 > 0; --i2) {
            if (possible[i2 - 1] == -1) continue;
            available = possible[i2 - 1];
        }
        if (available == -1) {
            throw new SamFSException("logic.noCopyAvailable");
        }
        boolean dumpOn = false;
        if (SamQFSUtil.isValidString(this.model.getDumpPath())) {
            dumpOn = true;
        }
        if (incorrectDiskVol = ((SamQFSSystemArchiveManager43Impl)this.model.getSamQFSSystemArchiveManager43()).isIncorrectDiskVol(copy)) {
            throw new SamFSException("logic.differentDiskVolExists");
        }
        if (dumpOn) {
            this.model.getJniContext().setDumpPath(this.model.getDumpPath());
        }
        if (!dumpOn || !this.model.getServerAPIVersion().equals("1.0")) {
            ((SamQFSSystemArchiveManager43Impl)this.model.getSamQFSSystemArchiveManager43()).createDiskVolInfo(copy);
        }
        if (dumpOn) {
            this.model.getJniContext().setDumpPath(null);
            this.model.getJniContext().setReadPath(null);
        }
        copy.setArchivePolicy(this);
        ((ArchiveCopyImpl)copy).setCopyNumber(available);
        this.archiveCopyList.add(copy);
        ArchivePolCriteriaCopyImpl critCpOrig = (ArchivePolCriteriaCopyImpl)copyWrapper.getArchivePolCriteriaCopy();
        for (int i3 = 0; i3 < this.polCriteriaList.size(); ++i3) {
            ArchivePolCriteriaImpl crit = (ArchivePolCriteriaImpl)this.polCriteriaList.get(i3);
            ArchivePolCriteriaCopyImpl critCp = new ArchivePolCriteriaCopyImpl(crit, critCpOrig.getJniCopy(), available);
            crit.addArchivePolCriteriaCopy(critCp);
        }
        this.updateCriteria();
        this.updateRegularCopies();
        if (dumpOn) {
            this.model.getJniContext().setDumpPath(this.model.getDumpPath());
        }
        try {
            Archiver.modifyArSet((Ctx)this.model.getJniContext(), (ArSet)this.jniArchiveSet);
        }
        catch (SamFSException e) {
            this.model.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
            throw e;
        }
        this.diskCParams43ToMap44(copy, this.getPolicyName() + "." + available);
        if (!dumpOn) {
            Archiver.activateCfgThrowWarnings((Ctx)this.model.getJniContext());
        }
        if (dumpOn) {
            this.model.setDumpPath(null);
            this.model.getJniContext().setDumpPath(null);
            this.model.getJniContext().setReadPath(null);
            this.model.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
        }
        TraceUtil.trace3("Logic: Exit addArchiveCopy()");
    }

    public void deleteArchiveCopy(int copyNo) throws SamFSException {
        int i;
        TraceUtil.trace3("Logic: Enter deleteArchiveCopy()");
        if (this.archiveCopyList.size() == 1 && ((ArchiveCopy)this.archiveCopyList.get(0)).getCopyNumber() == copyNo) {
            throw new SamFSException("logic.lastCopy");
        }
        for (i = 0; i < this.archiveCopyList.size(); ++i) {
            ArchiveCopy copy = (ArchiveCopy)this.archiveCopyList.get(i);
            if (copy.getCopyNumber() != copyNo) continue;
            this.archiveCopyList.remove(i);
            break;
        }
        for (i = 0; i < this.polCriteriaList.size(); ++i) {
            ArchivePolCriteriaImpl crit = (ArchivePolCriteriaImpl)this.polCriteriaList.get(i);
            crit.removeArchivePolCriteriaCopy(copyNo);
        }
        this.updateCriteria();
        this.updateRegularCopies();
        Archiver.modifyArSet((Ctx)this.model.getJniContext(), (ArSet)this.jniArchiveSet);
        Archiver.activateCfgThrowWarnings((Ctx)this.model.getJniContext());
        TraceUtil.trace3("Logic: Exit deleteArchiveCopy()");
    }

    public void updatePolicy() throws SamFSException {
        this.updatePolicy(true);
    }

    public void updatePolicy(boolean activate) throws SamFSException {
        TraceUtil.trace3("Logic: Enter updatePolicy()");
        this.updateCriteria();
        this.updateRegularCopies();
        boolean dumpOn = false;
        if (SamQFSUtil.isValidString(this.model.getDumpPath())) {
            dumpOn = true;
        }
        if (dumpOn) {
            this.model.getJniContext().setDumpPath(this.model.getDumpPath());
        }
        Archiver.modifyArSet((Ctx)this.model.getJniContext(), (ArSet)this.jniArchiveSet);
        if (!dumpOn && activate) {
            Archiver.activateCfgThrowWarnings((Ctx)this.model.getJniContext());
        }
        if (dumpOn) {
            this.model.setDumpPath(null);
            this.model.getJniContext().setDumpPath(null);
            this.model.getJniContext().setReadPath(null);
            this.model.getSamQFSSystemArchiveManager43().getAllArchivePolicies();
        }
        TraceUtil.trace3("Logic: Exit updatePolicy()");
    }

    public ArchivePolCriteria[] getArchivePolCriteriaForFS(String fsName) {
        TraceUtil.trace3("Logic: Enter getArchivePolCriteriaForFS(fsName)");
        ArrayList<ArchivePolCriteriaImpl> list = new ArrayList<ArchivePolCriteriaImpl>();
        if (SamQFSUtil.isValidString(fsName)) {
            for (int i = 0; i < this.polCriteriaList.size(); ++i) {
                ArchivePolCriteriaImpl polCrit = (ArchivePolCriteriaImpl)this.polCriteriaList.get(i);
                if (!polCrit.isFSPresent(fsName)) continue;
                list.add(polCrit);
            }
        }
        TraceUtil.trace3("Logic: Exit getArchivePolCriteriaForFS(fsName)");
        return list.toArray(new ArchivePolCriteria[0]);
    }

    public String toString() {
        ArchiveCopy[] copies;
        StringBuffer buf = new StringBuffer();
        buf.append("Policy Name: " + this.getPolicyName() + "\n");
        buf.append("Policy Type: " + this.getPolicyType() + "\n");
        ArchivePolCriteria[] crits = this.getArchivePolCriteria();
        if (crits != null && crits.length > 0) {
            for (int i = 0; i < crits.length; ++i) {
                buf.append("Criteria: \n" + crits[i].toString() + "\n");
            }
        }
        if ((copies = this.getArchiveCopies()) != null && copies.length > 0) {
            for (int i = 0; i < copies.length; ++i) {
                buf.append("Copy: \n" + copies[i].toString() + "\n");
            }
        }
        return buf.toString();
    }

    private void updateCriteria() {
        TraceUtil.trace3("Logic: Enter updateCriteria()");
        ArrayList<Criteria> newTotalCrits = new ArrayList<Criteria>();
        for (int i = 0; i < this.polCriteriaList.size(); ++i) {
            ArchivePolCriteriaImpl polCrit = (ArchivePolCriteriaImpl)this.polCriteriaList.get(i);
            Criteria[] crits = polCrit.getJniCriteria();
            if (crits == null) continue;
            for (int j = 0; j < crits.length; ++j) {
                newTotalCrits.add(crits[j]);
            }
        }
        this.jniArchiveSet.setCriteria(newTotalCrits.toArray(new Criteria[0]));
        TraceUtil.trace3("Logic: Exit updateCriteria()");
    }

    private void updateRegularCopies() {
        int i;
        TraceUtil.trace3("Logic: Enter updateRegularCopies()");
        CopyParams[] cParams = new CopyParams[MAX_COPY_ALLSETS];
        VSNMap[] maps = new VSNMap[MAX_COPY_ALLSETS];
        for (i = 0; i < MAX_COPY_ALLSETS; ++i) {
            cParams[i] = null;
            maps[i] = null;
        }
        for (i = 0; i < this.archiveCopyList.size(); ++i) {
            ArchiveCopyImpl copy = (ArchiveCopyImpl)this.archiveCopyList.get(i);
            int copyNumber2 = copy.getCopyNumber() - 1;
            cParams[copyNumber2] = copy.getJniCopyParams();
            ArchiveVSNMapImpl map = (ArchiveVSNMapImpl)copy.getArchiveVSNMap();
            if (map == null) continue;
            VSNMap jniMap = map.getJniVSNMap();
            if (map.getWillBeSaved() && !jniMap.isEmpty()) {
                maps[copyNumber2] = jniMap;
            }
            if ("1.3".compareTo(this.model.getServerAPIVersion()) <= 0 || !jniMap.getMediaType().equals("dk")) continue;
            String dvsn = null;
            if (!jniMap.isEmpty() && SamQFSUtil.isValidString(dvsn = jniMap.getVSNNames()[0])) {
                copy.setDiskArchiveVSN(dvsn);
                maps[copyNumber2] = null;
                continue;
            }
            TraceUtil.trace1("no disk vsn in dk VSNMap!");
        }
        this.jniArchiveSet.setCopies(cParams);
        this.jniArchiveSet.setMaps(maps);
        TraceUtil.trace3("Logic: Exit updateRegularCopies()");
    }
}

