/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive43;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.Copy;
import com.sun.netstorage.samqfs.mgmt.arc.Criteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolCriteriaCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolCriteriaPropImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolicyImpl;
import java.util.ArrayList;

public class ArchivePolCriteriaImpl
implements ArchivePolCriteria {
    private ArchivePolicyImpl policy = null;
    private int index = -1;
    private ArrayList fsNameList = new ArrayList();
    private ArchivePolCriteriaPropImpl criteriaProp = null;
    private ArrayList criteriaCopy = new ArrayList();

    public ArchivePolCriteriaImpl(ArchivePolicyImpl policy, int index, ArrayList criteriaList) throws SamFSException {
        this.policy = policy;
        this.index = index;
        Criteria commonCrit = null;
        if (criteriaList != null && criteriaList.size() > 0) {
            for (int i = 0; i < criteriaList.size(); ++i) {
                if (i == 0) {
                    commonCrit = (Criteria)criteriaList.get(i);
                }
                this.fsNameList.add(((Criteria)criteriaList.get(i)).getFilesysName());
            }
        }
        if (commonCrit == null) {
            throw new SamFSException("logic.mismatchLogicBackend");
        }
        this.criteriaProp = new ArchivePolCriteriaPropImpl(this, commonCrit);
        Copy[] copies = commonCrit.getCopies();
        if (copies != null) {
            for (int i = 0; i < copies.length; ++i) {
                if (copies[i] == null) continue;
                this.criteriaCopy.add(new ArchivePolCriteriaCopyImpl(this, copies[i], i + 1));
            }
        }
    }

    public ArchivePolCriteriaImpl(ArchivePolCriteriaPropImpl criteriaProp, ArchivePolCriteriaCopyImpl[] critCopies) {
        this.criteriaProp = criteriaProp;
        if (critCopies != null && critCopies.length > 0) {
            for (int i = 0; i < critCopies.length; ++i) {
                this.criteriaCopy.add(critCopies[i]);
            }
        }
    }

    public Criteria[] getJniCriteria() {
        int i;
        ArrayList<Criteria> crits = new ArrayList<Criteria>();
        Copy[] copies = new Copy[ArchivePolicyImpl.MAX_COPY_ALLSETS];
        for (i = 0; i < ArchivePolicyImpl.MAX_COPY_ALLSETS; ++i) {
            copies[i] = null;
        }
        for (i = 0; i < this.criteriaCopy.size(); ++i) {
            ArchivePolCriteriaCopyImpl cp = (ArchivePolCriteriaCopyImpl)this.criteriaCopy.get(i);
            copies[cp.getArchivePolCriteriaCopyNumber() - 1] = cp.getJniCopy();
            copies[cp.getArchivePolCriteriaCopyNumber() - 1].setCopyNumber(cp.getArchivePolCriteriaCopyNumber());
        }
        String policyName = "Unknown";
        if (this.policy != null) {
            policyName = this.policy.getPolicyName();
        }
        Criteria crit = null;
        crit = this.criteriaProp != null ? this.criteriaProp.getJniCriteria() : new Criteria(policyName, "Unknown");
        crit.setCopies(copies);
        if (this.fsNameList.size() == 0) {
            crits.add(crit);
        } else {
            for (int i2 = 0; i2 < this.fsNameList.size(); ++i2) {
                Criteria fsCrit = new Criteria((String)this.fsNameList.get(i2), crit);
                crits.add(fsCrit);
            }
        }
        return crits.toArray(new Criteria[0]);
    }

    public ArchivePolicy getArchivePolicy() {
        return this.policy;
    }

    public void setArchivePolicy(ArchivePolicy policy) {
        this.policy = (ArchivePolicyImpl)policy;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public ArchivePolCriteriaProp getArchivePolCriteriaProperties() {
        return this.criteriaProp;
    }

    public void setArchivePolCriteriaProperties(ArchivePolCriteriaProp prop) {
        this.criteriaProp = (ArchivePolCriteriaPropImpl)prop;
    }

    public ArchivePolCriteriaCopy[] getArchivePolCriteriaCopies() {
        return this.criteriaCopy.toArray(new ArchivePolCriteriaCopy[0]);
    }

    public void setArchivePolCriteriaCopies(ArchivePolCriteriaCopy[] copies) {
        this.criteriaCopy.clear();
        if (copies != null && copies.length > 0) {
            for (int i = 0; i < copies.length; ++i) {
                this.criteriaCopy.add(copies[i]);
            }
        }
    }

    public void addArchivePolCriteriaCopy(ArchivePolCriteriaCopy copy) {
        this.criteriaCopy.add(copy);
    }

    public void removeArchivePolCriteriaCopy(int copyNo) {
        for (int i = 0; i < this.criteriaCopy.size(); ++i) {
            ArchivePolCriteriaCopy cp = (ArchivePolCriteriaCopy)this.criteriaCopy.get(i);
            if (cp.getArchivePolCriteriaCopyNumber() != copyNo) continue;
            this.criteriaCopy.remove(i);
            break;
        }
    }

    public FileSystem[] getFileSystemsForCriteria() throws SamFSException {
        FileSystem[] totalFSList;
        ArrayList<FileSystem> fsList = new ArrayList<FileSystem>();
        if (this.policy != null && this.policy.getModel() != null && (totalFSList = this.policy.getModel().getSamQFSSystemFSManager().getAllFileSystems()) != null) {
            block0: for (int i = 0; i < this.fsNameList.size(); ++i) {
                String name = (String)this.fsNameList.get(i);
                for (int j = 0; j < totalFSList.length; ++j) {
                    if (!name.equals(totalFSList[j].getName())) continue;
                    fsList.add(totalFSList[j]);
                    continue block0;
                }
            }
        }
        return fsList.toArray(new FileSystem[0]);
    }

    public void addFileSystemForCriteria(String fileSystem) throws SamFSException {
        this.addFileSystemForCriteria(fileSystem, true);
    }

    public void addFileSystemForCriteria(String fileSystem, boolean activate) throws SamFSException {
        if (this.policy != null && SamQFSUtil.isValidString(fileSystem)) {
            this.fsNameList.add(fileSystem);
            this.policy.updatePolicy(activate);
        }
    }

    public void deleteFileSystemForCriteria(String fileSystem) throws SamFSException {
        this.deleteFileSystemForCriteria(fileSystem, true);
    }

    public void deleteFileSystemForCriteria(String fileSystem, boolean activate) throws SamFSException {
        if (this.policy != null && SamQFSUtil.isValidString(fileSystem)) {
            if (this.fsNameList.size() == 1 && fileSystem.equals((String)this.fsNameList.get(0))) {
                throw new SamFSException("logic.lastFSForCriteria");
            }
            int index = this.fsNameList.indexOf(fileSystem);
            if (index != -1) {
                this.fsNameList.remove(index);
            }
            this.policy.updatePolicy(activate);
        }
    }

    public boolean isFSPresent(String fsName) {
        boolean present = false;
        int index = this.fsNameList.indexOf(fsName);
        if (index != -1) {
            present = true;
        }
        return present;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Policy Name: \n");
        if (this.getArchivePolicy() != null) {
            buf.append(this.policy.getPolicyName() + "\n");
        }
        buf.append("Policy criteria index number: " + this.getIndex() + "\n");
        buf.append("Criteria Property: \n");
        if (this.criteriaProp != null) {
            buf.append(this.criteriaProp.toString() + "\n");
        }
        buf.append("Criteria Copies: \n");
        ArchivePolCriteriaCopy[] copies = this.getArchivePolCriteriaCopies();
        if (copies != null && copies.length > 0) {
            for (int i = 0; i < copies.length; ++i) {
                buf.append(copies[i].toString() + "\n");
            }
        }
        buf.append("Criteria File Systems: \n");
        String[] names = this.fsNameList.toArray(new String[0]);
        if (names != null && names.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                buf.append(names[i] + "\n");
            }
        }
        return buf.toString();
    }
}

