/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.Archiver;
import com.sun.netstorage.samqfs.mgmt.arc.VSNOp;
import com.sun.netstorage.samqfs.mgmt.arc.VSNPool;
import com.sun.netstorage.samqfs.mgmt.arc.VSNPoolProps;
import com.sun.netstorage.samqfs.mgmt.media.CatEntry;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemMediaManagerImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import java.util.ArrayList;

public class VSNPoolImpl
implements com.sun.netstorage.samqfs.web.model.archive.VSNPool,
Cloneable {
    private SamQFSSystemModelImpl model = null;
    private VSNPool jniPool = null;
    private VSNPoolProps jniPoolProp = null;
    private String poolName = new String();
    private int mediaType = -1;
    private long spaceAvailable = -1L;
    private String vsnExp = new String();
    private ArrayList memberVSNs = new ArrayList();

    public VSNPoolImpl() {
    }

    public VSNPoolImpl(String poolName, int mediaType, String vsnExp, ArrayList memberVSNs) {
        if (poolName != null) {
            this.poolName = poolName;
        }
        this.mediaType = mediaType;
        if (vsnExp != null) {
            this.vsnExp = vsnExp;
        }
        if (memberVSNs != null) {
            this.memberVSNs = memberVSNs;
        }
    }

    public VSNPoolImpl(SamQFSSystemModelImpl model, VSNPool jniPool) throws SamFSException {
        this.model = model;
        this.poolName = jniPool.getName();
        this.mediaType = SamQFSUtil.getMediaTypeInteger(jniPool.getMediaType());
        this.vsnExp = SamQFSUtil.createVSNExpressionFromStrings(jniPool.getVSNs());
        this.jniPool = jniPool;
        this.jniPoolProp = this.getJniPoolPropsForProperty();
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getMediaType() {
        return this.mediaType;
    }

    public long getSpaceAvailable() throws SamFSException {
        long available = 0L;
        if (this.jniPoolProp != null) {
            available = this.jniPoolProp.getFreeSpace();
        }
        return available;
    }

    public String getVSNExpression() {
        return this.vsnExp;
    }

    public void update() throws SamFSException {
        String[] newExp = SamQFSUtil.getStringsFromCommaStream(this.vsnExp);
        Ctx ctx = null;
        if (this.model != null) {
            ctx = this.model.getJniContext();
        }
        if (this.jniPool == null) {
            this.jniPool = new VSNPool(this.poolName, SamQFSUtil.getMediaTypeString(this.mediaType), newExp);
            VSNOp.addPool((Ctx)ctx, (VSNPool)this.jniPool);
            this.jniPoolProp = this.getJniPoolPropsForProperty();
        } else {
            this.jniPool.setVSNs(newExp);
            VSNOp.modifyPool((Ctx)ctx, (VSNPool)this.jniPool);
            this.jniPoolProp = this.getJniPoolPropsForProperty();
        }
        Archiver.activateCfgThrowWarnings((Ctx)ctx);
    }

    public Object clone() {
        VSNPoolImpl newPool = null;
        try {
            ArrayList list = null;
            if (this.memberVSNs != null) {
                list = new ArrayList();
                for (int i = 0; i < this.memberVSNs.size(); ++i) {
                    list.add(this.memberVSNs.get(i));
                }
            }
            newPool = new VSNPoolImpl(this.getPoolName(), this.getMediaType(), this.getVSNExpression(), list);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newPool;
    }

    public String toString() {
        long spaceAvailable = 0L;
        try {
            spaceAvailable = this.getSpaceAvailable();
        }
        catch (Exception e) {
            // empty catch block
        }
        StringBuffer buf = new StringBuffer();
        buf.append("Pool Name: " + this.poolName + "\n");
        buf.append("Media Type: " + this.mediaType + "\n");
        buf.append("Space Available: " + spaceAvailable + "\n");
        buf.append("VSN Expression: " + this.vsnExp + "\n");
        try {
            if (this.memberVSNs != null) {
                for (int i = 0; i < this.memberVSNs.size(); ++i) {
                    buf.append("VSN Members: " + (VSN)this.memberVSNs.get(i) + "\n\n");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return buf.toString();
    }

    /*
     * WARNING - void declaration
     */
    public VSN[] getMemberVSNs(int start, int size, int sortby, boolean ascending) throws SamFSException {
        void var6_6;
        VSNPoolProps prop;
        CatEntry[] vsnFromCat;
        VSN[] list = new VSN[]{};
        switch (sortby) {
            case 7: {
                int s = 2;
                break;
            }
            case 8: {
                int s = 0;
                break;
            }
            case 9: {
                int s = 1;
                break;
            }
            default: {
                throw new SamFSException("logic.unsupportedSortLib");
            }
        }
        if (this.model != null && (vsnFromCat = (prop = VSNOp.getPoolProps((Ctx)this.model.getJniContext(), (String)this.getPoolName(), (int)start, (int)size, (short)var6_6, (boolean)ascending)).getCatEntries()) != null && vsnFromCat.length > 0) {
            list = new VSN[vsnFromCat.length];
            for (int j = 0; j < vsnFromCat.length; ++j) {
                list[j] = ((SamQFSSystemMediaManagerImpl)this.model.getSamQFSSystemMediaManager()).getVSN(vsnFromCat[j]);
            }
        }
        return list;
    }

    public String[] getMemberVSNNames() throws SamFSException {
        ArrayList<String> list = new ArrayList<String>();
        int max = 100000;
        if (this.jniPoolProp != null) {
            max = this.jniPoolProp.getNumOfVSNs();
        }
        VSNPoolProps prop = VSNOp.getPoolProps((Ctx)this.model.getJniContext(), (String)this.poolName, (int)0, (int)max, (short)0, (boolean)true);
        CatEntry[] cat = null;
        if (prop != null) {
            cat = prop.getCatEntries();
        }
        if (cat != null && cat.length > 0) {
            for (int i = 0; i < cat.length; ++i) {
                list.add(cat[i].getVSN());
            }
        }
        return list.toArray(new String[0]);
    }

    public int getNoOfVSNsInPool() throws SamFSException {
        int no = 0;
        if (this.jniPoolProp == null) {
            this.jniPoolProp = this.getJniPoolPropsForProperty();
        }
        if (this.jniPoolProp != null) {
            no = this.jniPoolProp.getNumOfVSNs();
        }
        return no;
    }

    public void setMemberVSNs(int mediaType, String expression) throws SamFSException {
        this.memberVSNs.clear();
        this.mediaType = mediaType;
        this.vsnExp = expression;
        String[] newExp = SamQFSUtil.getStringsFromCommaStream(expression);
        Ctx ctx = null;
        if (this.model != null) {
            ctx = this.model.getJniContext();
        }
        if (this.jniPool == null) {
            this.jniPool = new VSNPool(this.poolName, SamQFSUtil.getMediaTypeString(mediaType), newExp);
            VSNOp.addPool((Ctx)ctx, (VSNPool)this.jniPool);
            this.jniPoolProp = this.getJniPoolPropsForProperty();
        } else {
            this.jniPool.setVSNs(newExp);
            VSNOp.modifyPool((Ctx)ctx, (VSNPool)this.jniPool);
            this.jniPoolProp = this.getJniPoolPropsForProperty();
        }
    }

    private VSNPoolProps getJniPoolPropsForProperty() throws SamFSException {
        return VSNOp.getPoolProps((Ctx)this.model.getJniContext(), (String)this.poolName, (int)0, (int)10, (short)2, (boolean)true);
    }
}

