/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.Criteria;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveFileParams;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;

public class ArchiveFileParamsImpl
implements ArchiveFileParams,
Cloneable {
    private static final int MIN_CHANGE = 1;
    private static final int MAX_CHANGE = 2;
    private static final int PATTERN_CHANGE = 3;
    private static final int OWNER_CHANGE = 4;
    private static final int GROUP_CHANGE = 5;
    private static final int STAGE_CHANGE = 6;
    private static final int RELEASE_CHANGE = 7;
    private static final int START_CHANGE = 8;
    private ArchivePolicy archPolicy = null;
    private Criteria criteria = null;
    private String startingDir = new String();
    private long minSize = -1L;
    private int minSizeUnit = -1;
    private long maxSize = -1L;
    private int maxSizeUnit = -1;
    private String namePattern = new String();
    private String owner = new String();
    private String group = new String();
    private int stageAttribs = -1;
    private int releaseAttribs = -1;

    public ArchiveFileParamsImpl() {
    }

    public ArchiveFileParamsImpl(ArchivePolicy archPolicy, String startingDir, long minSize, long maxSize, String namePattern, String owner, String group, int stageAttribs, int releaseAttribs) {
        this.archPolicy = archPolicy;
        if (startingDir != null) {
            this.startingDir = startingDir;
        }
        this.minSize = minSize;
        this.maxSize = maxSize;
        if (namePattern != null) {
            this.namePattern = namePattern;
        }
        if (owner != null) {
            this.owner = owner;
        }
        if (group != null) {
            this.group = group;
        }
        this.stageAttribs = stageAttribs;
        this.releaseAttribs = releaseAttribs;
        if (minSize >= 0L) {
            this.minSizeUnit = 0;
        }
        if (maxSize >= 0L) {
            this.maxSizeUnit = 0;
        }
    }

    public ArchiveFileParamsImpl(ArchivePolicy archPolicy, Criteria criteria) {
        this.archPolicy = archPolicy;
        this.criteria = criteria;
        if (criteria != null) {
            String size;
            this.startingDir = criteria.getRootDir();
            String tmp = criteria.getMinSize();
            if (SamQFSUtil.isValidString(tmp)) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.minSize = SamQFSUtil.getLongVal(size);
                this.minSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            if (SamQFSUtil.isValidString(tmp = criteria.getMaxSize())) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.maxSize = SamQFSUtil.getLongVal(size);
                this.maxSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            this.namePattern = criteria.getRegExp();
            this.owner = criteria.getUser();
            this.group = criteria.getGroup();
            this.stageAttribs = SamQFSUtil.convertStageAttribFromJni(criteria.getStageAttr());
            this.releaseAttribs = SamQFSUtil.convertReleaseAttribFromJni(criteria.getReleaseAttr());
        } else {
            this.criteria = new Criteria("unknown", "unknown");
        }
    }

    public ArchivePolicy getArchivePolicy() throws SamFSException {
        return this.archPolicy;
    }

    public void setArchivePolicy(ArchivePolicy policy) throws SamFSException {
        this.archPolicy = policy;
    }

    public Criteria getJniCriteria() {
        return this.criteria;
    }

    public String getStartingDir() throws SamFSException {
        return this.startingDir;
    }

    public void setStartingDir(String startingDir) throws SamFSException {
        if (startingDir != null) {
            this.startingDir = startingDir;
        }
        this.updateCriteria(8, -1L, startingDir);
    }

    public long getMinSize() throws SamFSException {
        return this.minSize;
    }

    public void setMinSize(long size) throws SamFSException {
        this.minSize = size;
        this.changeMinOrMax(true, this.minSize, this.minSizeUnit);
    }

    public long getMinSizeInBytes() throws SamFSException {
        long size = -1L;
        if (this.minSizeUnit != -1 && this.minSize >= 0L) {
            size = SamQFSUtil.getSizeInBytes(this.minSize, this.minSizeUnit);
        }
        return size;
    }

    public int getMinSizeUnit() throws SamFSException {
        return this.minSizeUnit;
    }

    public void setMinSizeUnit(int sizeUnit) throws SamFSException {
        this.minSizeUnit = sizeUnit;
        this.changeMinOrMax(true, this.minSize, this.minSizeUnit);
    }

    public long getMaxSize() throws SamFSException {
        return this.maxSize;
    }

    public void setMaxSize(long size) throws SamFSException {
        this.maxSize = size;
        this.changeMinOrMax(false, this.maxSize, this.maxSizeUnit);
    }

    public long getMaxSizeInBytes() throws SamFSException {
        long size = -1L;
        if (this.maxSizeUnit != -1 && this.maxSize >= 0L) {
            size = SamQFSUtil.getSizeInBytes(this.maxSize, this.maxSizeUnit);
        }
        return size;
    }

    public int getMaxSizeUnit() throws SamFSException {
        return this.maxSizeUnit;
    }

    public void setMaxSizeUnit(int sizeUnit) throws SamFSException {
        this.maxSizeUnit = sizeUnit;
        this.changeMinOrMax(false, this.maxSize, this.maxSizeUnit);
    }

    public String getNamePattern() throws SamFSException {
        return this.namePattern;
    }

    public void setNamePattern(String pattern) throws SamFSException {
        this.namePattern = pattern;
        this.updateCriteria(3, -1L, pattern);
    }

    public String getOwner() throws SamFSException {
        return this.owner;
    }

    public void setOwner(String owner) throws SamFSException {
        this.owner = owner;
        this.updateCriteria(4, -1L, owner);
    }

    public String getGroup() throws SamFSException {
        return this.group;
    }

    public void setGroup(String group) throws SamFSException {
        this.group = group;
        this.updateCriteria(5, -1L, group);
    }

    public int getStageAttributes() throws SamFSException {
        return this.stageAttribs;
    }

    public void setStageAttributes(int attribs) throws SamFSException {
        this.stageAttribs = attribs;
        this.updateCriteria(6, attribs, null);
    }

    public int getReleaseAttributes() throws SamFSException {
        return this.releaseAttribs;
    }

    public void setReleaseAttributes(int attribs) throws SamFSException {
        this.releaseAttribs = attribs;
        this.updateCriteria(7, attribs, null);
    }

    public Object clone() {
        ArchiveFileParamsImpl newParams = null;
        try {
            newParams = new ArchiveFileParamsImpl(this.getArchivePolicy(), this.getStartingDir(), this.getMinSizeInBytes(), this.getMaxSizeInBytes(), this.getNamePattern(), this.getOwner(), this.getGroup(), this.getStageAttributes(), this.getReleaseAttributes());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newParams;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.archPolicy != null) {
            try {
                buf.append("Archive Policy: " + this.archPolicy.getPolicyName() + "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        buf.append("Min Size: " + this.minSize + "\n");
        buf.append("Max Size: " + this.maxSize + "\n");
        buf.append("Name Pattern: " + this.namePattern + "\n");
        buf.append("Owner: " + this.owner + "\n");
        buf.append("Group: " + this.group + "\n");
        buf.append("Stage Attributes: " + this.stageAttribs + "\n");
        buf.append("Release Attributes: " + this.releaseAttribs + "\n");
        return buf.toString();
    }

    private void updateCriteria(int field, long newIntVal, String newStrVal) {
        Criteria[] c = new Criteria[]{this.criteria};
        if (this.criteria != null) {
            switch (field) {
                case 8: {
                    for (int i = 0; i < c.length; ++i) {
                        if (!SamQFSUtil.isValidString(newStrVal)) {
                            c[i].resetRootDir();
                            continue;
                        }
                        c[i].setRootDir(newStrVal);
                    }
                    break;
                }
                case 3: {
                    for (int i = 0; i < c.length; ++i) {
                        if (!SamQFSUtil.isValidString(newStrVal)) {
                            c[i].resetRegExp();
                            continue;
                        }
                        c[i].setRegExp(newStrVal);
                    }
                    break;
                }
                case 4: {
                    for (int i = 0; i < c.length; ++i) {
                        if (!SamQFSUtil.isValidString(newStrVal)) {
                            c[i].resetUser();
                            continue;
                        }
                        c[i].setUser(newStrVal);
                    }
                    break;
                }
                case 5: {
                    for (int i = 0; i < c.length; ++i) {
                        if (!SamQFSUtil.isValidString(newStrVal)) {
                            c[i].resetGroup();
                            continue;
                        }
                        c[i].setGroup(newStrVal);
                    }
                    break;
                }
                case 6: {
                    for (int i = 0; i < c.length; ++i) {
                        if (newIntVal == -1L || newIntVal == 10004L) {
                            c[i].resetStageAttr();
                            continue;
                        }
                        c[i].setStageAttr(SamQFSUtil.convertStageAttribToJni(newIntVal));
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < c.length; ++i) {
                        if (newIntVal == -1L || newIntVal == 10009L) {
                            c[i].resetReleaseAttr();
                            continue;
                        }
                        c[i].setReleaseAttr(SamQFSUtil.convertReleaseAttribToJni(newIntVal));
                    }
                    break;
                }
            }
        }
    }

    private void changeMinOrMax(boolean min, long size, int sizeUnit) throws SamFSException {
        block6: {
            Criteria[] c = new Criteria[]{this.criteria};
            if (this.criteria == null) break block6;
            if (min) {
                for (int i = 0; i < c.length; ++i) {
                    if (size != -1L && sizeUnit != -1) {
                        String unit = SamQFSUtil.getUnitString(sizeUnit);
                        c[i].setMinSize(SamQFSUtil.fsizeToString(new Long(size).toString() + unit));
                        continue;
                    }
                    c[i].resetMinSize();
                }
            } else {
                for (int i = 0; i < c.length; ++i) {
                    if (size != -1L && sizeUnit != -1) {
                        String unit = SamQFSUtil.getUnitString(sizeUnit);
                        c[i].setMaxSize(SamQFSUtil.fsizeToString(new Long(size).toString() + unit));
                        continue;
                    }
                    c[i].resetMaxSize();
                }
            }
        }
    }
}

