/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.archive;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.Copy;
import com.sun.netstorage.samqfs.mgmt.arc.CopyParams;
import com.sun.netstorage.samqfs.mgmt.rec.RecyclerParams;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchiveVSNMapImpl;

public class ArchiveCopyImpl
implements ArchiveCopy,
Cloneable {
    private CopyParams param = null;
    private Copy[] copy = null;
    private ArchivePolicy archPolicy = null;
    private int copyNumber = -1;
    private ArchiveVSNMap archVSNMap = null;
    private long archAge = -1L;
    private int archAgeUnit = -1;
    private int resMethod = -1;
    private int archSortMethod = -1;
    private int offlineCopyMethod = -1;
    private boolean release = false;
    private boolean noRelease = false;
    private String diskArchVSN = new String();
    private String diskArchVSNPath = new String();
    private String diskArchVSNHost = new String();
    private int drives = -1;
    private long maxDrives = -1L;
    private int maxDrivesUnit = -1;
    private long minDrives = -1L;
    private int minDrivesUnit = -1;
    private int joinMethod = -1;
    private long unarchAge = -1L;
    private int unarchAgeUnit = -1;
    private int unarchTimeRef = -1;
    private boolean fillVSNs = false;
    private long overflowMinSize = -1L;
    private int overflowMinSizeUnit = -1;
    private long archMaxSize = -1L;
    private int archMaxSizeUnit = -1;
    private int bufSize = -1;
    private boolean bufLocked = false;
    private long startAge = -1L;
    private int startAgeUnit = -1;
    private int startCount = -1;
    private long startSize = -1L;
    private int startSizeUnit = -1;
    private long recDataSize = -1L;
    private int recDataSizeUnit = -1;
    private int recHWM = -1;
    private boolean ignoreRec = false;
    private String notifyAddr = new String();
    private int minGain = -1;
    private int maxVSNCount = -1;
    private boolean isReleaseSet = false;
    private boolean isNoReleaseSet = false;
    private boolean isFillVSNsSet = false;
    private boolean isBufLockedSet = false;
    private boolean isIgnoreRecSet = false;

    public ArchiveCopyImpl() {
    }

    public ArchiveCopyImpl(ArchivePolicy archPolicy, int copyNumber2, ArchiveVSNMap archVSNMap, long archAge, int resMethod, int archSortMethod, int offlineCopyMethod, boolean release, boolean noRelease, String diskArchVSN, int drives, long maxDrives, long minDrives, int joinMethod, long unarchAge, int unarchTimeRef, boolean fillVSNs, long overflowMinSize, long archMaxSize, int bufSize, boolean bufLocked, long startAge, int startCount, long startSize, long recDataSize, int recHWM, boolean ignoreRec, String notifyAddr, int minGain, int maxVSNCount) throws SamFSException {
        this.archPolicy = archPolicy;
        this.copyNumber = copyNumber2;
        this.archVSNMap = archVSNMap;
        this.archAge = archAge;
        this.resMethod = resMethod;
        this.archSortMethod = archSortMethod;
        this.offlineCopyMethod = offlineCopyMethod;
        this.release = release;
        this.noRelease = noRelease;
        this.diskArchVSN = diskArchVSN;
        this.drives = drives;
        this.maxDrives = maxDrives;
        this.minDrives = minDrives;
        this.joinMethod = joinMethod;
        this.unarchAge = unarchAge;
        this.unarchTimeRef = unarchTimeRef;
        this.fillVSNs = fillVSNs;
        this.overflowMinSize = overflowMinSize;
        this.archMaxSize = archMaxSize;
        this.bufSize = bufSize;
        this.bufLocked = bufLocked;
        this.startAge = startAge;
        this.startCount = startCount;
        this.startSize = startSize;
        this.recDataSize = recDataSize;
        this.recHWM = recHWM;
        this.ignoreRec = ignoreRec;
        this.notifyAddr = notifyAddr;
        this.minGain = minGain;
        this.maxVSNCount = maxVSNCount;
    }

    public ArchiveCopyImpl(ArchivePolicy policy, ArchiveVSNMap map, int copyNumber2, Copy copy, CopyParams param) {
        long sec;
        String tmp;
        this.archPolicy = policy;
        this.archVSNMap = map;
        this.copyNumber = copyNumber2;
        if (copy != null) {
            this.copy = new Copy[1];
            this.copy[0] = copy;
        }
        this.param = param;
        if (param != null) {
            RecyclerParams recP;
            String size;
            this.resMethod = SamQFSUtil.convertARResMethod(param.getReservationMethod());
            this.archSortMethod = SamQFSUtil.convertARSortMethod(param.getArchiveSortMethod());
            this.offlineCopyMethod = SamQFSUtil.convertAROfflineCopyMethod(param.getOfflineCopyMethod());
            this.diskArchVSN = param.getDiskArchiveVol();
            this.drives = param.getDrives();
            tmp = param.getMaxDrives();
            if (SamQFSUtil.isValidString(tmp)) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.maxDrives = SamQFSUtil.getLongVal(size);
                this.maxDrivesUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            if (SamQFSUtil.isValidString(tmp = param.getMinDrives())) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.minDrives = SamQFSUtil.getLongVal(size);
                this.minDrivesUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            this.joinMethod = SamQFSUtil.convertARJoinMethod(param.getJoinMethod());
            this.unarchTimeRef = !param.getUnarchAge() ? 11 : 12;
            this.fillVSNs = param.isFillVSNs();
            tmp = param.getOverflowMinSize();
            if (SamQFSUtil.isValidString(tmp)) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.overflowMinSize = SamQFSUtil.getLongVal(size);
                this.overflowMinSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            if (SamQFSUtil.isValidString(tmp = param.getArchMax())) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.archMaxSize = SamQFSUtil.getLongVal(size);
                this.archMaxSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            this.bufSize = param.getBufSize();
            if (this.bufSize < 2 || this.bufSize > 1024) {
                this.bufSize = -1;
            }
            this.bufLocked = param.isBufferLocked();
            sec = param.getStartAge();
            if (sec >= 0L) {
                tmp = SamQFSUtil.longToInterval(sec);
                this.startAge = SamQFSUtil.getLongValSecond(tmp);
                this.startAgeUnit = SamQFSUtil.getTimeUnitInteger(tmp);
            }
            this.startCount = param.getStartCount();
            tmp = param.getStartSize();
            if (SamQFSUtil.isValidString(tmp)) {
                size = SamQFSUtil.stringToFsize(tmp);
                this.startSize = SamQFSUtil.getLongVal(size);
                this.startSizeUnit = SamQFSUtil.getSizeUnitInteger(size);
            }
            if ((recP = param.getRecyclerParams()) != null) {
                if (SamQFSUtil.isValidString(recP.getDatasize())) {
                    String size2 = SamQFSUtil.stringToFsize(recP.getDatasize());
                    this.recDataSize = SamQFSUtil.getLongVal(size2);
                    this.recDataSizeUnit = SamQFSUtil.getSizeUnitInteger(size2);
                }
                this.recHWM = recP.getHWM();
                this.ignoreRec = recP.getIgnore();
                this.notifyAddr = recP.getEmailAddr();
                this.minGain = recP.getMinGain();
                this.maxVSNCount = recP.getVSNCount();
            }
        }
        Copy target = null;
        if (this.copy != null && this.copy.length == 1) {
            target = this.copy[0];
        }
        if (target != null) {
            sec = target.getArchiveAge();
            if (sec >= 0L) {
                tmp = SamQFSUtil.longToInterval(sec);
                this.archAge = SamQFSUtil.getLongValSecond(tmp);
                this.archAgeUnit = SamQFSUtil.getTimeUnitInteger(tmp);
            }
            if ((sec = target.getUnarchiveAge()) >= 0L) {
                tmp = SamQFSUtil.longToInterval(sec);
                this.unarchAge = SamQFSUtil.getLongValSecond(tmp);
                this.unarchAgeUnit = SamQFSUtil.getTimeUnitInteger(tmp);
            }
            this.release = target.isRelease();
            this.noRelease = target.isNoRelease();
        }
    }

    public Copy getJniCopy() {
        if (this.copy == null || this.copy.length != 1) {
            this.createCopy();
        }
        Copy cp = null;
        if (this.copy != null && this.copy.length == 1) {
            cp = this.copy[0];
        }
        return cp;
    }

    public CopyParams getJniCopyParams() {
        if (this.param == null) {
            this.createParam();
        }
        if (!SamQFSUtil.isValidString(this.param.getName())) {
            String name = null;
            try {
                name = this.archPolicy.getPolicyName() + "." + this.copyNumber;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.param = new CopyParams(name, this.param);
        }
        return this.param;
    }

    public ArchivePolicy getArchivePolicy() throws SamFSException {
        return this.archPolicy;
    }

    public void setArchivePolicy(ArchivePolicy policy) throws SamFSException {
        this.archPolicy = policy;
    }

    public int getCopyNumber() throws SamFSException {
        return this.copyNumber;
    }

    public void setCopyNumber(int number) throws SamFSException {
        this.copyNumber = number;
    }

    public ArchiveVSNMap getArchiveVSNMap() throws SamFSException {
        return this.archVSNMap;
    }

    public void setArchiveVSNMap(ArchiveVSNMap map) throws SamFSException {
        this.archVSNMap = map;
    }

    public long getArchiveAge() throws SamFSException {
        return this.archAge;
    }

    public void setArchiveAge(long age) throws SamFSException {
        this.archAge = age;
        if (this.copy != null) {
            for (int i = 0; i < this.copy.length; ++i) {
                if (age != -1L) {
                    if (this.archAgeUnit == -1) continue;
                    this.copy[i].setArchiveAge(SamQFSUtil.convertToSecond(this.archAge, this.archAgeUnit));
                    continue;
                }
                this.copy[i].resetArchiveAge();
            }
        }
    }

    public int getArchiveAgeUnit() throws SamFSException {
        return this.archAgeUnit;
    }

    public void setArchiveAgeUnit(int ageUnit) throws SamFSException {
        this.archAgeUnit = ageUnit;
        if (this.copy != null) {
            for (int i = 0; i < this.copy.length; ++i) {
                if (ageUnit != -1) {
                    if (this.archAge == -1L) continue;
                    this.copy[i].setArchiveAge(SamQFSUtil.convertToSecond(this.archAge, this.archAgeUnit));
                    continue;
                }
                this.copy[i].resetArchiveAge();
            }
        }
    }

    public int getReservationMethod() throws SamFSException {
        return this.resMethod;
    }

    public void setReservationMethod(int method) throws SamFSException {
        this.resMethod = method;
        if (this.param != null) {
            if (method != -1) {
                this.param.setReservationMethod(SamQFSUtil.convertARResMethodJni(method));
            } else {
                this.param.reserReservationMethod();
            }
        }
    }

    public int getArchiveSortMethod() throws SamFSException {
        return this.archSortMethod;
    }

    public void setArchiveSortMethod(int method) throws SamFSException {
        this.archSortMethod = method;
        if (this.param != null) {
            if (method != -1) {
                this.param.setArchiveSortMethod(SamQFSUtil.convertARSortMethodJni(method));
            } else {
                this.param.resetArchiveSortMethod();
            }
        }
    }

    public int getOfflineCopyMethod() throws SamFSException {
        return this.offlineCopyMethod;
    }

    public void setOfflineCopyMethod(int method) throws SamFSException {
        this.offlineCopyMethod = method;
        if (this.param != null) {
            if (method != -1) {
                this.param.setOfflineCopyMethod(SamQFSUtil.convertAROfflineCopyMethodJni(method));
            } else {
                this.param.resetOfflineCopyMethod();
            }
        }
    }

    public boolean isRelease() throws SamFSException {
        return this.release;
    }

    public void setRelease(boolean release) throws SamFSException {
        this.release = release;
        if (this.copy != null) {
            for (int i = 0; i < this.copy.length; ++i) {
                this.copy[i].setRelease(release);
            }
        } else {
            this.isReleaseSet = true;
        }
    }

    public boolean isNoRelease() throws SamFSException {
        return this.noRelease;
    }

    public void setNoRelease(boolean noRelease) throws SamFSException {
        this.noRelease = noRelease;
        if (this.copy != null) {
            for (int i = 0; i < this.copy.length; ++i) {
                this.copy[i].setNoRelease(noRelease);
            }
        } else {
            this.isNoReleaseSet = true;
        }
    }

    public String getDiskArchiveVSN() throws SamFSException {
        return this.diskArchVSN;
    }

    public void setDiskArchiveVSN(String vsn) throws SamFSException {
        this.diskArchVSN = vsn;
        if (this.param != null) {
            if (SamQFSUtil.isValidString(vsn)) {
                this.param.setDiskArchiveVol(vsn);
            } else {
                this.param.resetDiskArchiveVol();
            }
        }
    }

    public String getDiskArchiveVSNPath() throws SamFSException {
        return this.diskArchVSNPath;
    }

    public void setDiskArchiveVSNPath(String path) throws SamFSException {
        this.diskArchVSNPath = path;
    }

    public String getDiskArchiveVSNHost() throws SamFSException {
        return this.diskArchVSNHost;
    }

    public void setDiskArchiveVSNHost(String hostname) throws SamFSException {
        this.diskArchVSNHost = hostname;
    }

    public int getDrives() throws SamFSException {
        return this.drives;
    }

    public void setDrives(int drives) throws SamFSException {
        this.drives = drives;
        if (this.param != null) {
            if (drives != -1) {
                this.param.setDrives(drives);
            } else {
                this.param.resetDrives();
            }
        }
    }

    public long getMaxDrives() throws SamFSException {
        return this.maxDrives;
    }

    public void setMaxDrives(long size) throws SamFSException {
        this.maxDrives = size;
        if (this.param != null) {
            if (size != -1L) {
                if (this.maxDrivesUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.maxDrivesUnit);
                    this.param.setMaxDrives(SamQFSUtil.fsizeToString(new Long(this.maxDrives).toString() + unit));
                }
            } else {
                this.param.resetMaxDrives();
            }
        }
    }

    public int getMaxDrivesUnit() throws SamFSException {
        return this.maxDrivesUnit;
    }

    public void setMaxDrivesUnit(int sizeUnit) throws SamFSException {
        this.maxDrivesUnit = sizeUnit;
        if (this.param != null) {
            if (sizeUnit != -1) {
                if (this.maxDrives != -1L) {
                    String unit = SamQFSUtil.getUnitString(this.maxDrivesUnit);
                    this.param.setMaxDrives(SamQFSUtil.fsizeToString(new Long(this.maxDrives).toString() + unit));
                }
            } else {
                this.param.resetMaxDrives();
            }
        }
    }

    public long getMinDrives() throws SamFSException {
        return this.minDrives;
    }

    public void setMinDrives(long size) throws SamFSException {
        this.minDrives = size;
        if (this.param != null) {
            if (size != -1L) {
                if (this.minDrivesUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.minDrivesUnit);
                    this.param.setMinDrives(SamQFSUtil.fsizeToString(new Long(this.minDrives).toString() + unit));
                }
            } else {
                this.param.resetMinDrives();
            }
        }
    }

    public int getMinDrivesUnit() throws SamFSException {
        return this.minDrivesUnit;
    }

    public void setMinDrivesUnit(int sizeUnit) throws SamFSException {
        this.minDrivesUnit = sizeUnit;
        if (this.param != null) {
            if (sizeUnit != -1) {
                if (this.minDrives != -1L) {
                    String unit = SamQFSUtil.getUnitString(this.minDrivesUnit);
                    this.param.setMinDrives(SamQFSUtil.fsizeToString(new Long(this.minDrives).toString() + unit));
                }
            } else {
                this.param.resetMinDrives();
            }
        }
    }

    public int getJoinMethod() throws SamFSException {
        return this.joinMethod;
    }

    public void setJoinMethod(int method) throws SamFSException {
        this.joinMethod = method;
        if (this.param != null) {
            if (method != -1) {
                this.param.setJoinMethod(SamQFSUtil.convertARJoinMethodJni(method));
            } else {
                this.param.resetJoinMethod();
            }
        }
    }

    public long getUnarchiveAge() throws SamFSException {
        return this.unarchAge;
    }

    public void setUnarchiveAge(long age) throws SamFSException {
        this.unarchAge = age;
        if (this.copy != null) {
            for (int i = 0; i < this.copy.length; ++i) {
                if (age != -1L) {
                    if (this.unarchAgeUnit == -1) continue;
                    this.copy[i].setUnarchiveAge(SamQFSUtil.convertToSecond(this.unarchAge, this.unarchAgeUnit));
                    continue;
                }
                this.copy[i].resetUnarchiveAge();
            }
        }
    }

    public int getUnarchiveAgeUnit() throws SamFSException {
        return this.unarchAgeUnit;
    }

    public void setUnarchiveAgeUnit(int ageUnit) throws SamFSException {
        this.unarchAgeUnit = ageUnit;
        if (this.copy != null) {
            for (int i = 0; i < this.copy.length; ++i) {
                if (ageUnit != -1) {
                    if (this.unarchAge == -1L) continue;
                    this.copy[i].setUnarchiveAge(SamQFSUtil.convertToSecond(this.unarchAge, this.unarchAgeUnit));
                    continue;
                }
                this.copy[i].resetUnarchiveAge();
            }
        }
    }

    public int getUnarchiveTimeReference() throws SamFSException {
        return this.unarchTimeRef;
    }

    public void setUnarchiveTimeReference(int ref) throws SamFSException {
        this.unarchTimeRef = ref;
        if (this.param != null) {
            if (ref == -1) {
                this.param.resetUnarchAge();
            } else if (ref == 12) {
                this.param.setUnarchAge(true);
            } else if (ref == 11) {
                this.param.setUnarchAge(false);
            }
        }
    }

    public boolean isFillVSNs() throws SamFSException {
        return this.fillVSNs;
    }

    public void setFillVSNs(boolean fillVSN) throws SamFSException {
        this.fillVSNs = fillVSN;
        if (this.param != null) {
            this.param.setFillVSNs(fillVSN);
        } else {
            this.isFillVSNsSet = true;
        }
    }

    public long getOverflowMinSize() throws SamFSException {
        return this.overflowMinSize;
    }

    public void setOverflowMinSize(long size) throws SamFSException {
        this.overflowMinSize = size;
        if (this.param != null) {
            if (size != -1L) {
                if (this.overflowMinSizeUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.overflowMinSizeUnit);
                    this.param.setOverflowMinSize(SamQFSUtil.fsizeToString(new Long(this.overflowMinSize).toString() + unit));
                }
            } else {
                this.param.resetOverflowMinSize();
            }
        }
    }

    public int getOverflowMinSizeUnit() throws SamFSException {
        return this.overflowMinSizeUnit;
    }

    public void setOverflowMinSizeUnit(int sizeUnit) throws SamFSException {
        this.overflowMinSizeUnit = sizeUnit;
        if (this.param != null) {
            if (sizeUnit != -1) {
                if (this.overflowMinSize != -1L) {
                    String unit = SamQFSUtil.getUnitString(this.overflowMinSizeUnit);
                    this.param.setOverflowMinSize(SamQFSUtil.fsizeToString(new Long(this.overflowMinSize).toString() + unit));
                }
            } else {
                this.param.resetOverflowMinSize();
            }
        }
    }

    public long getArchiveMaxSize() throws SamFSException {
        return this.archMaxSize;
    }

    public void setArchiveMaxSize(long size) throws SamFSException {
        this.archMaxSize = size;
        if (this.param != null) {
            if (size != -1L) {
                if (this.archMaxSizeUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.archMaxSizeUnit);
                    this.param.setArchMax(SamQFSUtil.fsizeToString(new Long(this.archMaxSize).toString() + unit));
                }
            } else {
                this.param.resetArchMax();
            }
        }
    }

    public int getArchiveMaxSizeUnit() throws SamFSException {
        return this.archMaxSizeUnit;
    }

    public void setArchiveMaxSizeUnit(int sizeUnit) throws SamFSException {
        this.archMaxSizeUnit = sizeUnit;
        if (this.param != null && sizeUnit != -1 && this.archMaxSize != -1L) {
            String unit = SamQFSUtil.getUnitString(this.archMaxSizeUnit);
            this.param.setArchMax(SamQFSUtil.fsizeToString(new Long(this.archMaxSize).toString() + unit));
        }
    }

    public int getBufferSize() throws SamFSException {
        return this.bufSize;
    }

    public void setBufferSize(int size) throws SamFSException {
        this.bufSize = size;
        if (this.param != null) {
            if (size != -1) {
                this.param.setBufSize(size);
            } else {
                this.param.resetBufSize();
            }
        }
    }

    public boolean isBufferLocked() throws SamFSException {
        return this.bufLocked;
    }

    public void setBufferLocked(boolean lock) throws SamFSException {
        this.bufLocked = lock;
        if (this.param != null) {
            this.param.setBufferLocked(lock);
        } else {
            this.isBufLockedSet = true;
        }
    }

    public long getStartAge() throws SamFSException {
        return this.startAge;
    }

    public void setStartAge(long age) throws SamFSException {
        this.startAge = age;
        if (this.param != null) {
            if (age != -1L) {
                if (this.startAgeUnit != -1) {
                    this.param.setStartAge(SamQFSUtil.convertToSecond(this.startAge, this.startAgeUnit));
                }
            } else {
                this.param.resetStartAge();
            }
        }
    }

    public int getStartAgeUnit() throws SamFSException {
        return this.startAgeUnit;
    }

    public void setStartAgeUnit(int ageUnit) throws SamFSException {
        this.startAgeUnit = ageUnit;
        if (this.param != null) {
            if (ageUnit != -1) {
                if (this.startAge != -1L) {
                    this.param.setStartAge(SamQFSUtil.convertToSecond(this.startAge, this.startAgeUnit));
                }
            } else {
                this.param.resetStartAge();
            }
        }
    }

    public int getStartCount() throws SamFSException {
        return this.startCount;
    }

    public void setStartCount(int count) throws SamFSException {
        this.startCount = count;
        if (this.param != null) {
            if (count != -1) {
                this.param.setStartCount(count);
            } else {
                this.param.resetStartCount();
            }
        }
    }

    public long getStartSize() throws SamFSException {
        return this.startSize;
    }

    public void setStartSize(long size) throws SamFSException {
        this.startSize = size;
        if (this.param != null) {
            if (size != -1L) {
                if (this.startSizeUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.startSizeUnit);
                    this.param.setStartSize(SamQFSUtil.fsizeToString(new Long(this.startSize).toString() + unit));
                }
            } else {
                this.param.resetStartSize();
            }
        }
    }

    public int getStartSizeUnit() throws SamFSException {
        return this.startSizeUnit;
    }

    public void setStartSizeUnit(int sizeUnit) throws SamFSException {
        this.startSizeUnit = sizeUnit;
        if (this.param != null) {
            if (sizeUnit != -1) {
                if (this.startSize != -1L) {
                    String unit = SamQFSUtil.getUnitString(this.startSizeUnit);
                    this.param.setStartSize(SamQFSUtil.fsizeToString(new Long(this.startSize).toString() + unit));
                }
            } else {
                this.param.resetStartSize();
            }
        }
    }

    public long getRecycleDataSize() throws SamFSException {
        return this.recDataSize;
    }

    public void setRecycleDataSize(long size) throws SamFSException {
        this.recDataSize = size;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (size != -1L) {
                if (this.recDataSizeUnit != -1) {
                    String unit = SamQFSUtil.getUnitString(this.recDataSizeUnit);
                    rec.setDatasize(SamQFSUtil.fsizeToString(new Long(this.recDataSize).toString() + unit));
                }
            } else {
                rec.resetDatasize();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public int getRecycleDataSizeUnit() throws SamFSException {
        return this.recDataSizeUnit;
    }

    public void setRecycleDataSizeUnit(int sizeUnit) throws SamFSException {
        this.recDataSizeUnit = sizeUnit;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (sizeUnit != -1) {
                if (this.recDataSize != -1L) {
                    String unit = SamQFSUtil.getUnitString(this.recDataSizeUnit);
                    rec.setDatasize(SamQFSUtil.fsizeToString(new Long(this.recDataSize).toString() + unit));
                }
            } else {
                rec.resetDatasize();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public int getRecycleHWM() throws SamFSException {
        return this.recHWM;
    }

    public void setRecycleHWM(int hwm) throws SamFSException {
        this.recHWM = hwm;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (hwm != -1) {
                rec.setHWM(hwm);
            } else {
                rec.resetHWM();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public boolean isIgnoreRecycle() throws SamFSException {
        return this.ignoreRec;
    }

    public void setIgnoreRecycle(boolean ignore) throws SamFSException {
        this.ignoreRec = ignore;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            rec.setIgnore(ignore);
            this.param.setRecyclerParams(rec);
        } else {
            this.isIgnoreRecSet = true;
        }
    }

    public String getNotificationAddress() throws SamFSException {
        return this.notifyAddr;
    }

    public void setNotificationAddress(String addr) throws SamFSException {
        this.notifyAddr = addr;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (SamQFSUtil.isValidString(addr)) {
                rec.setEmailAddr(addr);
            } else {
                rec.resetEmailAddr();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public int getMinGain() throws SamFSException {
        return this.minGain;
    }

    public void setMinGain(int gain) throws SamFSException {
        this.minGain = gain;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (gain != -1) {
                rec.setMinGain(gain);
            } else {
                rec.resetMinGain();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public int getMaxVSNCount() throws SamFSException {
        return this.maxVSNCount;
    }

    public void setMaxVSNCount(int count) throws SamFSException {
        this.maxVSNCount = count;
        if (this.param != null) {
            RecyclerParams rec = this.param.getRecyclerParams();
            if (rec == null) {
                rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
            }
            if (count != -1) {
                rec.setVSNCount(count);
            } else {
                rec.resetVSNCount();
            }
            this.param.setRecyclerParams(rec);
        }
    }

    public Object clone() {
        ArchiveCopyImpl copy = null;
        try {
            ArchiveVSNMapImpl map = null;
            if (this.getArchiveVSNMap() != null) {
                map = (ArchiveVSNMapImpl)((ArchiveVSNMapImpl)this.getArchiveVSNMap()).clone();
            }
            copy = new ArchiveCopyImpl(this.getArchivePolicy(), this.copyNumber, map, this.archAge, this.resMethod, this.archSortMethod, this.offlineCopyMethod, this.release, this.noRelease, this.diskArchVSN, this.drives, this.maxDrives, this.minDrives, this.joinMethod, this.unarchAge, this.unarchTimeRef, this.fillVSNs, this.overflowMinSize, this.archMaxSize, this.bufSize, this.bufLocked, this.startAge, this.startCount, this.startSize, this.recDataSize, this.recHWM, this.ignoreRec, this.notifyAddr, this.minGain, this.maxVSNCount);
            map.setArchiveCopy(copy);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return copy;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.archPolicy != null) {
            try {
                buf.append("Archive Policy: " + this.archPolicy.getPolicyName() + "\n");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        buf.append("Copy Number: " + this.copyNumber + "\n");
        if (this.archVSNMap != null) {
            buf.append("Archive VSNMap: " + this.archVSNMap.toString() + "\n");
        }
        buf.append("Archive Age: " + this.archAge + "\n");
        buf.append("Reservation Method: " + this.resMethod + "\n");
        buf.append("Archive Sort Method: " + this.archSortMethod + "\n");
        buf.append("Offline Copy Method: " + this.offlineCopyMethod + "\n");
        buf.append("Release: " + this.release + "\n");
        buf.append("No Release: " + this.noRelease + "\n");
        buf.append("DiskArchive VSN: " + this.diskArchVSN + "\n");
        buf.append("Drives: " + this.drives + "\n");
        buf.append("Join Method: " + this.joinMethod + "\n");
        buf.append("Unarchive Age: " + this.unarchAge + "\n");
        buf.append("Unarchive Time Reference: " + this.unarchTimeRef + "\n");
        buf.append("Fill VSNs: " + this.fillVSNs + "\n");
        buf.append("Overflow Min Size: " + this.overflowMinSize + "\n");
        buf.append("Archive Max Size: " + this.archMaxSize + "\n");
        buf.append("Buffer Size: " + this.bufSize + "\n");
        buf.append("Buffer Locked: " + this.bufLocked + "\n");
        buf.append("Start Age: " + this.startAge + "\n");
        buf.append("Start Count: " + this.startCount + "\n");
        buf.append("Start Size: " + this.startSize + "\n");
        buf.append("Recycle Data Size: " + this.recDataSize + "\n");
        buf.append("Recycle HWM: " + this.recHWM + "\n");
        buf.append("Ignore Recycle: " + this.ignoreRec + "\n");
        buf.append("Notification Address: " + this.notifyAddr + "\n");
        buf.append("Min Gain: " + this.minGain + "\n");
        buf.append("Max VSN Count: " + this.maxVSNCount + "\n");
        return buf.toString();
    }

    private void createParam() {
        if (this.archPolicy != null) {
            try {
                String unit;
                this.param = new CopyParams(this.archPolicy.getPolicyName() + "." + this.copyNumber);
                RecyclerParams rec = new RecyclerParams();
                this.param.setRecyclerParams(rec);
                if (this.getReservationMethod() != -1) {
                    this.param.setReservationMethod(SamQFSUtil.convertARResMethodJni(this.getReservationMethod()));
                }
                if (this.getArchiveSortMethod() != -1) {
                    this.param.setArchiveSortMethod(SamQFSUtil.convertARSortMethodJni(this.getArchiveSortMethod()));
                }
                if (this.getOfflineCopyMethod() != -1) {
                    this.param.setOfflineCopyMethod(SamQFSUtil.convertAROfflineCopyMethodJni(this.getOfflineCopyMethod()));
                }
                if (this.getDiskArchiveVSN() != null && !this.getDiskArchiveVSN().equals(new String())) {
                    this.param.setDiskArchiveVol(this.getDiskArchiveVSN());
                }
                if (this.getDrives() != -1) {
                    this.param.setDrives(this.getDrives());
                }
                if (this.getMinDrives() != -1L && this.getMinDrivesUnit() != -1) {
                    unit = SamQFSUtil.getUnitString(this.minDrivesUnit);
                    this.param.setMinDrives(SamQFSUtil.fsizeToString(new Long(this.minDrives).toString() + unit));
                }
                if (this.getMaxDrives() != -1L && this.getMaxDrivesUnit() != -1) {
                    unit = SamQFSUtil.getUnitString(this.maxDrivesUnit);
                    this.param.setMaxDrives(SamQFSUtil.fsizeToString(new Long(this.maxDrives).toString() + unit));
                }
                if (this.getJoinMethod() != -1) {
                    this.param.setJoinMethod(SamQFSUtil.convertARJoinMethodJni(this.getJoinMethod()));
                }
                if (this.getUnarchiveTimeReference() != -1) {
                    this.setUnarchiveTimeReference(this.getUnarchiveTimeReference());
                }
                if (this.isFillVSNsSet) {
                    this.param.setFillVSNs(this.isFillVSNs());
                    this.isFillVSNsSet = false;
                }
                if (this.getOverflowMinSize() != -1L && this.getOverflowMinSizeUnit() != -1) {
                    unit = SamQFSUtil.getUnitString(this.overflowMinSizeUnit);
                    this.param.setOverflowMinSize(SamQFSUtil.fsizeToString(new Long(this.overflowMinSize).toString() + unit));
                }
                if (this.getArchiveMaxSize() != -1L && this.getArchiveMaxSizeUnit() != -1) {
                    unit = SamQFSUtil.getUnitString(this.archMaxSizeUnit);
                    this.param.setArchMax(SamQFSUtil.fsizeToString(new Long(this.archMaxSize).toString() + unit));
                }
                if (this.getBufferSize() != -1) {
                    this.param.setBufSize(this.getBufferSize());
                }
                if (this.isBufLockedSet) {
                    this.param.setBufferLocked(this.isBufferLocked());
                    this.isBufLockedSet = false;
                }
                if (this.getStartAge() != -1L && this.getStartAgeUnit() != -1) {
                    this.param.setStartAge(SamQFSUtil.convertToSecond(this.getStartAge(), this.getStartAgeUnit()));
                }
                if (this.getStartCount() != -1) {
                    this.param.setStartCount(this.getStartCount());
                }
                if (this.getStartSize() != -1L && this.getStartSizeUnit() != -1) {
                    unit = SamQFSUtil.getUnitString(this.startSizeUnit);
                    this.param.setStartSize(SamQFSUtil.fsizeToString(new Long(this.startSize).toString() + unit));
                }
                if (this.getRecycleDataSize() != -1L && this.getRecycleDataSizeUnit() != -1) {
                    unit = SamQFSUtil.getUnitString(this.recDataSizeUnit);
                    this.param.setStartSize(SamQFSUtil.fsizeToString(new Long(this.recDataSize).toString() + unit));
                }
                if (this.getRecycleHWM() != -1) {
                    rec.setHWM(this.getRecycleHWM());
                }
                if (this.isIgnoreRecSet) {
                    rec.setIgnore(this.isIgnoreRecycle());
                    this.isIgnoreRecSet = false;
                }
                if (this.getNotificationAddress() != null && !this.getNotificationAddress().equals(new String())) {
                    rec.setEmailAddr(this.getNotificationAddress());
                }
                if (this.getMinGain() != -1) {
                    rec.setMinGain(this.getMinGain());
                }
                if (this.getMaxVSNCount() != -1) {
                    rec.setVSNCount(this.getMaxVSNCount());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void createCopy() {
        if (this.archPolicy != null) {
            try {
                this.copy = new Copy[1];
                this.copy[0] = new Copy();
                this.copy[0].setCopyNumber(this.getCopyNumber());
                if (this.getArchiveAge() != -1L && this.getArchiveAgeUnit() != -1) {
                    this.copy[0].setArchiveAge(SamQFSUtil.convertToSecond(this.getArchiveAge(), this.getArchiveAgeUnit()));
                }
                if (this.getUnarchiveAge() != -1L && this.getUnarchiveAgeUnit() != -1) {
                    this.copy[0].setUnarchiveAge(SamQFSUtil.convertToSecond(this.getUnarchiveAge(), this.getUnarchiveAgeUnit()));
                }
                if (this.isReleaseSet) {
                    this.copy[0].setRelease(this.isRelease());
                    this.isReleaseSet = false;
                }
                if (this.isNoReleaseSet) {
                    this.copy[0].setNoRelease(this.isNoRelease());
                    this.isNoReleaseSet = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

