/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.alarm;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.adm.Fault;
import com.sun.netstorage.samqfs.mgmt.adm.FaultAttr;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.media.Library;
import java.util.GregorianCalendar;

public class AlarmImpl
implements Alarm {
    private static int MAXEQ = 65534;
    private SamQFSSystemModelImpl model = null;
    private FaultAttr fault = null;
    private long index = -1L;
    private String compId = new String();
    private int severity = -1;
    private String description = new String();
    private GregorianCalendar dateTimeGenerated = null;
    private int status = -1;
    private String hostName = new String();
    private int associatedEquipOrdinal = -1;
    private Library associatedLibrary = null;
    private String libName = new String();
    private FileSystem associatedFileSystem = null;

    public AlarmImpl() {
    }

    public AlarmImpl(long index, int severity, String description, GregorianCalendar dateTimeGenerated, int status, Library associatedLibrary, FileSystem associatedFileSystem) {
        this.index = index;
        this.severity = severity;
        this.description = description;
        this.dateTimeGenerated = dateTimeGenerated;
        this.status = status;
        this.associatedLibrary = associatedLibrary;
        this.associatedFileSystem = associatedFileSystem;
        try {
            if (associatedLibrary != null) {
                this.associatedEquipOrdinal = associatedLibrary.getEquipOrdinal();
            } else if (associatedFileSystem != null) {
                this.associatedEquipOrdinal = associatedFileSystem.getEquipOrdinal();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public AlarmImpl(SamQFSSystemModelImpl model, FaultAttr fault) {
        this.model = model;
        this.fault = fault;
        this.update();
    }

    public long getAlarmID() throws SamFSException {
        return this.index;
    }

    public int getSeverity() throws SamFSException {
        return this.severity;
    }

    public String getDescription() throws SamFSException {
        return this.description;
    }

    public GregorianCalendar getDateTimeGenerated() throws SamFSException {
        return this.dateTimeGenerated;
    }

    public int getStatus() throws SamFSException {
        return this.status;
    }

    public void setStatusAcknowledged() {
        this.status = 4;
    }

    public String getComponentName() {
        return this.compId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setStatus(int status) throws SamFSException {
        switch (status) {
            case 4: {
                this.status = status;
                if (this.model == null || this.fault == null) break;
                long[] list = new long[]{this.fault.getErrID()};
                Fault.ack((Ctx)this.model.getJniContext(), (long[])list);
                break;
            }
            default: {
                this.status = -1;
            }
        }
    }

    public int getAssociatedEquipOrdinal() throws SamFSException {
        return this.associatedEquipOrdinal;
    }

    public Library getAssociatedLibrary() throws SamFSException {
        if (SamQFSUtil.isValidString(this.libName) && this.associatedEquipOrdinal > 0 && this.associatedEquipOrdinal <= MAXEQ) {
            try {
                this.associatedLibrary = this.model.getSamQFSSystemMediaManager().getLibraryByEQ(this.associatedEquipOrdinal);
            }
            catch (SamFSException se) {
                se.printStackTrace();
            }
        } else {
            this.associatedLibrary = null;
        }
        return this.associatedLibrary;
    }

    public FileSystem getAssociatedFileSystem() throws SamFSException {
        return this.associatedFileSystem;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        try {
            if (this.associatedLibrary != null) {
                buf.append("Library: " + this.associatedLibrary.getName() + "\n\n");
            } else if (this.associatedFileSystem != null) {
                buf.append("Filesystem: " + this.associatedFileSystem.getName());
                buf.append("\n\n");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        buf.append("Alarm Index: " + this.index + "\n");
        buf.append("Severity: " + this.severity + "\n");
        buf.append("Description: " + this.description + "\n");
        buf.append("Generated on : " + SamQFSUtil.dateTime(this.dateTimeGenerated) + "\n");
        buf.append("Status: " + this.status + "\n");
        buf.append("Associated Equip Ordinal: " + this.associatedEquipOrdinal + "\n");
        buf.append("Library Name: " + this.libName + "\n");
        return buf.toString();
    }

    private void update() {
        if (this.fault != null) {
            this.index = this.fault.getErrID();
            this.compId = this.fault.getComponentID();
            if (this.fault.getSeverity() == 0) {
                this.severity = 0;
            } else if (this.fault.getSeverity() == 1) {
                this.severity = 1;
            } else if (this.fault.getSeverity() == 2) {
                this.severity = 2;
            }
            this.description = this.fault.getMessage();
            this.dateTimeGenerated = SamQFSUtil.convertTime(this.fault.getTimestamp());
            if (this.fault.getState() == 0) {
                this.status = 3;
            } else if (this.fault.getState() == 1) {
                this.status = 4;
            }
            this.associatedEquipOrdinal = this.fault.getEq();
            this.libName = this.fault.getLibName();
            this.hostName = this.fault.getHostname();
        }
    }
}

