/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni.admin;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.adm.License;
import com.sun.netstorage.samqfs.mgmt.media.MdLicense;
import com.sun.netstorage.samqfs.web.model.admin.SystemLicense;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import java.util.GregorianCalendar;

public class SystemLicenseImpl
implements SystemLicense {
    private License license = null;
    private short fsType = (short)-1;
    private short type = (short)-1;
    private long expire = -1L;
    private long hostID = -1L;
    private boolean samRemoteServerSupport = false;
    private boolean samRemoteClientSupport = false;
    private boolean migrationToolkitSupport = false;
    private boolean databaseSupport = false;
    private boolean segmentSupport = false;
    private boolean sharedFSSupport = false;
    private boolean fastFSSupport = false;
    private boolean sanAPISupport = false;
    private boolean foreignTapeSupport = false;
    private boolean qfsOnlySupport = false;
    private MdLicense[] mdLicenses = new MdLicense[0];

    public SystemLicenseImpl(License jniLicense) throws SamFSException {
        if (jniLicense == null) {
            throw new SamFSException("logic.invalidSystemLicenseParam");
        }
        this.license = jniLicense;
        this.type = this.license.getLicenseType();
        this.expire = this.license.getExpiration();
        this.fsType = this.license.getFSType();
        this.hostID = this.license.getHostID();
        this.samRemoteServerSupport = this.license.isRemoteSamServerSupported();
        this.samRemoteClientSupport = this.license.isRemoteSamClientSupported();
        this.migrationToolkitSupport = this.license.isMigrationToolkitSupported();
        this.qfsOnlySupport = this.license.isStandaloneQFSSupported();
        this.databaseSupport = this.license.isDatabaseSupported();
        this.foreignTapeSupport = this.license.isForeignTapeSupported();
        this.segmentSupport = this.license.isSegmentSupported();
        this.sharedFSSupport = this.license.isSharedFileSystemSupported();
        this.fastFSSupport = this.license.isFastFileSystemSupported();
        this.sanAPISupport = this.license.isSANAPISupported();
        this.mdLicenses = this.license.getMediaLicenses();
    }

    public int getLicenseType() {
        return this.type;
    }

    public GregorianCalendar getLicenseExpiration() {
        GregorianCalendar calendar = SamQFSUtil.convertTime(this.expire);
        return calendar;
    }

    public int getLicenseFSType() {
        return this.fsType;
    }

    public long getLicenseHostID() {
        return this.hostID;
    }

    public boolean isRemoteSamServerSupported() {
        return this.samRemoteServerSupport;
    }

    public boolean isRemoteSamClientSupported() {
        return this.samRemoteClientSupport;
    }

    public boolean isMigrationToolkitSupported() {
        return this.migrationToolkitSupport;
    }

    public boolean isFastFileSystemSupported() {
        return this.fastFSSupport;
    }

    public boolean isDatabaseSupported() {
        return this.databaseSupport;
    }

    public boolean isForeignTapeSupported() {
        return this.foreignTapeSupport;
    }

    public boolean isSegmentSupported() {
        return this.segmentSupport;
    }

    public boolean isSharedFileSystemSupported() {
        return this.sharedFSSupport;
    }

    public boolean isSANAPISupported() {
        return this.sanAPISupport;
    }

    public boolean isStandaloneQFSSupported() {
        return this.qfsOnlySupport;
    }

    public MdLicense[] getMediaLicenses() {
        return this.mdLicenses;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("License Type: " + this.fsType + " " + this.type + "\n");
        buf.append(" Expiration: " + this.expire + "\n");
        buf.append(" Host ID: " + Long.toHexString(this.hostID) + "\n");
        buf.append("\nRemote server: " + this.samRemoteServerSupport + "\n");
        buf.append("\nRemote client: " + this.samRemoteClientSupport + "\n");
        buf.append("\nMigration: " + this.migrationToolkitSupport + "\n");
        buf.append("\nQFS: " + this.qfsOnlySupport + "\n");
        buf.append("\nData Base features: " + this.databaseSupport + "\n");
        buf.append("\nForeign tape support: " + this.foreignTapeSupport + "\n");
        buf.append("\nSAN API support: " + this.sanAPISupport + "\n");
        buf.append("\nSegment feature: " + this.segmentSupport + "\n");
        buf.append("\nShared filesystem support: " + this.sharedFSSupport + "\n");
        buf.append("\nFast filesystem support: " + this.fastFSSupport + "\n");
        if (this.mdLicenses != null) {
            for (int i = 0; i < this.mdLicenses.length; ++i) {
                buf.append("   " + this.mdLicenses[i] + "\n");
            }
        } else {
            buf.append("  none\n");
        }
        return buf.toString();
    }
}

