/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.Copy;
import com.sun.netstorage.samqfs.mgmt.arc.CopyParams;
import com.sun.netstorage.samqfs.mgmt.arc.Criteria;
import com.sun.netstorage.samqfs.mgmt.arc.DiskVol;
import com.sun.netstorage.samqfs.mgmt.arc.VSNMap;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.impl.jni.RE;
import com.sun.netstorage.samqfs.web.model.impl.jni.fs.FileSystemMountPropertiesImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;

public class SamQFSUtil {
    private static final long SIZE_KB = 1024L;
    private static final long SIZE_MB = 0x100000L;
    private static final long SIZE_GB = 0x40000000L;
    private static final long SIZE_TB = 0x10000000000L;
    private static final long SIZE_PB = 0x4000000000000L;
    private static final String TIME_UNITS = "SMHDW";
    private static final int[] TIME_BASE = new int[]{60, 60, 24, 7};
    private static final String SIZE_UNITS = "BKMGTP";
    private static final BigInteger SIZE_BASE = new BigInteger("1024");

    public static Criteria createCriteria(String fs2, Criteria cr, Copy[] c) throws SamFSException {
        Criteria ret = null;
        if (cr != null) {
            cr.setCopies(c);
            ret = new Criteria(fs2, cr);
        }
        return ret;
    }

    public static Criteria createCriteriaNewName(String newName, Criteria cr) throws SamFSException {
        Criteria ret = null;
        if (cr != null) {
            ret = new Criteria(cr.getFilesysName(), cr);
            ret.setSetName(newName);
        }
        return ret;
    }

    public static CopyParams createCopyParams(String newCopyNumber, CopyParams cp) throws SamFSException {
        CopyParams cparams = null;
        if (cp != null) {
            cparams = new CopyParams(newCopyNumber, cp);
        }
        return cparams;
    }

    public static VSNMap createVSNMap(String newCopyNumber, VSNMap map) throws SamFSException {
        VSNMap ret = null;
        if (map != null) {
            ret = new VSNMap(newCopyNumber, map.getMediaType(), map.getVSNNames(), map.getPoolNames());
        }
        return ret;
    }

    public static Criteria updateCriteria(Criteria target, Criteria source, Copy[] copy, boolean ignoreCopy) {
        if (target != null && source != null) {
            target = new Criteria(target.getFilesysName(), source);
        }
        return target;
    }

    public static ArrayList createClusters(Criteria[] crits) {
        ArrayList cluster = new ArrayList();
        if (crits != null & crits.length > 0) {
            ArrayList<Criteria> eleToBeProcessed = new ArrayList<Criteria>();
            for (int i = 0; i < crits.length; ++i) {
                eleToBeProcessed.add(crits[i]);
            }
            while (eleToBeProcessed.size() > 0) {
                ArrayList<Criteria> clusterMember = new ArrayList<Criteria>();
                Criteria crit = (Criteria)eleToBeProcessed.get(0);
                clusterMember.add(crit);
                for (int i = 1; i < eleToBeProcessed.size(); ++i) {
                    Criteria anotherCrit = (Criteria)eleToBeProcessed.get(i);
                    if (!crit.sameAs(anotherCrit)) continue;
                    eleToBeProcessed.remove(i);
                    clusterMember.add(anotherCrit);
                    --i;
                }
                eleToBeProcessed.remove(0);
                cluster.add(clusterMember);
            }
        }
        return cluster;
    }

    public static String createVSNExpressionFromStrings(String[] strs) {
        String exp = null;
        if (strs != null && strs.length > 0) {
            StringBuffer buf = new StringBuffer(strs[0]);
            for (int i = 1; i < strs.length; ++i) {
                buf.append("," + strs[i]);
            }
            exp = buf.toString();
        } else {
            exp = new String();
        }
        return exp;
    }

    public static String[] getStringsFromCommaStream(String str) {
        ArrayList<String> tokens = new ArrayList<String>();
        if (str != null) {
            StringTokenizer st = new StringTokenizer(str, ",");
            while (st.hasMoreTokens()) {
                tokens.add(st.nextToken());
            }
        }
        return tokens.toArray(new String[0]);
    }

    public static String getCriteriaName(String nameWithDot) {
        String name = new String();
        if (nameWithDot != null) {
            StringTokenizer st = new StringTokenizer(nameWithDot, ".");
            name = st.nextToken();
        }
        return name;
    }

    public static int getCopyNumber(String nameWithDot) {
        int index;
        int copyNo = -1;
        if (nameWithDot != null && (index = nameWithDot.lastIndexOf(46)) != -1) {
            try {
                copyNo = Integer.parseInt(nameWithDot.substring(index + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (copyNo < 1 || copyNo > 4) {
                copyNo = -1;
            }
        }
        return copyNo;
    }

    public static String createExpression(String startVSN, String endVSN) {
        String s = new String();
        if (SamQFSUtil.isValidString(startVSN) && !SamQFSUtil.isValidString(endVSN)) {
            s = startVSN;
        } else if (!SamQFSUtil.isValidString(startVSN) && SamQFSUtil.isValidString(endVSN)) {
            s = endVSN;
        } else if (SamQFSUtil.isValidString(startVSN) && SamQFSUtil.isValidString(endVSN) && !SamQFSUtil.isValidString(s = RE.convertToREsString(startVSN, endVSN))) {
            s = startVSN + " " + endVSN;
        }
        return s;
    }

    public static long convertSize(long srcSize, int srcUnit, int targetUnit) {
        long sizeInBytes = SamQFSUtil.getSizeInBytes(srcSize, srcUnit);
        long targetSize = -1L;
        if (sizeInBytes >= 0L) {
            switch (targetUnit) {
                case 1: {
                    targetSize = sizeInBytes / 1024L;
                    break;
                }
                case 2: {
                    targetSize = sizeInBytes / 0x100000L;
                    break;
                }
                case 3: {
                    targetSize = sizeInBytes / 0x40000000L;
                    break;
                }
                case 4: {
                    targetSize = sizeInBytes / 0x10000000000L;
                    break;
                }
                case 41: {
                    targetSize = sizeInBytes / 0x4000000000000L;
                }
            }
        }
        return targetSize;
    }

    public static long getSizeInBytes(long srcSize, int srcUnit) {
        long size = -1L;
        switch (srcUnit) {
            case 0: {
                size = srcSize;
                break;
            }
            case 1: {
                size = srcSize * 1024L;
                break;
            }
            case 2: {
                size = srcSize * 0x100000L;
                break;
            }
            case 3: {
                size = srcSize * 0x40000000L;
                break;
            }
            case 4: {
                size = srcSize * 0x10000000000L;
                break;
            }
            case 41: {
                size = srcSize * 0x4000000000000L;
            }
        }
        return size;
    }

    public static String getPrefix(String vsn) {
        String ret = new String();
        if (SamQFSUtil.isValidString(vsn)) {
            int length = 0;
            for (int i = 0; i < vsn.length() && (vsn.charAt(i) < '0' || vsn.charAt(i) > '9'); ++i) {
                ++length;
            }
            if (length > 0) {
                ret = vsn.substring(0, length);
            }
        }
        return ret;
    }

    public static int getNumber(String vsn) {
        int no = -1;
        if (SamQFSUtil.isValidString(vsn)) {
            int length = 0;
            for (int i = 0; i < vsn.length() && (vsn.charAt(i) < '0' || vsn.charAt(i) > '9'); ++i) {
                ++length;
            }
            try {
                no = new Integer(vsn.substring(length, vsn.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return no;
    }

    public static int getEquipTypeInteger(String equipType) {
        int type = -1;
        if (SamQFSUtil.isValidString(equipType)) {
            if (equipType.equals("md") || equipType.equals("MD")) {
                type = 2;
            } else if (equipType.equals("mr") || equipType.equals("MR")) {
                type = 3;
            } else if (equipType.equals("mm") || equipType.equals("MM")) {
                type = 1;
            } else if (equipType.equals("at") || equipType.equals("AT")) {
                type = 101;
            } else if (equipType.equals("d2") || equipType.equals("D2")) {
                type = 102;
            } else if (equipType.equals("d3") || equipType.equals("D3")) {
                type = 103;
            } else if (equipType.equals("dt") || equipType.equals("DT")) {
                type = 104;
            } else if (equipType.equals("fd") || equipType.equals("FD")) {
                type = 105;
            } else if (equipType.equals("i7") || equipType.equals("I7")) {
                type = 106;
            } else if (equipType.equals("li") || equipType.equals("LI")) {
                type = 107;
            } else if (equipType.equals("lt") || equipType.equals("LT")) {
                type = 108;
            } else if (equipType.equals("se") || equipType.equals("SE")) {
                type = 109;
            } else if (equipType.equals("sg") || equipType.equals("SG")) {
                type = 110;
            } else if (equipType.equals("so") || equipType.equals("SO")) {
                type = 111;
            } else if (equipType.equals("vt") || equipType.equals("VT")) {
                type = 112;
            } else if (equipType.equals("xm") || equipType.equals("XM")) {
                type = 113;
            } else if (equipType.equals("mo") || equipType.equals("MO")) {
                type = 114;
            } else if (equipType.equals("wo") || equipType.equals("WO")) {
                type = 115;
            } else if (equipType.equals("ib") || equipType.equals("IB")) {
                type = 122;
            } else if (equipType.equals("sf") || equipType.equals("SF")) {
                type = 123;
            } else if (equipType.equals("st") || equipType.equals("ST")) {
                type = 124;
            } else if (equipType.equals("xt") || equipType.equals("XT")) {
                type = 125;
            } else if (equipType.equals("o2") || equipType.equals("O2")) {
                type = 126;
            } else if (equipType.equals("od") || equipType.equals("OD")) {
                type = 127;
            } else if (equipType.equals("tp") || equipType.equals("TP")) {
                type = 128;
            } else if (equipType.equals("hy") || equipType.equals("HY")) {
                type = 116;
            } else if (equipType.equals("rb") || equipType.equals("RB")) {
                type = 129;
            } else if (equipType.equals("hc") || equipType.equals("HC")) {
                type = 130;
            } else if (equipType.equals("gr") || equipType.equals("GR")) {
                type = 118;
            } else if (equipType.equals("fj") || equipType.equals("FJ")) {
                type = 120;
            } else if (equipType.equals("im") || equipType.equals("IM")) {
                type = 121;
            } else if (equipType.equals("pe") || equipType.equals("PE")) {
                type = 119;
            } else if (equipType.equals("sk") || equipType.equals("SK")) {
                type = 117;
            } else if (equipType.equals("s9") || equipType.equals("S9")) {
                type = 132;
            } else if (equipType.equals("dk") || equipType.equals("DK")) {
                type = 133;
            } else if (equipType.equals("al") || equipType.equals("AL")) {
                type = 134;
            } else if (equipType.equals("c4") || equipType.equals("C4")) {
                type = 135;
            } else if (equipType.equals("ti") || equipType.equals("TI")) {
                type = 136;
            }
        }
        return type;
    }

    public static int getMediaTypeInteger(String mediaType) {
        return SamQFSUtil.getEquipTypeInteger(mediaType);
    }

    public static String getMediaTypeString(int mediaType) {
        String s = new String();
        switch (mediaType) {
            case 2: {
                s = new String("md");
                break;
            }
            case 3: {
                s = new String("mr");
                break;
            }
            case 1: {
                s = new String("mm");
                break;
            }
            case 101: {
                s = new String("at");
                break;
            }
            case 102: {
                s = new String("d2");
                break;
            }
            case 103: {
                s = new String("d3");
                break;
            }
            case 104: {
                s = new String("dt");
                break;
            }
            case 105: {
                s = new String("fd");
                break;
            }
            case 106: {
                s = new String("i7");
                break;
            }
            case 107: {
                s = new String("li");
                break;
            }
            case 108: {
                s = new String("lt");
                break;
            }
            case 109: {
                s = new String("se");
                break;
            }
            case 110: {
                s = new String("sg");
                break;
            }
            case 111: {
                s = new String("so");
                break;
            }
            case 112: {
                s = new String("vt");
                break;
            }
            case 113: {
                s = new String("xm");
                break;
            }
            case 114: {
                s = new String("mo");
                break;
            }
            case 115: {
                s = new String("wo");
                break;
            }
            case 122: {
                s = new String("ib");
                break;
            }
            case 123: {
                s = new String("sf");
                break;
            }
            case 124: {
                s = new String("st");
                break;
            }
            case 125: {
                s = new String("xt");
                break;
            }
            case 126: {
                s = new String("o2");
                break;
            }
            case 127: {
                s = new String("od");
                break;
            }
            case 128: {
                s = new String("tp");
                break;
            }
            case 129: {
                s = new String("rb");
                break;
            }
            case 116: {
                s = new String("hy");
                break;
            }
            case 121: {
                s = new String("im");
                break;
            }
            case 120: {
                s = new String("fj");
                break;
            }
            case 119: {
                s = new String("pe");
                break;
            }
            case 118: {
                s = new String("gr");
                break;
            }
            case 117: {
                s = new String("sk");
                break;
            }
            case 132: {
                s = new String("s9");
                break;
            }
            case 130: {
                s = new String("hc");
                break;
            }
            case 133: {
                s = new String("dk");
                break;
            }
            case 135: {
                s = new String("c4");
                break;
            }
            case 136: {
                s = new String("ti");
            }
        }
        return s;
    }

    public static long convertToSecond(long value, int unit) {
        long ret = value;
        switch (unit) {
            case 6: {
                ret = value * 60L;
                break;
            }
            case 7: {
                ret = value * 60L * 60L;
                break;
            }
            case 8: {
                ret = value * 60L * 60L * 24L;
                break;
            }
            case 9: {
                ret = value * 60L * 60L * 24L * 7L;
            }
        }
        return ret;
    }

    public static int convertStageAttribFromJni(char jniVal) {
        int type = -1;
        if (jniVal == 'n') {
            type = 10002;
        } else if (jniVal == 'a') {
            type = 10001;
        } else if (jniVal == 'd') {
            type = 10003;
        } else if (jniVal == '0') {
            type = 10004;
        }
        return type;
    }

    public static char convertStageAttribToJni(long logicVal) {
        int c = 32;
        if (logicVal == 10002L) {
            c = 110;
        } else if (logicVal == 10001L) {
            c = 97;
        } else if (logicVal == 10003L) {
            c = 100;
        } else if (logicVal == 10004L) {
            c = 48;
        }
        return (char)c;
    }

    public static int convertReleaseAttribFromJni(char jniVal) {
        int type = -1;
        if (jniVal == 'n') {
            type = 10005;
        } else if (jniVal == 'p') {
            type = 10006;
        } else if (jniVal == 'a') {
            type = 10007;
        } else if (jniVal == 'd') {
            type = 10008;
        } else if (jniVal == '0') {
            type = 10009;
        }
        return type;
    }

    public static char convertReleaseAttribToJni(long logicVal) {
        int c = 32;
        if (logicVal == 10005L) {
            c = 110;
        } else if (logicVal == 10006L) {
            c = 112;
        } else if (logicVal == 10008L) {
            c = 100;
        } else if (logicVal == 10007L) {
            c = 97;
        } else if (logicVal == 10009L) {
            c = 48;
        }
        return (char)c;
    }

    public static int convertARResMethod(short jniMethod) {
        int type = -1;
        if (jniMethod == 1) {
            type = 15;
        } else if (jniMethod == 4) {
            type = 14;
        } else if (jniMethod == 2 || jniMethod == 16) {
            type = 17;
        } else if (jniMethod == 32) {
            type = 18;
        } else if (jniMethod == 8) {
            type = 16;
        }
        return type;
    }

    public static short convertARResMethodJni(int uiMethod) {
        short type = -1;
        switch (uiMethod) {
            case 15: {
                type = 1;
                break;
            }
            case 14: {
                type = 4;
                break;
            }
            case 16: {
                type = 8;
                break;
            }
            case 17: {
                type = 16;
                break;
            }
            case 18: {
                type = 32;
            }
        }
        return type;
    }

    public static int convertARSortMethod(int jniMethod) {
        int type = -1;
        switch (jniMethod) {
            case -1: {
                type = 8;
                break;
            }
            case 0: {
                type = 9;
                break;
            }
            case 1: {
                type = 10;
                break;
            }
            case 2: {
                type = 11;
                break;
            }
            case 3: {
                type = 12;
                break;
            }
            case 4: {
                type = 13;
            }
        }
        return type;
    }

    public static int convertARSortMethodJni(int uiMethod) {
        int type = -1;
        switch (uiMethod) {
            case 8: {
                type = -1;
                break;
            }
            case 9: {
                type = 0;
                break;
            }
            case 10: {
                type = 1;
                break;
            }
            case 11: {
                type = 2;
                break;
            }
            case 12: {
                type = 3;
                break;
            }
            case 13: {
                type = 4;
            }
        }
        return type;
    }

    public static int convertAROfflineCopyMethod(int jniMethod) {
        int type = -1;
        switch (jniMethod) {
            case -1: {
                type = 3;
                break;
            }
            case 0: {
                type = 4;
                break;
            }
            case 1: {
                type = 5;
                break;
            }
            case 2: {
                type = 6;
                break;
            }
            case 3: {
                type = 7;
            }
        }
        return type;
    }

    public static int convertAROfflineCopyMethodJni(int uiMethod) {
        int type = -1;
        switch (uiMethod) {
            case 3: {
                type = -1;
                break;
            }
            case 4: {
                type = 0;
                break;
            }
            case 5: {
                type = 1;
                break;
            }
            case 6: {
                type = 2;
                break;
            }
            case 7: {
                type = 3;
            }
        }
        return type;
    }

    public static int convertARJoinMethod(int jniMethod) {
        int type = -1;
        switch (jniMethod) {
            case -1: {
                type = 0;
                break;
            }
            case 0: {
                type = 1;
                break;
            }
            case 1: {
                type = 2;
            }
        }
        return type;
    }

    public static int convertARJoinMethodJni(int uiMethod) {
        int type = -1;
        switch (uiMethod) {
            case 0: {
                type = -1;
                break;
            }
            case 1: {
                type = 0;
                break;
            }
            case 2: {
                type = 1;
            }
        }
        return type;
    }

    public static GregorianCalendar convertTime(long time) {
        GregorianCalendar calendar = null;
        if (time > 0L) {
            Date date = new Date(time * 1000L);
            calendar = new GregorianCalendar();
            calendar.setTime(date);
        }
        return calendar;
    }

    public static long convertTime(GregorianCalendar time) {
        return time.getTime().getTime() / 1000L;
    }

    public static boolean isValidString(String str) {
        boolean valid = true;
        if (str == null || str.equals("") || str.equals(new String()) || str.length() == 0) {
            valid = false;
        }
        return valid;
    }

    public static int convertStateToJni(int uiState) {
        int jniState = -1;
        switch (uiState) {
            case 0: {
                jniState = 0;
                break;
            }
            case 1: {
                jniState = 4;
                break;
            }
            case 2: {
                jniState = 5;
                break;
            }
            case 3: {
                jniState = 3;
                break;
            }
            case 4: {
                jniState = 2;
                break;
            }
            case 5: {
                jniState = 1;
            }
        }
        return jniState;
    }

    public static int convertStateToUI(int jniState) {
        int uiState = -1;
        switch (jniState) {
            case 0: {
                uiState = 0;
                break;
            }
            case 4: {
                uiState = 1;
                break;
            }
            case 5: {
                uiState = 2;
                break;
            }
            case 3: {
                uiState = 3;
                break;
            }
            case 2: {
                uiState = 4;
                break;
            }
            case 1: {
                uiState = 5;
            }
        }
        return uiState;
    }

    public static int getDriverTypeFromEQType(String eqType) {
        int type = 1001;
        if (SamQFSUtil.isValidString(eqType)) {
            if (eqType.equals("sk") || eqType.equals("SK")) {
                type = 1002;
            } else if (eqType.equals("gr") || eqType.equals("GR")) {
                type = 1003;
            } else if (eqType.equals("fj") || eqType.equals("FJ")) {
                type = 1004;
            } else if (eqType.equals("im") || eqType.equals("IM")) {
                type = 1005;
            } else if (eqType.equals("pe") || eqType.equals("PE")) {
                type = 1006;
            }
        }
        return type;
    }

    public static int getLogicScanType(short jniType) {
        int type = -1;
        if (jniType == -1) {
            type = 4;
        } else if (jniType == 1) {
            type = 0;
        } else if (jniType == 2) {
            type = 1;
        } else if (jniType == 3) {
            type = 2;
        } else if (jniType == 4) {
            type = 3;
        }
        return type;
    }

    public static short getJniScanType(int logicType) {
        short type = -1;
        switch (logicType) {
            case 0: {
                type = 1;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 3;
                break;
            }
            case 3: {
                type = 4;
            }
        }
        return type;
    }

    public static String dateTime(GregorianCalendar dateTime) {
        String dateTimeString = new String();
        if (dateTime != null) {
            int month = dateTime.get(2) + 1;
            int day = dateTime.get(5);
            int year = dateTime.get(1);
            int hour = dateTime.get(10);
            int minute = dateTime.get(12);
            int second = dateTime.get(13);
            String am_pm = new String();
            if (dateTime.get(9) == 1) {
                am_pm = "PM";
            } else if (dateTime.get(9) == 0) {
                am_pm = "AM";
            }
            String fillerMin = new String();
            if (minute < 10) {
                fillerMin = "0";
            }
            String fillerSec = new String();
            if (second < 10) {
                fillerSec = "0";
            }
            dateTimeString = month + "/" + day + "/" + year + ", " + hour + ":" + fillerMin + minute + ":" + fillerSec + second + " " + am_pm;
        }
        return dateTimeString;
    }

    public static GregorianCalendar getDateTime() {
        return new GregorianCalendar();
    }

    public static FileSystemMountProperties getDefaultMountProperties(int fsType, int archType, int shareType) throws SamFSException {
        return new FileSystemMountPropertiesImpl();
    }

    public static void printDisks(DiskCache[] disks) throws SamFSException {
        System.out.println("Printing Disks...");
        if (disks != null) {
            for (int i = 0; i < disks.length; ++i) {
                System.out.println("Printing disk " + (i + 1));
                System.out.println(disks[i]);
            }
        }
    }

    public static void printFS(FileSystem[] fs2) throws SamFSException {
        System.out.println("Printing File Systems...");
        if (fs2 != null) {
            for (int i = 0; i < fs2.length; ++i) {
                System.out.println("Printing File System " + (i + 1));
                System.out.println(fs2[i]);
            }
        }
    }

    public static String fsizeToString(String fsize) throws NumberFormatException {
        int length = fsize.length();
        int unit = fsize.charAt(length - 1);
        if (Character.isDigit((char)unit)) {
            unit = 98;
            ++length;
        }
        BigInteger size = new BigInteger(fsize.substring(0, length - 1));
        switch (unit) {
            case 66: 
            case 98: {
                break;
            }
            case 75: 
            case 107: {
                size = size.multiply(new BigInteger(new Long(1024L).toString()));
                break;
            }
            case 77: 
            case 109: {
                size = size.multiply(new BigInteger(new Long(0x100000L).toString()));
                break;
            }
            case 71: 
            case 103: {
                size = size.multiply(new BigInteger(new Long(0x40000000L).toString()));
                break;
            }
            case 84: 
            case 116: {
                size = size.multiply(new BigInteger(new Long(0x10000000000L).toString()));
                break;
            }
            case 80: 
            case 112: {
                size = size.multiply(new BigInteger(new Long(0x4000000000000L).toString()));
                break;
            }
            default: {
                throw new NumberFormatException("Invalid file size: " + fsize);
            }
        }
        return size.toString();
    }

    public static String stringToFsize(String bytes) throws NumberFormatException {
        int i;
        if (bytes.equals("0")) {
            return "0B";
        }
        BigInteger size = new BigInteger(bytes);
        int count = SIZE_UNITS.length() - 1;
        for (i = 0; i < count && size.mod(SIZE_BASE).compareTo(BigInteger.ZERO) == 0; ++i) {
            size = size.divide(SIZE_BASE);
        }
        StringBuffer interval = new StringBuffer(size.toString()).append(SIZE_UNITS.charAt(i));
        return interval.toString();
    }

    public static String getUnitString(int unit) {
        String ret = "b";
        switch (unit) {
            case 1: {
                ret = "k";
                break;
            }
            case 2: {
                ret = "m";
                break;
            }
            case 3: {
                ret = "g";
                break;
            }
            case 4: {
                ret = "t";
                break;
            }
            case 41: {
                ret = "p";
            }
        }
        return ret;
    }

    public static String getTimeUnitString(int unit) {
        String ret = "s";
        switch (unit) {
            case 6: {
                ret = "m";
                break;
            }
            case 7: {
                ret = "h";
                break;
            }
            case 8: {
                ret = "d";
                break;
            }
            case 9: {
                ret = "w";
            }
        }
        return ret;
    }

    public static long getLongVal(String sizeWithUnit) {
        long val = -1L;
        if (SamQFSUtil.isValidString(sizeWithUnit) && sizeWithUnit.length() > 1) {
            String str = sizeWithUnit.substring(0, sizeWithUnit.length() - 1);
            try {
                val = new Long(str);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        return val;
    }

    public static int getIntegerVal(String sizeWithUnit) {
        int val = -1;
        if (SamQFSUtil.isValidString(sizeWithUnit) && sizeWithUnit.length() > 1) {
            String str = sizeWithUnit.substring(0, sizeWithUnit.length() - 1);
            try {
                val = new Integer(str);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        return val;
    }

    public static int getSizeUnitInteger(String sizeWithUnit) {
        int val = -1;
        if (SamQFSUtil.isValidString(sizeWithUnit) && sizeWithUnit.length() > 0) {
            char c = sizeWithUnit.charAt(sizeWithUnit.length() - 1);
            switch (c) {
                case 'B': 
                case 'b': {
                    val = 0;
                    break;
                }
                case 'K': 
                case 'k': {
                    val = 1;
                    break;
                }
                case 'M': 
                case 'm': {
                    val = 2;
                    break;
                }
                case 'G': 
                case 'g': {
                    val = 3;
                    break;
                }
                case 'T': 
                case 't': {
                    val = 4;
                    break;
                }
                case 'P': 
                case 'p': {
                    val = 41;
                }
            }
        }
        return val;
    }

    public static long getLongValSecond(String timeWithUnit) {
        long val = -1L;
        if (SamQFSUtil.isValidString(timeWithUnit) && timeWithUnit.length() > 1) {
            String str = timeWithUnit.substring(0, timeWithUnit.length() - 1);
            try {
                val = new Long(str);
            }
            catch (NumberFormatException nfe) {
                nfe.printStackTrace();
            }
        }
        return val;
    }

    public static int getTimeUnitInteger(String timeWithUnit) {
        int val = -1;
        if (SamQFSUtil.isValidString(timeWithUnit) && timeWithUnit.length() > 0) {
            char c = timeWithUnit.charAt(timeWithUnit.length() - 1);
            switch (c) {
                case 'S': 
                case 's': {
                    val = 5;
                    break;
                }
                case 'M': 
                case 'm': {
                    val = 6;
                    break;
                }
                case 'H': 
                case 'h': {
                    val = 7;
                    break;
                }
                case 'D': 
                case 'd': {
                    val = 8;
                    break;
                }
                case 'W': 
                case 'w': {
                    val = 9;
                }
            }
        }
        return val;
    }

    public static long intervalToLong(String timeInterval) throws NumberFormatException {
        int length = timeInterval.length();
        int unit = timeInterval.charAt(length - 1);
        if (Character.isDigit((char)unit)) {
            unit = 115;
            ++length;
        }
        long interval = Long.parseLong(timeInterval.substring(0, length - 1));
        switch (unit) {
            case 83: 
            case 115: {
                break;
            }
            case 77: 
            case 109: {
                interval *= 60L;
                break;
            }
            case 72: 
            case 104: {
                interval *= 3600L;
                break;
            }
            case 68: 
            case 100: {
                interval *= 86400L;
                break;
            }
            case 87: 
            case 119: {
                interval *= 604800L;
                break;
            }
            default: {
                throw new NumberFormatException("Invalid time interval: " + timeInterval);
            }
        }
        return interval;
    }

    public static String longToInterval(long seconds) throws NumberFormatException {
        int i;
        if (seconds < 0L) {
            throw new NumberFormatException("Invalid time interval: " + seconds);
        }
        if (seconds == 0L) {
            return "0S";
        }
        for (i = 0; i < TIME_BASE.length && seconds % (long)TIME_BASE[i] == 0L; ++i) {
            seconds /= (long)TIME_BASE[i];
        }
        StringBuffer interval = new StringBuffer().append(seconds).append(TIME_UNITS.charAt(i));
        return interval.toString();
    }

    public static void createDiskVolInfo(String dvsn, String host, String path, Ctx ctx) throws SamFSException {
        if (SamQFSUtil.isValidString(dvsn)) {
            DiskVol vol = null;
            try {
                vol = DiskVol.get((Ctx)ctx, (String)dvsn);
            }
            catch (SamFSException se) {
                vol = null;
            }
            if (vol == null) {
                DiskVol.add((Ctx)ctx, (DiskVol)new DiskVol(dvsn, null, path));
                if (SamQFSUtil.isValidString(ctx.getDumpPath())) {
                    ctx.setReadPath(ctx.getDumpPath());
                }
            }
        }
    }

    public static void removeDiskVolInfo(String dvsn, Ctx ctx) throws SamFSException {
        if (SamQFSUtil.isValidString(dvsn)) {
            DiskVol vol = null;
            try {
                vol = DiskVol.get((Ctx)ctx, (String)dvsn);
            }
            catch (SamFSException samFSException) {
                // empty catch block
            }
            if (vol != null) {
                DiskVol.remove((Ctx)ctx, (String)dvsn);
            }
        }
    }

    public static boolean isDifferentDiskVolInfoPresent(String dvsn, String host, String path, Ctx ctx) {
        boolean present = false;
        if (SamQFSUtil.isValidString(dvsn)) {
            DiskVol vol = null;
            try {
                vol = DiskVol.get((Ctx)ctx, (String)dvsn);
            }
            catch (SamFSException se) {
                vol = null;
            }
            if (vol != null) {
                String volPath = vol.getPath();
                if (volPath != null && !volPath.equals(path)) {
                    present = true;
                }
                if (!present && (vol.getHost() != null && !vol.getHost().equals(host) || host != null && !host.equals(vol.getHost()))) {
                    present = true;
                }
            }
        }
        return present;
    }

    public static int[] getRemovableMediaStatusIntegers(String status) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (SamQFSUtil.isValidString(status)) {
            for (int i = 0; i < status.length(); ++i) {
                int statusInt;
                int c = status.charAt(i);
                if (c == 82 && i == 5) {
                    c = 90;
                }
                if ((statusInt = SamQFSUtil.getRemovableMediaStatusInteger((char)c)) == -1) continue;
                list.add(new Integer(statusInt));
            }
        }
        int[] statusIntArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            statusIntArray[i] = (Integer)list.get(i);
        }
        return statusIntArray;
    }

    private static int getRemovableMediaStatusInteger(char c) {
        int status = -1;
        switch (c) {
            case 's': {
                status = 10001;
                break;
            }
            case 'm': {
                status = 10002;
                break;
            }
            case 'M': {
                status = 10003;
                break;
            }
            case 'E': {
                status = 10004;
                break;
            }
            case 'a': {
                status = 10005;
                break;
            }
            case 'l': {
                status = 10006;
                break;
            }
            case 'N': {
                status = 10007;
                break;
            }
            case 'L': {
                status = 10008;
                break;
            }
            case 'I': {
                status = 10009;
                break;
            }
            case 'A': {
                status = 10010;
                break;
            }
            case 'C': {
                status = 10011;
                break;
            }
            case 'U': {
                status = 10012;
                break;
            }
            case 'Z': {
                status = 10013;
                break;
            }
            case 'w': {
                status = 10014;
                break;
            }
            case 'o': {
                status = 10015;
                break;
            }
            case 'P': {
                status = 10016;
                break;
            }
            case 'F': {
                status = 10017;
                break;
            }
            case 'R': {
                status = 10018;
                break;
            }
            case 'r': {
                status = 10019;
                break;
            }
            case 'p': {
                status = 10020;
                break;
            }
            case 'W': {
                status = 10021;
            }
        }
        return status;
    }

    public static int[] getFileSystemStatusIntegers(String status) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        if (SamQFSUtil.isValidString(status)) {
            for (int i = 0; i < status.length(); ++i) {
                int statusInt;
                int c = status.charAt(i);
                if (c == 82 && i == 3) {
                    c = 90;
                }
                if ((statusInt = SamQFSUtil.getFileSystemStatusInteger((char)c)) == -1) continue;
                list.add(new Integer(statusInt));
            }
        }
        int[] statusIntArray = new int[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            statusIntArray[i] = (Integer)list.get(i);
        }
        return statusIntArray;
    }

    private static int getFileSystemStatusInteger(char c) {
        int status = -1;
        switch (c) {
            case 'm': {
                status = 20001;
                break;
            }
            case 'M': {
                status = 20002;
                break;
            }
            case 'u': {
                status = 20003;
                break;
            }
            case 'A': {
                status = 20004;
                break;
            }
            case 'Z': {
                status = 20005;
                break;
            }
            case 'S': {
                status = 20006;
                break;
            }
            case '1': {
                status = 20007;
                break;
            }
            case '2': {
                status = 20008;
                break;
            }
            case 'c': {
                status = 20009;
                break;
            }
            case 'W': {
                status = 20010;
                break;
            }
            case 'R': {
                status = 20011;
                break;
            }
            case 'r': {
                status = 20012;
                break;
            }
            case 'd': {
                status = 20013;
            }
        }
        return status;
    }

    public static void doPrint(String str) {
    }

    public static void doPrintTemp(String str) {
        System.out.println(str);
    }

    public static String arr2Str(Object[] arr) {
        String s = "[";
        if (arr != null) {
            for (int i = 0; i < arr.length; ++i) {
                s = s + arr[i];
                if (i == arr.length - 1) continue;
                s = s + ",";
            }
        }
        return s + "]";
    }
}

