/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.mgmt.adm.License;
import com.sun.netstorage.samqfs.mgmt.fs.AU;
import com.sun.netstorage.samqfs.mgmt.fs.DiskDev;
import com.sun.netstorage.samqfs.mgmt.fs.FS;
import com.sun.netstorage.samqfs.mgmt.fs.FSInfo;
import com.sun.netstorage.samqfs.mgmt.fs.Host;
import com.sun.netstorage.samqfs.mgmt.fs.MountOptions;
import com.sun.netstorage.samqfs.mgmt.fs.StripedGrp;
import com.sun.netstorage.samqfs.web.model.MDSAddresses;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.model.fs.SharedMember;
import com.sun.netstorage.samqfs.web.model.impl.jni.MultiHostUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSAppModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.fs.FileSystemImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.fs.FileSystemMountPropertiesImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.fs.SharedMemberImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.BaseDeviceImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.DiskCacheImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.SharedDiskCacheImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.media.StripedGroupImpl;
import com.sun.netstorage.samqfs.web.model.impl.mt.Barrier;
import com.sun.netstorage.samqfs.web.model.impl.mt.MethodInfo;
import com.sun.netstorage.samqfs.web.model.impl.mt.ThreadPool;
import com.sun.netstorage.samqfs.web.model.impl.mt.ThreadPoolMember;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.SharedDiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;
import java.util.LinkedList;

public class SamQFSSystemSharedFSManagerImpl
extends MultiHostUtil
implements SamQFSSystemSharedFSManager {
    SamQFSAppModelImpl appModel = null;
    ThreadPool threadPool = null;

    public SamQFSSystemSharedFSManagerImpl(SamQFSAppModelImpl model) {
        this.appModel = model;
        this.threadPool = new ThreadPool(10);
        this.threadPool.init();
    }

    public void freeResources() {
        this.threadPool.destroy();
    }

    protected boolean matchAUs(DiskDev dc1, DiskDev dc2) {
        boolean match = false;
        AU au1 = dc1.getAU();
        AU au2 = dc2.getAU();
        if (au1.getSCSIDevInfo() != null && au2.getSCSIDevInfo() != null && 0 == au1.getSCSIDevInfo().devID.compareTo(au2.getSCSIDevInfo().devID) && au1.getPath().charAt(au1.getPath().length() - 1) == au2.getPath().charAt(au2.getPath().length() - 1)) {
            match = true;
        }
        return match;
    }

    private DiskDev[] fixDiskPath(DiskDev[] disksUsed, DiskCache[] disksKnown) throws SamFSException {
        for (int i = 0; i < disksUsed.length; ++i) {
            boolean matched = false;
            for (int j = 0; j < disksKnown.length; ++j) {
                DiskCacheImpl dci = (DiskCacheImpl)disksKnown[j];
                if (!this.matchAUs(disksUsed[i], dci.getJniDisk())) continue;
                disksUsed[i].setDevicePath(dci.getDevicePath());
                matched = true;
            }
            if (matched) continue;
            throw new SamFSException("logic.internal.no-matching-disk");
        }
        return disksUsed;
    }

    protected void parallelDisco(String[] servers, String[] clients, DiskCache[][] allDCs, ArrayList errHostNames, ArrayList errExceptions) {
        int n;
        String[] hosts = new String[servers.length + (clients != null ? clients.length : 0)];
        for (n = 0; n < servers.length; ++n) {
            hosts[n] = servers[n];
        }
        if (clients != null) {
            int i = 0;
            while (i < clients.length) {
                hosts[n] = clients[i];
                ++i;
                ++n;
            }
        }
        Barrier bar = new Barrier();
        ThreadPoolMember[] t = new ThreadPoolMember[hosts.length];
        for (n = 0; n < hosts.length; ++n) {
            t[n] = this.threadPool.getNewThread(bar, "disco-" + n);
        }
        bar.addThreads(t);
        try {
            for (n = 0; n < hosts.length; ++n) {
                SamQFSSystemModel model;
                Object[] methodArgs = new Object[3];
                try {
                    model = this.appModel.getSamQFSSystemModel(hosts[n]);
                }
                catch (SamFSException e) {
                    t[n].setThrowable(e);
                    continue;
                }
                methodArgs[0] = n < servers.length ? Boolean.TRUE : Boolean.FALSE;
                methodArgs[1] = model.isClusterNode() ? new String[]{hosts[n]} : null;
                methodArgs[2] = Boolean.TRUE;
                t[n].startMethod(new MethodInfo("discoverAUs", model.getSamQFSSystemFSManager(), methodArgs));
            }
        }
        catch (NoSuchMethodException nsme) {
            System.out.println(nsme);
            System.exit(-1);
        }
        bar.waitForAll();
        for (n = 0; n < hosts.length; ++n) {
            Throwable e = t[n].getThrowable();
            if (null != e) {
                errHostNames.add(hosts[n]);
                errExceptions.add(e);
                continue;
            }
            DiskCache[] dc = (DiskCache[])t[n].getResult();
            TraceUtil.trace1(dc.length + " AU-s discovered");
            allDCs[n] = new DiskCacheImpl[dc.length];
            for (int d = 0; d < dc.length; ++d) {
                allDCs[n][d] = (DiskCacheImpl)dc[d];
            }
        }
        this.threadPool.releaseAllToPool();
    }

    public SharedDiskCache[] discoverAllocatableUnitsForShared(String[] servers, String[] clients) throws SamFSMultiHostException {
        DiskCache crtDskCache;
        int j;
        int i;
        ArrayList<SharedDiskCacheImpl> sdcLst = new ArrayList<SharedDiskCacheImpl>();
        ArrayList errorHostNames = new ArrayList();
        ArrayList errorExceptions = new ArrayList();
        int clientsLen = null == clients ? 0 : clients.length;
        if (null == servers) {
            throw new SamFSMultiHostException("internal error:need to pass metadata server!");
        }
        int serversLen = servers.length;
        DiskCache[][] allDCs = new DiskCacheImpl[servers.length + clientsLen][];
        this.parallelDisco(servers, clients, allDCs, errorHostNames, errorExceptions);
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        if (allDCs[0] == null) {
            return null;
        }
        for (i = 0; i < allDCs[0].length; ++i) {
            if (((DiskCacheImpl)allDCs[0][i]).getJniDisk().getAU().getType() != 0) continue;
            sdcLst.add(new SharedDiskCacheImpl((DiskCacheImpl)allDCs[0][i]));
        }
        SharedDiskCache[] sdcArr = sdcLst.toArray(new SharedDiskCacheImpl[0]);
        for (int s = 1; s < serversLen; ++s) {
            for (i = 0; i < sdcArr.length; ++i) {
                for (j = 0; j < allDCs[s].length; ++j) {
                    crtDskCache = allDCs[s][j];
                    if (!this.matchAUs(((DiskCacheImpl)((Object)sdcArr[i])).getJniDisk(), ((DiskCacheImpl)crtDskCache).getJniDisk())) continue;
                    ((SharedDiskCacheImpl)sdcArr[i]).addServer(servers[s]);
                    ((SharedDiskCacheImpl)sdcArr[i]).addServerDevpath(((BaseDeviceImpl)((Object)crtDskCache)).getDevicePath());
                }
            }
        }
        for (int c = 0; c < clientsLen; ++c) {
            for (i = 0; i < sdcArr.length; ++i) {
                for (j = 0; j < allDCs[serversLen + c].length; ++j) {
                    crtDskCache = allDCs[serversLen + c][j];
                    if (!this.matchAUs(((DiskCacheImpl)((Object)sdcArr[i])).getJniDisk(), ((DiskCacheImpl)crtDskCache).getJniDisk())) continue;
                    if (((DiskCacheImpl)crtDskCache).getJniDisk().getAU().getUsedBy() != null) {
                        TraceUtil.trace3(clients[c] + ": " + ((DiskCacheImpl)crtDskCache).getJniDisk().getAU().getPath() + " used by " + ((DiskCacheImpl)crtDskCache).getJniDisk().getAU().getUsedBy());
                        ((SharedDiskCacheImpl)sdcArr[i]).setUsedByClient(true);
                        continue;
                    }
                    ((SharedDiskCacheImpl)sdcArr[i]).addClient(clients[c]);
                    ((SharedDiskCacheImpl)sdcArr[i]).addClientDevpath(((BaseDeviceImpl)((Object)crtDskCache)).getDevicePath());
                }
            }
        }
        return sdcArr;
    }

    private Host[] membersToHosts(SharedMember[] members, SamQFSSystemModelImpl[] models) {
        Host[] hosts = new Host[members.length];
        int potentialMDServerPriority = 2;
        boolean isCurrentMDServer = false;
        for (int i = 0; i < hosts.length; ++i) {
            int priority = 0;
            isCurrentMDServer = false;
            switch (members[i].getType()) {
                case 0: {
                    priority = 1;
                    isCurrentMDServer = true;
                    break;
                }
                case 1: {
                    priority = potentialMDServerPriority++;
                    break;
                }
                case 2: {
                    priority = 0;
                }
            }
            hosts[i] = new Host(models[i].getServerHostname(), members[i].getIPs(), priority, isCurrentMDServer);
        }
        return hosts;
    }

    String getDevicePathForHost(SharedDiskCache sdc, SharedMember member) {
        String[] devPaths = null;
        String[] hostNames = null;
        switch (member.getType()) {
            case 0: 
            case 1: {
                devPaths = sdc.getServerDevpaths();
                hostNames = sdc.availFromServers();
                break;
            }
            case 2: {
                devPaths = sdc.getClientDevpaths();
                hostNames = sdc.availFromClients();
            }
        }
        String memberName = member.getHostName();
        String path = null;
        for (int i = 0; i < devPaths.length; ++i) {
            if (!hostNames[i].equals(memberName)) continue;
            path = devPaths[i];
            break;
        }
        return path;
    }

    private void setDevicePaths(SharedDiskCache[] metaSDC, DiskDev[] meta, SharedDiskCache[] dataSDC, DiskDev[] data, StripedGroup[] stripedGroups, StripedGrp[] grp, SharedMember member) {
        int j;
        for (j = 0; j < meta.length; ++j) {
            meta[j].setDevicePath(this.getDevicePathForHost(metaSDC[j], member));
        }
        if (data != null && dataSDC != null) {
            for (j = 0; j < data.length; ++j) {
                data[j].setDevicePath(this.getDevicePathForHost(dataSDC[j], member));
            }
        }
        if (stripedGroups != null) {
            for (j = 0; j < stripedGroups.length; ++j) {
                SharedDiskCache[] grpSDC = (SharedDiskCache[])stripedGroups[j].getMembers();
                DiskDev[] disks = grp[j].getMembers();
                for (int k = 0; k < disks.length; ++k) {
                    disks[k].setDevicePath(this.getDevicePathForHost(grpSDC[k], member));
                }
            }
        }
    }

    public FileSystem createSharedFileSystem(String fsName, String mountPoint, int DAUSize, SharedMember[] members, FileSystemMountProperties mountProps, DiskCache[] metadataDevices, DiskCache[] dataDevices, StripedGroup[] stripedGroups, boolean single, boolean mountAtBoot, boolean createMountPoint, boolean mountAfterCreate) throws SamFSMultiHostException {
        int i;
        boolean isMetaSame;
        ArrayList<String> errorHostNames = new ArrayList<String>();
        ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
        boolean bl = isMetaSame = metadataDevices == null || metadataDevices.length == 0;
        if (!SamQFSUtil.isValidString(fsName) || !SamQFSUtil.isValidString(mountPoint)) {
            throw new SamFSMultiHostException("logic.invalidFSParam");
        }
        if (!(dataDevices != null && dataDevices.length != 0 || stripedGroups != null && stripedGroups.length != 0)) {
            throw new SamFSMultiHostException("logic.invalidFSParam");
        }
        int mdServerIndex = -1;
        for (int i2 = 0; i2 < members.length; ++i2) {
            if (members[i2].getType() != 0) continue;
            mdServerIndex = i2;
            break;
        }
        if (mdServerIndex == -1) {
            throw new SamFSMultiHostException("logic.invalidFSParam");
        }
        SamQFSSystemModelImpl[] models = SamQFSSystemSharedFSManagerImpl.getSystemModels(members);
        String mdServerName = members[mdServerIndex].getHostName();
        SamQFSSystemModelImpl mdServerModel = models[mdServerIndex];
        DiskDev[] meta = null;
        DiskDev[] data = null;
        StripedGrp[] grp = null;
        String eqTypeForJni = "md";
        if (single) {
            eqTypeForJni = "mr";
        }
        int countEqOrdinalsRequired = SamQFSSystemSharedFSManagerImpl.countOrdinalsRequired(metadataDevices, dataDevices, stripedGroups);
        int firstAvailableOrdinal = SamQFSSystemSharedFSManagerImpl.getAvailableOrdinals(countEqOrdinalsRequired, models);
        int equ = firstAvailableOrdinal++;
        SharedDiskCache[] metaSDC = null;
        if (isMetaSame) {
            metaSDC = new SharedDiskCache[]{};
            meta = new DiskDev[]{};
        } else {
            metaSDC = (SharedDiskCache[])metadataDevices;
            meta = new DiskDev[metadataDevices.length];
            for (int i3 = 0; i3 < metadataDevices.length; ++i3) {
                meta[i3] = ((DiskCacheImpl)metadataDevices[i3]).getJniDisk();
                meta[i3].setEquipType("mm");
                meta[i3].setEquipOrdinal(firstAvailableOrdinal++);
            }
        }
        SharedDiskCache[] dataSDC = null;
        if (dataDevices != null && dataDevices.length > 0) {
            dataSDC = (SharedDiskCache[])dataDevices;
            if (dataDevices != null && dataDevices.length > 0) {
                data = new DiskDev[dataDevices.length];
                for (i = 0; i < dataDevices.length; ++i) {
                    data[i] = ((DiskCacheImpl)dataDevices[i]).getJniDisk();
                    data[i].setEquipType(eqTypeForJni);
                    data[i].setEquipOrdinal(firstAvailableOrdinal++);
                }
            }
        }
        if (stripedGroups != null) {
            grp = new StripedGrp[stripedGroups.length];
            for (i = 0; i < stripedGroups.length; ++i) {
                grp[i] = ((StripedGroupImpl)stripedGroups[i]).getJniStripedGroup();
                DiskDev[] disks = grp[i].getMembers();
                for (int j = 0; j < disks.length; ++j) {
                    disks[j].setEquipOrdinal(firstAvailableOrdinal++);
                }
            }
        }
        MountOptions opt = ((FileSystemMountPropertiesImpl)mountProps).getJniMountOptions();
        Host[] hosts = this.membersToHosts(members, models);
        FSInfo fsInfoMDS = new FSInfo(fsName, equ, DAUSize, isMetaSame ? "ms" : "ma", meta, data, grp, opt, mountPoint, mdServerName, true, false, hosts);
        FSInfo fsInfoPMDS = new FSInfo(fsName, equ, DAUSize, isMetaSame ? "ms" : "ma", meta, data, grp, opt, mountPoint, mdServerName, true, true, hosts);
        FSInfo fsInfoClient = new FSInfo(fsName, equ, DAUSize, isMetaSame ? "ms" : "ma", meta, data, grp, opt, mountPoint, mdServerName, false, false, hosts);
        boolean resetCtx = false;
        FileSystemImpl fs2 = null;
        String savePath = null;
        try {
            if (SamQFSUtil.isValidString(mdServerModel.getDumpPath())) {
                mdServerModel.getJniContext().setDumpPath(mdServerModel.getDumpPath());
                savePath = mdServerModel.getDumpPath();
                resetCtx = true;
            }
            FS.createAndMount((Ctx)mdServerModel.getJniContext(), (FSInfo)fsInfoMDS, (boolean)mountAtBoot, (boolean)createMountPoint, (boolean)mountAfterCreate);
            fs2 = new FileSystemImpl(mdServerModel, fsInfoMDS);
            mdServerModel.setDumpPath(null);
            if (resetCtx) {
                mdServerModel.getJniContext().setDumpPath(null);
            }
            mdServerModel.getDataStore().clearAvailableAllocatableUnits();
            mdServerModel.getDataStore().clearTemporaryStripedGroups();
        }
        catch (SamFSException e) {
            errorHostNames.add(mdServerName);
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        FSInfo info = null;
        for (int i4 = 0; i4 < members.length; ++i4) {
            switch (members[i4].getType()) {
                case 0: {
                    info = null;
                    break;
                }
                case 1: {
                    info = fsInfoPMDS;
                    break;
                }
                case 2: {
                    info = fsInfoClient;
                }
            }
            if (info == null) continue;
            String name = members[i4].getHostName();
            SamQFSSystemModelImpl model = SamQFSSystemSharedFSManagerImpl.getSystemModel(name, errorHostNames, errorExceptions);
            if (!errorHostNames.isEmpty()) continue;
            try {
                if (SamQFSUtil.isValidString(savePath)) {
                    model.getJniContext().setDumpPath(savePath);
                    resetCtx = true;
                }
                this.setDevicePaths(metaSDC, meta, dataSDC, data, stripedGroups, grp, members[i4]);
                FS.createAndMount((Ctx)model.getJniContext(), (FSInfo)info, (boolean)mountAtBoot, (boolean)createMountPoint, (boolean)mountAfterCreate);
                model.setDumpPath(null);
                if (!resetCtx) continue;
                model.getJniContext().setDumpPath(null);
                continue;
            }
            catch (SamFSException e) {
                errorHostNames.add(name);
                errorExceptions.add(e);
            }
        }
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        return fs2;
    }

    public FileSystem addHostToSharedFS(String fsName, String mdServerName, String mountPoint, String hostName, String[] hostIP, boolean readOnly, boolean mountAtBoot, boolean createMountPoint, boolean mountAfterCreate, boolean potentialMdServer, boolean bg) throws SamFSMultiHostException {
        ArrayList<String> errorHostNames = new ArrayList<String>();
        ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
        String uname = null;
        if (!SamQFSUtil.isValidString(fsName) || !SamQFSUtil.isValidString(mountPoint)) {
            throw new SamFSMultiHostException("logic.invalidFSParam");
        }
        SamQFSSystemModelImpl mdServerModel = SamQFSSystemSharedFSManagerImpl.getSystemModel(mdServerName, errorHostNames, errorExceptions);
        SamQFSSystemModelImpl hostModel = SamQFSSystemSharedFSManagerImpl.getSystemModel(hostName, errorHostNames, errorExceptions);
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        FSInfo mdsInfo = null;
        FSInfo info = null;
        boolean resetCtx = false;
        Host host = null;
        try {
            mdsInfo = FS.get((Ctx)mdServerModel.getJniContext(), (String)fsName);
            MountOptions mdsOpts = mdsInfo.getMountOptions();
            mdsOpts.setReadOnlyMount(readOnly);
            mdsOpts.setMountInBackground(bg);
            try {
                this.verifyEQsAreAvailOnNewHost(mdsInfo, hostModel);
            }
            catch (SamFSException e) {
                String msg = e.getSAMerrno() == 31116 ? "logic.sharedFSEQInUse" : "logic.sharedFSOperationPartialFailure";
                errorHostNames.add(hostName);
                errorExceptions.add(e);
                throw new SamFSMultiHostException(msg, errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
            }
            Host[] hosts = mdsInfo.getHosts();
            int priority = 0;
            if (potentialMdServer) {
                for (int i = 0; i < hosts.length; ++i) {
                    if (hosts[i].getSrvPrio() <= priority) continue;
                    priority = hosts[i].getSrvPrio();
                }
                ++priority;
            }
            uname = hostModel.getServerHostname();
            host = new Host(uname, hostIP, priority, false);
            Host[] hosts2 = new Host[hosts.length + 1];
            for (int i = 0; i < hosts.length; ++i) {
                hosts2[i] = hosts[i];
            }
            hosts2[hosts.length] = host;
            DiskDev[] dataDevices = mdsInfo.getDataDevices();
            DiskDev[] metaDevices = mdsInfo.getMetadataDevices();
            StripedGrp[] stripedGroups = mdsInfo.getStripedGroups();
            boolean combMetaAndData = true;
            if (metaDevices != null && metaDevices.length > 0) {
                combMetaAndData = false;
            }
            if (!hostModel.isClusterNode()) {
                DiskCache[] disksKnown = hostModel.getSamQFSSystemFSManager().discoverAvailableAllocatableUnits(null);
                this.fixDiskPath(dataDevices, disksKnown);
                if (!combMetaAndData) {
                    if (potentialMdServer) {
                        this.fixDiskPath(metaDevices, disksKnown);
                    }
                    for (int i = 0; i < stripedGroups.length; ++i) {
                        this.fixDiskPath(stripedGroups[i].getMembers(), disksKnown);
                    }
                }
            } else {
                mountAtBoot = false;
            }
            info = new FSInfo(fsName, mdsInfo.getEqu(), mdsInfo.getDAUSize(), combMetaAndData ? "ms" : "ma", metaDevices, dataDevices, stripedGroups, mdsOpts, mountPoint, mdServerName, potentialMdServer, potentialMdServer, hosts2);
        }
        catch (SamFSMultiHostException multiEx) {
            throw multiEx;
        }
        catch (SamFSException e) {
            errorHostNames.add(mdServerName);
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        FileSystemImpl fs2 = null;
        try {
            if (SamQFSUtil.isValidString(mdServerModel.getDumpPath())) {
                mdServerModel.getJniContext().setDumpPath(mdServerModel.getDumpPath());
                hostModel.getJniContext().setDumpPath(hostModel.getDumpPath());
                resetCtx = true;
            }
            Host.addToConfig((Ctx)mdServerModel.getJniContext(), (String)fsName, (Host)host);
            FS.createAndMount((Ctx)hostModel.getJniContext(), (FSInfo)info, (boolean)mountAtBoot, (boolean)createMountPoint, (boolean)mountAfterCreate);
            fs2 = new FileSystemImpl(hostModel, info);
            mdServerModel.setDumpPath(null);
            hostModel.setDumpPath(null);
            if (resetCtx) {
                mdServerModel.getJniContext().setDumpPath(null);
                hostModel.getJniContext().setDumpPath(null);
            }
            hostModel.getDataStore().clearAvailableAllocatableUnits();
            hostModel.getDataStore().clearTemporaryStripedGroups();
        }
        catch (SamFSException e) {
            errorHostNames.add(hostName);
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        return fs2;
    }

    public void deleteSharedFileSystem(String hostName, String fsName, String mdServerName) throws SamFSMultiHostException {
        int i;
        TraceUtil.trace1("deleteSharedFS(" + hostName + "," + fsName + "," + (mdServerName == null ? "-" : mdServerName));
        ArrayList<String> errorHostNames = new ArrayList<String>();
        ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
        SamQFSSystemModelImpl modelMDS = null;
        SamQFSSystemModelImpl model = SamQFSSystemSharedFSManagerImpl.getSystemModel(hostName, errorHostNames, errorExceptions);
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        FSInfo info = null;
        try {
            info = FS.get((Ctx)model.getJniContext(), (String)fsName);
            if (mdServerName == null) {
                mdServerName = info.getServerName();
            }
            modelMDS = SamQFSSystemSharedFSManagerImpl.getSystemModel(mdServerName, errorHostNames, errorExceptions);
        }
        catch (SamFSException e) {
            if (e.getSAMerrno() == 30132) {
                if (mdServerName == null) {
                    throw new SamFSMultiHostException("logic.sharedNotSharedFS");
                }
                try {
                    modelMDS = SamQFSSystemSharedFSManagerImpl.getSystemModel(mdServerName, errorHostNames, errorExceptions);
                    Host.removeFromConfig((Ctx)modelMDS.getJniContext(), (String)fsName, (String)hostName);
                }
                catch (SamFSException ex) {
                    errorHostNames.add(mdServerName);
                    errorExceptions.add(e);
                    throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
                }
                return;
            }
            errorHostNames.add(hostName);
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        Host[] hosts = null;
        if (errorHostNames.isEmpty()) {
            try {
                hosts = Host.getConfig((Ctx)modelMDS.getJniContext(), (String)fsName);
            }
            catch (SamFSException e) {
                errorHostNames.add(mdServerName);
                errorExceptions.add(e);
            }
        } else {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        FSInfo[] infos = new FSInfo[hosts.length];
        SamQFSSystemModelImpl[] models = new SamQFSSystemModelImpl[hosts.length];
        for (i = 0; i < hosts.length; ++i) {
            try {
                models[i] = SamQFSSystemSharedFSManagerImpl.getSystemModel(hosts[i].getName(), errorHostNames, errorExceptions);
                if (models[i] == null) continue;
                infos[i] = FS.get((Ctx)models[i].getJniContext(), (String)fsName);
                if (infos[i].isMounted()) {
                    errorHostNames.add(hosts[i].getName());
                    errorExceptions.add(new SamFSException("logic.sharedMountedFS"));
                    continue;
                }
                TraceUtil.trace1("model was null");
                continue;
            }
            catch (SamFSException e) {
                if (e.getSAMerrno() == 30132 && modelMDS != models[i]) continue;
                errorHostNames.add(hosts[i].getName());
                errorExceptions.add(e);
            }
        }
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        if (info.isMdServer()) {
            for (i = 0; i < infos.length; ++i) {
                if (infos[i] == null || infos[i].isMdServer()) continue;
                try {
                    infos[i].remove(models[i].getJniContext());
                    continue;
                }
                catch (SamFSException e) {
                    if (e.getSAMerrno() == 30132) continue;
                    errorHostNames.add(hosts[i].getName());
                    errorExceptions.add(e);
                }
            }
            if (!errorHostNames.isEmpty()) {
                throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
            }
            try {
                info.remove(modelMDS.getJniContext());
            }
            catch (SamFSException e) {
                errorHostNames.add(mdServerName);
                errorExceptions.add(e);
            }
        } else if (info.isPotentialMdServer()) {
            try {
                info.remove(model.getJniContext());
            }
            catch (SamFSException e) {
                errorHostNames.add(hostName);
                errorExceptions.add(e);
            }
        } else if (info.isClient()) {
            try {
                info.remove(model.getJniContext());
                Host.removeFromConfig((Ctx)modelMDS.getJniContext(), (String)fsName, (String)hostName);
            }
            catch (SamFSException e) {
                errorHostNames.add(hostName);
                errorExceptions.add(e);
            }
        } else {
            throw new SamFSMultiHostException("logic.sharedNotSharedFS");
        }
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
    }

    public boolean failingover(String mdServer, String fsName) throws SamFSException {
        SamQFSSystemModelImpl model = (SamQFSSystemModelImpl)this.appModel.getSamQFSSystemModel(mdServer);
        if (model.isDown()) {
            throw new SamFSException("logic.hostIsDown");
        }
        FSInfo info = FS.get((Ctx)model.getJniContext(), (String)fsName);
        if (info == null) {
            throw new SamFSException("logic.invalidFS");
        }
        return info.failoverStatus() != 0;
    }

    public int getSharedFSType(String hostName, String fsName) throws SamFSException {
        SamQFSSystemModelImpl model = (SamQFSSystemModelImpl)this.appModel.getSamQFSSystemModel(hostName);
        if (model.isDown()) {
            throw new SamFSException("logic.hostIsDown");
        }
        FSInfo info = FS.get((Ctx)model.getJniContext(), (String)fsName);
        if (info == null) {
            throw new SamFSException("logic.invalidFS");
        }
        if (info.isMdServer()) {
            return 0;
        }
        if (info.isPotentialMdServer()) {
            return 1;
        }
        if (info.isClient()) {
            return 2;
        }
        return -1;
    }

    public SharedMember[] getSharedMembers(String mdServer, String fsName) throws SamFSMultiHostException {
        ArrayList<SharedMemberImpl> members = new ArrayList<SharedMemberImpl>();
        ArrayList<String> errorHostNames = new ArrayList<String>();
        ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
        SamQFSSystemModelImpl model = SamQFSSystemSharedFSManagerImpl.getSystemModel(mdServer, errorHostNames, errorExceptions);
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        Host[] hosts = null;
        try {
            hosts = Host.getConfig((Ctx)model.getJniContext(), (String)fsName);
        }
        catch (SamFSException e) {
            errorHostNames.add(mdServer);
            errorExceptions.add(e);
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        for (int i = 0; i < hosts.length; ++i) {
            boolean mounted = false;
            int type = -1;
            try {
                SamQFSSystemModelImpl hostModel = SamQFSSystemSharedFSManagerImpl.getSystemModel(hosts[i].getName(), errorHostNames, errorExceptions);
                if (hostModel == null) continue;
                FSInfo info = FS.get((Ctx)hostModel.getJniContext(), (String)fsName);
                if (info.isClient()) {
                    type = 2;
                } else if (info.isMdServer()) {
                    type = 0;
                } else if (info.isPotentialMdServer()) {
                    type = 1;
                }
                mounted = info.isMounted();
                members.add(new SharedMemberImpl(hosts[i].getName(), hosts[i].getIPs(), type, mounted));
                continue;
            }
            catch (SamFSException e) {
                if (e.getSAMerrno() == 30132) {
                    members.add(new SharedMemberImpl(hosts[i].getName(), hosts[i].getIPs(), type, mounted));
                }
                errorHostNames.add(hosts[i].getName());
                errorExceptions.add(e);
            }
        }
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]), (Object)members.toArray(new SharedMember[0]));
        }
        return members.toArray(new SharedMember[0]);
    }

    public int[] getSharedLicenses(String[] hostNames) throws SamFSException {
        int[] ret = new int[hostNames.length];
        for (int i = 0; i < hostNames.length; ++i) {
            License license;
            SamQFSSystemModelImpl model;
            ret[i] = -1;
            try {
                model = (SamQFSSystemModelImpl)this.appModel.getSamQFSSystemModel(hostNames[i]);
            }
            catch (SamFSException e) {
                TraceUtil.trace1("no model for " + hostNames[i] + ". cannot get license information");
                continue;
            }
            if (model.isDown() || (license = License.getLicense((Ctx)model.getJniContext())) == null) continue;
            ret[i] = license.isSharedFileSystemSupported() ? 1 : 0;
        }
        return ret;
    }

    public void setSharedMountOptions(String mdServer, String fsName, FileSystemMountProperties options) throws SamFSMultiHostException {
        ArrayList<String> errorHostNames = new ArrayList<String>();
        ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
        FileSystemMountPropertiesImpl jniOptions = (FileSystemMountPropertiesImpl)options;
        SharedMember[] members = this.getSharedMembers(mdServer, fsName);
        for (int i = 0; i < members.length; ++i) {
            try {
                SamQFSSystemModelImpl current = SamQFSSystemSharedFSManagerImpl.getSystemModel(members[i].getHostName(), errorHostNames, errorExceptions);
                if (current == null) continue;
                if (members[i].isMounted()) {
                    FS.setLiveMountOpts((Ctx)current.getJniContext(), (String)fsName, (MountOptions)jniOptions.getJniMountOptions());
                }
                FS.setMountOpts((Ctx)current.getJniContext(), (String)fsName, (MountOptions)jniOptions.getJniMountOptions());
                continue;
            }
            catch (SamFSException e) {
                errorHostNames.add(members[i].getHostName());
                errorExceptions.add(e);
            }
        }
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
    }

    public String[] getHostsNotUsedBy(String fsName, String mdServer) throws SamFSException {
        LinkedList<String> hostList = new LinkedList<String>();
        SamQFSSystemModelImpl model = (SamQFSSystemModelImpl)this.appModel.getSamQFSSystemModel(mdServer);
        if (model.isDown()) {
            throw new SamFSException("logic.hostIsDown");
        }
        String mdsVersion = model.getServerProductVersion();
        SamQFSSystemModelImpl[] allModels = (SamQFSSystemModelImpl[])this.appModel.getAllSamQFSSystemModels();
        Host[] hosts = Host.getConfig((Ctx)model.getJniContext(), (String)fsName);
        for (int j = 0; j < allModels.length; ++j) {
            License license;
            boolean match = false;
            SamQFSSystemModelImpl crtModel = allModels[j];
            if (crtModel == null) {
                TraceUtil.trace1("model " + j + " is null. skipping");
                continue;
            }
            if (!crtModel.getServerProductVersion().equals(mdsVersion)) continue;
            String name = crtModel.getHostname();
            String uname = crtModel.getServerHostname();
            for (int i = 0; i < hosts.length; ++i) {
                if (!hosts[i].getName().equals(name) && !hosts[i].getName().equals(uname)) continue;
                match = true;
                break;
            }
            if (match || crtModel.isDown() || (license = License.getLicense((Ctx)crtModel.getJniContext())) == null || !license.isSharedFileSystemSupported()) continue;
            hostList.add(name);
        }
        return hostList.toArray(new String[0]);
    }

    public String[] getIPAddresses(String hostName) throws SamFSException {
        SamQFSSystemModelImpl model = (SamQFSSystemModelImpl)this.appModel.getSamQFSSystemModel(hostName);
        if (model.isDown()) {
            throw new SamFSException("logic.hostIsDown");
        }
        return Host.discoverIPsAndNames((Ctx)model.getJniContext());
    }

    public SharedMember createSharedMember(String name, String[] ips, int type) {
        return new SharedMemberImpl(name, ips, type, false);
    }

    public MDSAddresses[] getAdvancedNetworkConfig(String hostName, String fsName) throws SamFSException {
        SamQFSSystemModelImpl model = (SamQFSSystemModelImpl)this.appModel.getSamQFSSystemModel(hostName);
        if (model.isDown()) {
            throw new SamFSException("logic.hostIsDown");
        }
        if (fsName == null || fsName.length() == 0) {
            throw new SamFSException("logic.invalidFS");
        }
        String[] properties = Host.getAdvancedNetCfg((Ctx)model.getJniContext(), (String)fsName);
        MDSAddresses[] myAddresses = new MDSAddresses[properties.length];
        for (int i = 0; i < properties.length; ++i) {
            myAddresses[i] = new MDSAddresses(properties[i]);
        }
        return myAddresses;
    }

    private void setAdvancedNetworkConfig(String hostName, String fsName, MDSAddresses[] addresses) throws SamFSException {
        SamQFSSystemModelImpl model = (SamQFSSystemModelImpl)this.appModel.getSamQFSSystemModel(hostName);
        if (model.isDown()) {
            throw new SamFSException("logic.hostIsDown");
        }
        if (addresses == null || addresses.length == 0) {
            throw new SamFSException("logic.emptynetworkconfig");
        }
        String[] hosts = new String[addresses.length];
        for (int i = 0; i < addresses.length; ++i) {
            hosts[i] = addresses[i].toString();
        }
        Host.setAdvancedNetCfg((Ctx)model.getJniContext(), (String)fsName, (String[])hosts);
    }

    public void setAdvancedNetworkConfigToMultipleHosts(String[] hostNames, String fsName, String mdsServer, MDSAddresses[] addresses) throws SamFSMultiHostException, SamFSException {
        if (hostNames == null || hostNames.length == 0) {
            throw new SamFSMultiHostException("Developers' bug found!");
        }
        ArrayList<String> errorHostNames = new ArrayList<String>();
        ArrayList<SamFSException> errorExceptions = new ArrayList<SamFSException>();
        for (int i = 0; i < hostNames.length; ++i) {
            try {
                this.setAdvancedNetworkConfig(hostNames[i], fsName, addresses);
                continue;
            }
            catch (SamFSException e) {
                errorHostNames.add(hostNames[i]);
                errorExceptions.add(e);
            }
        }
        if (!errorHostNames.isEmpty()) {
            throw new SamFSMultiHostException("logic.sharedFSOperationPartialFailure", errorExceptions.toArray(new SamFSException[0]), errorHostNames.toArray(new String[0]));
        }
        this.configureHostFileIfNecessary(fsName, mdsServer, addresses);
    }

    private void configureHostFileIfNecessary(String fsName, String mdsServer, MDSAddresses[] addresses) throws SamFSException {
        if (fsName == null || addresses == null || fsName.length() == 0 || addresses.length == 0) {
            return;
        }
        SharedMember[] sharedMember = this.getSharedMembers(mdsServer, fsName);
        for (int j = 0; j < addresses.length; ++j) {
            String hostName = addresses[j].getHostName();
            for (int i = 0; i < sharedMember.length; ++i) {
                String[] newIPs;
                if (!hostName.equals(sharedMember[i].getHostName()) || (newIPs = this.compareIPs(sharedMember[i].getIPs(), addresses[j].getIPAddress())).length == sharedMember[i].getIPs().length) continue;
                this.addIPToHost(fsName, mdsServer, hostName, newIPs);
            }
        }
    }

    private void addIPToHost(String fsName, String mdServerName, String hostName, String[] newIPs) throws SamFSException {
        ArrayList errorHostNames = new ArrayList();
        ArrayList errorExceptions = new ArrayList();
        SamQFSSystemModelImpl mdServerModel = SamQFSSystemSharedFSManagerImpl.getSystemModel(mdServerName, errorHostNames, errorExceptions);
        if (!errorHostNames.isEmpty()) {
            throw (SamFSException)((Object)errorExceptions.get(0));
        }
        Host newHost = null;
        FSInfo mdsInfo = FS.get((Ctx)mdServerModel.getJniContext(), (String)fsName);
        Host[] hosts = mdsInfo.getHosts();
        for (int i = 0; i < hosts.length; ++i) {
            if (!hosts[i].getName().equals(hostName)) continue;
            newHost = new Host(hosts[i].getName(), newIPs, hosts[i].getSrvPrio(), hosts[i].isCrtServer());
            break;
        }
        if (newHost == null) {
            throw new SamFSException("Failed to add IP to the corresponding metadata server");
        }
        Host.addToConfig((Ctx)mdServerModel.getJniContext(), (String)fsName, newHost);
    }

    private String[] compareIPs(String[] existingIPs, String[] newIPs) {
        int k;
        NonSyncStringBuffer buf = new NonSyncStringBuffer();
        boolean addNew = true;
        for (int i = 0; i < newIPs.length; ++i) {
            for (int j = 0; j < existingIPs.length; ++j) {
                if (!newIPs[i].equals(existingIPs[j])) continue;
                addNew = false;
                break;
            }
            if (addNew) {
                if (buf.length() > 0) {
                    buf.append("###");
                }
                buf.append(newIPs[i]);
            }
            addNew = true;
        }
        if (buf.length() == 0) {
            return existingIPs;
        }
        String[] needToAdd = buf.toString().split("###");
        String[] resultIPs = new String[existingIPs.length + needToAdd.length];
        for (k = 0; k < existingIPs.length; ++k) {
            resultIPs[k] = existingIPs[k];
        }
        for (k = 0; k < needToAdd.length; ++k) {
            resultIPs[k + existingIPs.length] = needToAdd[k];
        }
        return resultIPs;
    }
}

