/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.Job;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.job.ArCopyJob;
import com.sun.netstorage.samqfs.mgmt.arc.job.ArFindJob;
import com.sun.netstorage.samqfs.mgmt.fs.SamfsckJob;
import com.sun.netstorage.samqfs.mgmt.media.LabelJob;
import com.sun.netstorage.samqfs.mgmt.media.MountJob;
import com.sun.netstorage.samqfs.mgmt.rel.ReleaserJob;
import com.sun.netstorage.samqfs.mgmt.stg.job.StagerJob;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemJobManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.job.ArchiveJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.job.ArchiveScanJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.job.BaseJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.job.LabelJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.job.MountJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.job.ReleaseJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.job.RestoreJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.job.SamfsckJobImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.job.StageJobImpl;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import java.util.ArrayList;

public class SamQFSSystemJobManagerImpl
implements SamQFSSystemJobManager {
    private SamQFSSystemModelImpl theModel;
    private ArrayList jobs = new ArrayList();

    public SamQFSSystemJobManagerImpl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public BaseJob[] getAllJobs() throws SamFSException {
        this.jobs.clear();
        Job[] jniJobs = null;
        try {
            jniJobs = Job.getJobs((Ctx)this.theModel.getJniContext(), (short)1);
        }
        catch (Exception e) {
            this.theModel.processException(e);
        }
        if (jniJobs != null) {
            for (int i = 0; i < jniJobs.length; ++i) {
                this.jobs.add(new ArchiveScanJobImpl((ArFindJob)jniJobs[i]));
            }
            jniJobs = null;
        }
        try {
            jniJobs = Job.getJobs((Ctx)this.theModel.getJniContext(), (short)0);
        }
        catch (Exception e) {
            this.theModel.processException(e);
        }
        if (jniJobs != null) {
            for (int i = 0; i < jniJobs.length; ++i) {
                this.jobs.add(new ArchiveJobImpl((ArCopyJob)jniJobs[i]));
            }
            jniJobs = null;
        }
        try {
            jniJobs = Job.getJobs((Ctx)this.theModel.getJniContext(), (short)2);
        }
        catch (Exception e) {
            this.theModel.processException(e);
        }
        if (jniJobs != null) {
            for (int i = 0; i < jniJobs.length; ++i) {
                this.jobs.add(new StageJobImpl(this.theModel, (StagerJob)jniJobs[i]));
            }
            jniJobs = null;
        }
        try {
            jniJobs = Job.getJobs((Ctx)this.theModel.getJniContext(), (short)3);
        }
        catch (Exception e) {
            this.theModel.processException(e);
        }
        if (jniJobs != null) {
            for (int i = 0; i < jniJobs.length; ++i) {
                this.jobs.add(new ReleaseJobImpl((ReleaserJob)jniJobs[i]));
            }
            jniJobs = null;
        }
        try {
            jniJobs = Job.getJobs((Ctx)this.theModel.getJniContext(), (short)5);
        }
        catch (Exception e) {
            this.theModel.processException(e);
        }
        if (jniJobs != null) {
            for (int i = 0; i < jniJobs.length; ++i) {
                this.jobs.add(new MountJobImpl(this.theModel, (MountJob)jniJobs[i]));
            }
            jniJobs = null;
        }
        try {
            jniJobs = Job.getJobs((Ctx)this.theModel.getJniContext(), (short)8);
        }
        catch (Exception e) {
            this.theModel.processException(e);
        }
        if (jniJobs != null) {
            for (int i = 0; i < jniJobs.length; ++i) {
                this.jobs.add(new SamfsckJobImpl((SamfsckJob)jniJobs[i]));
            }
            jniJobs = null;
        }
        try {
            jniJobs = Job.getJobs((Ctx)this.theModel.getJniContext(), (short)9);
        }
        catch (Exception e) {
            this.theModel.processException(e);
        }
        if (jniJobs != null) {
            for (int i = 0; i < jniJobs.length; ++i) {
                this.jobs.add(new LabelJobImpl((LabelJob)jniJobs[i]));
            }
            jniJobs = null;
        }
        try {
            String[] jobsStrs = Job.getAllActivities((Ctx)this.theModel.getJniContext(), (int)100, (String)"type=SAMR");
            if (jobsStrs != null) {
                for (int i = 0; i < jobsStrs.length; ++i) {
                    this.jobs.add(new RestoreJobImpl(jobsStrs[i]));
                }
            }
        }
        catch (Exception e) {
            this.theModel.processException(e);
        }
        return this.jobs.toArray(new BaseJob[0]);
    }

    public BaseJob[] getJobsByType(int type) throws SamFSException {
        String[] jobsStrs;
        ArrayList specificJobs = new ArrayList();
        String activityType = null;
        switch (type) {
            case 20: {
                activityType = "SAMRDUMP";
                break;
            }
            case 21: {
                activityType = "SAMRDECOMPRESS";
                break;
            }
            case 23: {
                activityType = "SAMRRESTORE";
                break;
            }
            case 22: {
                activityType = "SAMRSEARCH";
                break;
            }
            default: {
                this.getAllJobs();
                if (this.jobs == null) break;
                for (int i = 0; i < this.jobs.size(); ++i) {
                    if (((BaseJob)this.jobs.get(i)).getType() != type) continue;
                    specificJobs.add(this.jobs.get(i));
                }
            }
        }
        if (activityType != null && (jobsStrs = Job.getAllActivities((Ctx)this.theModel.getJniContext(), (int)100, (String)("type=" + activityType))) != null) {
            for (int i = 0; i < jobsStrs.length; ++i) {
                specificJobs.add(new RestoreJobImpl(jobsStrs[i]));
            }
        }
        return specificJobs.toArray(new BaseJob[0]);
    }

    public BaseJob[] getJobsByCondition(int condition) throws SamFSException {
        this.getAllJobs();
        ArrayList specificJobs = new ArrayList();
        if (this.jobs != null) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                if (((BaseJob)this.jobs.get(i)).getCondition() != condition) continue;
                specificJobs.add(this.jobs.get(i));
            }
        }
        return specificJobs.toArray(new BaseJob[0]);
    }

    public BaseJob getJobById(long id) throws SamFSException {
        this.getAllJobs();
        BaseJob job = null;
        if (this.jobs != null) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                if (((BaseJob)this.jobs.get(i)).getJobId() != id) continue;
                job = (BaseJob)this.jobs.get(i);
                break;
            }
        }
        return job;
    }

    public void cancelJob(BaseJob job) throws SamFSException {
        if (job == null) {
            throw new SamFSException("logic.invalidJob");
        }
        Job jniJob = ((BaseJobImpl)job).getJniJob();
        if (jniJob == null) {
            if (job.getType() >= 0 && job.getType() <= 10) {
                throw new SamFSException("logic.noBackEndJob");
            }
            try {
                RestoreJobImpl rJob = (RestoreJobImpl)job;
                rJob.cancel(this.theModel.getJniContext());
            }
            catch (ClassCastException cce) {
                throw new SamFSException("logic.noBackEndJob");
            }
        } else {
            jniJob.terminate(this.theModel.getJniContext());
        }
        int index = this.jobs.indexOf(job);
        if (index != -1) {
            this.jobs.remove(index);
        }
    }
}

