/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.Ctx;
import com.sun.netstorage.samqfs.mgmt.FileUtil;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.arc.ArFSDirective;
import com.sun.netstorage.samqfs.mgmt.arc.ArGlobalDirective;
import com.sun.netstorage.samqfs.mgmt.arc.ArSet;
import com.sun.netstorage.samqfs.mgmt.arc.Archiver;
import com.sun.netstorage.samqfs.mgmt.arc.BufDirective;
import com.sun.netstorage.samqfs.mgmt.arc.Copy;
import com.sun.netstorage.samqfs.mgmt.arc.CopyParams;
import com.sun.netstorage.samqfs.mgmt.arc.Criteria;
import com.sun.netstorage.samqfs.mgmt.arc.DrvDirective;
import com.sun.netstorage.samqfs.mgmt.arc.VSNMap;
import com.sun.netstorage.samqfs.mgmt.arc.VSNOp;
import com.sun.netstorage.samqfs.mgmt.arc.VSNPool;
import com.sun.netstorage.samqfs.mgmt.rec.LibRecParams;
import com.sun.netstorage.samqfs.mgmt.rec.Recycler;
import com.sun.netstorage.samqfs.mgmt.rel.Releaser;
import com.sun.netstorage.samqfs.mgmt.rel.ReleaserDirective;
import com.sun.netstorage.samqfs.mgmt.stg.Stager;
import com.sun.netstorage.samqfs.mgmt.stg.StagerParams;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager43;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopyGUIWrapper;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.archive43.BufferDirective;
import com.sun.netstorage.samqfs.web.model.archive43.DriveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.FSArchiveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.GlobalArchiveDirective;
import com.sun.netstorage.samqfs.web.model.archive43.RecycleParams;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchiveCopyGUIWrapperImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchiveCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolCriteriaCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolCriteriaPropImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.ArchiveVSNMapImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.BufferDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.DriveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.FSArchiveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.GlobalArchiveDirectiveImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.RecycleParamsImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive43.VSNPoolImpl;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;
import java.util.HashMap;

public class SamQFSSystemArchiveManager43Impl
implements SamQFSSystemArchiveManager43 {
    private static String GLOBAL = "global properties";
    private SamQFSSystemModelImpl theModel = null;
    private HashMap vsnPoolMap = new HashMap();
    private HashMap policyMap = new HashMap();

    public SamQFSSystemArchiveManager43Impl(SamQFSSystemModel model) {
        this.theModel = (SamQFSSystemModelImpl)model;
    }

    public GlobalArchiveDirective getGlobalDirective() throws SamFSException {
        ArGlobalDirective dir = Archiver.getArGlobalDirective((Ctx)this.theModel.getJniContext());
        return new GlobalArchiveDirectiveImpl(this.theModel, dir);
    }

    public void setGlobalDirective(GlobalArchiveDirective global) throws SamFSException {
        global.changeGlobalDirective();
        if (!SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
        }
    }

    public FSArchiveDirective[] getFSGeneralArchiveDirective() throws SamFSException {
        TraceUtil.trace3("Logic: Enter getFSGeneralArchiveDirective()");
        ArrayList<FSArchiveDirectiveImpl> list = new ArrayList<FSArchiveDirectiveImpl>();
        ArFSDirective[] jniDirs = Archiver.getArFSDirectives((Ctx)this.theModel.getJniContext());
        if (jniDirs != null && jniDirs.length > 0) {
            for (int i = 0; i < jniDirs.length; ++i) {
                String fsName = jniDirs[i].getFSName();
                if (GLOBAL.equals(fsName)) continue;
                list.add(new FSArchiveDirectiveImpl(this.theModel, jniDirs[i]));
            }
        }
        TraceUtil.trace3("Logic: Exit getFSGeneralArchiveDirective()");
        return list.toArray(new FSArchiveDirective[0]);
    }

    public boolean isValidGroup(String groupName) throws SamFSException {
        boolean valid = Archiver.isValidGroup((Ctx)this.theModel.getJniContext(), (String)groupName);
        return valid;
    }

    public boolean isValidUser(String userName) throws SamFSException {
        boolean valid = Archiver.isValidUser((Ctx)this.theModel.getJniContext(), (String)userName);
        return valid;
    }

    public String[] getAllArchivePolicyNames() throws SamFSException {
        String[] names = Archiver.getCriteriaNames((Ctx)this.theModel.getJniContext());
        if (names == null) {
            names = new String[]{};
        }
        return names;
    }

    public ArchivePolicy[] getAllArchivePolicies() throws SamFSException {
        TraceUtil.trace3("Logic: Enter getAllArchivePolicies()");
        ArSet[] jniSets = Archiver.getArSets((Ctx)this.theModel.getJniContext());
        this.policyMap.clear();
        if (jniSets != null) {
            for (int i = 0; i < jniSets.length; ++i) {
                this.policyMap.put(jniSets[i].getArSetName(), new ArchivePolicyImpl(this.theModel, jniSets[i]));
            }
        }
        TraceUtil.trace3("Logic: Exit getAllArchivePolicies()");
        return this.policyMap.values().toArray(new ArchivePolicy[0]);
    }

    public ArchivePolicy getArchivePolicy(String policyName) throws SamFSException {
        return (ArchivePolicy)this.policyMap.get(policyName);
    }

    public ArchivePolicy createArchivePolicy(String policyName, ArchivePolCriteriaProp critProp, ArchiveCopyGUIWrapper[] copies, String[] fsNames) throws SamFSException {
        int i;
        ArchiveCopyImpl cp;
        int i2;
        ArchivePolicy existingPol;
        TraceUtil.trace3("Logic: Enter createArchivePolicy()");
        if (!SamQFSUtil.isValidString(policyName)) {
            throw new SamFSException("logic.invalidPolName");
        }
        if (this.policyMap.size() == 0) {
            this.getAllArchivePolicies();
        }
        if ((existingPol = this.getArchivePolicy(policyName)) != null) {
            throw new SamFSException("logic.existingPol");
        }
        if (fsNames == null || fsNames.length == 0) {
            throw new SamFSException("logic.oneFSNeededForPol");
        }
        boolean incorrectDiskVol = false;
        if (copies != null && !policyName.equals("no_archive")) {
            for (i2 = 0; i2 < copies.length; ++i2) {
                cp = (ArchiveCopyImpl)copies[i2].getArchiveCopy();
                incorrectDiskVol = this.isIncorrectDiskVol(cp);
                if (!incorrectDiskVol) continue;
                throw new SamFSException("logic.differentDiskVolExists");
            }
        }
        if (SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            this.theModel.getJniContext().setDumpPath(this.theModel.getDumpPath());
        }
        if (!(SamQFSUtil.isValidString(this.theModel.getDumpPath()) && this.theModel.getServerAPIVersion().equals("1.0") || copies == null || policyName.equals("no_archive"))) {
            for (i2 = 0; i2 < copies.length; ++i2) {
                cp = (ArchiveCopyImpl)copies[i2].getArchiveCopy();
                this.createDiskVolInfo(cp);
            }
        }
        Copy[] jniCritCopies = new Copy[ArchivePolicyImpl.MAX_COPY_REGULAR];
        CopyParams[] jniCopyParams = new CopyParams[ArchivePolicyImpl.MAX_COPY_ALLSETS];
        CopyParams[] jniRCopyParams = new CopyParams[ArchivePolicyImpl.MAX_COPY_ALLSETS];
        VSNMap[] jniVSNMaps = new VSNMap[ArchivePolicyImpl.MAX_COPY_ALLSETS];
        VSNMap[] jniRVSNMaps = new VSNMap[ArchivePolicyImpl.MAX_COPY_ALLSETS];
        for (i = 0; i < ArchivePolicyImpl.MAX_COPY_REGULAR; ++i) {
            jniCritCopies[i] = null;
        }
        for (i = 0; i < ArchivePolicyImpl.MAX_COPY_ALLSETS; ++i) {
            jniCopyParams[i] = null;
            jniRCopyParams[i] = null;
            jniVSNMaps[i] = null;
            jniRVSNMaps[i] = null;
        }
        ArchivePolCriteriaPropImpl prop = (ArchivePolCriteriaPropImpl)critProp;
        Criteria crit = prop.getJniCriteria();
        for (int i3 = 0; i3 < copies.length; ++i3) {
            jniCritCopies[i3] = ((ArchivePolCriteriaCopyImpl)copies[i3].getArchivePolCriteriaCopy()).getJniCopy();
            jniCritCopies[i3].setCopyNumber(i3 + 1);
        }
        crit.setCopies(jniCritCopies);
        Criteria[] criteria = new Criteria[fsNames.length];
        for (int i4 = 0; i4 < fsNames.length; ++i4) {
            criteria[i4] = new Criteria(fsNames[i4], crit);
            criteria[i4].setSetName(policyName);
        }
        short numCopies = (short)copies.length;
        boolean numRCopies = false;
        short numMaps = numCopies;
        boolean numRMaps = false;
        for (int i5 = 0; i5 < copies.length; ++i5) {
            ArchiveCopyImpl cp2 = (ArchiveCopyImpl)copies[i5].getArchiveCopy();
            ArchiveVSNMapImpl map = (ArchiveVSNMapImpl)cp2.getArchiveVSNMap();
            jniCopyParams[i5] = new CopyParams(policyName + "." + (i5 + 1), cp2.getJniCopyParams());
            if (SamQFSUtil.isValidString(cp2.getDiskArchiveVSN())) {
                numMaps = (short)(numMaps - 1);
                continue;
            }
            jniVSNMaps[i5] = map.getJniVSNMap();
            jniVSNMaps[i5].setCopyName(policyName + "." + (i5 + 1));
        }
        short type = 1;
        if (policyName.equals("no_archive")) {
            type = 2;
        }
        ArSet arSet = new ArSet(policyName, type, criteria, jniCopyParams, jniRCopyParams, jniVSNMaps, jniRVSNMaps);
        boolean resetCtx = false;
        if (SamQFSUtil.isValidString(this.theModel.getDumpPath())) {
            this.theModel.getJniContext().setDumpPath(this.theModel.getDumpPath());
            resetCtx = true;
        }
        try {
            Archiver.createArSet((Ctx)this.theModel.getJniContext(), (ArSet)arSet);
        }
        catch (SamFSException ex) {
            TraceUtil.trace3("Logic: Exception Occur, errNo = " + ex.getSAMerrno());
            if (!(ex.getSAMerrno() != 30136 || SamQFSUtil.isValidString(this.theModel.getDumpPath()) && this.theModel.getServerAPIVersion().equals("1.0") || copies == null || policyName.equals("no_archive"))) {
                for (int i6 = 0; i6 < copies.length; ++i6) {
                    ArchiveCopyImpl cp3 = (ArchiveCopyImpl)copies[i6].getArchiveCopy();
                    this.removeDiskVolInfo(cp3);
                }
            }
            throw ex;
        }
        this.theModel.setDumpPath(null);
        if (resetCtx) {
            this.theModel.getJniContext().setDumpPath(null);
        }
        Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
        this.getAllArchivePolicies();
        TraceUtil.trace3("Logic: Exit createArchivePolicy()");
        return this.getArchivePolicy(policyName);
    }

    public ArchivePolCriteriaProp getDefaultArchivePolCriteriaProperties() {
        return new ArchivePolCriteriaPropImpl(null, null);
    }

    public ArchiveCopyGUIWrapper getArchiveCopyGUIWrapper() {
        return new ArchiveCopyGUIWrapperImpl();
    }

    public void deleteArchivePolicy(String policyName) throws SamFSException {
        TraceUtil.trace3("Logic: Enter deleteArchivePolicy()");
        if (!SamQFSUtil.isValidString(policyName)) {
            throw new SamFSException("logic.invalidPol");
        }
        ArchivePolicyImpl policy = (ArchivePolicyImpl)this.policyMap.get(policyName);
        if (policy != null) {
            Archiver.deleteArSet((Ctx)this.theModel.getJniContext(), (String)policyName);
            this.policyMap.remove(policyName);
            Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
        }
        TraceUtil.trace3("Logic: Exit deleteArchivePolicy()");
    }

    public String[] getAllPoolNames() throws SamFSException {
        TraceUtil.trace3("Logic: Enter getAllPoolNames()");
        VSNPool[] pools = VSNOp.getPools((Ctx)this.theModel.getJniContext());
        String[] names = new String[]{};
        if (pools != null) {
            names = new String[pools.length];
            for (int i = 0; i < pools.length; ++i) {
                names[i] = pools[i].getName();
            }
        }
        TraceUtil.trace3("Logic: Exit getAllPoolNames()");
        return names;
    }

    public com.sun.netstorage.samqfs.web.model.archive43.VSNPool[] getAllVSNPools() throws SamFSException {
        TraceUtil.trace3("Logic: Enter getAllVSNPools()");
        this.createPoolsFromBackEnd();
        TraceUtil.trace3("Logic: Exit getAllVSNPools()");
        return this.vsnPoolMap.values().toArray(new com.sun.netstorage.samqfs.web.model.archive43.VSNPool[0]);
    }

    public com.sun.netstorage.samqfs.web.model.archive43.VSNPool getVSNPool(String poolName) throws SamFSException {
        return (com.sun.netstorage.samqfs.web.model.archive43.VSNPool)this.vsnPoolMap.get(poolName);
    }

    public com.sun.netstorage.samqfs.web.model.archive43.VSNPool createVSNPool(String poolName, int mediaType, String vsnExpr) throws SamFSException {
        TraceUtil.trace3("Logic: Enter createVSNPool()");
        String[] exprs = SamQFSUtil.getStringsFromCommaStream(vsnExpr);
        VSNPool jniPool = new VSNPool(poolName, SamQFSUtil.getMediaTypeString(mediaType), exprs);
        VSNOp.addPool((Ctx)this.theModel.getJniContext(), (VSNPool)jniPool);
        VSNPoolImpl pool = new VSNPoolImpl(this.theModel, jniPool);
        this.vsnPoolMap.put(poolName, pool);
        Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
        TraceUtil.trace3("Logic: Exit createVSNPool()");
        return pool;
    }

    public void updateVSNPool(String poolName) throws SamFSException {
        TraceUtil.trace3("Logic: Enter updateVSNPool()");
        com.sun.netstorage.samqfs.web.model.archive43.VSNPool pool = this.getVSNPool(poolName);
        if (pool != null) {
            ((VSNPoolImpl)pool).update();
        }
        TraceUtil.trace3("Logic: Exit updateVSNPool()");
    }

    public boolean isPoolInUse(String poolName) throws SamFSException {
        TraceUtil.trace3("Logic: Enter isPoolInUse()");
        boolean inUse = false;
        String copy = VSNOp.getCopyUsingPool((Ctx)this.theModel.getJniContext(), (String)poolName);
        if (SamQFSUtil.isValidString(copy)) {
            inUse = true;
        }
        TraceUtil.trace3("Logic: Exit isPoolInUse()");
        return inUse;
    }

    public void deleteVSNPool(String poolName) throws SamFSException {
        TraceUtil.trace3("Logic: Enter deleteVSNPool()");
        if (SamQFSUtil.isValidString(poolName)) {
            VSNOp.removePool((Ctx)this.theModel.getJniContext(), (String)poolName);
            this.vsnPoolMap.remove(poolName);
        }
        Archiver.activateCfgThrowWarnings((Ctx)this.theModel.getJniContext());
        TraceUtil.trace3("Logic: Exit deleteVSNPool()");
    }

    public boolean isIncorrectDiskVol(ArchiveCopy cp) throws SamFSException {
        TraceUtil.trace3("Logic: Enter isIncorrectDiskVol()");
        boolean incorrectDiskVol = false;
        if (cp != null && SamQFSUtil.isValidString(cp.getDiskArchiveVSN())) {
            String dvsn = cp.getDiskArchiveVSN();
            String host = cp.getDiskArchiveVSNHost();
            String path = cp.getDiskArchiveVSNPath();
            incorrectDiskVol = SamQFSUtil.isDifferentDiskVolInfoPresent(dvsn, host, path, this.theModel.getJniContext());
        }
        TraceUtil.trace3("Logic: Exit isIncorrectDiskVol()");
        return incorrectDiskVol;
    }

    public void createDiskVolInfo(ArchiveCopy cp) throws SamFSException {
        TraceUtil.trace3("Logic: Enter createDiskVolInfo()");
        if (cp != null && SamQFSUtil.isValidString(cp.getDiskArchiveVSN())) {
            String dvsn = cp.getDiskArchiveVSN();
            String host = cp.getDiskArchiveVSNHost();
            String path = cp.getDiskArchiveVSNPath();
            SamQFSUtil.createDiskVolInfo(dvsn, host, path, this.theModel.getJniContext());
        }
        TraceUtil.trace3("Logic: Exit createDiskVolInfo()");
    }

    public void removeDiskVolInfo(ArchiveCopy cp) throws SamFSException {
        String vsnPath;
        String dvsn;
        TraceUtil.trace3("Logic: Enter removeDiskVolInfo()");
        if (cp != null && SamQFSUtil.isValidString(cp.getDiskArchiveVSN()) && !this.isVSNInUse(dvsn = cp.getDiskArchiveVSN(), vsnPath = cp.getDiskArchiveVSNPath())) {
            SamQFSUtil.removeDiskVolInfo(dvsn, this.theModel.getJniContext());
        }
        TraceUtil.trace3("Logic: Exit createDiskVolInfo()");
    }

    private boolean isVSNInUse(String vsnString, String vsnPath) throws SamFSException {
        boolean isUse = false;
        ArchivePolicy[] policies = this.getAllArchivePolicies();
        block0: for (int i = 0; i < policies.length; ++i) {
            ArchiveCopy[] copies = policies[i].getArchiveCopies();
            for (int j = 0; j < copies.length; ++j) {
                String vsnCopyString = copies[j].getDiskArchiveVSN();
                String vsnCopyPath = copies[j].getDiskArchiveVSNPath();
                if (!vsnString.equals(vsnCopyString) || !vsnPath.equals(vsnCopyPath)) continue;
                TraceUtil.trace3("FOUND IT");
                isUse = true;
                continue block0;
            }
        }
        return isUse;
    }

    private void createPoolsFromBackEnd() throws SamFSException {
        TraceUtil.trace3("Logic: Enter createPoolsFromBackEnd()");
        this.vsnPoolMap.clear();
        SamQFSUtil.doPrint("jni call for pool.");
        VSNPool[] jniPools = VSNOp.getPools((Ctx)this.theModel.getJniContext());
        if (jniPools == null) {
            SamQFSUtil.doPrint("jni returned null array");
        } else {
            SamQFSUtil.doPrint("length: " + new Integer(jniPools.length).toString());
        }
        if (jniPools != null && jniPools.length > 0) {
            for (int i = 0; i < jniPools.length; ++i) {
                VSNPoolImpl pool = new VSNPoolImpl(this.theModel, jniPools[i]);
                this.vsnPoolMap.put(pool.getPoolName(), pool);
            }
        }
        TraceUtil.trace3("Logic: Exit createPoolsFromBackEnd()");
    }

    public ArrayList isDuplicateCriteria(ArchivePolCriteria curCriteria, String[] fsName, boolean update) throws SamFSException {
        ArrayList<String> resultList = new ArrayList<String>();
        boolean isDuplicate = false;
        ArchivePolCriteriaProp curCriteriaProp = curCriteria.getArchivePolCriteriaProperties();
        ArchivePolicy[] policies = this.policyMap.values().toArray(new ArchivePolicy[0]);
        for (int j = 0; j < fsName.length; ++j) {
            for (int i = 0; i < policies.length; ++i) {
                ArchivePolCriteria[] criterias = policies[i].getArchivePolCriteriaForFS(fsName[j]);
                if (criterias != null) {
                    for (int k = 0; k < criterias.length; ++k) {
                        ArchivePolCriteriaProp critrtiaProp = criterias[k].getArchivePolCriteriaProperties();
                        String startingDir = critrtiaProp.getStartingDir();
                        long minSize = critrtiaProp.getMinSizeInBytes();
                        long maxSize = critrtiaProp.getMaxSizeInBytes();
                        String namePattern = critrtiaProp.getNamePattern();
                        String owner = critrtiaProp.getOwner();
                        String group = critrtiaProp.getGroup();
                        if (startingDir == null || namePattern == null || owner == null || group == null || !startingDir.equals(curCriteriaProp.getStartingDir()) || minSize != curCriteriaProp.getMinSizeInBytes() || maxSize != curCriteriaProp.getMaxSizeInBytes() || !namePattern.equals(curCriteriaProp.getNamePattern()) || !owner.equals(curCriteriaProp.getOwner()) || !group.equals(curCriteriaProp.getGroup())) continue;
                        if (update) {
                            String polName = curCriteria.getArchivePolicy().getPolicyName();
                            if (policies[i].getPolicyName().equals(polName)) break;
                        }
                        isDuplicate = true;
                        resultList.add(0, new String("true"));
                        String criteriaName = new NonSyncStringBuffer("Criteria").append(Integer.toString(criterias[k].getIndex())).toString();
                        resultList.add(1, criteriaName);
                        resultList.add(2, policies[i].getPolicyName());
                        break;
                    }
                }
                if (isDuplicate) break;
            }
            if (isDuplicate) break;
        }
        if (!isDuplicate) {
            resultList.add(0, new String("false"));
        }
        return resultList;
    }

    public String getStagerLogFile() throws SamFSException {
        String logfile = new String();
        StagerParams param = Stager.getParams((Ctx)this.theModel.getJniContext());
        if (param != null && SamQFSUtil.isValidString(param.getLogPath())) {
            logfile = param.getLogPath();
        }
        return logfile;
    }

    public void setStagerLogFile(String logfile) throws SamFSException {
        StagerParams param = Stager.getParams((Ctx)this.theModel.getJniContext());
        if (param != null) {
            param.setLogPath(logfile);
            Stager.setParams((Ctx)this.theModel.getJniContext(), (StagerParams)param);
            if (!logfile.equals("")) {
                FileUtil.createFile((Ctx)this.theModel.getJniContext(), (String)logfile);
            }
        }
    }

    public BufferDirective[] getStagerBufDirectives() throws SamFSException {
        StagerParams param = Stager.getParams((Ctx)this.theModel.getJniContext());
        BufDirective[] bufs = null;
        if (param != null) {
            bufs = param.getBufDirectives();
        }
        ArrayList<BufferDirectiveImpl> list = new ArrayList<BufferDirectiveImpl>();
        if (bufs != null && bufs.length > 0) {
            for (int i = 0; i < bufs.length; ++i) {
                list.add(new BufferDirectiveImpl(bufs[i]));
            }
        }
        return list.toArray(new BufferDirective[0]);
    }

    public void changeStagerDirective(BufferDirective[] dir) throws SamFSException {
        if (dir != null && dir.length > 0) {
            BufDirective[] bufs = new BufDirective[dir.length];
            for (int i = 0; i < dir.length; ++i) {
                bufs[i] = ((BufferDirectiveImpl)dir[i]).getJniBufferDirective();
            }
            StagerParams param = Stager.getParams((Ctx)this.theModel.getJniContext());
            param.setBufDirectives(bufs);
            Stager.setParams((Ctx)this.theModel.getJniContext(), (StagerParams)param);
        }
    }

    public DriveDirective[] getStagerDriveDirectives() throws SamFSException {
        StagerParams param = Stager.getParams((Ctx)this.theModel.getJniContext());
        DrvDirective[] drvs = null;
        if (param != null) {
            drvs = param.getDrvDirectives();
        }
        ArrayList<DriveDirectiveImpl> list = new ArrayList<DriveDirectiveImpl>();
        if (drvs != null && drvs.length > 0) {
            for (int i = 0; i < drvs.length; ++i) {
                list.add(new DriveDirectiveImpl(this.theModel, drvs[i]));
            }
        }
        return list.toArray(new DriveDirective[0]);
    }

    public void changeStagerDriveDirective(DriveDirective[] dir) throws SamFSException {
        if (dir != null && dir.length > 0) {
            DrvDirective[] drvs = new DrvDirective[dir.length];
            for (int i = 0; i < dir.length; ++i) {
                drvs[i] = ((DriveDirectiveImpl)dir[i]).getJniDriveDirective();
            }
            StagerParams param = Stager.getParams((Ctx)this.theModel.getJniContext());
            param.setDrvDirectives(drvs);
            Stager.setParams((Ctx)this.theModel.getJniContext(), (StagerParams)param);
        }
    }

    public String getReleaserLogFile() throws SamFSException {
        String releaseLog = new String();
        ReleaserDirective rlDir = Releaser.getGlobalDirective((Ctx)this.theModel.getJniContext());
        if (rlDir != null) {
            releaseLog = rlDir.getLogFile();
        }
        return releaseLog;
    }

    public void setReleaserLogFile(String logFile) throws SamFSException {
        ReleaserDirective rlDir = Releaser.getGlobalDirective((Ctx)this.theModel.getJniContext());
        if (rlDir != null) {
            rlDir.setLogFile(logFile);
            Releaser.setGlobalDirective((Ctx)this.theModel.getJniContext(), (ReleaserDirective)rlDir);
            if (!logFile.equals("")) {
                FileUtil.createFile((Ctx)this.theModel.getJniContext(), (String)logFile);
            }
        }
    }

    public String getMinReleaseAge() throws SamFSException {
        long releaseAge = -1L;
        String ageString = "";
        ReleaserDirective rlDir = Releaser.getGlobalDirective((Ctx)this.theModel.getJniContext());
        if (rlDir != null && (releaseAge = rlDir.getMinAge()) >= 0L) {
            ageString = SamQFSUtil.longToInterval(releaseAge);
        }
        return ageString;
    }

    public void setMinReleaseAge(String ageValue) throws SamFSException {
        ReleaserDirective rlDir = Releaser.getGlobalDirective((Ctx)this.theModel.getJniContext());
        if (rlDir != null) {
            int unit = SamQFSUtil.getTimeUnitInteger(ageValue);
            long age = SamQFSUtil.getLongValSecond(ageValue);
            if (unit == -1 && age == -1L) {
                rlDir.resetMinAge();
            } else {
                rlDir.setMinAge(SamQFSUtil.convertToSecond(age, unit));
            }
            Releaser.setGlobalDirective((Ctx)this.theModel.getJniContext(), (ReleaserDirective)rlDir);
        }
    }

    public String getRecyclerLogFile() throws SamFSException {
        return Recycler.getLogPath((Ctx)this.theModel.getJniContext());
    }

    public void setRecyclerLogFile(String logFile) throws SamFSException {
        Recycler.setLogPath((Ctx)this.theModel.getJniContext(), (String)logFile);
        if (!logFile.equals("")) {
            FileUtil.createFile((Ctx)this.theModel.getJniContext(), (String)logFile);
        }
    }

    public int getPostRecycle() throws SamFSException {
        int postRecycleOpt = -1;
        int jni = Recycler.getActions((Ctx)this.theModel.getJniContext());
        if (jni == 1) {
            postRecycleOpt = 0;
        } else if (jni == 16) {
            postRecycleOpt = 1;
        } else {
            SamQFSUtil.doPrint("Label Jni val: " + Integer.toString(1));
            SamQFSUtil.doPrint("Export Jni val: " + Integer.toString(16));
            SamQFSUtil.doPrint("Returned JNI val: " + Integer.toString(jni));
        }
        return postRecycleOpt;
    }

    public void setPostRecycle(int postRecycleOpt) throws SamFSException {
        if (postRecycleOpt == 1) {
            Recycler.addActionExport((Ctx)this.theModel.getJniContext(), (String)"root");
        } else if (postRecycleOpt == 0) {
            Recycler.addActionLabel((Ctx)this.theModel.getJniContext());
        }
    }

    public RecycleParams[] getRecycleParams() throws SamFSException {
        ArrayList<RecycleParamsImpl> list = new ArrayList<RecycleParamsImpl>();
        LibRecParams[] params = Recycler.getAllLibRecParams((Ctx)this.theModel.getJniContext());
        if (params != null && params.length > 0) {
            for (int i = 0; i < params.length; ++i) {
                list.add(new RecycleParamsImpl(this.theModel, params[i]));
            }
        }
        return list.toArray(new RecycleParams[0]);
    }

    public void changeRecycleParams(RecycleParams param) throws SamFSException {
        ((RecycleParamsImpl)param).changeParams();
    }

    public void restartArchivingAll() throws SamFSException {
        Archiver.restart((Ctx)this.theModel.getJniContext());
    }

    public void idleArchivingAll() throws SamFSException {
        Archiver.idle((Ctx)this.theModel.getJniContext());
    }

    public void runNowArchivingAll() throws SamFSException {
        Archiver.run((Ctx)this.theModel.getJniContext());
    }

    public void stopArchivingAll() throws SamFSException {
        Archiver.stop((Ctx)this.theModel.getJniContext());
    }

    public void rerunArchivingAll() throws SamFSException {
        Archiver.rerun((Ctx)this.theModel.getJniContext());
    }

    public void runStagingAll() throws SamFSException {
        Stager.run((Ctx)this.theModel.getJniContext());
    }

    public void idleStagingAll() throws SamFSException {
        Stager.idle((Ctx)this.theModel.getJniContext());
    }

    public void restartStagingAll() throws SamFSException {
    }
}

