/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSDataStore;
import com.sun.netstorage.samqfs.web.model.archive.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSSystemModelImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.SamQFSUtil;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchiveCopyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchivePolicyImpl;
import com.sun.netstorage.samqfs.web.model.impl.jni.archive.ArchiveVSNMapImpl;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;
import java.util.ArrayList;
import java.util.HashMap;

public class SamQFSDataStoreImpl
implements SamQFSDataStore {
    private SamQFSSystemModelImpl model = null;
    private boolean discoveryNeeded = true;
    private HashMap available = new HashMap();
    private HashMap tempExclusions = new HashMap();
    private HashMap stripedGroupMap = new HashMap();
    private ArchivePolicy policy = null;

    public SamQFSDataStoreImpl(SamQFSSystemModelImpl model) throws SamFSException {
        this.model = model;
        this.clearSavedPolicy();
        this.clearAvailableAllocatableUnits();
    }

    public Drive[] getResultingSortedDriveSet(Drive[] drives, String[] includedPaths) throws SamFSException {
        int i;
        ArrayList<Drive> drvList = new ArrayList<Drive>();
        ArrayList<String> pathList = new ArrayList<String>();
        if (includedPaths != null && includedPaths.length > 0) {
            for (i = 0; i < includedPaths.length; ++i) {
                pathList.add(includedPaths[i]);
                System.out.println("Path " + (i + 1) + ": " + includedPaths[i]);
            }
        }
        if (drives != null && drives.length > 0) {
            for (i = 0; i < drives.length; ++i) {
                int index = pathList.indexOf(drives[i].getDevicePath());
                System.out.println("Drive " + (i + 1) + ": " + drives[i].getDevicePath() + ", index = " + index);
                if (index == -1) continue;
                drvList.add(drives[i]);
            }
        }
        return drvList.toArray(new Drive[0]);
    }

    public void setAvailableAllocatableUnits(String[] deviceExceptions) throws SamFSException {
        SamQFSUtil.doPrint("Debug: setAvailableAllocatableUnits()");
        if (this.available != null && deviceExceptions != null && deviceExceptions.length > 0) {
            for (int i = 0; i < deviceExceptions.length; ++i) {
                Object o;
                if (!SamQFSUtil.isValidString(deviceExceptions[i]) || (o = this.available.get(deviceExceptions[i])) == null) continue;
                this.tempExclusions.put(deviceExceptions[i], o);
                this.available.remove(deviceExceptions[i]);
            }
        }
    }

    public void addAvailableAllocatableUnits(String[] includeDevices) throws SamFSException {
        SamQFSUtil.doPrint("Debug: addAvailableAllocatableUnits()");
        if (this.available != null && includeDevices != null && includeDevices.length > 0) {
            for (int i = 0; i < includeDevices.length; ++i) {
                Object o;
                if (!SamQFSUtil.isValidString(includeDevices[i]) || (o = this.tempExclusions.get(includeDevices[i])) == null) continue;
                this.available.put(includeDevices[i], o);
                this.tempExclusions.remove(includeDevices[i]);
            }
        }
    }

    public DiskCache[] getAvailableAllocatableUnits() throws SamFSException {
        SamQFSUtil.doPrint("Debug: getAvailableAllocatableUnits()");
        if (this.discoveryNeeded) {
            this.resetAvailableAllocatableUnits(null);
        }
        return this.available.values().toArray(new DiskCache[0]);
    }

    public void resetAvailableAllocatableUnits(String[] haHosts) throws SamFSException {
        SamQFSUtil.doPrint("Debug: resetAvailableAllocatableUnits()");
        this.clearAvailableAllocatableUnits();
        this.discoveryNeeded = false;
        DiskCache[] disks = this.model.getSamQFSSystemFSManager().discoverAvailableAllocatableUnits(haHosts);
        if (disks != null && disks.length > 0) {
            for (int i = 0; i < disks.length; ++i) {
                this.available.put(disks[i].getDevicePath(), disks[i]);
            }
        }
    }

    public void clearAvailableAllocatableUnits() throws SamFSException {
        SamQFSUtil.doPrint("Debug: clearAvailableAllocatableUnits()");
        this.available.clear();
        this.tempExclusions.clear();
        this.discoveryNeeded = true;
    }

    public DiskCache getAvailableDisk(String path) {
        DiskCache disk = (DiskCache)this.tempExclusions.get(path);
        if (disk == null) {
            disk = (DiskCache)this.available.get(path);
        }
        return disk;
    }

    public StripedGroup getStripedGroup(int stepNo) throws SamFSException {
        return (StripedGroup)this.stripedGroupMap.get(new Integer(stepNo));
    }

    public StripedGroup[] getStripedGroupFromAllSteps() throws SamFSException {
        return this.stripedGroupMap.values().toArray(new StripedGroup[0]);
    }

    public void addStripedGroupForStep(int stepNo, StripedGroup group) throws SamFSException {
        this.stripedGroupMap.put(new Integer(stepNo), group);
    }

    public void clearTemporaryStripedGroups() throws SamFSException {
        this.stripedGroupMap.clear();
    }

    public ArchivePolicy getSavedPolicy() throws SamFSException {
        if (this.policy == null) {
            this.policy = this.createEmptyPolicy();
        }
        return this.policy;
    }

    public void setSavedPolicy(ArchivePolicy pol) throws SamFSException {
        this.policy = (ArchivePolicyImpl)((ArchivePolicyImpl)pol).clone();
        ArchiveCopy[] copies = this.policy.getArchiveCopies();
        int remainingCopies = 0;
        remainingCopies = copies == null ? 4 : 4 - copies.length;
        if (remainingCopies != 0) {
            ArchiveCopyImpl[] newCopies = new ArchiveCopyImpl[remainingCopies];
            ArchiveVSNMapImpl[] newMaps = new ArchiveVSNMapImpl[remainingCopies];
            for (int i = 0; i < remainingCopies; ++i) {
                newCopies[i] = new ArchiveCopyImpl();
                newCopies[i].setCopyNumber(copies.length + i + 1);
                newMaps[i] = new ArchiveVSNMapImpl();
                newCopies[i].setArchiveVSNMap(newMaps[i]);
                newMaps[i].setArchiveCopy(newCopies[i]);
                newCopies[i].setArchivePolicy(this.policy);
                ((ArchivePolicyImpl)this.policy).addArchiveCopy(newCopies[i]);
            }
        }
    }

    public void clearSavedPolicy() throws SamFSException {
        this.policy = null;
    }

    public void resetFileSystemsForSavedPolicy() throws SamFSException {
        FileSystem[] filesystems = this.policy.getFileSystemsForPolicy();
        if (filesystems != null) {
            for (int i = 0; i < filesystems.length; ++i) {
                this.policy.deleteFileSystemForPolicy(filesystems[i]);
            }
        }
    }

    private ArchivePolicy createEmptyPolicy() throws SamFSException {
        return this.model.getSamQFSSystemArchiveManager().getDefaultArchivePolicy();
    }

    public boolean isDefaultArchiveCopy(ArchiveCopy copy) throws SamFSException {
        ArchiveCopy dCopy = this.model.getSamQFSSystemArchiveManager().getDefaultArchivePolicy().getArchiveCopy(1);
        boolean defaultCopy = true;
        if (defaultCopy && copy.getArchiveAge() != dCopy.getArchiveAge()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getReservationMethod() != dCopy.getReservationMethod()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getArchiveSortMethod() != dCopy.getArchiveSortMethod()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getOfflineCopyMethod() != dCopy.getOfflineCopyMethod()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getDiskArchiveVSN() != null && !copy.getDiskArchiveVSN().equals(new String())) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getDrives() != dCopy.getDrives()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getMinDrives() != dCopy.getMinDrives()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getMaxDrives() != dCopy.getMaxDrives()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getJoinMethod() != dCopy.getJoinMethod()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getUnarchiveAge() != dCopy.getUnarchiveAge()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getUnarchiveTimeReference() != dCopy.getUnarchiveTimeReference()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getOverflowMinSize() != dCopy.getOverflowMinSize()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getArchiveMaxSize() != dCopy.getArchiveMaxSize()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getBufferSize() != dCopy.getBufferSize()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getStartAge() != dCopy.getStartAge()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getStartCount() != dCopy.getStartCount()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getStartSize() != dCopy.getStartSize()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getRecycleDataSize() != dCopy.getRecycleDataSize()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getRecycleHWM() != dCopy.getRecycleHWM()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getNotificationAddress() != null && !copy.getNotificationAddress().equals(new String())) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getMinGain() != dCopy.getMinGain()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getMaxVSNCount() != dCopy.getMaxVSNCount()) {
            defaultCopy = false;
        }
        if (defaultCopy && copy.getArchiveVSNMap().getArchiveMediaType() != dCopy.getArchiveVSNMap().getArchiveMediaType()) {
            defaultCopy = false;
        }
        return defaultCopy;
    }

    public void doNumberCorrection(ArchiveCopy[] copies) throws SamFSException {
        if (copies != null && copies.length > 4) {
            throw new SamFSException("logic.invalidNoOfCopies");
        }
        if (copies != null) {
            for (int i = 1; i <= copies.length; ++i) {
                int currentMin = this.getMinimumGreaterThanOrEqualTo(i, copies);
                if (currentMin <= i) continue;
                int difference = currentMin - i;
                for (int j = 0; j < copies.length; ++j) {
                    if (copies[j].getCopyNumber() <= i) continue;
                    copies[j].setCopyNumber(copies[j].getCopyNumber() - difference);
                }
            }
        }
    }

    private int getMinimumGreaterThanOrEqualTo(int i, ArchiveCopy[] copies) throws SamFSException {
        int currentMin = 4;
        for (int j = 0; j < copies.length; ++j) {
            if (copies[j].getCopyNumber() < i || copies[j].getCopyNumber() >= currentMin) continue;
            currentMin = copies[j].getCopyNumber();
        }
        return currentMin;
    }
}

