/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.impl.jni;

import java.util.ArrayList;

public class RE {
    public static final String r09 = "[0-9]";

    public static String genRange(char low, char high) {
        StringBuffer range = new StringBuffer(6);
        if (low == high) {
            range.append(low);
        } else {
            range.append("[").append(low).append("-").append(high).append("]");
        }
        return range.toString();
    }

    public static char incDigit(char c) {
        return Character.forDigit(Character.digit(c, 10) + 1, 10);
    }

    public static char decDigit(char c) {
        return Character.forDigit(Character.digit(c, 10) - 1, 10);
    }

    protected static String getPrefix(String startVSN, String endVSN) {
        int maxsz = startVSN.length();
        int i = 0;
        StringBuffer prefix = new StringBuffer(maxsz + 1);
        if (maxsz != endVSN.length()) {
            return null;
        }
        while (startVSN.charAt(i) == endVSN.charAt(i)) {
            prefix.append(startVSN.charAt(i++));
            if (i != maxsz) continue;
            break;
        }
        return prefix.toString();
    }

    public static StringBuffer[] convertToREs(String startVSN, String endVSN) {
        int j;
        StringBuffer re;
        char c;
        int i;
        String prefix = RE.getPrefix(startVSN, endVSN);
        int vsnlen = startVSN.length();
        int preflen = null == prefix ? vsnlen - 1 : prefix.length();
        boolean count = false;
        if (null == prefix) {
            return null;
        }
        if (preflen == vsnlen) {
            StringBuffer[] res1 = new StringBuffer[]{new StringBuffer(startVSN)};
            return res1;
        }
        if (startVSN.substring(preflen).compareTo(endVSN.substring(preflen)) > 0) {
            return null;
        }
        ArrayList<StringBuffer> res = new ArrayList<StringBuffer>(2 * (vsnlen - preflen) - 1);
        for (i = vsnlen - 1; i >= preflen; --i) {
            c = startVSN.charAt(i);
            if (!Character.isDigit(c)) {
                return null;
            }
            re = new StringBuffer(vsnlen + 1);
            re.append(startVSN.substring(0, i));
            if (i == vsnlen - 1) {
                if (i != preflen) {
                    re.append(RE.genRange(c, '9'));
                } else {
                    re.append(RE.genRange(c, endVSN.charAt(i)));
                }
            } else if (i == preflen) {
                char c2 = RE.decDigit(endVSN.charAt(i));
                if (c == c2) continue;
                re.append(RE.genRange(RE.incDigit(c), c2));
            } else {
                if (c == '9') continue;
                re.append(RE.genRange(RE.incDigit(c), '9'));
            }
            for (j = i + 1; j < vsnlen; ++j) {
                re.append(r09);
            }
            res.add(re);
        }
        for (i = preflen + 1; i < vsnlen; ++i) {
            c = endVSN.charAt(i);
            if (!Character.isDigit(c)) {
                return null;
            }
            re = new StringBuffer(vsnlen + 1);
            re.append(endVSN.substring(0, i));
            if (i == vsnlen - 1) {
                re.append(RE.genRange('0', c));
            } else {
                if (c == '0') continue;
                re.append(RE.genRange('0', RE.decDigit(c)));
            }
            for (j = i + 1; j < vsnlen; ++j) {
                re.append(r09);
            }
            res.add(re);
        }
        return res.toArray(new StringBuffer[0]);
    }

    public static String convertToREsString(String startVSN, String endVSN) {
        StringBuffer[] sbufs = RE.convertToREs(startVSN, endVSN);
        if (sbufs == null) {
            return null;
        }
        StringBuffer concat = new StringBuffer();
        for (int i = 0; i < sbufs.length; ++i) {
            concat.append(sbufs[i]);
            if (i == sbufs.length - 1) continue;
            concat.append(' ');
        }
        return concat.toString();
    }

    public static final void main(String[] args) {
        StringBuffer[] res = RE.convertToREs(args[0], args[1]);
        if (null == res) {
            System.out.println("wrong arguments");
            System.exit(-1);
        }
        System.out.println("list of RE-s:");
        for (int i = 0; i < res.length; ++i) {
            System.out.println("\t" + res[i]);
        }
        System.out.println("\nRE-s as a String:\n\t" + RE.convertToREsString(args[0], args[1]));
    }
}

