/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model.admin;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import java.io.Serializable;
import java.util.Properties;

public class Schedule
implements Serializable {
    protected long startTime;
    protected long startTimeMillis;
    protected long repeat;
    protected String preScript;
    protected String postScript;
    protected String logPath;
    protected static final String KEY_FREQ = "frequency";
    protected static final char FREQ_SEPARATOR = 'p';
    protected static final String KEY_PRESCRIPT = "prescript";
    protected static final String KEY_POSTSCRIPT = "postscript";
    protected static final String KEY_LOG = "logfile";

    protected Schedule() {
    }

    public Schedule(long startTime, long repeat, String preScript, String postScript, String logPath) {
        this.startTime = startTime;
        this.startTimeMillis = startTime * 1000L;
        this.repeat = repeat;
        this.preScript = preScript;
        this.postScript = postScript;
        this.logPath = logPath;
    }

    public Schedule(Properties props) throws SamFSException {
        this(Schedule.parseStartTime(props), Schedule.parseRepeatValue(props), props.getProperty(KEY_PRESCRIPT), props.getProperty(KEY_POSTSCRIPT), props.getProperty(KEY_LOG));
    }

    private static long parseStartTime(Properties props) throws SamFSException {
        String freq = props.getProperty(KEY_FREQ);
        if (freq == null) {
            throw new SamFSException("logic.invalidSchedule - null freq");
        }
        int sepIdx = freq.indexOf(Character.toLowerCase('p'));
        if (-1 == sepIdx) {
            sepIdx = freq.indexOf(Character.toUpperCase('p'));
        }
        if (-1 == sepIdx) {
            throw new SamFSException("logic.invalidSchedule(parameter: " + freq + ")");
        }
        return ConversionUtil.strToLongVal(freq.substring(0, sepIdx));
    }

    private static long parseRepeatValue(Properties props) throws SamFSException {
        String freq = props.getProperty(KEY_FREQ);
        if (freq == null) {
            throw new SamFSException("logic.invalidSchedule - null freq");
        }
        int sepIdx = freq.indexOf(Character.toLowerCase('p'));
        if (-1 == sepIdx) {
            sepIdx = freq.indexOf(Character.toUpperCase('p'));
        }
        if (-1 == sepIdx) {
            throw new SamFSException("logic.invalidSchedule(parameter: " + freq + ")");
        }
        return ConversionUtil.strToLongVal(freq.substring(sepIdx + 1, freq.length()));
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getStartTimeInMillis() {
        return this.startTimeMillis;
    }

    public long getRepeatCnt() {
        return this.repeat;
    }

    public String getPrescript() {
        return this.preScript;
    }

    public String getPostscript() {
        return this.postScript;
    }

    public String getLogPath() {
        return this.logPath;
    }

    public String toString() {
        NonSyncStringBuffer s = new NonSyncStringBuffer().append(KEY_FREQ).append("=").append(this.startTime).append('p').append(this.repeat);
        if (this.preScript != null) {
            s.append(",").append(KEY_PRESCRIPT).append("=").append(this.preScript);
        }
        if (this.postScript != null) {
            s.append(",").append(KEY_POSTSCRIPT).append("=").append(this.postScript);
        }
        if (this.logPath != null) {
            s.append(",").append(KEY_LOG).append("=").append(this.logPath);
        }
        return s.toString();
    }
}

