/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import java.util.Properties;

public class SystemInfo {
    final String KEY_HOSTID = "Hostid";
    final String KEY_HOSTNAME = "Hostname";
    final String KEY_OSNAME = "OSname";
    final String KEY_RELEASE = "Release";
    final String KEY_VERSION = "Version";
    final String KEY_MACHINE = "Machine";
    final String KEY_CPUS = "Cpus";
    final String KEY_MEM = "Memory";
    final String KEY_ARCHIT = "Architecture";
    final String KEY_IPADDRS = "IPaddress";
    protected String hostid;
    protected String hostName;
    protected String osName;
    protected String release;
    protected String version;
    protected String machine;
    protected int cpus;
    protected long mem;
    protected String archit;
    protected String ipAddresses;

    public SystemInfo(Properties props) throws SamFSException {
        if (props == null) {
            return;
        }
        this.hostid = props.getProperty("Hostid");
        this.hostName = props.getProperty("Hostname");
        this.osName = props.getProperty("OSname");
        this.release = props.getProperty("Release");
        this.version = props.getProperty("Version");
        this.machine = props.getProperty("Machine");
        this.cpus = ConversionUtil.strToIntVal(props.getProperty("Cpus"));
        this.mem = ConversionUtil.strToLongVal(props.getProperty("Memory"));
        this.archit = props.getProperty("Architecture");
        this.ipAddresses = props.getProperty("IPaddress");
    }

    public SystemInfo(String sysInfoStr) throws SamFSException {
        this(ConversionUtil.strToProps(sysInfoStr));
    }

    public String getHostid() {
        return this.hostid;
    }

    public String getHostname() {
        return this.hostName;
    }

    public String getOSname() {
        return this.osName;
    }

    public String getRelease() {
        return this.release;
    }

    public String getVersion() {
        return this.version;
    }

    public String getMachine() {
        return this.machine;
    }

    public int getCPUs() {
        return this.cpus;
    }

    public long getMemoryMB() {
        return this.mem;
    }

    public String getArchitecture() {
        return this.archit;
    }

    public String getIPAddresses() {
        return this.ipAddresses;
    }

    public String toString() {
        String E = "=";
        String C = ",";
        String s = "Hostid" + E + this.hostid + C + "Hostname" + E + this.hostName + C + "OSname" + E + this.osName + C + "Release" + E + this.release + C + "Version" + E + this.version + C + "Machine" + E + this.machine + C + "Cpus" + E + this.cpus + C + "Memory" + E + this.mem + C + "Architecture" + E + this.archit + C + "IPaddress" + E + this.ipAddresses;
        return s;
    }
}

