/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import java.util.Properties;

public class SystemCapacity {
    final String KEY_NUMOF_MNT_FS = "MountedFS";
    final String KEY_DSKCACHE_TOTAL = "DiskCache";
    final String KEY_DSKCACHE_AVAIL = "AvailableDiskCache";
    final String KEY_NUMOF_LIBS = "LibCount";
    final String KEY_MEDIA_TOTAL = "MediaCapacity";
    final String KEY_MEDIA_AVAIL = "AvailableMediaCapacity";
    final String KEY_NUMOF_SLOTS = "SlotCount";
    protected int mountedFS;
    protected long diskCache;
    protected long availDiskCache;
    protected int libCount;
    protected long mediaCapacity;
    protected long availMedia;
    protected int slotCount;

    public SystemCapacity(Properties props) throws SamFSException {
        if (props == null) {
            return;
        }
        this.mountedFS = ConversionUtil.strToIntVal(props.getProperty("MountedFS"));
        this.diskCache = ConversionUtil.strToLongVal(props.getProperty("DiskCache"));
        this.availDiskCache = ConversionUtil.strToLongVal(props.getProperty("AvailableDiskCache"));
        this.libCount = ConversionUtil.strToIntVal(props.getProperty("LibCount"));
        this.mediaCapacity = ConversionUtil.strToLongVal(props.getProperty("MediaCapacity"));
        this.availMedia = ConversionUtil.strToLongVal(props.getProperty("AvailableMediaCapacity"));
        this.slotCount = ConversionUtil.strToIntVal(props.getProperty("SlotCount"));
    }

    public SystemCapacity(int mountedFS, long diskCache, long availDiskCache, int libCount, long mediaCapacity, long availMedia, int slotCount) {
        this.mountedFS = mountedFS;
        this.diskCache = diskCache;
        this.availDiskCache = availDiskCache;
        this.libCount = libCount;
        this.mediaCapacity = mediaCapacity;
        this.availMedia = availMedia;
        this.slotCount = slotCount;
    }

    public int getNumOfMountedFS() {
        return this.mountedFS;
    }

    public long getDiskCacheKB() {
        return this.diskCache;
    }

    public long getAvailDiskCacheKB() {
        return this.availDiskCache;
    }

    public int getNumOfLibs() {
        return this.libCount;
    }

    public long getMediaKB() {
        return this.mediaCapacity;
    }

    public long getAvailMediaKB() {
        return this.availMedia;
    }

    public int getNumOfSlots() {
        return this.slotCount;
    }

    public String toString() {
        String E = "=";
        String C = ",";
        String s = "MountedFS" + E + this.mountedFS + C + "DiskCache" + E + this.diskCache + C + "AvailableDiskCache" + E + this.availDiskCache + C + "LibCount" + E + this.libCount + C + "MediaCapacity" + E + this.mediaCapacity + C + "AvailableMediaCapacity" + E + this.availMedia + C + "SlotCount" + E + this.slotCount;
        return s;
    }
}

