/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.util.ConversionUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import java.util.Properties;

public class ImportVSNFilter {
    private static final String KEY_ACCESS_DATE = "access_date";
    private static final String KEY_EQ_TYPE = "equ_type";
    private static final String KEY_FILTER_TYPE = "filter_type";
    private static final String KEY_SCRATCH_POOL_ID = "scratch_pool_id";
    private static final String KEY_START_VSN = "start_vsn";
    private static final String KEY_END_VSN = "end_vsn";
    private static final String KEY_VSN_EXPRESSION = "vsn_expression";
    private static final String KEY_LSM = "lsm";
    private static final String KEY_PANEL = "panel";
    private static final String KEY_START_ROW = "start_row";
    private static final String KEY_END_ROW = "end_row";
    private static final String KEY_START_COL = "start_col";
    private static final String KEY_END_COL = "end_col";
    protected String accessDate;
    protected String eqType;
    protected String startVSN;
    protected String endVSN;
    protected String regEx;
    protected int filterType;
    protected int poolID;
    protected int lsm;
    protected int panel;
    protected int startRow;
    protected int endRow;
    protected int startCol;
    protected int endCol;

    public ImportVSNFilter(Properties props) throws SamFSException {
        if (props == null) {
            return;
        }
        this.accessDate = props.getProperty(KEY_ACCESS_DATE);
        this.eqType = props.getProperty(KEY_EQ_TYPE);
        this.startVSN = props.getProperty(KEY_START_VSN);
        this.endVSN = props.getProperty(KEY_END_VSN);
        this.regEx = props.getProperty(KEY_VSN_EXPRESSION);
        this.lsm = ConversionUtil.strToIntVal(props.getProperty(KEY_LSM));
        this.panel = ConversionUtil.strToIntVal(props.getProperty(KEY_PANEL));
        this.filterType = ConversionUtil.strToIntVal(props.getProperty(KEY_FILTER_TYPE));
        this.poolID = ConversionUtil.strToIntVal(props.getProperty(KEY_SCRATCH_POOL_ID));
        this.startRow = ConversionUtil.strToIntVal(props.getProperty(KEY_START_ROW));
        this.endRow = ConversionUtil.strToIntVal(props.getProperty(KEY_END_ROW));
        this.startCol = ConversionUtil.strToIntVal(props.getProperty(KEY_START_COL));
        this.endCol = ConversionUtil.strToIntVal(props.getProperty(KEY_END_COL));
    }

    public ImportVSNFilter(String propStr) throws SamFSException {
        this(ConversionUtil.strToProps(propStr));
    }

    public ImportVSNFilter(int filterType, String accessDate, String eqType, String startVSN, String endVSN, String regEx, int poolID, int lsm, int panel, int startRow, int endRow, int startCol, int endCol) throws SamFSException {
        if (filterType < 0 || filterType > 4) {
            throw new SamFSException(null, -2530);
        }
        if (!this.isAccessDateValid(accessDate)) {
            throw new SamFSException(null, -2531);
        }
        switch (filterType) {
            case 0: {
                if (poolID != -1) break;
                throw new SamFSException("Invalid Pool ID.  Developer's bug found!");
            }
            case 1: {
                if (startVSN == null || startVSN.length() == 0 || endVSN == null || endVSN.length() == 0) {
                    throw new SamFSException(null, -2532);
                }
                startVSN = startVSN.trim();
                endVSN = endVSN.trim();
                if (SamUtil.isValidVSNString(startVSN) && SamUtil.isValidVSNString(endVSN)) break;
                throw new SamFSException(null, -2532);
            }
            case 2: {
                if (regEx == null || regEx.length() == 0) {
                    throw new SamFSException(null, -2533);
                }
                regEx.trim();
                if (SamUtil.isValidString(regEx)) break;
                throw new SamFSException(null, -2533);
            }
            case 3: {
                if (lsm == -1 && panel == -1 && startRow == -1 && endRow == -1 && startCol == -1 && endCol == -1) {
                    throw new SamFSException("Invalid location.  Developer's bug found!");
                }
                if (startRow != -1 && endRow == -1 || endRow != -1 && startRow == -1) {
                    throw new SamFSException("Invalid location.  Developer's bug found!");
                }
                if ((startCol == -1 || endCol != -1) && (endCol == -1 || startCol != -1)) break;
                throw new SamFSException("Invalid location.  Developer's bug found!");
            }
        }
        this.filterType = filterType;
        this.accessDate = accessDate;
        this.eqType = eqType;
        this.startVSN = startVSN;
        this.endVSN = endVSN;
        this.regEx = regEx;
        this.poolID = poolID;
        this.lsm = lsm;
        this.panel = panel;
        this.startRow = startRow;
        this.endRow = endRow;
        this.startCol = startCol;
        this.endCol = endCol;
    }

    public void setEQType(String eqType) {
        this.eqType = eqType;
    }

    private boolean isAccessDateValid(String accessDate) {
        if (accessDate == null || accessDate.length() == 0) {
            return false;
        }
        String[] dateArray = accessDate.split("-");
        if (dateArray.length != 3 && dateArray.length != 6) {
            return false;
        }
        for (int i = 0; i < dateArray.length; ++i) {
            if (i % 3 == 0 && dateArray[i].length() != 4) {
                return false;
            }
            if (i % 3 == 0 || dateArray[i].length() == 2) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        String E = "=";
        String C = ",";
        String s = KEY_FILTER_TYPE + E + this.filterType + C + KEY_ACCESS_DATE + E + this.accessDate + C + KEY_EQ_TYPE + E + this.eqType + C + KEY_SCRATCH_POOL_ID + E + this.poolID + C + KEY_START_VSN + E + this.startVSN + C + KEY_END_VSN + E + this.endVSN + C + KEY_VSN_EXPRESSION + E + this.regEx + C + KEY_LSM + E + this.lsm + C + KEY_PANEL + E + this.panel + C + KEY_START_ROW + E + this.startRow + C + KEY_END_ROW + E + this.endRow + C + KEY_START_COL + E + this.startCol + C + KEY_END_COL + E + this.endCol;
        return s;
    }

    public String getAccessDate() {
        return this.accessDate;
    }

    public String getEQType() {
        return this.eqType;
    }

    public String getStartVSN() {
        return this.startVSN;
    }

    public String getEndVSN() {
        return this.endVSN;
    }

    public String getRegEx() {
        return this.regEx;
    }

    public int getFilterType() {
        return this.filterType;
    }

    public int getPoolID() {
        return this.poolID;
    }

    public int getLSM() {
        return this.lsm;
    }

    public int getPanel() {
        return this.panel;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public int getEndCol() {
        return this.endCol;
    }
}

