/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.model;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.StkNetLibParam;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;

public class Common {
    public static boolean sameLib(Library l1, Library l2) throws SamFSException {
        return l1.getSerialNo().equals(l2.getSerialNo());
    }

    public static Library[] getAllLibrariesFromServers() throws SamFSException {
        Library[] empty = new Library[]{};
        SamQFSAppModel app = SamQFSFactory.getSamQFSAppModel();
        SamQFSSystemModel[] models = app.getAllSamQFSSystemModels();
        if (models == null) {
            return empty;
        }
        ArrayList<Library> libs = new ArrayList<Library>();
        for (int i = 0; i < models.length; ++i) {
            try {
                Library[] crtLibs = models[i].getSamQFSSystemMediaManager().getAllLibraries();
                int gSz = libs.size();
                for (int c = 0; c < crtLibs.length; ++c) {
                    if (116 == crtLibs[c].getEquipType()) continue;
                    boolean found = false;
                    for (int g = 0; g < gSz; ++g) {
                        if (!Common.sameLib(crtLibs[c], (Library)libs.get(g))) continue;
                        found = true;
                    }
                    if (found) continue;
                    libs.add(crtLibs[c]);
                }
                continue;
            }
            catch (SamFSException e) {
                TraceUtil.trace1("Skipped model for which cannot get libraries");
            }
        }
        return libs.toArray(empty);
    }

    public static boolean shareACSLSServer(Library l1, Library l2) throws SamFSException {
        if (l1.getDriverType() != 1002 || l2.getDriverType() != 1002) {
            return false;
        }
        StkNetLibParam l1Param = l1.getStkNetLibParam();
        StkNetLibParam l2Param = l2.getStkNetLibParam();
        if (l1Param == null || l2Param == null) {
            return false;
        }
        return l1Param.getAcsServerName().equals(l2Param.getAcsServerName());
    }

    public static boolean shareACSLSServer(String acsServerName, Library l2) throws SamFSException {
        StkNetLibParam l2Param = l2.getStkNetLibParam();
        if (l2Param == null) {
            return false;
        }
        return acsServerName.equals(l2Param.getAcsServerName());
    }
}

