/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media.wizards;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.StkClntConn;
import com.sun.netstorage.samqfs.mgmt.media.StkNetLibParam;
import com.sun.netstorage.samqfs.web.media.wizards.AddLibraryACSLSParamView;
import com.sun.netstorage.samqfs.web.media.wizards.AddLibraryACSLSSelectLibraryView;
import com.sun.netstorage.samqfs.web.media.wizards.AddLibraryDirectSelectLibraryView;
import com.sun.netstorage.samqfs.web.media.wizards.AddLibraryDirectSelectNameView;
import com.sun.netstorage.samqfs.web.media.wizards.AddLibraryImplData;
import com.sun.netstorage.samqfs.web.media.wizards.AddLibraryNetworkSelectNameView;
import com.sun.netstorage.samqfs.web.media.wizards.AddLibrarySaveView;
import com.sun.netstorage.samqfs.web.media.wizards.AddLibrarySelectDriveView;
import com.sun.netstorage.samqfs.web.media.wizards.AddLibrarySelectTypeView;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import javax.servlet.http.HttpServletRequest;

public class AddLibraryImpl
extends SamWizardImpl {
    public static final String WIZARDPAGEMODELNAME = "AddLibPageModelName";
    public static final String WIZARDPAGEMODELNAME_PREFIX = "WizardModel";
    public static final String WIZARDIMPLNAME = "AddLibraryImpl";
    public static final String WIZARDIMPLNAME_PREFIX = "WizardImpl";
    public static final String WIZARDCLASSNAME = "com.sun.netstorage.samqfs.web.media.wizards.AddLibraryImpl";
    public static final String MY_LIBRARY = "myLibrary";
    public static final String DRIVE_COUNT = "driveCount";
    private static boolean hasMixedMedia = false;
    private Drive[] sortedDrives = null;
    private String attached = null;
    private String saveValue = null;
    private boolean dumpOn = false;
    private String dumpPath = null;
    private boolean wizardInitialized = false;
    public static final String SA_IS45UP = "sessionattr_is45up";
    public static final String SA_ACSLS_SERIAL_NO = "sessionattr_acsls_serial";
    public static final String SA_STK_LIBRARY_ARRAY = "sessionattr_stklib_array";
    public static final String SA_DISCOVERD_STK_LIBRARY_ARRAY = "sessionattr_dis_stklib_array";
    public static final String SA_DISCOVERD_DA_LIBRARY_ARRAY = "sessionattr_dis_dalib_array";
    public static final String SA_STK_LIBRARY_INDEX = "sessionattr_stklib_index";
    public static final String SA_STK_MEDIA_TYPES = "sessionattr_stklib_mediatypes";

    public static WizardInterface create(RequestContext requestContext) {
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        return new AddLibraryImpl(requestContext);
    }

    public AddLibraryImpl(RequestContext requestContext) {
        super(requestContext, WIZARDPAGEMODELNAME);
        this.processInitialRequest(requestContext.getRequest());
        this.initializeWizard();
        this.initializeWizardControl(requestContext);
    }

    private void initializeWizard() {
        TraceUtil.trace3("Entering");
        this.wizardName = WIZARDIMPLNAME;
        this.wizardTitle = "AddLibrary.title";
        this.pageClass = AddLibraryImplData.pageClass;
        this.pageTitle = AddLibraryImplData.pageTitle;
        this.stepHelp = AddLibraryImplData.stepHelp;
        this.stepText = AddLibraryImplData.stepText;
        this.stepInstruction = AddLibraryImplData.stepInstruction;
        this.cancelMsg = AddLibraryImplData.cancelMsg;
        try {
            this.getDumpValue();
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "AddLibraryImpl()", "Failed to get preferences status", this.getServerName());
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", ex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", Integer.toString(ex.getSAMerrno()));
        }
        this.pages = AddLibraryImplData.directPrefOnPages;
        this.setShowResultsPage(true);
        this.initializeWizardPages(this.pages);
        this.wizardModel.setValue("ACSLSPortNumber", Integer.toString(50004));
        TraceUtil.trace3("Exiting");
    }

    private void processInitialRequest(HttpServletRequest request) {
        String serverName = request.getParameter("serverNameParam");
        String samfsServerAPIVersion = request.getParameter("serverVersionParam");
        boolean version45Up = samfsServerAPIVersion != null && SamUtil.isVersionCurrentOrLaterThan(samfsServerAPIVersion, "1.4");
        this.wizardModel.setValue(SA_IS45UP, new Boolean(version45Up));
        if (serverName != null) {
            SamUtil.doPrint(new NonSyncStringBuffer("Wizard Key: serverName is ").append(serverName).toString());
        } else {
            serverName = "";
            SamUtil.doPrint("Wizard Key: serverName is null");
        }
        this.wizardModel.setValue("SERVER_NAME", serverName);
        TraceUtil.trace2(new NonSyncStringBuffer("AddLibraryImpl: serverName is ").append(serverName).append(", version45Up is ").append(version45Up).toString());
    }

    public static CCWizardWindowModel createModel(String cmdChild) {
        return AddLibraryImpl.getWizardWindowModel(WIZARDIMPLNAME, "AddLibrary.title", WIZARDCLASSNAME, cmdChild);
    }

    public boolean cancelStep(WizardEvent wizardEvent) {
        super.cancelStep(wizardEvent);
        SamUtil.doPrint("Start clearing wizard Model ...");
        this.wizardModel.clear();
        SamUtil.doPrint("Done clearing wizard Model ...");
        return true;
    }

    public void closeStep(WizardEvent wizardEvent) {
        SamUtil.doPrint("Start clearing wizard Model ...");
        this.wizardModel.clear();
        SamUtil.doPrint("Done clearing wizard Model ...");
    }

    public String[] getFuturePages(String currentPageId) {
        TraceUtil.trace3(new NonSyncStringBuffer("Entering getFuturePages(): currentPageId is ").append(currentPageId).toString());
        int page = this.pageIdToPage(currentPageId);
        String[] futurePages = null;
        if (this.pages[page] == 0) {
            futurePages = new String[]{};
        } else if (this.pages[page] == 5) {
            futurePages = new String[]{};
        } else if (this.pages[page] == 1) {
            futurePages = new String[]{Integer.toString(2)};
        } else {
            int howMany = this.pages.length - page + 1;
            futurePages = new String[howMany];
            for (int i = 0; i < howMany; ++i) {
                futurePages[i] = Integer.toString(page + i);
            }
        }
        TraceUtil.trace3("Exiting");
        return futurePages;
    }

    public String[] getFutureSteps(String currentPageId) {
        TraceUtil.trace3("Entering getFutureSteps()");
        int page = this.pageIdToPage(currentPageId);
        String[] futureSteps = null;
        if (this.pages[page] == 0) {
            futureSteps = new String[]{};
        } else if (this.pages[page] == 5) {
            futureSteps = new String[]{};
        } else if (this.pages[page] == 1) {
            futureSteps = new String[]{this.stepText[2]};
        } else {
            int howMany = this.pages.length - page - 1;
            futureSteps = new String[howMany];
            for (int i = 0; i < howMany; ++i) {
                int futureStep = page + 1 + i;
                int futurePage = this.pages[futureStep];
                if (futurePage == 6) {
                    String[] mediaTypes = (String[])this.wizardModel.getValue(SA_STK_MEDIA_TYPES);
                    futureSteps[i] = SamUtil.getResourceString(this.stepText[futurePage], new String[]{mediaTypes[this.getStkLibraryIndex(futureStep)]});
                    continue;
                }
                futureSteps[i] = this.stepText[futurePage];
            }
        }
        TraceUtil.trace3("Exiting");
        return futureSteps;
    }

    public Class getPageClass(String pageId) {
        TraceUtil.trace3(new NonSyncStringBuffer().append("Entered with pageID = ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        if (this.wizardInitialized) {
            this.wizardModel.setValue("ERROR", "No");
        }
        if (this.pages[page] == 6) {
            this.wizardModel.setValue(SA_STK_LIBRARY_INDEX, new Integer(this.getStkLibraryIndex(page)));
            TraceUtil.trace2("This is STK Library # " + this.getStkLibraryIndex(page));
        }
        return super.getPageClass(pageId);
    }

    public String getStepText(String pageId) {
        TraceUtil.trace2(new NonSyncStringBuffer("Entered with pageID = ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        String text = null;
        String[] mediaTypes = (String[])this.wizardModel.getValue(SA_STK_MEDIA_TYPES);
        text = this.pages[page] == 6 ? SamUtil.getResourceString(this.stepText[this.pages[page]], new String[]{mediaTypes[this.getStkLibraryIndex(page)]}) : this.stepText[this.pages[page]];
        return text;
    }

    public String getStepTitle(String pageId) {
        TraceUtil.trace2(new NonSyncStringBuffer("Entered with pageID = ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        String title = null;
        String[] mediaTypes = (String[])this.wizardModel.getValue(SA_STK_MEDIA_TYPES);
        title = this.pages[page] == 6 ? SamUtil.getResourceString(this.pageTitle[this.pages[page]], new String[]{mediaTypes[this.getStkLibraryIndex(page)]}) : this.pageTitle[this.pages[page]];
        return title;
    }

    public String getStepInstruction(String pageId) {
        TraceUtil.trace2(new NonSyncStringBuffer("Entered with pageID = ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        String instruction = null;
        instruction = this.pages[page] == 8 ? (this.attached.equals("AddLibrary.type.direct") ? SamUtil.getResourceString("AddLibrary.summary.direct.instruction") : (this.attached.equals("AddLibrary.type.network") ? SamUtil.getResourceString("AddLibrary.summary.network.instruction") : (this.attached.equals("AddLibrary.type.acsls") ? SamUtil.getResourceString("AddLibrary.summary.acsls.instruction") : this.stepInstruction[this.pages[page]]))) : this.stepInstruction[this.pages[page]];
        return instruction;
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering nextStep()");
        super.nextStep(wizardEvent);
        this.wizardInitialized = true;
        String pageId = wizardEvent.getPageId();
        boolean result = true;
        TraceUtil.trace3(new NonSyncStringBuffer().append("nextStep() pageID: ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        switch (this.pages[page]) {
            case 0: {
                result = this.processSelectTypePage(wizardEvent);
                break;
            }
            case 1: {
                result = this.processDirectSelectLibraryPage(wizardEvent);
                break;
            }
            case 2: {
                result = this.processDirectSelectNamePage(wizardEvent);
                break;
            }
            case 3: {
                result = this.processSelectMediaTypePage(wizardEvent, true);
                break;
            }
            case 5: {
                result = this.processACSLSSelectLibraryPage(wizardEvent, true);
                break;
            }
            case 6: {
                result = this.processACSLSParamPage(wizardEvent, true);
                break;
            }
            case 4: {
                result = this.processNetworkSelectNamePage(wizardEvent);
                break;
            }
            case 7: {
                result = this.processSavePage(wizardEvent, true);
            }
        }
        TraceUtil.trace3("Exiting");
        return result;
    }

    public boolean previousStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Calling previousStep");
        super.previousStep(wizardEvent);
        String pageId = wizardEvent.getPageId();
        boolean result = true;
        TraceUtil.trace3(new NonSyncStringBuffer().append("previousStep() pageID: ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        switch (this.pages[page]) {
            case 7: {
                result = this.processSavePage(wizardEvent, false);
                break;
            }
            case 3: {
                result = this.processSelectMediaTypePage(wizardEvent, false);
                break;
            }
            case 5: {
                result = this.processACSLSSelectLibraryPage(wizardEvent, false);
                break;
            }
            case 6: {
                result = this.processACSLSParamPage(wizardEvent, false);
            }
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        if (!super.finishStep(wizardEvent)) {
            return true;
        }
        if (this.attached.equals("AddLibrary.type.direct")) {
            this.addSingleLibrary(true);
        } else if (this.attached.equals("AddLibrary.type.network")) {
            this.addSingleLibrary(false);
        } else if (this.attached.equals("AddLibrary.type.acsls")) {
            this.addACSLSLibrary();
        } else {
            TraceUtil.trace1("Developer's bug found in Impl::finishStep!");
            return false;
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private void addSingleLibrary(boolean isDirectAttached) {
        Library myLibrary = this.getMyLibrary();
        String libName = null;
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            libName = myLibrary.getName();
            if (isDirectAttached) {
                this.updateDriveList();
            }
            SamUtil.doPrint(new NonSyncStringBuffer("GOING to add: ").append(myLibrary.getName()).toString());
            LogUtil.info(this.getClass(), "finishStep", "Start adding Direct-attached Tape Library");
            if (isDirectAttached) {
                LogUtil.info(this.getClass(), "finishStep", "Start adding Direct-attached Tape Library");
                if (this.sortedDrives == null) {
                    sysModel.getSamQFSSystemMediaManager().addLibrary(myLibrary);
                } else {
                    sysModel.getSamQFSSystemMediaManager().addLibrary(myLibrary, this.sortedDrives);
                }
            } else {
                LogUtil.info(this.getClass(), "finishStep", "Start adding Network-attached Tape Library");
                sysModel.getSamQFSSystemMediaManager().addNetworkLibrary(myLibrary, this.sortedDrives);
            }
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1("Failed to add library " + libName);
            LogUtil.info(this.getClass(), "finishStep", "FAILED to add Tape Library " + libName);
            SamUtil.processException((Exception)((Object)samEx), this.getClass(), "finishStep", "Failed to add Tape Library", this.getServerName());
            this.wizardModel.setValue("Detail_code", Integer.toString(samEx.getSAMerrno()));
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "LibrarySummary.error.add");
            this.wizardModel.setValue("WizardResultAlertDetail", samEx.getMessage());
            return;
        }
        LogUtil.info(this.getClass(), "finishStep", "Done adding tape Library");
        this.wizardModel.setValue("Finish_result", "successful");
        this.wizardModel.setValue("WizardResultAlertSummary", "success.summary");
        this.wizardModel.setValue("WizardResultAlertDetail", SamUtil.getResourceString("LibrarySummary.action.add", libName));
    }

    private void addACSLSLibrary() {
        Library[] myStkLibraryArray = (Library[])this.wizardModel.getValue(SA_STK_LIBRARY_ARRAY);
        NonSyncStringBuffer addLibString = new NonSyncStringBuffer();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            for (int i = 0; i < myStkLibraryArray.length; ++i) {
                String libName = myStkLibraryArray[i].getName();
                if (libName == null) continue;
                if (addLibString.length() != 0) {
                    addLibString.append(", ");
                }
                addLibString.append(libName);
            }
            LogUtil.info(this.getClass(), "finishStep", "Start adding ACSLS Library" + addLibString.toString());
            sysModel.getSamQFSSystemMediaManager().addLibraries(myStkLibraryArray);
            LogUtil.info(this.getClass(), "finishStep", "Done adding ACSLS Library" + addLibString.toString());
        }
        catch (SamFSException samEx) {
            TraceUtil.trace1("Failed to add libraries " + addLibString.toString());
            LogUtil.info(this.getClass(), "finishStep", "FAILED to add Tape Libraries " + addLibString.toString());
            SamUtil.processException((Exception)((Object)samEx), this.getClass(), "finishStep", "Failed to add Tape Libraries", this.getServerName());
            this.wizardModel.setValue("Detail_code", Integer.toString(samEx.getSAMerrno()));
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "LibrarySummary.error.add");
            this.wizardModel.setValue("WizardResultAlertDetail", samEx.getMessage());
            return;
        }
        this.wizardModel.setValue("Finish_result", "successful");
        this.wizardModel.setValue("WizardResultAlertSummary", "success.summary");
        this.wizardModel.setValue("WizardResultAlertDetail", SamUtil.getResourceString("LibrarySummary.action.add", addLibString.toString()));
    }

    private void getDumpValue() throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
        if (appModel == null) {
            throw new SamFSException(null, -2501);
        }
        this.dumpOn = appModel.isDumpOn();
        if (this.dumpOn) {
            this.wizardModel.setValue("DUMP", "on");
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            this.wizardModel.setValue("LOCATION", sysModel.getDefaultDumpPath());
        } else {
            this.wizardModel.setValue("DUMP", "off");
        }
        TraceUtil.trace3("Exiting");
    }

    private void populateEQforDrives(int start, int incre) throws SamFSException {
        TraceUtil.trace3("Entering");
        Library myLibrary = this.getMyLibrary();
        this.sortedDrives = myLibrary.getDrives();
        for (int i = 0; i < this.sortedDrives.length; ++i) {
            this.sortedDrives[i].setEquipOrdinal(start);
            start += incre;
        }
        TraceUtil.trace3("Exiting");
    }

    private boolean savePreferenceSettings(boolean isNextStep, WizardEvent wizardEvent) throws SamFSException {
        String errMsg;
        TraceUtil.trace3("Entering");
        SamUtil.doPrint(new NonSyncStringBuffer().append("savePreferenceSettings: isNextStep is ").append(isNextStep).toString());
        AddLibrarySaveView pageView = (AddLibrarySaveView)wizardEvent.getView();
        this.saveValue = (String)pageView.getDisplayFieldValue("Page7RadioButton");
        this.dumpPath = (String)pageView.getDisplayFieldValue("DumpPathTextField");
        if (this.dumpPath != null) {
            this.dumpPath = this.dumpPath.trim();
        }
        if (isNextStep && (errMsg = pageView.getErrorMsg()) != null) {
            this.setErrorMessage(wizardEvent, errMsg);
            return false;
        }
        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
        if (this.saveValue.equals("AddLibrary.page7.radio2")) {
            this.wizardModel.setValue("DUMP", "on");
            this.wizardModel.setValue("LOCATION", this.dumpPath);
            this.wizardModel.setValue("saveValue", new NonSyncStringBuffer().append(SamUtil.getResourceString("AddLibrary.page7.radio2")).append(" ").append(this.dumpPath).toString());
            if (isNextStep) {
                sysModel.setDumpPath(this.dumpPath);
            }
        } else {
            this.wizardModel.setValue("DUMP", "off");
            sysModel.setDumpPath(null);
            this.wizardModel.setValue("saveValue", "AddLibrary.page7.radio1");
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private void setErrorMessage(WizardEvent wizardEvent, String errMsg) {
        wizardEvent.setSeverity(0);
        wizardEvent.setErrorMessage(errMsg);
    }

    private void setWizardModelErrorMessage(String message, int errorCode) {
        this.wizardModel.setValue("ERROR", "Yes");
        this.wizardModel.setValue("ERROR_MSGS", message);
        this.wizardModel.setValue("ERROR_CODE", Integer.toString(errorCode));
    }

    boolean processSelectTypePage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        AddLibrarySelectTypeView pageView = (AddLibrarySelectTypeView)wizardEvent.getView();
        String errMsg = pageView.getErrorMsg();
        if (errMsg != null) {
            this.setErrorMessage(wizardEvent, errMsg);
            return false;
        }
        this.attached = (String)pageView.getDisplayFieldValue("LibraryType");
        if (this.attached.equals("AddLibrary.type.direct")) {
            this.pages = this.dumpOn ? AddLibraryImplData.directPrefOnPages : AddLibraryImplData.directPrefOffPages;
            this.discoverDirectAttachedLibraries();
        } else if (this.isVersion45Up()) {
            if (this.attached.equals("AddLibrary.type.acsls")) {
                this.pages = this.dumpOn ? AddLibraryImplData.acslsPrefOnPages : AddLibraryImplData.acslsPrefOffPages;
                this.discoverSTKLibraries();
            } else {
                this.pages = this.dumpOn ? AddLibraryImplData.networkPrefOnPages : AddLibraryImplData.networkPrefOffPages;
            }
        } else {
            this.pages = this.dumpOn ? AddLibraryImplData.networkPrefOnPages : AddLibraryImplData.networkPrefOffPages;
        }
        this.initializeWizardPages(this.pages);
        this.wizardModel.setValue("attachedValue", this.attached);
        this.wizardModel.setValue("STKHostName", (String)pageView.getDisplayFieldValue("ACSLSHostName"));
        this.sortedDrives = null;
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processDirectSelectLibraryPage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        AddLibraryDirectSelectLibraryView pageView = (AddLibraryDirectSelectLibraryView)wizardEvent.getView();
        String errMsg = pageView.getErrorMsg();
        if (errMsg != null) {
            this.setErrorMessage(wizardEvent, errMsg);
            return false;
        }
        String selectedValue = (String)pageView.getDisplayFieldValue("DropDownMenu");
        String vendor = null;
        String productID = null;
        String name = null;
        String location = null;
        Object eq = null;
        Library myLibrary = null;
        TraceUtil.trace3(new NonSyncStringBuffer().append("NP: selectedValue is ").append(selectedValue).toString());
        try {
            Library[] allLibrary = (Library[])this.wizardModel.getValue(SA_DISCOVERD_DA_LIBRARY_ARRAY);
            int selectedIndex = Integer.parseInt(selectedValue);
            myLibrary = allLibrary[selectedIndex];
            vendor = myLibrary.getVendor();
            productID = myLibrary.getProductID();
            name = myLibrary.getName();
            location = myLibrary.getCatalogLocation();
            name = SamUtil.replaceSpaceWithUnderscore(name);
            myLibrary.setName(name);
            if (myLibrary.doesLibraryContainMixedMedia()) {
                TraceUtil.trace2("LIBRARY CONTAINS MIXED MEDIA!");
                hasMixedMedia = true;
                this.pages = this.dumpOn ? AddLibraryImplData.directMixedMediaPrefOnPages : AddLibraryImplData.directMixedMediaPrefOffPages;
                this.initializeWizardPages(this.pages);
            } else {
                hasMixedMedia = false;
                this.wizardModel.setValue("mediaTypeValue", SamUtil.getMediaTypeString(myLibrary.getMediaType()));
                TraceUtil.trace2("LIBRARY DOES NOT CONTAIN MIXED MEDIA!");
            }
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "processDirectSelectLibraryName()", "Failed to retrieve library information", this.getServerName());
            this.setWizardModelErrorMessage(ex.getMessage(), -2509);
        }
        this.wizardModel.setValue(MY_LIBRARY, myLibrary);
        this.wizardModel.setValue("vendorIDValue", vendor);
        this.wizardModel.setValue("productIDValue", productID);
        this.wizardModel.setValue("nameValue", name);
        this.wizardModel.setValue("catalogValue", location);
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processSelectMediaTypePage(WizardEvent wizardEvent, boolean isNextStep) {
        TraceUtil.trace3("Entering");
        try {
            AddLibrarySelectDriveView pageView = (AddLibrarySelectDriveView)wizardEvent.getView();
            CCActionTable actionTable = (CCActionTable)pageView.getChild("SelectMediaTypeTable");
            actionTable.restoreStateData();
            CCActionTableModel driveModel = (CCActionTableModel)actionTable.getModel();
            Integer[] selectedRows = driveModel.getSelectedRows();
            if (selectedRows.length == 0) {
                if (isNextStep) {
                    this.setErrorMessage(wizardEvent, "AddLibrary.selectdrive.errmsg.chooseone");
                    TraceUtil.trace3("Exiting");
                    return false;
                }
                this.wizardModel.setValue("mediaTypeValue", "");
                TraceUtil.trace3("Exiting");
                return true;
            }
            int row = selectedRows[0];
            driveModel.setRowIndex(row);
            String mType = (String)driveModel.getValue("TypeText");
            Integer driveCount = (Integer)driveModel.getValue("DriveCountText");
            int mediaType = SamUtil.getMediaType(mType);
            this.wizardModel.setValue("mediaTypeValue", SamUtil.getMediaTypeString(mediaType));
            this.wizardModel.setValue(DRIVE_COUNT, driveCount);
            SamUtil.doPrint(new NonSyncStringBuffer("Selected Media Type is ").append(SamUtil.getMediaTypeString(mediaType)).toString());
        }
        catch (ModelControlException mcex) {
            SamUtil.processException((Exception)((Object)mcex), this.getClass(), "processSelectMediaTypePage", "Failed to save media type selections", this.getServerName());
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", mcex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", "8001234");
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processACSLSSelectLibraryPage(WizardEvent wizardEvent, boolean isNextStep) {
        TraceUtil.trace3("Entering");
        try {
            AddLibraryACSLSSelectLibraryView pageView = (AddLibraryACSLSSelectLibraryView)wizardEvent.getView();
            CCActionTable actionTable = (CCActionTable)pageView.getChild("SelectLibraryTable");
            actionTable.restoreStateData();
            CCActionTableModel libModel = (CCActionTableModel)actionTable.getModel();
            Integer[] selectedRows = libModel.getSelectedRows();
            if (selectedRows.length == 0) {
                if (isNextStep) {
                    this.setErrorMessage(wizardEvent, "AddLibrary.acsls.selectlibrary.error.chooseone");
                    TraceUtil.trace3("Exiting");
                    return false;
                }
                this.wizardModel.setValue(SA_ACSLS_SERIAL_NO, "");
                TraceUtil.trace3("Exiting");
                return true;
            }
            int row = selectedRows[0];
            libModel.setRowIndex(row);
            String serialNumber = (String)libModel.getValue("SerialHidden");
            String types = (String)libModel.getValue("TypeHidden");
            this.wizardModel.setValue(SA_ACSLS_SERIAL_NO, serialNumber);
            Library[] discoveredLibrariesFromJNI = (Library[])this.wizardModel.getValue(SA_DISCOVERD_STK_LIBRARY_ARRAY);
            try {
                this.createStkLibrariesArray(discoveredLibrariesFromJNI, serialNumber, types);
            }
            catch (SamFSException samEx) {
                this.setErrorMessage(wizardEvent, "AddLibrary.acsls.selectlibrary.error.savesetting");
                TraceUtil.trace3("Exiting");
                return false;
            }
        }
        catch (ModelControlException mcex) {
            SamUtil.processException((Exception)((Object)mcex), this.getClass(), "processACSLSSelectLibraryPage", "Failed to save ACSLS Library selections", this.getServerName());
            this.wizardModel.setValue("ERROR", "Yes");
            this.wizardModel.setValue("ERROR_MSGS", mcex.getMessage());
            this.wizardModel.setValue("ERROR_CODE", "8001234");
        }
        int numOfLoops = this.getStkLibrariesArraySize();
        if (this.dumpOn) {
            this.pages = new int[5 + numOfLoops];
            this.pages[0] = 0;
            this.pages[1] = 5;
            for (int i = 0; i < numOfLoops; ++i) {
                this.pages[2 + i] = 6;
            }
            this.pages[2 + numOfLoops] = 7;
            this.pages[3 + numOfLoops] = 8;
            this.pages[4 + numOfLoops] = 9;
        } else {
            this.pages = new int[4 + numOfLoops];
            this.pages[0] = 0;
            this.pages[1] = 5;
            for (int i = 0; i < numOfLoops; ++i) {
                this.pages[2 + i] = 6;
            }
            this.pages[2 + numOfLoops] = 8;
            this.pages[3 + numOfLoops] = 9;
        }
        this.initializeWizardPages(this.pages);
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processACSLSParamPage(WizardEvent wizardEvent, boolean isNextStep) {
        AddLibraryACSLSParamView pageView = (AddLibraryACSLSParamView)wizardEvent.getView();
        String errMsg = null;
        if (isNextStep && (errMsg = pageView.getErrorMsg()) != null) {
            this.setErrorMessage(wizardEvent, errMsg);
            return false;
        }
        String libraryName = (String)this.wizardModel.getValue("LibraryNameValue");
        String catalogFile = (String)this.wizardModel.getValue("CatalogValue");
        String eqValue = (String)this.wizardModel.getValue("EQValue");
        String driveStartEQ = (String)this.wizardModel.getValue("StartValue");
        String driveIncreEQ = (String)this.wizardModel.getValue("IncrementValue");
        String accessID = (String)this.wizardModel.getValue("AccessIDValue");
        String SSIHost = (String)this.wizardModel.getValue("SSIHostValue");
        String useSecureRPC = (String)this.wizardModel.getValue("UseSecureRPC");
        String SSIInetPort = (String)this.wizardModel.getValue("SSIInetPortValue");
        String CSIHostPort = (String)this.wizardModel.getValue("CSIHostPortValue");
        String acslsPort = (String)this.wizardModel.getValue("ACSLSPortNumber");
        libraryName = libraryName == null ? "" : libraryName;
        catalogFile = catalogFile == null ? new NonSyncStringBuffer("/var/opt/SUNWsamfs/catalog/").append(libraryName).toString() : catalogFile;
        eqValue = eqValue == null ? "" : eqValue;
        driveStartEQ = driveStartEQ == null ? "" : driveStartEQ;
        driveIncreEQ = driveIncreEQ == null ? "" : driveIncreEQ;
        accessID = accessID == null ? "" : accessID;
        SSIHost = SSIHost == null ? "" : SSIHost;
        useSecureRPC = useSecureRPC == null ? "" : useSecureRPC;
        SSIInetPort = SSIInetPort == null ? "" : SSIInetPort;
        CSIHostPort = CSIHostPort == null ? "" : CSIHostPort;
        Library myLibrary = null;
        try {
            int stkLibraryIndex = (Integer)this.wizardModel.getValue(SA_STK_LIBRARY_INDEX);
            myLibrary = this.getStkLibrary(stkLibraryIndex);
            if (myLibrary == null) {
                throw new SamFSException(null, -2502);
            }
            myLibrary.setName(libraryName);
            if (catalogFile.length() != 0) {
                myLibrary.setCatalogLocation(catalogFile);
            }
            try {
                if (eqValue.length() != 0) {
                    myLibrary.setEquipOrdinal(Integer.parseInt(eqValue));
                }
            }
            catch (NumberFormatException numEx) {
                // empty catch block
            }
            try {
                if (driveStartEQ.length() != 0 && driveIncreEQ.length() != 0) {
                    myLibrary.setDriveStartNumber(Integer.parseInt(driveStartEQ));
                    myLibrary.setDriveIncreNumber(Integer.parseInt(driveIncreEQ));
                    Drive[] myDrives = myLibrary.getDrives();
                    for (int i = 0; i < myDrives.length; ++i) {
                        myDrives[i].setEquipOrdinal(Integer.parseInt(driveStartEQ) + i * Integer.parseInt(driveIncreEQ));
                    }
                }
            }
            catch (NumberFormatException numEx) {
                // empty catch block
            }
            String paramLocation = new NonSyncStringBuffer("/etc/opt/SUNWsamfs/").append(libraryName).toString();
            myLibrary.setDevicePath(paramLocation);
            StkNetLibParam param = myLibrary.getStkNetLibParam();
            if (param == null) {
                param = new StkNetLibParam(paramLocation, SSIHost, Integer.parseInt(acslsPort));
            } else {
                param.setPath(paramLocation);
            }
            if (accessID.length() != 0) {
                param.setAccess(accessID);
            }
            if (SSIHost.length() != 0) {
                param.setSamServerName(SSIHost);
            }
            if (SSIInetPort.length() != 0) {
                param.setSamRecvPort(Integer.parseInt(SSIInetPort));
            } else {
                param.setSamRecvPort(-1);
            }
            if (CSIHostPort.length() != 0) {
                param.setSamSendPort(Integer.parseInt(CSIHostPort));
            } else {
                param.setSamSendPort(-1);
            }
            myLibrary.setStkNetLibParam(param);
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "processACSLSParamame()", "Failed to save ACSLS Parameters to the hashMap", this.getServerName());
            this.setWizardModelErrorMessage(ex.getMessage(), -2509);
            return false;
        }
        this.updateStkLibrariesArray(myLibrary);
        return true;
    }

    boolean processDirectSelectNamePage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        Library myLibrary = this.getMyLibrary();
        AddLibraryDirectSelectNameView pageView = (AddLibraryDirectSelectNameView)wizardEvent.getView();
        String errMsg = pageView.getErrorMsg();
        if (errMsg != null) {
            this.setErrorMessage(wizardEvent, errMsg);
            return false;
        }
        String nameValue = (String)pageView.getDisplayFieldValue("nameValue");
        String catalogValue = (String)pageView.getDisplayFieldValue("catalogValue");
        String eqValue = (String)pageView.getDisplayFieldValue("eqValue");
        String startValue = (String)pageView.getDisplayFieldValue("startValue");
        String incrementValue = (String)pageView.getDisplayFieldValue("incrementValue");
        if (nameValue != null) {
            nameValue = nameValue.trim();
        }
        if (catalogValue != null) {
            catalogValue = catalogValue.trim();
        }
        if (eqValue != null) {
            eqValue = eqValue.trim();
        }
        if (startValue != null) {
            startValue = startValue.trim();
        }
        if (incrementValue != null) {
            incrementValue = incrementValue.trim();
        }
        try {
            if (nameValue.length() != 0) {
                myLibrary.setName(nameValue);
            }
            if (catalogValue.length() != 0) {
                myLibrary.setCatalogLocation(catalogValue);
            }
            if (eqValue.length() != 0) {
                myLibrary.setEquipOrdinal(Integer.parseInt(eqValue));
            }
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "processDirectSelectName()", "Failed to set user input setting to library", this.getServerName());
            this.setWizardModelErrorMessage(ex.getMessage(), -2509);
        }
        catch (NumberFormatException numEx) {
            SamUtil.processException(numEx, this.getClass(), "processDirectSelectName(", "NumberFormatException occurred in Direct Select Name", this.getServerName());
            this.setWizardModelErrorMessage(numEx.getMessage(), -2509);
        }
        this.wizardModel.setValue(MY_LIBRARY, myLibrary);
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processNetworkSelectNamePage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        AddLibraryNetworkSelectNameView pageView = (AddLibraryNetworkSelectNameView)wizardEvent.getView();
        String errMsg = pageView.getErrorMsg();
        if (errMsg != null) {
            this.setErrorMessage(wizardEvent, errMsg);
            return false;
        }
        Library myLibrary = this.getMyLibrary();
        String startValue = (String)pageView.getDisplayFieldValue("startValue");
        String incrementValue = (String)pageView.getDisplayFieldValue("incrementValue");
        try {
            if (startValue.length() != 0 && incrementValue.length() != 0) {
                int start = Integer.parseInt(startValue.trim());
                int incre = Integer.parseInt(incrementValue.trim());
                int myEQ = start;
                this.populateEQforDrives(start, incre);
            } else {
                this.sortedDrives = myLibrary.getDrives();
            }
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "processNetworkSelectDriveEQPage()", "Failed to set drives EQ to the library", this.getServerName());
            this.setWizardModelErrorMessage(ex.getMessage(), -2515);
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processSavePage(WizardEvent wizardEvent, boolean isNextStep) {
        TraceUtil.trace3("Entering");
        boolean result = true;
        try {
            result = this.savePreferenceSettings(isNextStep, wizardEvent);
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), this.getClass(), "processSavePage()", "Failed to process saving information", this.getServerName());
            this.setWizardModelErrorMessage(smfex.getMessage(), smfex.getSAMerrno());
        }
        if (!result) {
            return false;
        }
        if (!this.dumpOn) {
            if (this.attached.equals("AddLibrary.type.direct")) {
                this.wizardModel.setValue("saveValue", "AddLibrary.page7.radio1");
            } else {
                this.wizardModel.setValue("saveValue", "AddLibrary.page7.radio1");
            }
        }
        TraceUtil.trace3("Exiting");
        return result;
    }

    private void updateDriveList() throws SamFSException {
        String startValue = (String)this.wizardModel.getValue("startValue");
        String increValue = (String)this.wizardModel.getValue("incrementValue");
        int start = startValue == null || startValue.length() == 0 ? -1 : Integer.parseInt(startValue.trim());
        int incre = increValue == null || increValue.length() == 0 ? 1 : Integer.parseInt(increValue.trim());
        Library myLibrary = this.getMyLibrary();
        if (hasMixedMedia) {
            Drive[] allDrives = myLibrary.getDrives();
            if (allDrives == null) {
                SamUtil.doPrint("allDrives is NULL");
                throw new SamFSException(null, -2508);
            }
            int driveCount = (Integer)this.wizardModel.getValue(DRIVE_COUNT);
            int mediaType = SamUtil.getMediaType((String)this.wizardModel.getValue("mediaTypeValue"));
            Drive[] myNewDrives = new Drive[driveCount];
            int newDriveIndex = 0;
            int myEQ = start;
            for (int i = 0; i < allDrives.length; ++i) {
                if (allDrives[i].getEquipType() != mediaType) continue;
                myNewDrives[newDriveIndex] = allDrives[i];
                if (myEQ != -1) {
                    myNewDrives[newDriveIndex].setEquipOrdinal(myEQ);
                    myEQ += incre;
                }
                ++newDriveIndex;
            }
            this.sortedDrives = myNewDrives;
        } else if (start != -1) {
            Drive[] allDrives = myLibrary.getDrives();
            int myEQ = start;
            if (allDrives == null) {
                SamUtil.doPrint("allDrives is NULL");
                throw new SamFSException(null, -2508);
            }
            for (int i = 0; i < allDrives.length; ++i) {
                allDrives[i].setEquipOrdinal(myEQ);
                myEQ += incre;
            }
        }
        this.wizardModel.setValue(MY_LIBRARY, myLibrary);
    }

    private String getServerName() {
        return (String)this.wizardModel.getValue("SERVER_NAME");
    }

    private Library getMyLibrary() {
        return (Library)this.wizardModel.getValue(MY_LIBRARY);
    }

    private boolean isVersion45Up() {
        return (Boolean)this.wizardModel.getValue(SA_IS45UP);
    }

    private void createStkLibrariesArray(Library[] discoveredLibraries, String serialNumber, String types) throws SamFSException {
        String[] typeArray = types.split(", ");
        this.wizardModel.setValue(SA_STK_MEDIA_TYPES, typeArray);
        Library[] myStkLibraryArray = (Library[])this.wizardModel.getValue(SA_STK_LIBRARY_ARRAY);
        if (myStkLibraryArray == null) {
            myStkLibraryArray = new Library[typeArray.length];
        }
        int counter = 0;
        for (int i = 0; i < discoveredLibraries.length; ++i) {
            if (!discoveredLibraries[i].getSerialNo().equals(serialNumber)) continue;
            myStkLibraryArray[counter++] = discoveredLibraries[i];
            if (counter > typeArray.length) break;
        }
        this.wizardModel.setValue(SA_STK_LIBRARY_ARRAY, myStkLibraryArray);
    }

    private int getStkLibrariesArraySize() {
        Library[] myStkLibraryArray = (Library[])this.wizardModel.getValue(SA_STK_LIBRARY_ARRAY);
        return myStkLibraryArray.length;
    }

    private Library getStkLibrary(int index) {
        Library[] myStkLibraryArray = (Library[])this.wizardModel.getValue(SA_STK_LIBRARY_ARRAY);
        if (index > this.getStkLibrariesArraySize() - 1) {
            TraceUtil.trace1("Developers Bug found in Impl::getStkLibrary()");
            return null;
        }
        return myStkLibraryArray[index];
    }

    private void updateStkLibrariesArray(Library myNewStkLibrary) {
        int index = (Integer)this.wizardModel.getValue(SA_STK_LIBRARY_INDEX);
        Library[] myStkLibraryArray = (Library[])this.wizardModel.getValue(SA_STK_LIBRARY_ARRAY);
        myStkLibraryArray[index] = myNewStkLibrary;
        this.wizardModel.setValue(SA_STK_LIBRARY_ARRAY, myStkLibraryArray);
    }

    private int getStkLibraryIndex(int page) {
        return page - 2;
    }

    private void discoverDirectAttachedLibraries() {
        Library[] allLibrary = null;
        TraceUtil.trace1("Start discovering direct attached libraries..");
        try {
            allLibrary = SamUtil.getModel(this.getServerName()).getSamQFSSystemMediaManager().discoverLibraries();
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), this.getClass(), "AddLibraryDirectSelectLibraryView", "Failed to populate available libraries", this.getServerName());
            this.setWizardModelErrorMessage(samEx.getMessage(), -2510);
        }
        TraceUtil.trace1("Done discovering direct attached libraries..");
        allLibrary = allLibrary == null ? new Library[]{} : allLibrary;
        this.wizardModel.setValue(SA_DISCOVERD_DA_LIBRARY_ARRAY, allLibrary);
    }

    private void discoverSTKLibraries() {
        Library[] myDiscoveredLibraries = null;
        String acslsHostName = (String)this.wizardModel.getValue("ACSLSHostName");
        String acslsPortNumber = (String)this.wizardModel.getValue("ACSLSPortNumber");
        StkClntConn[] conns = new StkClntConn[]{new StkClntConn(acslsHostName, acslsPortNumber)};
        TraceUtil.trace1("Start discovering STK Libraries ....");
        try {
            myDiscoveredLibraries = SamUtil.getModel(this.getServerName()).getSamQFSSystemMediaManager().discoverSTKLibraries(conns);
        }
        catch (SamFSException samEx) {
            TraceUtil.trace2("Failed to discover STK Libraries.  Reason: " + samEx.getMessage());
            SamUtil.processException((Exception)((Object)samEx), this.getClass(), "AddLibraryDirectSelectLibraryView", "Failed to populate available libraries", this.getServerName());
            this.setWizardModelErrorMessage(samEx.getMessage(), -2510);
        }
        TraceUtil.trace1("Done discovering STK Libraries.");
        myDiscoveredLibraries = myDiscoveredLibraries == null ? new Library[]{} : myDiscoveredLibraries;
        this.wizardModel.setValue(SA_DISCOVERD_STK_LIBRARY_ARRAY, myDiscoveredLibraries);
    }
}

