/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.media.MediaUtil;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.LDSTableModel;
import com.sun.netstorage.samqfs.web.util.LargeDataSet;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;

public final class VSNSummaryModel
extends LDSTableModel {
    public VSNSummaryModel(LargeDataSet data) {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/media/VSNSummaryTable.xml");
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.dataSet = data;
        this.initActionButtons();
        this.initActionMenu();
        this.initHeaders();
        this.initProductName();
        TraceUtil.trace3("Exiting");
    }

    private void initActionButtons() {
        TraceUtil.trace3("Entering");
        this.setActionValue("LabelButton", "vsn.button.label");
        this.setActionValue("SamQFSWizardReserveButton", "vsn.button.reserve");
        this.setActionValue("UnreserveButton", "vsn.button.unreserve");
        this.setActionValue("EditVSNButton", "vsn.button.editvsn");
        TraceUtil.trace3("Exiting");
    }

    private void initActionMenu() {
        TraceUtil.trace3("Entering");
        this.setActionValue("ActionMenu", "VSNSummary.option1");
        TraceUtil.trace3("Exiting");
    }

    private void initHeaders() {
        TraceUtil.trace3("Entering");
        this.setActionValue("SlotColumn", "vsn.heading.slot");
        this.setActionValue("VSNColumn", "vsn.heading.vsn");
        this.setActionValue("BarcodeColumn", "vsn.heading.barcode");
        this.setActionValue("UsageColumn", "vsn.heading.usage");
        this.setActionValue("AccessCountColumn", "vsn.heading.accesscount");
        this.setActionValue("MediaAttributesColumn", "vsn.heading.attr");
        TraceUtil.trace3("Exiting");
    }

    private void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows() throws SamFSException {
        TraceUtil.trace3("Entering");
        super.getModelRows();
        for (int i = 0; i < this.currentDataSet.length; ++i) {
            if (i > 0) {
                this.appendRow();
            }
            VSN vsn = (VSN)this.currentDataSet[i];
            String vsnName = vsn.getVSN();
            String barcode = vsn.getBarcode();
            int slotNumber = vsn.getSlotNumber();
            long capacity = vsn.getCapacity();
            long freeSpace = vsn.getAvailableSpace();
            long spaceConsumed = 0L;
            long accessCount = vsn.getAccessCount();
            boolean isReserved = vsn.isReserved();
            String loaded = null;
            String flagsInfo = null;
            if (capacity != 0L) {
                spaceConsumed = 100L * (capacity - freeSpace) / capacity;
            }
            flagsInfo = MediaUtil.getFlagsInformation(vsn);
            loaded = vsn.getDrive() == null ? "not-loaded" : "loaded";
            this.setValue("SlotText", new Integer(slotNumber));
            this.setValue("VSNText", vsnName);
            this.setValue("BarcodeText", barcode);
            this.setValue("AccessCountText", new Long(accessCount));
            if (spaceConsumed < 0L || spaceConsumed > 100L) {
                this.setValue("usageText", new Long(-1L));
                this.setValue("capacityText", "");
                this.setValue("UsageBarImage", "/samqfsui/images/samqfs_blank.gif");
            } else {
                this.setValue("capacityText", new NonSyncStringBuffer("(").append((Object)new Capacity(capacity, 2)).append(")").toString());
                this.setValue("usageText", new Long(spaceConsumed));
                this.setValue("UsageBarImage", new NonSyncStringBuffer("/samqfsui/images/usagebar/").append(spaceConsumed).append(".gif").toString());
            }
            this.setValue("MediaAttributesLinkText", this.hasPermission() ? flagsInfo : "");
            this.setValue("MediaAttributesText", this.hasPermission() ? "" : flagsInfo);
            String delimitor = "###";
            this.setValue("InformationHiddenField", new NonSyncStringBuffer().append((Object)new Integer(slotNumber)).append(delimitor).append(vsnName).append(delimitor).append(barcode).append(delimitor).append(isReserved).append(delimitor).append(loaded).toString());
            this.setValue("VSNHref", Integer.toString(slotNumber));
            this.setValue("EditHref", Integer.toString(slotNumber));
        }
        TraceUtil.trace3("Exiting");
    }

    private boolean hasPermission() throws SamFSException {
        return SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG);
    }
}

