/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;

public final class VSNSearchResultModel
extends CCActionTableModel {
    public VSNSearchResultModel() {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/media/VSNSearchResultTable.xml");
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.initHeaders();
        this.initProductName();
        TraceUtil.trace3("Exiting");
    }

    private void initHeaders() {
        TraceUtil.trace3("Entering");
        this.setActionValue("VSNColumn", "VSNSearchResult.heading1");
        this.setActionValue("MediaTypeColumn", "VSNSearchResult.heading2");
        this.setActionValue("LibraryNameColumn", "VSNSearchResult.heading3");
        this.setActionValue("CapacityColumn", "VSNSearchResult.heading4");
        this.setActionValue("FreeSpaceColumn", "VSNSearchResult.heading5");
        this.setActionValue("SpaceConsumedColumn", "VSNSearchResult.heading6");
        TraceUtil.trace3("Exiting");
    }

    private void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows(String serverName, String parent, String searchString, String libraryName) throws SamFSException {
        TraceUtil.trace3("Entering");
        this.clear();
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        VSN[] allVSN = null;
        Object myLibrary = null;
        long usage = 0L;
        long capacity = 0L;
        if (libraryName != null && libraryName.equals("Historian")) {
            libraryName = "historian";
        }
        if ((allVSN = sysModel.getSamQFSSystemMediaManager().searchVSNInLibraries(searchString)) == null) {
            return;
        }
        for (int i = 0; i < allVSN.length; ++i) {
            if (!parent.equals("LibrarySummaryViewBean") && !allVSN[i].getLibrary().getName().equals(libraryName)) continue;
            capacity = allVSN[i].getCapacity();
            if (capacity != 0L) {
                usage = 100L * (capacity - allVSN[i].getAvailableSpace()) / capacity;
            }
            if (i > 0) {
                this.appendRow();
            }
            this.setValue("VSNText", allVSN[i].getVSN());
            this.setValue("MediaTypeText", SamUtil.getMediaTypeString(allVSN[i].getLibrary().getEquipType()));
            this.setValue("LibraryNameText", allVSN[i].getLibrary().getName());
            this.setValue("CapacityText", new Long(allVSN[i].getCapacity()));
            this.setValue("FreeSpaceText", new Long(allVSN[i].getAvailableSpace()));
            this.setValue("SpaceConsumedText", new Long(usage));
            this.setValue("VSNHidden", allVSN[i].getVSN());
            SamUtil.doPrint(new NonSyncStringBuffer("Slot Number: ").append(allVSN[i].getSlotNumber()).toString());
            SamUtil.doPrint(new NonSyncStringBuffer("Library Name: ").append(allVSN[i].getLibrary().getName()).toString());
            this.setValue("VSNHref", new NonSyncStringBuffer(Integer.toString(allVSN[i].getSlotNumber())).append(",").append(allVSN[i].getLibrary().getName()).toString());
        }
        TraceUtil.trace3("Exiting");
    }
}

