/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;

public final class StandAloneSummaryModel
extends CCActionTableModel {
    public StandAloneSummaryModel() {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/media/StandAloneSummaryTable.xml");
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.initActionButtons();
        this.initActionMenu();
        this.initHeaders();
        this.initProductName();
        TraceUtil.trace3("Exiting");
    }

    private void initActionButtons() {
        TraceUtil.trace3("Entering");
        this.setActionValue("SamQFSWizardAddButton", "StandAloneSummary.button.add");
        this.setActionValue("ChangeStateButton", "StandAloneSummary.button.changestate");
        TraceUtil.trace3("Exiting");
    }

    private void initActionMenu() {
        TraceUtil.trace3("Entering");
        this.setActionValue("ActionMenu", "StandAloneSummary.option0");
        TraceUtil.trace3("Exiting");
    }

    private void initHeaders() {
        TraceUtil.trace3("Entering");
        this.setActionValue("VSNColumn", "DriveSummary.heading.vsn");
        this.setActionValue("EQColumn", "DriveSummary.heading.eq");
        this.setActionValue("VendorColumn", "DriveSummary.heading.vendor");
        this.setActionValue("ProductIDColumn", "DriveSummary.heading.productID");
        this.setActionValue("usageColumn", "DriveSummary.heading.usage");
        this.setActionValue("StateColumn", "DriveSummary.heading.state");
        TraceUtil.trace3("Exiting");
    }

    private void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows(String serverName) throws SamFSException {
        TraceUtil.trace3("Entering");
        this.clear();
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        Drive[] allDrives = sysModel.getSamQFSSystemMediaManager().getAllStandAloneDrives();
        if (allDrives == null) {
            return;
        }
        String name = null;
        String vendor = null;
        String productID = null;
        String emptyVSN = null;
        int eq = 0;
        int status = -1;
        long capacity = 0L;
        long freeSpace = 0L;
        long consumed = 0L;
        VSN testVSN = null;
        boolean unlabeledVSN = false;
        for (int i = 0; i < allDrives.length; ++i) {
            String vsnName = allDrives[i].getVSNName();
            testVSN = allDrives[i].getVSN();
            eq = allDrives[i].getEquipOrdinal();
            if (testVSN != null) {
                name = testVSN.getVSN();
                if (name == null || name.length() == 0) {
                    if (allDrives[i].unLabeled()) {
                        unlabeledVSN = true;
                        emptyVSN = "StandAloneSummary.unlabelled";
                    } else {
                        emptyVSN = "";
                    }
                    name = "";
                }
                capacity = testVSN.getCapacity();
                freeSpace = testVSN.getAvailableSpace();
                if (capacity != 0L) {
                    consumed = 100L * (capacity - freeSpace) / capacity;
                }
            } else {
                VSN realVSN = sysModel.getSamQFSSystemMediaManager().searchVSNInStandAloneDrive(vsnName, eq);
                if (realVSN != null) {
                    name = realVSN.getVSN();
                    if (name == null || name.length() == 0) {
                        if (allDrives[i].unLabeled()) {
                            unlabeledVSN = true;
                            emptyVSN = "StandAloneSummary.unlabelled";
                        } else {
                            emptyVSN = "";
                        }
                        name = "";
                    }
                    capacity = realVSN.getCapacity();
                    freeSpace = realVSN.getAvailableSpace();
                    if (capacity != 0L) {
                        consumed = 100L * (capacity - freeSpace) / capacity;
                    }
                } else {
                    name = "";
                    if (allDrives[i].unLabeled()) {
                        unlabeledVSN = true;
                        emptyVSN = "StandAloneSummary.unlabelled";
                    } else {
                        consumed = -1L;
                    }
                }
            }
            vendor = allDrives[i].getVendor();
            productID = allDrives[i].getProductID();
            status = allDrives[i].getStatus();
            if (i > 0) {
                this.appendRow();
            }
            this.setValue("VSNText", name);
            this.setValue("EmptyVSN", emptyVSN);
            this.setValue("EQText", new Integer(eq));
            this.setValue("VendorText", vendor);
            this.setValue("ProductIDText", productID);
            if (!unlabeledVSN) {
                this.setValue("VSNHidden", name);
            } else {
                this.setValue("VSNHidden", emptyVSN);
            }
            if (consumed < 0L || consumed > 100L) {
                this.setValue("usageText", new Long(-1L));
                this.setValue("capacityText", "");
                this.setValue("UsageBarImage", "/samqfsui/images/samqfs_blank.gif");
            } else {
                this.setValue("capacityText", new NonSyncStringBuffer("(").append((Object)new Capacity(capacity, 2)).append(")").toString());
                this.setValue("usageText", new Long(consumed));
                this.setValue("UsageBarImage", new NonSyncStringBuffer("/samqfsui/images/usagebar/").append(consumed).append(".gif").toString());
            }
            this.setValue("StateText", SamUtil.getStateString(status));
            this.setValue("EQHidden", new Integer(eq));
            this.setValue("StateHidden", new Integer(status));
            this.setValue("EQHref", new Integer(eq));
            String key = new NonSyncStringBuffer(name).append(",").append(eq).toString();
            this.setValue("VSNHref", key);
        }
        TraceUtil.trace3("Exiting");
    }
}

