/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.view.alarm.CCAlarmObject;
import com.sun.web.ui.view.alert.CCAlertInline;

public class MediaUtil {
    public static Library getLibraryObject(String serverName, String libName) throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(libName);
        if (myLibrary == null) {
            TraceUtil.trace1("MediaUtil.getLibraryObject returns null!");
            TraceUtil.trace1("MediaUtil: serverName is " + serverName + " libName is " + libName);
            throw new SamFSException(null, -2502);
        }
        return myLibrary;
    }

    public static void setLabelTapeInfoAlert(ContainerView view, String varName, String errMsg, String errorMsg) {
        TraceUtil.trace3("Entering");
        CCAlertInline alert = (CCAlertInline)view.getChild(varName);
        boolean errorAlertPresent = false;
        String detailMsg = "";
        String alertValue = (String)alert.getValue();
        detailMsg = alert.getDetail();
        if (alertValue != null && alertValue.equals("error") && detailMsg != null) {
            TraceUtil.trace3("FOUND AN ERROR ALERT");
            errorAlertPresent = true;
            alert.setValue((Object)"warning");
            alert.setSummary("success.summary");
        }
        if (!errorAlertPresent) {
            alert.setValue((Object)"info");
            alert.setSummary(errMsg);
            alert.setDetail(errorMsg);
        } else {
            alert.setDetail(errorMsg.concat("<br>").concat(detailMsg));
        }
        TraceUtil.trace3("Exiting");
    }

    public static int getTotalNumberOfFlags(VSN vsn) throws SamFSException {
        int totalFlags = 0;
        if (vsn.isMediaDamaged()) {
            ++totalFlags;
        }
        if (vsn.isDuplicateVSN()) {
            ++totalFlags;
        }
        if (vsn.isReadOnly()) {
            ++totalFlags;
        }
        if (vsn.isWriteProtected()) {
            ++totalFlags;
        }
        if (vsn.isForeignMedia()) {
            ++totalFlags;
        }
        if (vsn.isRecycled()) {
            ++totalFlags;
        }
        if (vsn.isVolumeFull()) {
            ++totalFlags;
        }
        if (vsn.isUnavailable()) {
            ++totalFlags;
        }
        if (vsn.isNeedAudit()) {
            ++totalFlags;
        }
        return totalFlags;
    }

    public static String getFlagsInformation(VSN vsn) throws SamFSException {
        NonSyncStringBuffer buffer = new NonSyncStringBuffer();
        String dotDotDot = "...";
        if (vsn.isMediaDamaged()) {
            buffer.append(SamUtil.getResourceString("EditVSN.damagemedia"));
        }
        if (vsn.isNeedAudit()) {
            if (buffer.length() != 0) {
                return buffer.append(dotDotDot).toString();
            }
            buffer.append(SamUtil.getResourceString("EditVSN.needaudit"));
        }
        if (vsn.isUnavailable()) {
            if (buffer.length() != 0) {
                return buffer.append(dotDotDot).toString();
            }
            buffer.append(SamUtil.getResourceString("EditVSN.unavailable"));
        }
        if (vsn.isDuplicateVSN()) {
            if (buffer.length() != 0) {
                return buffer.append(dotDotDot).toString();
            }
            buffer.append(SamUtil.getResourceString("EditVSN.duplicatevsn"));
        }
        if (vsn.isVolumeFull()) {
            if (buffer.length() != 0) {
                return buffer.append(dotDotDot).toString();
            }
            buffer.append(SamUtil.getResourceString("EditVSN.volumefull"));
        }
        if (vsn.isRecycled()) {
            if (buffer.length() != 0) {
                return buffer.append(dotDotDot).toString();
            }
            buffer.append(SamUtil.getResourceString("EditVSN.recycle"));
        }
        if (vsn.isReadOnly()) {
            if (buffer.length() != 0) {
                return buffer.append(dotDotDot).toString();
            }
            buffer.append(SamUtil.getResourceString("EditVSN.readonly"));
        }
        if (vsn.isWriteProtected()) {
            if (buffer.length() != 0) {
                return buffer.append(dotDotDot).toString();
            }
            buffer.append(SamUtil.getResourceString("EditVSN.writeprotected"));
        }
        if (vsn.isForeignMedia()) {
            if (buffer.length() != 0) {
                return buffer.append(dotDotDot).toString();
            }
            buffer.append(SamUtil.getResourceString("EditVSN.foreignmedia"));
        }
        return buffer.toString();
    }

    public static String createLibraryEntry(Library myLibrary) throws SamFSException {
        NonSyncStringBuffer myBuf = new NonSyncStringBuffer();
        String driveWord = SamUtil.getResourceString("ServerConfiguration.media.word.drive");
        String availableSlotWord = SamUtil.getResourceString("ServerConfiguration.media.word.slot");
        String prodID = myLibrary.getProductID();
        String vendor = myLibrary.getVendor();
        int type = myLibrary.getDriverType();
        int slots = myLibrary.getNoOfCatalogEntries();
        Drive[] allDrives = myLibrary.getDrives();
        if (prodID.equals("")) {
            myBuf.append("<b>").append(myLibrary.getName()).append("</b><br />");
        } else {
            myBuf.append("<b>").append(vendor).append(" ").append(prodID).append("</b><br />");
        }
        if (allDrives != null) {
            if (allDrives.length == 0) {
                myBuf.append(SamUtil.getResourceString("ServerConfiguration.media.noDrive"));
            } else {
                myBuf.append(allDrives.length).append(" ").append(allDrives[0].getVendor()).append(" ").append(allDrives[0].getProductID()).append(" ").append(driveWord).append("<br>").append(slots).append(" ").append(availableSlotWord);
            }
        } else {
            myBuf.append(SamUtil.getResourceString("ServerConfiguration.media.noDrive"));
        }
        return myBuf.toString();
    }

    public static CCAlarmObject getAlarm(int alarmType) {
        Object alarm = null;
        switch (alarmType) {
            case 1: {
                return new CCAlarmObject(2);
            }
            case 2: {
                return new CCAlarmObject(3);
            }
            case 3: {
                return new CCAlarmObject(4);
            }
        }
        return new CCAlarmObject(5);
    }

    public static boolean isDriveSharedCapable(String serverName, String libName) throws SamFSException {
        String samfsServerAPIVersion = SamUtil.getServerInfo(serverName).getSamfsServerAPIVersion();
        int driverType = MediaUtil.getLibraryObject(serverName, libName).getDriverType();
        return SamUtil.isVersionCurrentOrLaterThan(samfsServerAPIVersion, "1.4") && driverType == 1002;
    }
}

