/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.media.MediaUtil;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.alarm.Alarm;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.alarm.CCAlarmObject;

public final class LibrarySummaryModel
extends CCActionTableModel {
    public LibrarySummaryModel() {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/media/LibrarySummaryTable.xml");
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.initActionButtons();
        this.initActionMenu();
        this.initHeaders();
        this.initProductName();
        TraceUtil.trace3("Exiting");
    }

    private void initActionButtons() {
        TraceUtil.trace3("Entering");
        this.setActionValue("SamQFSWizardAddButton", "LibrarySummary.button1");
        this.setActionValue("ViewVSNButton", "LibrarySummary.button2");
        this.setActionValue("ViewDriveButton", "LibrarySummary.button3");
        this.setActionValue("ImportButton", "LibrarySummary.button4");
        TraceUtil.trace3("Exiting");
    }

    private void initActionMenu() {
        TraceUtil.trace3("Entering");
        this.setActionValue("ActionMenu", "LibrarySummary.option.changestate");
        TraceUtil.trace3("Exiting");
    }

    private void initHeaders() {
        TraceUtil.trace3("Entering");
        this.setActionValue("NameColumn", "LibrarySummary.heading.name");
        this.setActionValue("FaultColumn", "LibrarySummary.heading.fault");
        this.setActionValue("EQColumn", "LibrarySummary.heading.eq");
        this.setActionValue("VendorColumn", "LibrarySummary.heading.vendor");
        this.setActionValue("ProductIDColumn", "LibrarySummary.heading.productID");
        this.setActionValue("DriverColumn", "LibrarySummary.heading.driver");
        this.setActionValue("UsageColumn", "LibrarySummary.heading.usage");
        this.setActionValue("StateColumn", "LibrarySummary.heading.state");
        TraceUtil.trace3("Exiting");
    }

    private void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows(String serverName) throws SamFSException {
        TraceUtil.trace3("Entering");
        this.clear();
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        CCAlarmObject alarm = null;
        String name = null;
        String vendor = null;
        String productID = null;
        String driver = null;
        Object alarmType = null;
        int eq = 0;
        boolean license_slot = false;
        boolean alarms = false;
        int status = -1;
        Alarm[] allAlarms = null;
        long spaceConsumed = -1L;
        long capacity = 0L;
        Library[] allLibrary = sysModel.getSamQFSSystemMediaManager().getAllLibraries();
        if (allLibrary == null) {
            return;
        }
        for (int i = 0; i < allLibrary.length; ++i) {
            if (i > 0) {
                this.appendRow();
            }
            name = allLibrary[i].getName();
            eq = allLibrary[i].getEquipOrdinal();
            vendor = allLibrary[i].getVendor();
            productID = allLibrary[i].getProductID();
            driver = SamUtil.getLibraryDriverString(allLibrary[i].getDriverType());
            status = allLibrary[i].getStatus();
            allAlarms = allLibrary[i].getAssociatedAlarms();
            int[] alarmInfo = SamUtil.getAlarmInfo(allAlarms);
            alarm = MediaUtil.getAlarm(alarmInfo[0]);
            if (name.equals("Historian") || name.equals("historian")) {
                name = SamUtil.getResourceString("LibrarySummary.string.Historian");
                driver = SamUtil.getResourceString("LibrarySummary.driver.Historian");
                spaceConsumed = -1L;
            } else {
                spaceConsumed = status != 0 ? -1L : ((capacity = allLibrary[i].getTotalCapacity()) != 0L ? 100L * (capacity - allLibrary[i].getTotalFreeSpace()) / capacity : -1L);
            }
            this.setValue("NameText", name);
            this.setValue("EQText", new Integer(eq));
            this.setValue("VendorText", vendor);
            this.setValue("ProductIDText", productID);
            this.setValue("DriverText", driver);
            this.setValue("StateText", SamUtil.getStateString(status));
            this.setValue("NameHidden", name);
            this.setValue("DriverHidden", driver);
            this.setValue("StateHidden", new Integer(status));
            if (name.equals(SamUtil.getResourceString("LibrarySummary.string.Historian"))) {
                this.setValue("Alarm", new CCAlarmObject(5));
            } else {
                this.setValue("Alarm", alarm);
            }
            if (spaceConsumed < 0L || spaceConsumed > 100L) {
                this.setValue("usageText", new Long(-1L));
                this.setValue("capacityText", "");
                this.setValue("UsageBarImage", "/samqfsui/images/samqfs_blank.gif");
            } else {
                this.setValue("capacityText", new NonSyncStringBuffer("(").append((Object)new Capacity(capacity, 2)).append(")").toString());
                this.setValue("usageText", new Long(spaceConsumed));
                this.setValue("UsageBarImage", new NonSyncStringBuffer("/samqfsui/images/usagebar/").append(spaceConsumed).append(".gif").toString());
            }
            this.setValue("DetailHref", name);
            this.setValue("AlarmHref", name);
        }
        TraceUtil.trace3("Exiting");
    }
}

