/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.media.StkDevice;
import com.sun.netstorage.samqfs.mgmt.media.StkNetLibParam;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;

public final class LibraryDriveSummaryModel
extends CCActionTableModel {
    private boolean sharedCapable = false;

    public LibraryDriveSummaryModel(boolean sharedCapable) {
        super(RequestManager.getRequestContext().getServletContext(), sharedCapable ? "/jsp/media/LibrarySharedDriveSummaryTable.xml" : "/jsp/media/LibraryDriveSummaryTable.xml");
        this.sharedCapable = sharedCapable;
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.initActionButtons();
        this.initHeaders();
        this.initProductName();
        TraceUtil.trace3("Exiting");
    }

    private void initActionButtons() {
        TraceUtil.trace3("Entering");
        this.setActionValue("ChangeStateButton", "LibraryDriveSummary.button.changestate");
        this.setActionValue("IdleButton", "LibraryDriveSummary.button.idle");
        this.setActionValue("UnloadButton", "LibraryDriveSummary.button.unload");
        this.setActionValue("CleanButton", "LibraryDriveSummary.button.clean");
        if (this.sharedCapable) {
            this.setActionValue("ActionMenu", "LibraryDriveSummary.option.share");
        }
        TraceUtil.trace3("Exiting");
    }

    private void initHeaders() {
        TraceUtil.trace3("Entering");
        this.setActionValue("VSNColumn", "DriveSummary.heading.vsn");
        this.setActionValue("EQColumn", "DriveSummary.heading.eq");
        this.setActionValue("VendorColumn", "DriveSummary.heading.vendor");
        this.setActionValue("ProductIDColumn", "DriveSummary.heading.productID");
        this.setActionValue("usageColumn", "DriveSummary.heading.usage");
        this.setActionValue("StateColumn", "DriveSummary.heading.state");
        if (this.sharedCapable) {
            this.setActionValue("SharedColumn", "DriveSummary.heading.shared");
        }
        TraceUtil.trace3("Exiting");
    }

    private void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows(String serverName, String libraryName) throws SamFSException {
        TraceUtil.trace3("Entering");
        this.clear();
        if (libraryName == null) {
            throw new SamFSException(null, -2502);
        }
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        Drive[] allDrives = null;
        VSN testVSN = null;
        String name = null;
        String vendor = null;
        String productID = null;
        int eq = 0;
        int status = -1;
        int slotNumber = -1;
        long capacity = 0L;
        long freeSpace = 0L;
        long spaceConsumed = 0L;
        Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(libraryName);
        if (myLibrary == null) {
            throw new SamFSException(null, -2502);
        }
        allDrives = myLibrary.getDrives();
        if (allDrives == null) {
            return;
        }
        for (int i = 0; i < allDrives.length; ++i) {
            testVSN = allDrives[i].getVSN();
            if (testVSN != null) {
                name = testVSN.getVSN();
                capacity = testVSN.getCapacity();
                freeSpace = testVSN.getAvailableSpace();
                slotNumber = testVSN.getSlotNumber();
                if (capacity != 0L) {
                    spaceConsumed = 100L * (capacity - freeSpace) / capacity;
                }
            } else {
                name = "";
                spaceConsumed = -1L;
            }
            eq = allDrives[i].getEquipOrdinal();
            vendor = allDrives[i].getVendor();
            productID = allDrives[i].getProductID();
            status = allDrives[i].getStatus();
            if (i > 0) {
                this.appendRow();
            }
            this.setValue("VSNText", name);
            this.setValue("EQText", new Integer(eq));
            this.setValue("VendorText", vendor);
            this.setValue("ProductIDText", productID);
            if (spaceConsumed < 0L || spaceConsumed > 100L) {
                this.setValue("usageText", new Long(-1L));
                this.setValue("capacityText", "");
                this.setValue("UsageBarImage", "/samqfsui/images/samqfs_blank.gif");
            } else {
                this.setValue("capacityText", new NonSyncStringBuffer("(").append((Object)new Capacity(capacity, 2)).append(")").toString());
                this.setValue("usageText", new Long(spaceConsumed));
                this.setValue("UsageBarImage", new NonSyncStringBuffer("/samqfsui/images/usagebar/").append(spaceConsumed).append(".gif").toString());
            }
            this.setValue("StateText", SamUtil.getStateString(status));
            this.setValue("VSNHidden", name);
            this.setValue("EQHidden", new Integer(eq));
            this.setValue("StateHidden", new Integer(status));
            this.setValue("EQHref", new Integer(eq));
            this.setValue("VSNHref", new Integer(slotNumber));
            if (!this.sharedCapable) continue;
            boolean shared = this.isDriveShared(myLibrary, allDrives[i].getDevicePath());
            this.setValue("SharedText", shared ? "samqfsui.yes" : "samqfsui.no");
            this.setValue("SharedHidden", Boolean.toString(shared));
        }
        TraceUtil.trace3("Exiting");
    }

    private boolean isDriveShared(Library myLibrary, String drivePath) throws SamFSException {
        StkNetLibParam param = myLibrary.getStkNetLibParam();
        StkDevice[] devices = param.getStkDevice();
        for (int i = 0; i < devices.length; ++i) {
            if (!devices[i].getPathName().equals(drivePath)) continue;
            return devices[i].isShared();
        }
        throw new SamFSException(null, -2516);
    }
}

