/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.media.MediaUtil;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.html.CCTextField;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;

public class LabelTapeViewBean
extends CommonSecondaryViewBeanBase {
    private static final String PAGE_NAME = "LabelTape";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/media/LabelTape.jsp";
    private static final String CHILD_HIDDEN_MESSAGES = "HiddenMessages";
    private CCPageTitleModel pageTitleModel = null;
    private static CCPropertySheetModel propertySheetModel = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public LabelTapeViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.pageTitleModel = this.createPageTitleModel();
        propertySheetModel = this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, propertySheetModel);
        this.registerChild(CHILD_HIDDEN_MESSAGES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = LabelTapeViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3(new NonSyncStringBuffer("Entering: name is ").append(name).toString());
        View child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (name.equals(CHILD_HIDDEN_MESSAGES)) {
            child = new CCHiddenField((ContainerView)this, name, (Object)new NonSyncStringBuffer(SamUtil.getResourceString("LabelTape.errMsg1")).append("###").append(SamUtil.getResourceString("LabelTape.errMsg2")).append("###").append(SamUtil.getResourceString("LabelTape.renderMsg")).toString());
        } else if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        } else if (PropertySheetUtil.isChildSupported(propertySheetModel, name)) {
            child = PropertySheetUtil.createChild((ContainerView)this, propertySheetModel, name);
        } else {
            throw new IllegalArgumentException(new NonSyncStringBuffer("Invalid child name [").append(name).append("]").toString());
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        super.beginDisplay(event);
        this.loadPropertySheetModel(propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    private void disablePageButtons() {
        TraceUtil.trace3("Entering");
        ((CCButton)this.getChild("SubmitJobPageButton")).setDisabled(true);
        ((CCButton)this.getChild("ResetPageButton")).setDisabled(true);
        TraceUtil.trace3("Exiting");
    }

    private void disableInputFields() {
        TraceUtil.trace3("Entering");
        ((CCRadioButton)this.getChild("typeValue")).setDisabled(true);
        ((CCTextField)this.getChild("nameValue")).setDisabled(true);
        ((CCDropDownMenu)this.getChild("sizeValue")).setDisabled(true);
        TraceUtil.trace3("Exiting");
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/media/LabelTapePageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (propertySheetModel == null) {
            propertySheetModel = PropertySheetUtil.createModel("/jsp/media/LabelTapePropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
        return propertySheetModel;
    }

    private void loadPropertySheetModel(CCPropertySheetModel propertySheetModel) {
        TraceUtil.trace3("Entering");
        propertySheetModel.clear();
        propertySheetModel.setValue("typeValue", (Object)"LabelTape.type2");
        try {
            VSN myVSN = this.getThisVSN();
            String barcode = myVSN.getBarcode();
            if (barcode == null) {
                ((CCTextField)this.getChild("nameValue")).setValue((Object)"LabelTape.insertnewvalue");
            } else {
                ((CCTextField)this.getChild("nameValue")).setValue((Object)barcode);
            }
            long blockSize = myVSN.getBlockSize();
            propertySheetModel.setValue("sizeValue", (Object)new Long(blockSize));
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "loadPropertySheetModel", "Failed to retrieve VSN information", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "LabelTape.error.loadpsheet", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
            this.disablePageButtons();
            this.disableInputFields();
        }
        TraceUtil.trace3("Exiting");
    }

    public void handleSubmitRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        String labelType = (String)this.getDisplayFieldValue("typeValue");
        String labelName = (String)this.getDisplayFieldValue("nameValue");
        long blockSize = Long.parseLong((String)this.getDisplayFieldValue("sizeValue"));
        try {
            VSN myVSN = this.getThisVSN();
            if (labelType.equals("LabelTape.type1")) {
                LogUtil.info(((Object)((Object)this)).getClass(), "handleLabelTapeHrefRequest", new NonSyncStringBuffer("Start labeling tape to ").append(labelName).toString());
                long jobID = myVSN.label(0, labelName, blockSize);
                LogUtil.info(((Object)((Object)this)).getClass(), "handleLabelTapeHrefRequest", new NonSyncStringBuffer("Done labeling tape to ").append(labelName).append(" with Job ID ").append(Long.toString(jobID)).toString());
                this.setLabelTapeSuccessAlert("success.summary", true, labelName, jobID);
            } else if (labelType.equals("LabelTape.type2")) {
                LogUtil.info(((Object)((Object)this)).getClass(), "handleLabelTapeHrefRequest", new NonSyncStringBuffer("Start re-labeling tape to ").append(labelName).toString());
                long jobID = myVSN.label(1, labelName, blockSize);
                LogUtil.info(((Object)((Object)this)).getClass(), "handleLabelTapeHrefRequest", new NonSyncStringBuffer("Done re-labeling tape to ").append(labelName).toString());
                this.setLabelTapeSuccessAlert("success.summary", false, labelName, jobID);
            }
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "handleLabelTapeHrefRequest", "Failed to label/relabel VSN", this.getServerName());
            if (labelType.equals("LabelTape.type1")) {
                SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "VSNSummary.error.label", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
            }
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "VSNSummary.error.relabel", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private String getLibraryName() {
        String libraryName = (String)this.getPageSessionAttribute("SAMQFS_LIBRARY_NAME");
        if (libraryName == null) {
            libraryName = RequestManager.getRequest().getParameter("SAMQFS_LIBRARY_NAME");
            if (libraryName != null) {
                this.setPageSessionAttribute("SAMQFS_LIBRARY_NAME", (Serializable)((Object)libraryName));
            }
            if (libraryName == null) {
                throw new IllegalArgumentException("Library Name not supplied");
            }
        }
        return libraryName;
    }

    private int getEQValue() throws NumberFormatException {
        String eqValue = (String)this.getPageSessionAttribute("SAMQFS_EQ");
        if (eqValue == null) {
            eqValue = RequestManager.getRequest().getParameter("SAMQFS_EQ");
            if (eqValue != null) {
                this.setPageSessionAttribute("SAMQFS_EQ", (Serializable)((Object)eqValue));
            }
            if (eqValue == null) {
                throw new IllegalArgumentException("EQ value not supplied");
            }
        }
        return Integer.parseInt(eqValue);
    }

    private String getVSNName() {
        String vsnName = (String)this.getPageSessionAttribute("SAMQFS_VSN_NAME");
        if (vsnName == null) {
            vsnName = RequestManager.getRequest().getParameter("SAMQFS_VSN_NAME");
            if (vsnName != null) {
                this.setPageSessionAttribute("SAMQFS_VSN_NAME", (Serializable)((Object)vsnName));
            }
            if (vsnName == null) {
                throw new IllegalArgumentException("VSN_NAME not supplied");
            }
        }
        return vsnName;
    }

    private int getSlotNumber() throws SamFSException {
        String slotNum = (String)this.getPageSessionAttribute("SAMQFS_SLOT_NUMBER");
        if (slotNum == null) {
            slotNum = RequestManager.getRequest().getParameter("SAMQFS_SLOT_NUMBER");
            if (slotNum != null) {
                this.setPageSessionAttribute("SAMQFS_SLOT_NUMBER", (Serializable)((Object)slotNum));
            }
            if (slotNum == null) {
                throw new IllegalArgumentException("Slot Number not supplied");
            }
        }
        return Integer.parseInt(slotNum);
    }

    private VSN getThisVSN() throws SamFSException, NumberFormatException {
        VSN myVSN = null;
        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
        if (this.getLibraryName().equals("$STANDALONE")) {
            Drive myDrive = sysModel.getSamQFSSystemMediaManager().getStdAloneByEQ(this.getEQValue());
            myVSN = myDrive != null ? myDrive.getVSN() : sysModel.getSamQFSSystemMediaManager().searchVSNInStandAloneDrive(this.getVSNName(), this.getEQValue());
        } else {
            Library myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(this.getLibraryName());
            if (myLibrary == null) {
                throw new SamFSException(null, -2501);
            }
            myVSN = myLibrary.getVSN(this.getSlotNumber());
        }
        if (myVSN == null) {
            throw new SamFSException(null, -2507);
        }
        return myVSN;
    }

    private void setLabelTapeSuccessAlert(String summary, boolean isLabel, String newVSNString, long jobID) {
        String message = jobID < 0L ? (isLabel ? SamUtil.getResourceString("VSNSummary.msg.label", newVSNString) : SamUtil.getResourceString("VSNSummary.msg.relabel", newVSNString)) : (isLabel ? SamUtil.getResourceString("VSNSummary.msg.label", new String[]{newVSNString, Long.toString(jobID)}) : SamUtil.getResourceString("VSNSummary.msg.relabel", new String[]{newVSNString, Long.toString(jobID)}));
        MediaUtil.setLabelTapeInfoAlert((ContainerView)this.getParentViewBean(), "Alert", summary, message);
        this.setSubmitSuccessful(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

