/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.media;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.media.Drive;
import com.sun.netstorage.samqfs.web.model.media.Library;
import com.sun.netstorage.samqfs.web.model.media.VSN;
import com.sun.netstorage.samqfs.web.util.BreadCrumbUtil;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.PageInfo;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCBreadCrumbsModel;
import com.sun.web.ui.model.CCBreadCrumbsModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.breadcrumb.CCBreadCrumbs;
import com.sun.web.ui.view.html.CCHref;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.ServletException;

public class DriveDetailsViewBean
extends CommonViewBeanBase {
    private static final int TAB_NAME = 10;
    private static final String PAGE_NAME = "DriveDetails";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/media/DriveDetails.jsp";
    public static final String CHILD_BREADCRUMB = "BreadCrumb";
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_STANDALONE_SUMMARY_HREF = "StandAloneSummaryHref";
    public static final String CHILD_LIB_SUMMARY_HREF = "LibrarySummaryHref";
    public static final String CHILD_LIB_DETAILS_HREF = "LibraryDetailsHref";
    public static final String CHILD_LIB_DRIVE_SUMMARY_HREF = "LibraryDriveSummaryHref";
    private static CCPageTitleModel pageTitleModel = null;
    private static CCPropertySheetModel propertySheetModel = null;
    private CCBreadCrumbsModel breadCrumbsModel = null;
    private static String eqValue;
    private static String slotNumber;
    static /* synthetic */ Class class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$StandAloneSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$LibraryDetailsViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$media$VSNDetailsViewBean;

    public DriveDetailsViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL, 10);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.createPageTitleModel();
        this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        PageTitleUtil.registerChildren((ContainerViewBase)this, pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, propertySheetModel);
        this.registerChild(CHILD_BREADCRUMB, class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs == null ? (class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs = DriveDetailsViewBean.class$("com.sun.web.ui.view.breadcrumb.CCBreadCrumbs")) : class$com$sun$web$ui$view$breadcrumb$CCBreadCrumbs);
        this.registerChild(CHILD_STANDALONE_SUMMARY_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = DriveDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_LIB_SUMMARY_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = DriveDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_LIB_DETAILS_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = DriveDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_LIB_DRIVE_SUMMARY_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = DriveDetailsViewBean.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = DriveDetailsViewBean.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3(new NonSyncStringBuffer("Entering: child name is ").append(name).toString());
        View child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (PageTitleUtil.isChildSupported(pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, pageTitleModel, name);
        } else if (PropertySheetUtil.isChildSupported(propertySheetModel, name)) {
            child = PropertySheetUtil.createChild((ContainerView)this, propertySheetModel, name);
        } else if (name.equals(CHILD_BREADCRUMB)) {
            this.breadCrumbsModel = new CCBreadCrumbsModel("DriveDetails.pageTitle");
            BreadCrumbUtil.createBreadCrumbs((ViewBean)this, name, this.breadCrumbsModel);
            child = new CCBreadCrumbs((View)this, (CCBreadCrumbsModelInterface)this.breadCrumbsModel, name);
        } else if (name.equals(CHILD_STANDALONE_SUMMARY_HREF) || name.equals(CHILD_LIB_SUMMARY_HREF) || name.equals(CHILD_LIB_DETAILS_HREF) || name.equals(CHILD_LIB_DRIVE_SUMMARY_HREF)) {
            child = new CCHref((ContainerView)this, name, null);
        } else if (name.equals(CHILD_ALERT)) {
            child = new CCAlertInline((ContainerView)this, name, null);
        } else {
            throw new IllegalArgumentException(new NonSyncStringBuffer().append("Invalid child name [").append(name).append("]").toString());
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        eqValue = (String)this.getPageSessionAttribute("SAMQFS_EQ");
        this.loadPropertySheetModel();
        TraceUtil.trace3("Exiting");
    }

    private void createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (pageTitleModel == null) {
            pageTitleModel = new CCPageTitleModel(SamUtil.createBlankPageTitleXML());
        }
        TraceUtil.trace3("Exiting");
    }

    private void createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (propertySheetModel == null) {
            propertySheetModel = PropertySheetUtil.createModel("/jsp/media/DriveDetailsPropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadPropertySheetModel() {
        TraceUtil.trace3("Entering");
        propertySheetModel.clear();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            Drive[] allDrives = null;
            Drive myDrive = null;
            Library myLibrary = null;
            VSN myVSN = null;
            String libraryName = (String)this.getPageSessionAttribute("SAMQFS_LIBRARY_NAME");
            if (libraryName == null) {
                throw new SamFSException(null, -2502);
            }
            if (!libraryName.equals("$STANDALONE")) {
                myLibrary = sysModel.getSamQFSSystemMediaManager().getLibraryByName(libraryName);
                if (myLibrary == null) {
                    throw new SamFSException(null, -2502);
                }
                allDrives = myLibrary.getDrives();
                for (int i = 0; i < allDrives.length; ++i) {
                    try {
                        if (allDrives[i].getEquipOrdinal() != Integer.parseInt(eqValue)) continue;
                        myDrive = allDrives[i];
                        continue;
                    }
                    catch (NumberFormatException numEx) {
                        TraceUtil.trace3(new NonSyncStringBuffer().append("Number format exception occurs ").append("while parsing EQ value").toString());
                        throw new SamFSException(null, -2503);
                    }
                }
            } else {
                try {
                    myDrive = sysModel.getSamQFSSystemMediaManager().getStdAloneByEQ(Integer.parseInt(eqValue));
                }
                catch (NumberFormatException numEx) {
                    TraceUtil.trace3(new NonSyncStringBuffer().append("Number format exception occurs ").append("while parsing EQ value").toString());
                    throw new SamFSException(null, -2503);
                }
            }
            if (myDrive == null) {
                throw new SamFSException(null, -2503);
            }
            myVSN = myDrive.getVSN();
            if (myVSN != null) {
                if (!libraryName.equals("$STANDALONE")) {
                    slotNumber = Integer.toString(myVSN.getSlotNumber());
                }
                propertySheetModel.setValue("vsnValue", (Object)myVSN.getVSN());
                propertySheetModel.setValue("noLink", (Object)"");
                propertySheetModel.setValue("capacityValue", (Object)new Capacity(myVSN.getCapacity(), 2).toString());
                propertySheetModel.setValue("freespaceValue", (Object)new Capacity(myVSN.getAvailableSpace(), 2).toString());
                if (myVSN.getCapacity() == 0L) {
                    propertySheetModel.setValue("spaceconsumedValue", (Object)new Long(0L));
                } else {
                    propertySheetModel.setValue("spaceconsumedValue", (Object)new Long(100L * (myVSN.getCapacity() - myVSN.getAvailableSpace()) / myVSN.getCapacity()));
                }
            } else {
                propertySheetModel.setValue("vsnValue", (Object)"");
                if (myDrive.unLabeled()) {
                    propertySheetModel.setValue("noLink", (Object)SamUtil.getResourceString("StandAloneSummary.unlabelled"));
                } else {
                    propertySheetModel.setValue("noLink", (Object)SamUtil.getResourceString("DriveDetails.driveEmpty"));
                }
                propertySheetModel.setValue("capacityValue", (Object)new Long(0L));
                propertySheetModel.setValue("freespaceValue", (Object)new Long(0L));
                propertySheetModel.setValue("spaceconsumedValue", (Object)new Long(0L));
            }
            propertySheetModel.setValue("eqValue", (Object)new Integer(myDrive.getEquipOrdinal()));
            propertySheetModel.setValue("vendorValue", (Object)myDrive.getVendor());
            propertySheetModel.setValue("productValue", (Object)myDrive.getProductID());
            propertySheetModel.setValue("statusValue", (Object)SamUtil.getStateString(myDrive.getStatus()));
            propertySheetModel.setValue("serialValue", (Object)myDrive.getSerialNo());
            propertySheetModel.setValue("firmwareValue", (Object)myDrive.getFirmwareLevel());
            propertySheetModel.setValue("devicesValue", (Object)myDrive.getDevicePath());
            String[] messages = myDrive.getMessages();
            if (messages == null || messages.length == 0) {
                propertySheetModel.setValue("statusMsgValue", (Object)"");
            } else {
                NonSyncStringBuffer strBuf = new NonSyncStringBuffer();
                for (int i = 0; i < messages.length; ++i) {
                    if (i != 0) {
                        strBuf.append("<br>");
                        continue;
                    }
                    strBuf.append(messages[i]);
                }
                propertySheetModel.setValue("statusMsgValue", (Object)strBuf.toString());
            }
            int[] statusInfoCodes = myDrive.getDetailedStatus();
            if (statusInfoCodes == null || statusInfoCodes.length == 0) {
                propertySheetModel.setValue("statusInfoValue", (Object)"");
            } else {
                NonSyncStringBuffer strBuf = new NonSyncStringBuffer();
                for (int i = 0; i < statusInfoCodes.length; ++i) {
                    if (i != 0) {
                        strBuf.append("<br>");
                        continue;
                    }
                    if (statusInfoCodes[i] == 10017) {
                        strBuf.append(SamUtil.getResourceString(new NonSyncStringBuffer(Integer.toString(statusInfoCodes[i])).append("b").toString()));
                        continue;
                    }
                    strBuf.append(SamUtil.getResourceString(Integer.toString(statusInfoCodes[i])));
                }
                propertySheetModel.setValue("statusInfoValue", (Object)strBuf.toString());
            }
        }
        catch (SamFSException samEx) {
            SamUtil.processException((Exception)((Object)samEx), ((Object)((Object)this)).getClass(), "loadPropertySheet", "Failed to retrieve drive details information", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), CHILD_ALERT, "DriveDetails.error.loadpsheet", samEx.getSAMerrno(), samEx.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
    }

    public void handleStandAloneSummaryHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String str = (String)this.getDisplayFieldValue(CHILD_STANDALONE_SUMMARY_HREF);
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$media$StandAloneSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$StandAloneSummaryViewBean = DriveDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.StandAloneSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$StandAloneSummaryViewBean);
        this.removePageSessionAttribute("SAMQFS_LIBRARY_NAME");
        this.removePageSessionAttribute("SAMQFS_EQ");
        BreadCrumbUtil.breadCrumbPathBackward((ViewBean)this, PageInfo.getPageInfo().getPageNumber(targetView.getName()), str);
        this.forwardTo(targetView);
        TraceUtil.trace3("Exiting");
    }

    public void handleLibrarySummaryHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String str = (String)this.getDisplayFieldValue(CHILD_LIB_SUMMARY_HREF);
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean = DriveDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.LibrarySummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$LibrarySummaryViewBean);
        this.removePageSessionAttribute("SAMQFS_LIBRARY_NAME");
        this.removePageSessionAttribute("SAMQFS_EQ");
        BreadCrumbUtil.breadCrumbPathBackward((ViewBean)this, PageInfo.getPageInfo().getPageNumber(targetView.getName()), str);
        this.forwardTo(targetView);
        TraceUtil.trace3("Exiting");
    }

    public void handleLibraryDetailsHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String str = (String)this.getDisplayFieldValue(CHILD_LIB_DETAILS_HREF);
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$media$LibraryDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$LibraryDetailsViewBean = DriveDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.LibraryDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$media$LibraryDetailsViewBean);
        this.removePageSessionAttribute("SAMQFS_EQ");
        BreadCrumbUtil.breadCrumbPathBackward((ViewBean)this, PageInfo.getPageInfo().getPageNumber(targetView.getName()), str);
        this.forwardTo(targetView);
        TraceUtil.trace3("Exiting");
    }

    public void handleLibraryDriveSummaryHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String str = (String)this.getDisplayFieldValue(CHILD_LIB_DRIVE_SUMMARY_HREF);
        ViewBean targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryViewBean = DriveDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.LibraryDriveSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$media$LibraryDriveSummaryViewBean);
        this.removePageSessionAttribute("SAMQFS_EQ");
        BreadCrumbUtil.breadCrumbPathBackward((ViewBean)this, PageInfo.getPageInfo().getPageNumber(targetView.getName()), str);
        this.forwardTo(targetView);
        TraceUtil.trace3("Exiting");
    }

    public void handleVSNHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        this.setPageSessionAttribute("SAMQFS_SLOT_NUMBER", (Serializable)((Object)slotNumber));
        BreadCrumbUtil.breadCrumbPathForward((ViewBean)this, PageInfo.getPageInfo().getPageNumber(this.getName()));
        this.forwardTo(this.getViewBean(class$com$sun$netstorage$samqfs$web$media$VSNDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$media$VSNDetailsViewBean = DriveDetailsViewBean.class$("com.sun.netstorage.samqfs.web.media.VSNDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$media$VSNDetailsViewBean));
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

