/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.jobs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.jobs.StageJobsData;
import com.sun.netstorage.samqfs.web.jobs.StageJobsModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.job.StageJob;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.table.CCActionTable;
import javax.servlet.http.HttpSession;

public class StageJobsView
extends CommonTableContainerView {
    private CCPageTitleModel pageTitleModel;
    private CCPropertySheetModel propertySheetModel;
    private StageJobsModel model;
    private BaseJob baseJob;
    private StageJob stageJob;
    private long jobId;
    private String serverName;

    public StageJobsView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "StageJobsTable";
        ViewBean vb = this.getParentViewBean();
        this.serverName = (String)vb.getPageSessionAttribute("SERVER_NAME");
        TraceUtil.trace3("Got serverName from page session: " + this.serverName);
        String stageJobIDStr = (String)vb.getPageSessionAttribute("STAGE_JOB_ID");
        TraceUtil.trace3("Got stageJobID from page session: " + stageJobIDStr);
        StageJobsData dataSet = new StageJobsData(this.serverName, Long.parseLong(stageJobIDStr));
        this.model = new StageJobsModel(dataSet);
        this.pageTitleModel = this.createPageTitleModel();
        this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren(this.model);
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, this.propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            return PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        }
        if (PropertySheetUtil.isChildSupported(this.propertySheetModel, name)) {
            return PropertySheetUtil.createChild((ContainerView)this, this.propertySheetModel, name);
        }
        return super.createChild(this.model, name);
    }

    public void populateData() throws SamFSException {
        TraceUtil.trace3("Entering");
        CCActionTable actionTable = (CCActionTable)this.getChild(this.CHILD_ACTION_TABLE);
        try {
            actionTable.restoreStateData();
        }
        catch (ModelControlException mcex) {
            SamUtil.processException((Exception)((Object)mcex), ((Object)((Object)this)).getClass(), "populateData", "ModelControlException occurred within framework", this.serverName);
            throw new SamFSException("Exception occurred with framework");
        }
        this.model.initModelRows();
        TraceUtil.trace3("Exiting");
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/jobs/StageJobsPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    private void createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        ViewBean vb = this.getParentViewBean();
        String jobIdString = (String)vb.getPageSessionAttribute("SAMQFS_JOB_ID");
        TraceUtil.trace3("Got jobIdString from page session: " + jobIdString);
        if (jobIdString == null) {
            HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
            jobIdString = (String)session.getAttribute("JOB_ID");
        }
        try {
            String[] jobIdSplit = jobIdString.split(",");
            this.jobId = Long.parseLong(jobIdSplit[0]);
            String jobCondition = jobIdSplit[2];
            if (jobCondition.equals("Current")) {
                this.loadStageCurrentPropertySheet();
            } else if (jobCondition.equals("Pending")) {
                this.loadStagePendingPropertySheet();
            }
            this.propertySheetModel.setValue("jobIdText", (Object)jobIdSplit[0]);
            this.propertySheetModel.setValue("jobTypeText", (Object)"Jobs.jobType2");
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "createPropertySheetModel", "Cannot populate job details", this.serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "JobsDetails.error.failedPopulate", smfex.getSAMerrno(), smfex.getMessage(), this.serverName);
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadStageCurrentPropertySheet() throws SamFSException {
        this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/StageJobsCurrentPropSheet.xml");
        this.getModelInfo();
        this.loadGenericStageValues();
        this.propertySheetModel.setValue("positionText", (Object)this.stageJob.getPosition());
        this.propertySheetModel.setValue("offSetText", (Object)this.stageJob.getOffset());
        this.propertySheetModel.setValue("sizeFileText", (Object)this.stageJob.getFileSize());
        this.propertySheetModel.setValue("fileNameText", (Object)this.stageJob.getFileName());
    }

    private void loadStagePendingPropertySheet() throws SamFSException {
        this.propertySheetModel = PropertySheetUtil.createModel("/jsp/jobs/StageJobsPendingPropSheet.xml");
        this.getModelInfo();
        this.loadGenericStageValues();
    }

    private void loadGenericStageValues() {
        this.propertySheetModel.setValue("vsnText", (Object)this.stageJob.getVSNName());
        this.propertySheetModel.setValue("medTypeText", (Object)SamUtil.getMediaTypeString(this.stageJob.getMediaType()));
        this.propertySheetModel.setValue("initTimeText", (Object)SamUtil.getTimeString(this.stageJob.getStartDateTime()));
    }

    private void getModelInfo() throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        this.baseJob = sysModel.getSamQFSSystemJobManager().getJobById(this.jobId);
        if (this.baseJob == null) {
            throw new SamFSException(null, -2011);
        }
        this.stageJob = (StageJob)this.baseJob;
        TraceUtil.trace3("Exiting");
    }
}

