/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.jobs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.job.ArchiveJob;
import com.sun.netstorage.samqfs.web.model.job.ArchiveScanJob;
import com.sun.netstorage.samqfs.web.model.job.BaseJob;
import com.sun.netstorage.samqfs.web.model.job.MountJob;
import com.sun.netstorage.samqfs.web.model.job.StageJob;
import com.sun.netstorage.samqfs.web.util.FormattedDate;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;

public final class PendingJobsData
extends ArrayList {
    public static final String[] headings = new String[]{"Jobs.heading1", "Jobs.heading2", "Jobs.heading3", "Jobs.heading4"};
    public static final String[] filterOptions = new String[]{"Jobs.filterOptions0", "Jobs.filterOptions1", "Jobs.filterOptions2", "Jobs.filterOptions4"};
    public static final String button = "Jobs.button1";

    public PendingJobsData(String serverName) throws SamFSException {
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        BaseJob[] baseJobs = sysModel.getSamQFSSystemJobManager().getJobsByCondition(1);
        if (baseJobs == null) {
            return;
        }
        for (int i = 0; i < baseJobs.length; ++i) {
            String vsn;
            String fileSystem;
            String description = "";
            String comma = ",";
            String jobTypeString = null;
            int jobType = baseJobs[i].getType();
            if (jobType == 1) {
                jobTypeString = "Jobs.jobType1";
                ArchiveJob archiveJob = (ArchiveJob)baseJobs[i];
                fileSystem = archiveJob.getFileSystemName();
                String policyName = archiveJob.getPolicyName();
                String copyNumber2 = Integer.toString(archiveJob.getCopyNumber());
                description = SamUtil.processJobDescription(new String[]{fileSystem, policyName, copyNumber2});
            } else if (jobType == 2) {
                jobTypeString = "Jobs.jobType5";
                ArchiveScanJob archiveScanJob = (ArchiveScanJob)baseJobs[i];
                fileSystem = archiveScanJob.getFileSystemName();
                description = SamUtil.processJobDescription(new String[]{fileSystem});
            } else if (jobType == 4) {
                jobTypeString = "Jobs.jobType2";
                StageJob stageJob = (StageJob)baseJobs[i];
                vsn = stageJob.getVSNName();
                description = SamUtil.processJobDescription(new String[]{vsn});
            } else if (jobType == 7) {
                jobTypeString = "Jobs.jobType4";
                MountJob mountJob = (MountJob)baseJobs[i];
                vsn = mountJob.getVSNName();
                String mediaType = SamUtil.getMediaTypeString(mountJob.getMediaType());
                description = SamUtil.processJobDescription(new String[]{vsn, mediaType});
            }
            super.add(new Object[]{new Long(baseJobs[i].getJobId()), jobTypeString, new FormattedDate(baseJobs[i].getStartDateTime(), SamUtil.getTimeFormat()), description});
        }
        TraceUtil.trace3("Exiting");
    }
}

