/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs.wizards;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystemMountProperties;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCLabel;
import com.sun.web.ui.view.html.CCRadioButton;
import com.sun.web.ui.view.html.CCStaticTextField;
import com.sun.web.ui.view.html.CCTextField;
import com.sun.web.ui.view.wizard.CCWizardPage;

public class NewWizardQFSDAUView
extends RequestHandlingViewBase
implements CCWizardPage {
    public static final String PAGE_NAME = "NewWizardDAU43View";
    public static final String CHILD_LABEL = "label";
    public static final String CHILD_ALLOC_RADIOBUTTON = "allocSelect";
    public static final String CHILD_NUM_OF_STRIPED_GROUP_TEXTFIELD = "numOfStripedGroupTextField";
    public static final String CHILD_DAU_SIZE_FIELD = "DAUSizeField";
    public static final String CHILD_DAU_SIZE_HELP = "DAUSizeHelp";
    public static final String CHILD_DAU_SIZE_DROP_DOWN = "DAUSizeDropDown";
    public static final String CHILD_DAU_DROPDOWN = "DAUDropDown";
    public static final String CHILD_STRIPE_FIELD = "stripeValue";
    public static final String CHILD_IS_SHARED_HIDDEN = "isShared";
    public static final String CHILD_ALERT = "Alert";
    protected String serverName = null;
    private boolean previous_error = false;
    private OptionList dauSizeUnitDropDownOptions = new OptionList(new String[]{"FSWizard.new.dau.size.kbytes", "FSWizard.new.dau.size.mbytes"}, new String[]{"kb", "mb"});
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCLabel;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCRadioButton;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCStaticTextField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCDropDownMenu;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;

    public NewWizardQFSDAUView(View parent, Model model) {
        this(parent, model, PAGE_NAME);
    }

    public NewWizardQFSDAUView(View parent, Model model, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        this.setDefaultModel(model);
        SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
        this.serverName = (String)wizardModel.getValue("SERVER_NAME");
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(CHILD_LABEL, class$com$sun$web$ui$view$html$CCLabel == null ? (class$com$sun$web$ui$view$html$CCLabel = NewWizardQFSDAUView.class$("com.sun.web.ui.view.html.CCLabel")) : class$com$sun$web$ui$view$html$CCLabel);
        this.registerChild(CHILD_ALLOC_RADIOBUTTON, class$com$sun$web$ui$view$html$CCRadioButton == null ? (class$com$sun$web$ui$view$html$CCRadioButton = NewWizardQFSDAUView.class$("com.sun.web.ui.view.html.CCRadioButton")) : class$com$sun$web$ui$view$html$CCRadioButton);
        this.registerChild(CHILD_NUM_OF_STRIPED_GROUP_TEXTFIELD, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewWizardQFSDAUView.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(CHILD_DAU_SIZE_FIELD, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewWizardQFSDAUView.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(CHILD_DAU_SIZE_HELP, class$com$sun$web$ui$view$html$CCStaticTextField == null ? (class$com$sun$web$ui$view$html$CCStaticTextField = NewWizardQFSDAUView.class$("com.sun.web.ui.view.html.CCStaticTextField")) : class$com$sun$web$ui$view$html$CCStaticTextField);
        this.registerChild(CHILD_DAU_SIZE_DROP_DOWN, class$com$sun$web$ui$view$html$CCDropDownMenu == null ? (class$com$sun$web$ui$view$html$CCDropDownMenu = NewWizardQFSDAUView.class$("com.sun.web.ui.view.html.CCDropDownMenu")) : class$com$sun$web$ui$view$html$CCDropDownMenu);
        this.registerChild(CHILD_DAU_DROPDOWN, class$com$sun$web$ui$view$html$CCDropDownMenu == null ? (class$com$sun$web$ui$view$html$CCDropDownMenu = NewWizardQFSDAUView.class$("com.sun.web.ui.view.html.CCDropDownMenu")) : class$com$sun$web$ui$view$html$CCDropDownMenu);
        this.registerChild(CHILD_STRIPE_FIELD, class$com$sun$web$ui$view$html$CCTextField == null ? (class$com$sun$web$ui$view$html$CCTextField = NewWizardQFSDAUView.class$("com.sun.web.ui.view.html.CCTextField")) : class$com$sun$web$ui$view$html$CCTextField);
        this.registerChild(CHILD_IS_SHARED_HIDDEN, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = NewWizardQFSDAUView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = NewWizardQFSDAUView.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        TraceUtil.trace3("Exiting");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering with name = " + name);
        CCLabel child = null;
        if (name.equals(CHILD_LABEL)) {
            child = new CCLabel((ContainerView)this, name, null);
        } else if (name.equals(CHILD_ALLOC_RADIOBUTTON)) {
            CCRadioButton radioChild = new CCRadioButton((ContainerView)this, name, null);
            radioChild.setOptions(new OptionList(new String[]{"FSWizard.new.qfs.singleAllocation", "FSWizard.new.qfs.dualAllocation.label", "FSWizard.new.qfs.stripedGroup"}, new String[]{"FSWizard.new.qfs.singleAllocation", "FSWizard.new.qfs.dualAllocation.label", "FSWizard.new.qfs.stripedGroup"}));
            child = radioChild;
        } else if (name.equals(CHILD_NUM_OF_STRIPED_GROUP_TEXTFIELD)) {
            child = new CCTextField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_DAU_SIZE_FIELD) || name.equals(CHILD_STRIPE_FIELD)) {
            child = new CCTextField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_DAU_SIZE_HELP)) {
            child = new CCStaticTextField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_DAU_SIZE_DROP_DOWN)) {
            CCDropDownMenu myChild = new CCDropDownMenu((ContainerView)this, name, null);
            myChild.setOptions(this.dauSizeUnitDropDownOptions);
            myChild.setBoundName(name);
            child = myChild;
        } else if (name.equals(CHILD_DAU_DROPDOWN)) {
            CCDropDownMenu dropdownChild = new CCDropDownMenu((ContainerView)this, name, null);
            child = dropdownChild;
        } else if (name.equals(CHILD_ALERT)) {
            CCAlertInline child1 = new CCAlertInline((ContainerView)this, name, null);
            child1.setValue((Object)"error");
            child = child1;
        } else if (name.equals(CHILD_IS_SHARED_HIDDEN)) {
            child = new CCHiddenField((ContainerView)this, name, null);
        } else {
            throw new IllegalArgumentException("NewWizardDAU43View : Invalid child name [" + name + "]");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public String getPageletUrl() {
        TraceUtil.trace3("Entering");
        String url = null;
        url = !this.previous_error ? "/jsp/fs/NewWizardQFSDAUPage.jsp" : "/jsp/fs/wizardErrorPage.jsp";
        TraceUtil.trace3("Exiting");
        return url;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        String t;
        TraceUtil.trace3("Entering");
        super.beginDisplay(event);
        SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
        String allocation = (String)wizardModel.getWizardValue(CHILD_ALLOC_RADIOBUTTON);
        CCTextField groupField = (CCTextField)this.getChild(CHILD_NUM_OF_STRIPED_GROUP_TEXTFIELD);
        if (allocation == null) {
            allocation = "FSWizard.new.qfs.singleAllocation";
            CCRadioButton allocRadio = (CCRadioButton)this.getChild(CHILD_ALLOC_RADIOBUTTON);
            allocRadio.setValue((Object)allocation);
            groupField.setDisabled(true);
        } else if (allocation.equals("FSWizard.new.qfs.stripedGroup")) {
            groupField.setDisabled(false);
        } else {
            groupField.setDisabled(true);
        }
        CCDropDownMenu dauSizeUnit = (CCDropDownMenu)this.getChild(CHILD_DAU_SIZE_DROP_DOWN);
        String dauUnit = (String)wizardModel.getValue(CHILD_DAU_SIZE_DROP_DOWN);
        CCTextField dauSizeField = (CCTextField)this.getChild(CHILD_DAU_SIZE_FIELD);
        String dau43Size = (String)wizardModel.getValue(CHILD_DAU_SIZE_FIELD);
        TraceUtil.trace2("dauUnit is : " + dauUnit);
        if (dauUnit == null || dauUnit.trim().length() == 0) {
            TraceUtil.trace2("Setting dauUnit to KB");
            dauSizeUnit.setValue((Object)"kb");
        }
        CCDropDownMenu dauDropdown = (CCDropDownMenu)this.getChild(CHILD_DAU_DROPDOWN);
        String fsType = (String)wizardModel.getValue("fsTypeKey");
        String dauSize = (String)wizardModel.getValue(CHILD_DAU_DROPDOWN);
        OptionList dauOptions = new OptionList(new String[]{"samqfsui.fs.wizards.new.DAUPage.option.16", "samqfsui.fs.wizards.new.DAUPage.option.32", "samqfsui.fs.wizards.new.DAUPage.option.64"}, new String[]{"16", "32", "64"});
        dauDropdown.setOptions(dauOptions);
        if (allocation.equals("FSWizard.new.qfs.dualAllocation.label")) {
            dauSizeField.setDisabled(true);
            dauSizeUnit.setDisabled(true);
            dauDropdown.setDisabled(false);
        } else {
            dauSizeField.setDisabled(false);
            dauSizeUnit.setDisabled(false);
            dauDropdown.setDisabled(true);
        }
        CCTextField stripeWidthField = (CCTextField)this.getChild(CHILD_STRIPE_FIELD);
        String stripeWidth = (String)wizardModel.getValue(CHILD_STRIPE_FIELD);
        if (stripeWidth == null || stripeWidth.length() == 0) {
            stripeWidth = allocation.equals("FSWizard.new.qfs.dualAllocation.label") ? Integer.toString(this.getStripeWidth(wizardModel, dauSize)) : Integer.toString(this.getStripeWidth(wizardModel, dau43Size));
            stripeWidthField.setValue((Object)stripeWidth);
            wizardModel.setValue(CHILD_STRIPE_FIELD, stripeWidth);
        }
        if ((t = (String)wizardModel.getValue("ERROR")) != null && t.equals("Yes")) {
            String msgs = (String)wizardModel.getValue("ERROR_MSGS");
            int code = Integer.parseInt((String)wizardModel.getValue("ERROR_CODE"));
            String errorSummary = "FSWizard.new.error.steps";
            this.previous_error = true;
            String errorDetails = (String)wizardModel.getValue("ERROR_DETAIL");
            if (errorDetails != null) {
                errorSummary = (String)wizardModel.getValue("ERROR_SUMMARY");
                this.previous_error = !errorDetails.equals("INLINE_ALERT");
            }
            if (this.previous_error) {
                SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, errorSummary, code, msgs, this.serverName);
            } else {
                SamUtil.setWarningAlert((ContainerView)this, CHILD_ALERT, errorSummary, msgs);
            }
        }
        ((CCHiddenField)this.getChild(CHILD_IS_SHARED_HIDDEN)).setValue((Object)Boolean.toString(this.isSharedFileSystem(wizardModel)));
        TraceUtil.trace3("Exiting");
    }

    private int getStripeWidth(SamWizardModel wizardModel, String dauSize) {
        if (this.isSharedFileSystem(wizardModel)) {
            return 0;
        }
        int dau = 64;
        try {
            dau = Integer.parseInt(dauSize);
        }
        catch (NumberFormatException numEx) {
            // empty catch block
        }
        if (dau >= 128 && dau <= 0) {
            return 1;
        }
        return 128 / dau;
    }

    private String getDefaultStripeWidth(SamWizardModel wizardModel, String dauSize) {
        String fsType = (String)wizardModel.getValue("fsTypeKey");
        int dau = 64;
        try {
            dau = Integer.parseInt(dauSize);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        String stripeString = "";
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            int type = -1;
            int archType = -1;
            int shareStatus = 0;
            if (fsType.equals("qfs")) {
                type = 0;
                archType = 3;
            } else if (fsType.equals("fs")) {
                type = 1;
                archType = 2;
            }
            FileSystemMountProperties properties = sysModel.getSamQFSSystemFSManager().getDefaultMountProperties(type, archType, dau, false, shareStatus, false);
            stripeString = Integer.toString(properties.getStripeWidth());
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "beginDisplay()", "Failed to get default stripe width value", this.serverName);
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "FSWizard.new.error.steps", smfex.getSAMerrno(), smfex.getMessage(), this.serverName);
        }
        TraceUtil.trace3("default stripe width = " + stripeString);
        return stripeString;
    }

    private boolean isSharedFileSystem(SamWizardModel wizardModel) {
        String fsType = (String)wizardModel.getValue("fsTypeKey");
        return fsType.equals("sharedqfs");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

