/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs.wizards;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.view.View;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.fs.wizards.FSWizardDeviceSelectionPageView;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.SharedDiskCache;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardModel;
import java.util.ArrayList;

public class FSWizardStripedGroupDeviceSelectionPageView
extends FSWizardDeviceSelectionPageView {
    public static final String PAGE_NAME = "FSWizardStripedGroupDeviceSelectionPageView";

    public FSWizardStripedGroupDeviceSelectionPageView(View parent, Model model) {
        this(parent, model, PAGE_NAME);
    }

    public FSWizardStripedGroupDeviceSelectionPageView(View parent, Model model, String name) {
        super(parent, model, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Exiting");
    }

    protected void createActionTableModel() {
        super.createActionTableModel();
        this.tableModel.setTitle("FSWizard.stripedGroupDeviceSelectionTable.title");
        TraceUtil.trace2("Leaving createActionTableModel");
    }

    protected void populateActionTableModel() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.initSelected = 0;
        this.tableModel.clear();
        SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
        DiskCache[] devices = this.sharedChecked != null && this.sharedChecked.equals("true") ? (SharedDiskCache[])wizardModel.getValue("AllAllocatableDevices") : (DiskCache[])wizardModel.getValue("AllAllocatableDevices");
        this.totalItems = 0;
        if (devices == null) {
            TraceUtil.trace2("Device List is Null from Impl class");
            throw new SamFSException(null, -2001);
        }
        int groupNum = (Integer)wizardModel.getValue("stripedGroupNumber");
        ArrayList selectedMetadataDevices = (ArrayList)wizardModel.getValue("SelectedMetaDevices");
        ArrayList selectedStripedGroupDevices = (ArrayList)wizardModel.getValue("SelectedStripedGroupDevices");
        ArrayList thisGroupDevices = null;
        if (selectedStripedGroupDevices != null && selectedStripedGroupDevices.size() > groupNum) {
            thisGroupDevices = (ArrayList)selectedStripedGroupDevices.get(groupNum);
        }
        String samfsServerAPIVersion = (String)wizardModel.getValue("SamServerAPIVersion");
        for (int i = 0; i < devices.length; ++i) {
            if (selectedMetadataDevices != null && selectedMetadataDevices.contains(devices[i].getDevicePath())) continue;
            if (selectedStripedGroupDevices != null) {
                boolean found = false;
                for (int j = 0; j < groupNum; ++j) {
                    ArrayList groupDevices = (ArrayList)selectedStripedGroupDevices.get(j);
                    if (!groupDevices.contains(devices[i].getDevicePath())) continue;
                    found = true;
                    break;
                }
                if (found) continue;
            }
            if (i > 0) {
                this.tableModel.appendRow();
            }
            ++this.totalItems;
            String partition = null;
            int diskType = devices[i].getDiskType();
            if (diskType == 101) {
                partition = "FSWizard.diskType.slice";
            } else if (diskType == 102) {
                partition = "FSWizard.diskType.svm";
            } else if (diskType == 103) {
                partition = "FSWizard.diskType.vxvm";
            } else if (diskType == 104) {
                partition = "FSWizard.diskType.svm.mirror";
            } else if (diskType == 105) {
                partition = "FSWizard.diskType.vxvm.mirror";
            } else if (diskType == 106) {
                partition = "FSWizard.diskType.svm.raid5";
            } else if (diskType == 107) {
                partition = "FSWizard.diskType.vxvm.raid5";
            }
            String pathString = devices[i].getDevicePath();
            String[] sliceElement = pathString.split("/");
            if ((diskType == 102 || diskType == 104 || diskType == 106) && sliceElement.length == 6) {
                this.tableModel.setValue("DevicePath", (Object)(sliceElement[3] + "/" + sliceElement[5]));
            } else {
                int index = pathString.indexOf("/dsk/");
                this.tableModel.setValue("DevicePath", (Object)pathString.substring(index + 5));
            }
            this.tableModel.setValue("HiddenDevicePath", (Object)pathString);
            if (this.sharedChecked == null || !this.sharedChecked.equals("true")) {
                this.tableModel.setValue("Partition", (Object)partition);
            }
            long dCap = devices[i].getCapacity();
            this.tableModel.setValue("Capacity", (Object)new Capacity(dCap, 2));
            if (samfsServerAPIVersion != null && samfsServerAPIVersion.compareTo("1.2") >= 0) {
                this.tableModel.setValue("Vendor", (Object)devices[i].getVendor());
                this.tableModel.setValue("ProductID", (Object)devices[i].getProductId());
            }
            if (thisGroupDevices != null && thisGroupDevices.contains(devices[i].getDevicePath())) {
                this.tableModel.setRowSelected(true);
                ++this.initSelected;
            }
            if (this.sharedChecked == null || !this.sharedChecked.equals("true")) continue;
            String metaDataHostName = (String)wizardModel.getValue("SERVER_NAME");
            String[] serverHosts = ((SharedDiskCache)devices[i]).availFromServers();
            String[] clientHosts = ((SharedDiskCache)devices[i]).availFromClients();
            TraceUtil.trace3("client host is " + clientHosts.toString());
            ArrayList chosenClientHosts = (ArrayList)wizardModel.getValue("SelectedClientIndex");
            String displayHosts = metaDataHostName;
            for (int ii = 0; ii < clientHosts.length; ++ii) {
                displayHosts = displayHosts + ";" + clientHosts[ii];
            }
            ArrayList potentialHosts = (ArrayList)wizardModel.getValue("SelectedPotentialMetadataServerValue");
            ArrayList seleectedClientHosts = (ArrayList)wizardModel.getValue("SelectedClient");
            this.tableModel.setValue("AvailableFrom", (Object)displayHosts);
            if (seleectedClientHosts.size() != 0) {
                if (clientHosts.length != 0) continue;
                this.tableModel.setSelectionVisible(false);
                continue;
            }
            if (potentialHosts.size() == 0 || serverHosts.length == potentialHosts.size()) continue;
            this.tableModel.setSelectionVisible(false);
        }
        TraceUtil.trace2("Finished Adding devices and populateModel");
        TraceUtil.trace3("Exiting");
    }
}

