/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs.wizards;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemSharedFSManager;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardModel;
import com.sun.web.ui.model.CCActionTableModel;

public class FSWizardSharedMemberSelectionPageModel
extends CCActionTableModel {
    private String[] apiArch;
    private String[] apiVersion;
    private String[] sharedLicense;
    private String[] hostName;

    public FSWizardSharedMemberSelectionPageModel() {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/fs/FSWizardSharedMemberSelectionTable.xml");
        this.setActionValue("SharedMemberCol0", "FSWizard.sharedMemberSelectionTable.hostNameHeading");
        this.setActionValue("SharedMemberCol1", "FSWizard.sharedMemberSelectionTable.samVersionHeading");
        this.setActionValue("SharedMemberCol2", "FSWizard.sharedMemberSelectionTable.hardwareArchHeading");
        this.setActionValue("SharedMemberCol3", "FSWizard.sharedMemberSelectionTable.clientHeading");
        this.setActionValue("SharedMemberCol4", "FSWizard.sharedMemberSelectionTable.potentialMetaServerHeading");
        this.setActionValue("SharedMemberCol5", "FSWizard.sharedMemberSelectionTable.primaryIPHeading");
        this.setActionValue("SharedMemberCol6", "FSWizard.sharedMemberSelectionTable.secondaryIPHeading");
        TraceUtil.trace2("Leaving createActionTableModel");
    }

    public void populateSharedMemberModel(SamWizardModel wm) throws SamFSException {
        int i;
        TraceUtil.trace3("Entering");
        this.clear();
        String serverName = (String)wm.getValue("SERVER_NAME");
        SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
        if (appModel == null) {
            throw new SamFSException(null, -2501);
        }
        SamQFSSystemModel[] allSystemModel = appModel.getAllSamQFSSystemModels();
        if (allSystemModel == null) {
            return;
        }
        TraceUtil.trace3("before newhost newhost api version");
        String samfsServerAPIVersion = "samfs4.2";
        String samfsServerArch = "sparc";
        String hostname = null;
        this.apiArch = new String[allSystemModel.length];
        this.apiVersion = new String[allSystemModel.length];
        this.hostName = new String[allSystemModel.length];
        SamQFSSystemSharedFSManager fsManager = appModel.getSamQFSSystemSharedFSManager();
        int rowIndex = 0;
        String[] newHosts = new String[allSystemModel.length];
        int loc = 0;
        TraceUtil.trace3("before newhost metadta host handle");
        for (i = 0; i < allSystemModel.length; ++i) {
            String hName = allSystemModel[i].getHostname();
            if (!hName.equals(serverName)) continue;
            newHosts[0] = hName;
            loc = i;
            break;
        }
        TraceUtil.trace3("before newhost handle = " + Integer.toString(allSystemModel.length));
        TraceUtil.trace3("newhost =" + newHosts[0]);
        TraceUtil.trace3("newhost metahost =" + serverName);
        for (i = 1; i <= loc; ++i) {
            newHosts[i] = allSystemModel[i - 1].getHostname();
        }
        TraceUtil.trace3("loc = " + Integer.toString(loc));
        for (i = loc + 1; i < allSystemModel.length; ++i) {
            newHosts[i] = allSystemModel[i].getHostname();
        }
        TraceUtil.trace3("before newhost trace");
        for (i = 0; i < newHosts.length; ++i) {
            TraceUtil.trace3("newhost is " + newHosts[i]);
        }
        for (i = 0; i < newHosts.length; ++i) {
            try {
                hostname = newHosts[i];
                if (appModel.getSamQFSSystemModel(hostname).isDown() || hostname.equals(serverName)) continue;
                SamQFSSystemModel model = SamUtil.getModel(hostname);
                String hafs = (String)wm.getValue("hafs");
                if ("true".equals(hafs) && !model.isClusterNode()) continue;
                if (i > 0) {
                    this.appendRow();
                }
                this.setValue("hostName", hostname);
                this.setValue("HiddenHostName", hostname);
                this.hostName[rowIndex] = hostname;
                samfsServerAPIVersion = model.getServerAPIVersion();
                samfsServerArch = model.getArchitecture();
                this.setValue("hardwareArch", samfsServerArch);
                this.apiArch[rowIndex] = samfsServerArch;
                samfsServerAPIVersion = model.getServerProductVersion();
                this.setValue("samVersion", samfsServerAPIVersion);
                this.apiVersion[rowIndex] = samfsServerAPIVersion;
                this.setRowIndex(rowIndex);
                ++rowIndex;
                continue;
            }
            catch (Exception genEx) {
                // empty catch block
            }
        }
        TraceUtil.trace3("Exiting");
    }

    public String getApiArch(int index) {
        return this.apiArch[index];
    }

    public String getApiVersion(int index) {
        return this.apiVersion[index];
    }

    public String getSharedLicense(int index) {
        return this.sharedLicense[index];
    }

    public String getHostName(int index) {
        return this.hostName[index];
    }
}

