/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs.wizards;

import com.iplanet.jato.model.Model;
import com.iplanet.jato.view.View;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.fs.wizards.FSWizardDeviceSelectionPageView;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.SharedDiskCache;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardModel;
import java.util.ArrayList;

public class FSWizardMetadataDeviceSelectionPageView
extends FSWizardDeviceSelectionPageView {
    public static final String PAGE_NAME = "FSWizardMetadataDeviceSelectionPageView";

    public FSWizardMetadataDeviceSelectionPageView(View parent, Model model) {
        this(parent, model, PAGE_NAME);
    }

    public FSWizardMetadataDeviceSelectionPageView(View parent, Model model, String name) {
        super(parent, model, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Exiting");
    }

    protected void createActionTableModel() {
        super.createActionTableModel();
        this.tableModel.setTitle("FSWizard.metadataDeviceSelectionTable.title");
        TraceUtil.trace2("Leaving createActionTableModel");
    }

    protected void populateActionTableModel() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.initSelected = 0;
        this.tableModel.clear();
        TraceUtil.trace3("before getting sharedChecked");
        SamWizardModel wizardModel = (SamWizardModel)this.getDefaultModel();
        this.sharedChecked = (String)wizardModel.getWizardValue("sharedCheck");
        DiskCache[] devices = this.sharedChecked != null && this.sharedChecked.equals("true") ? (SharedDiskCache[])wizardModel.getValue("AllAllocatableDevices") : (DiskCache[])wizardModel.getValue("AllAllocatableDevices");
        TraceUtil.trace3("after getting sharedChecked");
        if (devices == null) {
            this.totalItems = 0;
            TraceUtil.trace2("Device List is Null from Impl class");
            throw new SamFSException(null, -2001);
        }
        this.totalItems = devices.length;
        ArrayList selectedMetadataDevices = (ArrayList)wizardModel.getValue("SelectedMetaDevices");
        TraceUtil.trace3("after getting selectedMetadataDevices");
        String samfsServerAPIVersion = (String)wizardModel.getValue("SamServerAPIVersion");
        TraceUtil.trace3("after getting samfsServerAPIVersion");
        for (int i = 0; i < devices.length; ++i) {
            TraceUtil.trace3("device string is " + devices[i].toString());
            if (i > 0) {
                this.tableModel.appendRow();
            }
            String partition = null;
            int diskType = devices[i].getDiskType();
            if (diskType == 101) {
                partition = "FSWizard.diskType.slice";
            } else if (diskType == 102) {
                partition = "FSWizard.diskType.svm";
            } else if (diskType == 103) {
                partition = "FSWizard.diskType.vxvm";
            } else if (diskType == 104) {
                partition = "FSWizard.diskType.svm.mirror";
            } else if (diskType == 105) {
                partition = "FSWizard.diskType.vxvm.mirror";
            } else if (diskType == 106) {
                partition = "FSWizard.diskType.svm.raid5";
            } else if (diskType == 107) {
                partition = "FSWizard.diskType.vxvm.raid5";
            }
            String pathString = devices[i].getDevicePath();
            String[] sliceElement = pathString.split("/");
            if ((diskType == 102 || diskType == 104 || diskType == 106) && sliceElement.length == 6) {
                this.tableModel.setValue("DevicePath", (Object)(sliceElement[3] + "/" + sliceElement[5]));
            } else {
                int index = pathString.indexOf("/dsk/");
                this.tableModel.setValue("DevicePath", (Object)pathString.substring(index + 5));
            }
            this.tableModel.setValue("HiddenDevicePath", (Object)pathString);
            if (this.sharedChecked == null || !this.sharedChecked.equals("true")) {
                this.tableModel.setValue("Partition", (Object)partition);
            }
            long dCap = devices[i].getCapacity();
            this.tableModel.setValue("Capacity", (Object)new Capacity(dCap, 2));
            if (this.sharedChecked != null && this.sharedChecked.equals("true")) {
                int ii;
                String metaDataHostName = (String)wizardModel.getValue("SERVER_NAME");
                String[] serverHosts = ((SharedDiskCache)devices[i]).availFromServers();
                String[] clientHosts = ((SharedDiskCache)devices[i]).availFromClients();
                ArrayList potentialHosts = (ArrayList)wizardModel.getValue("SelectedPotentialMetadataServerValue");
                ArrayList seleectedClientHosts = (ArrayList)wizardModel.getValue("SelectedClient");
                String displayHosts = metaDataHostName;
                for (ii = 0; ii < serverHosts.length; ++ii) {
                    displayHosts = displayHosts + ";" + serverHosts[ii];
                }
                for (ii = 0; ii < clientHosts.length; ++ii) {
                    displayHosts = displayHosts + ";" + clientHosts[ii];
                }
                this.tableModel.setValue("AvailableFrom", (Object)displayHosts);
                if (potentialHosts.size() != 0 && serverHosts.length != potentialHosts.size()) {
                    this.tableModel.setSelectionVisible(false);
                }
                if (((SharedDiskCache)devices[i]).usedByClient()) {
                    this.tableModel.setSelectionVisible(false);
                }
            }
            if (samfsServerAPIVersion != null && samfsServerAPIVersion.compareTo("1.2") >= 0) {
                this.tableModel.setValue("Vendor", (Object)devices[i].getVendor());
                this.tableModel.setValue("ProductID", (Object)devices[i].getProductId());
            }
            if (selectedMetadataDevices == null || !selectedMetadataDevices.contains(devices[i].getDevicePath())) continue;
            this.tableModel.setRowSelected(true);
            ++this.initSelected;
        }
        TraceUtil.trace2("Finished Adding devices and populateModel");
        TraceUtil.trace3("Exiting");
    }
}

