/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.fs.StageTiledView;
import com.sun.netstorage.samqfs.web.fs.StageViewBean;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemFSManager;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.StageFile;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.Constants;
import com.sun.netstorage.samqfs.web.util.Filter;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import java.io.File;
import java.util.Date;

public class StageView
extends CommonTableContainerView {
    public static final String TILED_VIEW = "stage_tiled_view";
    private CCActionTableModel model = null;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$StageTiledView;

    public StageView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "StageFilesTable";
        this.model = this.createTableModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(TILED_VIEW, class$com$sun$netstorage$samqfs$web$fs$StageTiledView == null ? (class$com$sun$netstorage$samqfs$web$fs$StageTiledView = StageView.class$("com.sun.netstorage.samqfs.web.fs.StageTiledView")) : class$com$sun$netstorage$samqfs$web$fs$StageTiledView);
        super.registerChildren(this.model);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(TILED_VIEW)) {
            return new StageTiledView((View)this, this.model, name);
        }
        return super.createChild(this.model, name, TILED_VIEW);
    }

    private CCActionTableModel createTableModel() {
        TraceUtil.trace3("Entering");
        String xmlFile = "/jsp/fs/StageTable.xml";
        TraceUtil.trace3("Exiting");
        return new CCActionTableModel(RequestManager.getRequestContext().getServletContext(), xmlFile);
    }

    public void populateTableModel() {
        TraceUtil.trace3("Entering");
        StageViewBean parent = (StageViewBean)this.getParentViewBean();
        String serverName = parent.getServerName();
        String fsName = (String)parent.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        NonSyncStringBuffer fileNames = new NonSyncStringBuffer();
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
            SamQFSSystemFSManager fsManager = sysModel.getSamQFSSystemFSManager();
            String dirPath = parent.getCurrentStageDirectory();
            Filter filter = (Filter)parent.getPageSessionAttribute("filterValue");
            StageFile[] stageFile = fsManager.getStageFiles(parent.getMaxEntries(), dirPath, filter);
            this.model.clear();
            for (int i = 0; stageFile != null && i < stageFile.length; ++i) {
                StageFile file = stageFile[i];
                if (i > 0) {
                    this.model.appendRow();
                    fileNames.append(";").append(dirPath.concat(File.separator).concat(file.getName()));
                } else {
                    fileNames.append(dirPath.concat(File.separator).concat(file.getName()));
                }
                if (file.isDirectory()) {
                    this.model.setValue("NameHref", (Object)file.getName());
                    this.model.setValue("DirIcon", (Object)Constants.Image.DIR_ICON);
                    this.model.setValue("DirNameText", (Object)file.getName());
                    this.model.setValue("FileIcon", (Object)"");
                    this.model.setValue("FileNameText", (Object)"");
                } else {
                    this.model.setValue("FileIcon", (Object)Constants.Image.FILE_ICON);
                    this.model.setValue("FileNameText", (Object)file.getName());
                    this.model.setValue("DirIcon", (Object)"");
                    this.model.setValue("DirNameText", (Object)"");
                }
                this.model.setValue("NameValue", (Object)file.getName());
                this.model.setValue("ModifiedDateText", (Object)new Date(file.lastModified()));
                this.model.setValue("SizeText", (Object)new Capacity(file.length(), 0));
                this.model.setValue("StateText", (Object)file.getLocalizedOnlineStatus());
                String stageAttributes = "";
                switch (file.getStageAttributes()) {
                    case 1: {
                        stageAttributes = "fs.stage.never";
                        break;
                    }
                    case 2: {
                        stageAttributes = "fs.stage.associative";
                        break;
                    }
                }
                this.model.setValue("StageAttributesText", (Object)stageAttributes);
                String releaseAttributes = "";
                switch (file.getReleaseAttributes()) {
                    case 1: {
                        releaseAttributes = "fs.release.never";
                        break;
                    }
                    case 2: {
                        releaseAttributes = "fs.release.after1copy";
                        break;
                    }
                }
                this.model.setValue("ReleaseAttributesText", (Object)releaseAttributes);
                this.model.setRowSelected(false);
            }
            ((CCHiddenField)parent.getChild("fileNames")).setValue((Object)fileNames.toString());
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), ((Object)((Object)this)).getClass(), "populateTableModel", "could not retrieve files", serverName);
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", SamUtil.getResourceString("fs.stage.retrieve.error"), sfe.getSAMerrno(), sfe.getMessage(), serverName);
        }
        TraceUtil.trace3("Exiting");
    }

    public void beginDisplay(DisplayEvent evt) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.model.setActionValue("Name", (Object)"fs.stage.file.name");
        this.model.setActionValue("ModifiedDate", (Object)"fs.stage.file.modifieddate");
        this.model.setActionValue("Size", (Object)"fs.stage.file.size");
        this.model.setActionValue("State", (Object)"fs.stage.file.state");
        this.model.setActionValue("StageAttributes", (Object)"fs.stage.stager.attributes");
        this.model.setActionValue("ReleaseAttributes", (Object)"fs.stage.releaser.attributes");
        this.populateTableModel();
        StageViewBean parent = (StageViewBean)this.getParentViewBean();
        String currentDirectory = parent.getCurrentStageDirectory();
        String mountPoint = (String)parent.getPageSessionAttribute("SAMQFS_fs_mount_point");
        if (currentDirectory.equals(mountPoint)) {
            ((CCButton)this.getChild("upOneLevel")).setDisabled(true);
        } else {
            ((CCButton)this.getChild("upOneLevel")).setDisabled(false);
        }
        ((CCButton)this.getChild("stage")).setDisabled(true);
        TraceUtil.trace3("Exiting");
    }

    public void handleUpOneLevelRequest(RequestInvocationEvent rie) throws ModelControlException {
        StageViewBean parent = (StageViewBean)this.getParentViewBean();
        String currentDirectory = parent.getCurrentStageDirectory();
        String[] dirs = currentDirectory.split(File.separator);
        String lastDir = dirs[dirs.length - 1];
        System.out.println("Last dir = " + lastDir);
        currentDirectory = currentDirectory.substring(0, currentDirectory.indexOf(lastDir) - 1);
        System.out.println("settting current dir to : " + currentDirectory);
        parent.setCurrentStageDirectory(currentDirectory);
        parent.forwardTo(this.getRequestContext());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

