/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiHostException;
import com.sun.netstorage.samqfs.web.fs.FSUtil;
import com.sun.netstorage.samqfs.web.fs.SharedFSDetailsData;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;

public final class SharedFSDetailsModel
extends CCActionTableModel {
    private ArrayList latestRows;
    public String partialErrMsg = null;
    public String sharedMDServer = null;
    private String fsName = null;
    private String hostName = null;

    public SharedFSDetailsModel(String hostName, String name) {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/fs/SharedFSDetailsTable.xml");
        TraceUtil.trace3("Entering Shared FS Model: serverName is " + hostName + "fsName is " + name);
        this.fsName = name;
        this.hostName = hostName;
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.initActionButtons();
        this.initActionMenu();
        this.initHeaders();
        this.initProductName();
        TraceUtil.trace3("Exiting");
    }

    private void initActionButtons() {
        TraceUtil.trace3("Entering");
        this.setActionValue("AddButton", "SharedFSDetails.button.add");
        this.setActionValue("DeleteButton", "SharedFSDetails.button.delete");
        TraceUtil.trace3("Exiting");
    }

    private void initActionMenu() {
        TraceUtil.trace3("Entering");
        TraceUtil.trace3("init action menu");
        this.setActionValue("ActionMenu", "SharedFSDetails.option.heading");
        TraceUtil.trace3("Exiting");
    }

    private void initHeaders() {
        TraceUtil.trace3("Entering");
        this.setActionValue("HostColumn", "SharedFSDetails.heading.host");
        this.setActionValue("TypeColumn", "SharedFSDetails.heading.type");
        this.setActionValue("StateColumn", "SharedFSDetails.heading.state");
        TraceUtil.trace3("Exiting");
    }

    private void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows() throws SamFSException, SamFSMultiHostException {
        TraceUtil.trace3("Entering");
        SharedFSDetailsData recordModel = new SharedFSDetailsData(this.hostName, this.fsName);
        this.clear();
        this.latestRows = new ArrayList();
        boolean allMounted = true;
        boolean allClientNotMounted = true;
        boolean allClientMounted = true;
        boolean mdMounted = false;
        this.partialErrMsg = recordModel.partialErrMsg;
        this.sharedMDServer = recordModel.sharedMDServer;
        for (int i = 0; i < recordModel.size(); ++i) {
            boolean isMounted;
            Object[] record = (Object[])recordModel.get(i);
            this.latestRows.add(new Integer(i));
            if (i > 0) {
                this.appendRow();
            }
            String mountState = (isMounted = ((Boolean)record[2]).booleanValue()) ? SamUtil.getResourceString("FSSummary.mount") : SamUtil.getResourceString("FSSummary.unmount");
            int type = (Integer)record[1];
            allMounted = !isMounted;
            allClientNotMounted = !isMounted || type == 0;
            allClientMounted = isMounted || type == 0;
            mdMounted = isMounted && type == 0;
            this.setValue("HostText", record[0]);
            this.setValue("TypeText", FSUtil.getSharedFSDescriptionString(type));
            this.setValue("StateText", mountState);
            this.setValue("HiddenMount", mountState);
            this.setValue("FSHiddenField", record[0]);
            this.setValue("HiddenType", FSUtil.getSharedFSDescriptionString(type));
            this.setValue("Href", record[0]);
        }
        TraceUtil.trace3("model FsName " + this.fsName);
        TraceUtil.trace3("model HostName " + this.hostName);
        this.setValue("HiddenFsName", this.fsName);
        this.setValue("HiddenHostName", this.hostName);
        this.setValue("HiddenAllMount", allMounted ? "allUnMounted" : "notAllUnMounted");
        this.setValue("HiddenAllClientMount", allClientNotMounted ? "allClientUnMounted" : "notAllClientUnMounted");
        this.setValue("HiddenAllClientMount", allClientMounted ? "allClientMounted" : "");
        this.setValue("HiddenMDMount", mdMounted ? "MDMounted" : "MDUnMounted");
        TraceUtil.trace3("Exiting");
    }
}

