/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.fs.GenericFileSystem;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;

public class FSUtil {
    public static final int FS_DESC_UNKNOWN = -1;
    public static final int FS_DESC_QFS = 0;
    public static final int FS_DESC_QFS_ARCHIVING = 1;
    public static final int FS_DESC_QFS_CLIENT = 2;
    public static final int FS_DESC_QFS_CLIENT_ARCHIVING = 3;
    public static final int FS_DESC_QFS_SERVER = 4;
    public static final int FS_DESC_QFS_SERVER_ARCHIVING = 5;
    public static final int FS_DESC_QFS_POTENTIAL_SERVER = 6;
    public static final int FS_DESC_QFS_POTENTIAL_SERVER_ARCHIVING = 7;
    public static final int FS_DESC_UFS = 8;
    public static final int FS_DESC_NFS_CLIENT = 9;
    public static final int FS_DESC_ZFS = 10;
    public static final int FS_DESC_VXFS = 11;
    public static final String DOTDOTDOT = "...";
    public static final int MAX_MOUNT_POINT_LENGTH = 20;

    public static int getFileSystemDescription(GenericFileSystem myGenericFS) {
        TraceUtil.trace3("Entering");
        int fsDesc = -1;
        block0 : switch (myGenericFS.getFSTypeByProduct()) {
            case 13: {
                if (myGenericFS.getFSTypeName().equalsIgnoreCase("ufs")) {
                    fsDesc = 8;
                    break;
                }
                if (myGenericFS.getFSTypeName().equalsIgnoreCase("vxfs")) {
                    fsDesc = 11;
                    break;
                }
                TraceUtil.trace1("Unknown fs desc: Non-SAM, non-ufs, non-vxfs.");
                break;
            }
            default: {
                FileSystem myFS = (FileSystem)myGenericFS;
                switch (myFS.getShareStatus()) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        switch (myFS.getArchivingType()) {
                            case 2: {
                                fsDesc = FSUtil.getSharedFSDescription(myFS, true);
                                break block0;
                            }
                            case 3: {
                                fsDesc = FSUtil.getSharedFSDescription(myFS, false);
                                break block0;
                            }
                        }
                        TraceUtil.trace1(new NonSyncStringBuffer("Unknown fs desc: shared-SAM, ").append("archiving status unknown").toString());
                        break block0;
                    }
                    case 0: {
                        switch (myFS.getArchivingType()) {
                            case 2: {
                                fsDesc = 1;
                                break block0;
                            }
                            case 3: {
                                fsDesc = 0;
                                break block0;
                            }
                        }
                        TraceUtil.trace1(new NonSyncStringBuffer("Unknown fs desc: unshared-SAM, ").append("archiving status unknown").toString());
                        break block0;
                    }
                }
                TraceUtil.trace1("Unknown fs type: shared status unknown");
            }
        }
        TraceUtil.trace3("Exiting");
        return fsDesc;
    }

    private static int getSharedFSDescription(FileSystem myFS, boolean isArchiving) {
        switch (myFS.getShareStatus()) {
            case 1: {
                if (isArchiving) {
                    return 5;
                }
                return 4;
            }
            case 2: {
                if (isArchiving) {
                    return 7;
                }
                return 6;
            }
            case 3: {
                if (isArchiving) {
                    return 3;
                }
                return 2;
            }
        }
        TraceUtil.trace1("Shared_FS_STATUS is " + myFS.getShareStatus());
        TraceUtil.trace1("Unknown fs desc: Unknown share type!");
        return -1;
    }

    public static String getFileSystemDescriptionString(GenericFileSystem myGenericFS) {
        NonSyncStringBuffer myBuffer = new NonSyncStringBuffer();
        int description = FSUtil.getFileSystemDescription(myGenericFS);
        switch (description) {
            case 0: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.qfs"));
                break;
            }
            case 1: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.qfs.archiving"));
                break;
            }
            case 2: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.qfs.client"));
                break;
            }
            case 3: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.qfs.client.archiving"));
                break;
            }
            case 4: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.qfs.server"));
                break;
            }
            case 5: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.qfs.server.archiving"));
                break;
            }
            case 6: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.qfs.potential.server"));
                break;
            }
            case 7: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.qfs.potential.server.archiving"));
                break;
            }
            case 8: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.ufs"));
                break;
            }
            case 11: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.vxfs"));
                break;
            }
            case 9: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.nfs.client"));
                break;
            }
            default: {
                myBuffer.append(SamUtil.getResourceString("filesystem.desc.unknown"));
                return myBuffer.toString();
            }
        }
        if (myGenericFS.isHA()) {
            myBuffer.append(",").append(SamUtil.getResourceString("filesystem.desc.ha"));
        }
        return myBuffer.toString();
    }

    public static String truncateMountPointString(String mountPoint) {
        if (mountPoint == null) {
            return "";
        }
        if (mountPoint.length() <= 20) {
            return mountPoint;
        }
        String[] mountPointArray = mountPoint.split("/");
        NonSyncStringBuffer myBuffer = null;
        try {
            if (mountPointArray.length == 2) {
                return new NonSyncStringBuffer("/").append(mountPointArray[1].substring(0, 8)).append(DOTDOTDOT).append(mountPointArray[1].substring(mountPointArray[1].length() - 8, mountPointArray[1].length())).toString();
            }
            myBuffer = new NonSyncStringBuffer("/");
            if (mountPointArray[1].length() > 8) {
                myBuffer.append(mountPointArray[1].substring(0, 8));
            } else {
                myBuffer.append(mountPointArray[1]);
                myBuffer.append("/");
            }
            myBuffer.append(DOTDOTDOT);
            int lastSize = 0;
            if (20 - myBuffer.length() < mountPointArray[mountPointArray.length - 1].length()) {
                lastSize = mountPointArray[mountPointArray.length - 1].length() - (20 - myBuffer.length() + 1);
            }
            myBuffer.append(mountPointArray[mountPointArray.length - 1].substring(lastSize, mountPointArray[mountPointArray.length - 1].length()));
        }
        catch (StringIndexOutOfBoundsException ex) {
            TraceUtil.trace1("StringIndexOutOfBoundsException CAUGHT!");
            TraceUtil.trace1("Reason: ex.getMessage()");
            return mountPoint;
        }
        return myBuffer.toString();
    }

    public static String getSharedFSDescriptionString(int sharedFSType) {
        switch (sharedFSType) {
            case 0: {
                return SamUtil.getResourceString("SharedFSDetails.type.mds");
            }
            case 1: {
                return SamUtil.getResourceString("SharedFSDetails.type.pmds");
            }
            case 2: {
                return SamUtil.getResourceString("SharedFSDetails.type.client");
            }
        }
        return SamUtil.getResourceString("SharedFSDetails.type.unknown");
    }
}

