/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.BasicCommandField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.iplanet.jato.view.html.Option;
import com.iplanet.jato.view.html.OptionList;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.fs.FSScheduleDateTime;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.DumpSched;
import com.sun.netstorage.samqfs.web.model.fs.DumpSchedDateTimeModel;
import com.sun.netstorage.samqfs.web.model.fs.DumpSchedRetention;
import com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl;
import com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserModel;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.BreadCrumbUtil;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.FsmVersion;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageInfo;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCDateTimeModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.filechooser.CCFileChooserWindow;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCSelectableList;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

public class FSScheduleDumpView
extends RequestHandlingViewBase {
    public static final String CHILD_SCHEDULE_CALENDAR = "scheduleCalendar";
    public static final String CHILD_FOLDER_CHOOSER = "folderChooser";
    public static final String CHILD_MOUNT_POINT = "mountPoint";
    public static final String CHILD_MOUNT_PROMPT = "mountPointPrompt";
    public static final String CHILD_PRESCRIPT_CHOOSER = "preScriptChooser";
    public static final String CHILD_PRESCRIPT_SKIP = "preScriptSkipOnFatalError";
    public static final String CHILD_POSTSCRIPT_CHOOSER = "postScriptChooser";
    public static final String CHILD_LOGFILE_CHOOSER = "logFileChooser";
    public static final String CHILD_NOTIFICATION_EMAIL = "notificationValue";
    public static final String CHILD_NOTIFICATION_PROMPT = "notificationEditPrompt";
    public static final String CHILD_NOTIFICATION_PROP = "notificationProperty";
    public static final String CHILD_AUTO_INDEX_VAL = "autoIndexValue";
    public static final String CHILD_AUTO_INDEX_PROP = "autoIndex";
    public static final String CHILD_ENABLE_SCHED_VAL = "enableScheduleValue";
    public static final String CHILD_RETENTION_LABEL = "retentionLabel";
    public static final String CHILD_RETENTION_TYPE = "retentionType";
    public static final String CHILD_RETENTION_VAL = "retentionValue";
    public static final String CHILD_RETENTION_UNIT = "retentionUnit";
    public static final String CHILD_RETENTION_PROP = "retention";
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_ERROR_MSG = "errorMsg";
    public static final String CHILD_CONTENTS_SECTION = "snapshotContentsSection";
    public static final String CHILD_CONTENTS_ALERT = "contentsAlert";
    public static final String CHILD_EXCLUDEDIRS_LIST = "contentsExcludeList";
    public static final String CHILD_EXCLUDEDIRS_CHOOSER = "contentsExcludeAdd";
    public static final String CHILD_EXCLUDEDIRS_ADD_CMD = "postExcludeDirAddCmd";
    public static final String CHILD_EXCLUDEDIRS_REMOVE = "contentsExcludeRemove";
    public static final String CHILD_EXCLUDEDIRS_REMOVE_PROMPT = "removePrompt";
    public static final int EXCLUDEDIR_MAX_CNT = 10;
    public static final String EXCLUDEDIR_DUMMY_OPTION = "FSScheduleDump.contents.exclude.dummy";
    public static final String RETENTION_TYPE_ALWAYS = "always";
    public static final String RETENTION_TYPE_UNTIL = "until";
    public static final String CHECKBOX_CHECKED_VALUE = "true";
    public static final String CHECKBOX_UNCHECKED_VALUE = "false";
    public static final String ATTRIBUTE_FORM_DATA = "FSScheduleDumpView.savedFormData";
    public static final String EXCLUDE_DIRS = "excludeDirsList";
    protected CCPropertySheetModel propertySheetModel = null;
    protected CCPageTitleModel pageTitleModel = null;
    protected RemoteFileChooserModel folderChooserModel = null;
    protected RemoteFileChooserModel preScriptChooserModel = null;
    protected RemoteFileChooserModel postScriptChooserModel = null;
    protected RemoteFileChooserModel logFileChooserModel = null;
    protected RemoteFileChooserModel addExcludeDirModel = null;
    protected String serverName = null;
    protected String fileSystemName = null;
    protected String mountPoint = null;
    protected boolean newSchedule = true;
    private FsmVersion version45 = null;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSScheduleDateTime;
    static /* synthetic */ Class class$com$iplanet$jato$view$BasicCommandField;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$admin$AdminNotificationViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSDetailsViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean;

    public FSScheduleDumpView(View parent, String name) {
        super(parent, name);
        TraceUtil.trace3("Entering");
        this.serverName = (String)this.getParentViewBean().getPageSessionAttribute("SERVER_NAME");
        if (this.serverName == null) {
            HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
            this.serverName = (String)session.getAttribute("SERVER_NAME");
        }
        this.fileSystemName = (String)this.getParentViewBean().getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        this.version45 = new FsmVersion("4.5", this.serverName);
        try {
            this.mountPoint = SamUtil.getModel(this.serverName).getSamQFSSystemFSManager().getFileSystem(this.fileSystemName).getMountPoint();
        }
        catch (SamFSException e) {
            this.mountPoint = "/";
        }
        TraceUtil.trace3("Got serverName and fsName from page session: " + this.serverName + ", " + this.fileSystemName);
        this.createPageTitleModel();
        this.createPropertySheetModel();
        this.createFileChooserModels();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = FSScheduleDumpView.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_CONTENTS_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = FSScheduleDumpView.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_FOLDER_CHOOSER, class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl == null ? (class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl = FSScheduleDumpView.class$("com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl")) : class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl);
        this.registerChild(CHILD_PRESCRIPT_CHOOSER, class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl == null ? (class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl = FSScheduleDumpView.class$("com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl")) : class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl);
        this.registerChild(CHILD_POSTSCRIPT_CHOOSER, class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl == null ? (class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl = FSScheduleDumpView.class$("com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl")) : class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl);
        this.registerChild(CHILD_LOGFILE_CHOOSER, class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl == null ? (class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl = FSScheduleDumpView.class$("com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl")) : class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl);
        this.registerChild(CHILD_SCHEDULE_CALENDAR, class$com$sun$netstorage$samqfs$web$fs$FSScheduleDateTime == null ? (class$com$sun$netstorage$samqfs$web$fs$FSScheduleDateTime = FSScheduleDumpView.class$("com.sun.netstorage.samqfs.web.fs.FSScheduleDateTime")) : class$com$sun$netstorage$samqfs$web$fs$FSScheduleDateTime);
        this.registerChild(CHILD_EXCLUDEDIRS_ADD_CMD, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = FSScheduleDumpView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        this.registerChild(CHILD_EXCLUDEDIRS_CHOOSER, class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl == null ? (class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl = FSScheduleDumpView.class$("com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl")) : class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl);
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, this.propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3("Entering with name" + name);
        if (name.equals(CHILD_ALERT)) {
            CCAlertInline child = new CCAlertInline((ContainerView)this, name, null);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_FOLDER_CHOOSER)) {
            RemoteFileChooserControl child = new RemoteFileChooserControl((ContainerView)this, this.folderChooserModel, name);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_PRESCRIPT_CHOOSER)) {
            RemoteFileChooserControl child = new RemoteFileChooserControl((ContainerView)this, this.preScriptChooserModel, name);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_POSTSCRIPT_CHOOSER)) {
            RemoteFileChooserControl child = new RemoteFileChooserControl((ContainerView)this, this.postScriptChooserModel, name);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_LOGFILE_CHOOSER)) {
            RemoteFileChooserControl child = new RemoteFileChooserControl((ContainerView)this, this.logFileChooserModel, name);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_EXCLUDEDIRS_CHOOSER)) {
            RemoteFileChooserControl child = new RemoteFileChooserControl((ContainerView)this, this.addExcludeDirModel, name);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (name.equals(CHILD_SCHEDULE_CALENDAR)) {
            DumpSchedDateTimeModel model = new DumpSchedDateTimeModel();
            FSScheduleDateTime datetime = new FSScheduleDateTime((ContainerView)this, (CCDateTimeModelInterface)model, name);
            TraceUtil.trace3("Exiting");
            return datetime;
        }
        if (name.equals(CHILD_EXCLUDEDIRS_ADD_CMD)) {
            TraceUtil.trace3("Exiting");
            return new BasicCommandField((View)this, name);
        }
        if (name.equals(CHILD_CONTENTS_ALERT)) {
            TraceUtil.trace3("Exiting");
            return new CCAlertInline((ContainerView)this, name, null);
        }
        if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            TraceUtil.trace3("Exiting");
            return PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        }
        if (PropertySheetUtil.isChildSupported(this.propertySheetModel, name)) {
            TraceUtil.trace3("Exiting");
            return PropertySheetUtil.createChild((ContainerView)this, this.propertySheetModel, name);
        }
        return null;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.FILESYSTEM_OPERATOR)) {
            ((CCButton)this.getChild("SaveButton")).setDisabled(true);
            ((CCButton)this.getChild("ResetButton")).setDisabled(true);
            ((CCButton)this.getChild("CancelButton")).setDisabled(true);
        }
        if (this.newSchedule) {
            this.pageTitleModel.setPageTitleText(SamUtil.getResourceString("FSScheduleDump.title.new", this.fileSystemName));
        } else {
            this.pageTitleModel.setPageTitleText(SamUtil.getResourceString("FSScheduleDump.title.edit", this.fileSystemName));
        }
        CCHiddenField errorMsg = (CCHiddenField)this.getChild(CHILD_ERROR_MSG);
        errorMsg.setValue((Object)SamUtil.getResourceString("FSScheduleDump.error.locationBad"));
        TraceUtil.trace3("Exiting");
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/fs/FSScheduleDumpPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (this.propertySheetModel == null) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/fs/FSScheduleDumpPropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.propertySheetModel;
    }

    private void createFileChooserModels() {
        TraceUtil.trace3("Entering");
        if (this.folderChooserModel == null) {
            this.folderChooserModel = new RemoteFileChooserModel(this.serverName, 50);
            this.folderChooserModel.setFileListBoxHeight(15);
            this.folderChooserModel.setHomeDirectory("/");
            this.folderChooserModel.setProductNameAlt("secondaryMasthead.productNameAlt");
            this.folderChooserModel.setProductNameSrc("secondaryMasthead.productNameSrc");
            this.folderChooserModel.setPopupMode(true);
        }
        if (this.preScriptChooserModel == null) {
            this.preScriptChooserModel = new RemoteFileChooserModel(this.serverName, 50);
            this.preScriptChooserModel.setFileListBoxHeight(15);
            this.preScriptChooserModel.setHomeDirectory("/");
            this.preScriptChooserModel.setProductNameAlt("secondaryMasthead.productNameAlt");
            this.preScriptChooserModel.setProductNameSrc("secondaryMasthead.productNameSrc");
            this.preScriptChooserModel.setPopupMode(true);
        }
        if (this.postScriptChooserModel == null) {
            this.postScriptChooserModel = new RemoteFileChooserModel(this.serverName, 50);
            this.postScriptChooserModel.setFileListBoxHeight(15);
            this.postScriptChooserModel.setHomeDirectory("/");
            this.postScriptChooserModel.setProductNameAlt("secondaryMasthead.productNameAlt");
            this.postScriptChooserModel.setProductNameSrc("secondaryMasthead.productNameSrc");
            this.postScriptChooserModel.setPopupMode(true);
        }
        if (this.logFileChooserModel == null) {
            this.logFileChooserModel = new RemoteFileChooserModel(this.serverName, 50);
            this.logFileChooserModel.setFileListBoxHeight(15);
            this.logFileChooserModel.setHomeDirectory("/");
            this.logFileChooserModel.setProductNameAlt("secondaryMasthead.productNameAlt");
            this.logFileChooserModel.setProductNameSrc("secondaryMasthead.productNameSrc");
            this.logFileChooserModel.setPopupMode(true);
        }
        if (this.addExcludeDirModel == null) {
            this.addExcludeDirModel = new RemoteFileChooserModel(this.serverName, 50);
            this.addExcludeDirModel.setFileListBoxHeight(15);
            this.addExcludeDirModel.setHomeDirectory(this.mountPoint);
            this.addExcludeDirModel.setProductNameAlt("secondaryMasthead.productNameAlt");
            this.addExcludeDirModel.setProductNameSrc("secondaryMasthead.productNameSrc");
            this.addExcludeDirModel.setPopupMode(true);
        }
        TraceUtil.trace3("Exiting");
    }

    public void loadPropertySheetModel() throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        CCCheckBox enableSchedule = (CCCheckBox)this.getChild(CHILD_ENABLE_SCHED_VAL);
        CCCheckBox autoIndex = (CCCheckBox)this.getChild(CHILD_AUTO_INDEX_VAL);
        CCCheckBox preScriptSkip = (CCCheckBox)this.getChild(CHILD_PRESCRIPT_SKIP);
        CCDropDownMenu retentionUnit = (CCDropDownMenu)this.getChild(CHILD_RETENTION_UNIT);
        CCSelectableList excludeDirs = (CCSelectableList)this.getChild(CHILD_EXCLUDEDIRS_LIST);
        CCSelectableList emailList = (CCSelectableList)this.getChild(CHILD_NOTIFICATION_EMAIL);
        if (this.version45.isAPICompatibleWithUI()) {
            this.propertySheetModel.setVisible(CHILD_AUTO_INDEX_PROP, true);
            this.propertySheetModel.setVisible(CHILD_RETENTION_PROP, true);
            enableSchedule.setVisible(true);
            this.propertySheetModel.setValue(CHILD_EXCLUDEDIRS_REMOVE_PROMPT, (Object)SamUtil.getResourceString("FSScheduleDump.contents.exclude.remove.prompt"));
            OptionList units = new OptionList(new Option[]{new Option(SamUtil.getResourceString("FSScheduleDump.retention.days"), "D"), new Option(SamUtil.getResourceString("FSScheduleDump.retention.weeks"), "W"), new Option(SamUtil.getResourceString("FSScheduleDump.retention.months"), "M"), new Option(SamUtil.getResourceString("FSScheduleDump.retention.years"), "Y")});
            retentionUnit.setOptions(units);
            String emails = sysModel.getSamQFSSystemAdminManager().getNotificationEmailsForSubject(4);
            Object[] emailArray = emails.split(",");
            Arrays.sort(emailArray);
            OptionList ol = new OptionList((String[])emailArray, (String[])emailArray);
            ol.add(0, SamUtil.getResourceString("FSScheduleDump.psheet.notification.dummy"), "");
            emailList.setOptions(ol);
            this.setDisplayFieldValue(CHILD_NOTIFICATION_PROMPT, SamUtil.getResourceString("FSScheduleDump.psheet.notification.editPrompt"));
        } else {
            this.propertySheetModel.setVisible(CHILD_AUTO_INDEX_PROP, false);
            this.propertySheetModel.setVisible(CHILD_RETENTION_PROP, false);
            this.propertySheetModel.setVisible(CHILD_CONTENTS_SECTION, false);
            this.propertySheetModel.setVisible(CHILD_NOTIFICATION_PROP, false);
            enableSchedule.setVisible(false);
            preScriptSkip.setVisible(false);
            excludeDirs.setVisible(false);
        }
        this.propertySheetModel.setValue(CHILD_MOUNT_POINT, (Object)this.mountPoint);
        this.propertySheetModel.setValue(CHILD_MOUNT_PROMPT, (Object)SamUtil.getResourceString("FSScheduleDump.psheet.location.prompt"));
        DumpSched dumpChanges = (DumpSched)this.getParentViewBean().getPageSessionAttribute(ATTRIBUTE_FORM_DATA);
        DumpSched dumpSaved = sysModel.getSamQFSSystemFSManager().getMetadataDumpSchedParams(this.fileSystemName);
        DumpSched dump = null;
        if (dumpChanges != null) {
            dump = dumpChanges;
        } else if (dumpSaved != null) {
            dump = dumpSaved;
        }
        if (dump != null) {
            this.newSchedule = dumpSaved == null;
            CCFileChooserWindow folderChooser = (CCFileChooserWindow)this.getChild(CHILD_FOLDER_CHOOSER);
            folderChooser.setDisplayFieldValue("browsetextfield", (Object)dump.getLocation());
            this.propertySheetModel.setValue("namePrefixValue", (Object)dump.getFilePrefix());
            this.propertySheetModel.setValue("compressionValue", (Object)dump.getCompress());
            CCFileChooserWindow preScriptChooser = (CCFileChooserWindow)this.getChild(CHILD_PRESCRIPT_CHOOSER);
            preScriptChooser.setDisplayFieldValue("browsetextfield", (Object)dump.getPrescript());
            CCFileChooserWindow postScriptChooser = (CCFileChooserWindow)this.getChild(CHILD_POSTSCRIPT_CHOOSER);
            postScriptChooser.setDisplayFieldValue("browsetextfield", (Object)dump.getPostscript());
            CCFileChooserWindow logFileChooser = (CCFileChooserWindow)this.getChild(CHILD_LOGFILE_CHOOSER);
            logFileChooser.setDisplayFieldValue("browsetextfield", (Object)dump.getLogPath());
            FSScheduleDateTime datetime = (FSScheduleDateTime)this.getChild(CHILD_SCHEDULE_CALENDAR);
            DumpSchedDateTimeModel model = (DumpSchedDateTimeModel)datetime.getModel();
            long time = dump.getStartTimeInMillis();
            model.setStartDateTime(new Date(time));
            model.setSelectedRepeatIntervalName(DumpSchedDateTimeModel.getIntervalNameFromUnit(dump.getRepeatCnt()));
            if (this.version45.isAPICompatibleWithUI()) {
                autoIndex.setChecked(dump.getAutoindex().booleanValue());
                enableSchedule.setChecked(dump.getEnabled().booleanValue());
                preScriptSkip.setChecked(dump.getPreScriptSkip().booleanValue());
                DumpSchedRetention retentionScheme = dump.getRetentionScheme();
                if (retentionScheme == null) {
                    this.setDisplayFieldValue(CHILD_RETENTION_TYPE, RETENTION_TYPE_ALWAYS);
                    this.setDisplayFieldValue(CHILD_RETENTION_VAL, "");
                    this.setDisplayFieldValue(CHILD_RETENTION_UNIT, "");
                } else {
                    this.setDisplayFieldValue(CHILD_RETENTION_TYPE, RETENTION_TYPE_UNTIL);
                    this.setDisplayFieldValue(CHILD_RETENTION_VAL, retentionScheme.getValue());
                    this.setDisplayFieldValue(CHILD_RETENTION_UNIT, retentionScheme.getUnit());
                }
                String dirsStr = dump.getExcludeDirs();
                this.getParentViewBean().setPageSessionAttribute(EXCLUDE_DIRS, (Serializable)((Object)dirsStr));
                String[] dirsArray = null;
                dirsArray = dirsStr != null && dirsStr.length() > 0 ? dirsStr.split(":") : new String[]{};
                OptionList optList = new OptionList();
                optList.setOptions(dirsArray, dirsArray);
                optList.add(0, SamUtil.getResourceString(EXCLUDEDIR_DUMMY_OPTION), "");
                excludeDirs.setOptions(optList);
            }
        } else {
            this.newSchedule = true;
            this.propertySheetModel.setValue("namePrefixValue", (Object)this.fileSystemName);
            this.propertySheetModel.setValue("compressionValue", (Object)"compress");
            if (this.version45.isAPICompatibleWithUI()) {
                enableSchedule.setCheckedValue((Object)CHECKBOX_CHECKED_VALUE);
                enableSchedule.setValue((Object)CHECKBOX_CHECKED_VALUE);
                autoIndex.setCheckedValue((Object)CHECKBOX_CHECKED_VALUE);
                autoIndex.setValue((Object)CHECKBOX_CHECKED_VALUE);
                preScriptSkip.setCheckedValue((Object)CHECKBOX_CHECKED_VALUE);
                this.setDisplayFieldValue(CHILD_RETENTION_TYPE, RETENTION_TYPE_ALWAYS);
                this.setDisplayFieldValue(CHILD_RETENTION_VAL, "");
                this.setDisplayFieldValue(CHILD_RETENTION_UNIT, "");
                OptionList optList = new OptionList();
                optList.add(0, SamUtil.getResourceString(EXCLUDEDIR_DUMMY_OPTION), "");
                excludeDirs.setOptions(optList);
            }
        }
        this.getParentViewBean().setPageSessionAttribute(ATTRIBUTE_FORM_DATA, null);
        TraceUtil.trace3("Exiting");
    }

    public void handlePostExcludeDirAddCmdRequest(RequestInvocationEvent event) {
        int i;
        TraceUtil.trace3("Entering");
        String excludeDirs = (String)this.getParentViewBean().getPageSessionAttribute(EXCLUDE_DIRS);
        if (excludeDirs == null) {
            excludeDirs = "";
        }
        TreeSet excludeDirsSet = SamUtil.delimitedStringToTreeSet(excludeDirs, ":");
        RemoteFileChooserControl excludeDirChooser = (RemoteFileChooserControl)this.getChild(CHILD_EXCLUDEDIRS_CHOOSER);
        String newDirList = excludeDirChooser.getDisplayFieldStringValue("pathHidden");
        String[] newDirs = newDirList.split(";");
        int mountPointLen = this.mountPoint.length();
        boolean isRootMountPoint = this.mountPoint.equals("/");
        for (i = 0; i < newDirs.length && excludeDirsSet.size() < 10; ++i) {
            NonSyncStringBuffer relativePath = new NonSyncStringBuffer(".");
            if (isRootMountPoint) {
                relativePath.append(newDirs[i]);
            } else {
                relativePath.append(newDirs[i].substring(mountPointLen));
            }
            excludeDirsSet.add(relativePath.toString());
        }
        if (excludeDirsSet.size() >= 10 && i < newDirs.length) {
            NonSyncStringBuffer buf = new NonSyncStringBuffer();
            while (i < newDirs.length) {
                buf.appendDelimited(" ", (Object)newDirs[i]);
                ++i;
            }
            SamUtil.setInfoAlert((ContainerView)this, CHILD_CONTENTS_ALERT, "FSScheduleDump.contents.exclude.errorSummary", SamUtil.getResourceString("FSScheduleDump.contents.exclude.errorDetail", new String[]{Integer.toString(10), buf.toString()}), this.serverName);
        }
        excludeDirs = SamUtil.treeSetToDelimitedString(excludeDirsSet, ":");
        this.getParentViewBean().setPageSessionAttribute(EXCLUDE_DIRS, (Serializable)((Object)excludeDirs));
        DumpSched sched = this.getUserInput(true);
        if (sched != null) {
            this.getParentViewBean().setPageSessionAttribute(ATTRIBUTE_FORM_DATA, (Serializable)sched);
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleContentsExcludeRemoveRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        String excludeDirs = (String)this.getParentViewBean().getPageSessionAttribute(EXCLUDE_DIRS);
        if (excludeDirs == null) {
            excludeDirs = "";
        }
        TreeSet excludeDirsSet = SamUtil.delimitedStringToTreeSet(excludeDirs, ":");
        CCSelectableList excludeDirsList = (CCSelectableList)this.getChild(CHILD_EXCLUDEDIRS_LIST);
        excludeDirsList.restoreStateData();
        Object[] selectedDirs = excludeDirsList.getValues();
        for (int i = 0; i < selectedDirs.length; ++i) {
            excludeDirsSet.remove(selectedDirs[i]);
        }
        excludeDirs = SamUtil.treeSetToDelimitedString(excludeDirsSet, ":");
        this.getParentViewBean().setPageSessionAttribute(EXCLUDE_DIRS, (Serializable)((Object)excludeDirs));
        DumpSched sched = this.getUserInput(true);
        if (sched != null) {
            this.getParentViewBean().setPageSessionAttribute(ATTRIBUTE_FORM_DATA, (Serializable)sched);
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleNotificationEditRequest(RequestInvocationEvent event) {
        TraceUtil.trace3("Entering");
        CommonViewBeanBase vb = (CommonViewBeanBase)this.getParentViewBean();
        DumpSched sched = this.getUserInput(false);
        if (sched != null) {
            vb.setPageSessionAttribute(ATTRIBUTE_FORM_DATA, sched);
        }
        vb.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)this.fileSystemName));
        BreadCrumbUtil.breadCrumbPathForward((ViewBean)vb, PageInfo.getPageInfo().getPageNumber(vb.getName()));
        CommonViewBeanBase notifSummaryVb = (CommonViewBeanBase)this.getViewBean(class$com$sun$netstorage$samqfs$web$admin$AdminNotificationViewBean == null ? (class$com$sun$netstorage$samqfs$web$admin$AdminNotificationViewBean = FSScheduleDumpView.class$("com.sun.netstorage.samqfs.web.admin.AdminNotificationViewBean")) : class$com$sun$netstorage$samqfs$web$admin$AdminNotificationViewBean);
        vb.forwardToWithAttributes(notifSummaryVb, new String[]{ATTRIBUTE_FORM_DATA});
        TraceUtil.trace3("Exiting");
    }

    public void handleSaveButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, SamFSException {
        TraceUtil.trace3("Entering");
        try {
            DumpSched dumpSchedule = this.getUserInput(false);
            if (dumpSchedule == null) {
                this.getParentViewBean().forwardTo(this.getRequestContext());
                TraceUtil.trace3("Exiting");
                return;
            }
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleSaveButtonRequest", "Starting save the dump schedule");
            sysModel.getSamQFSSystemFSManager().setMetadataDumpSchedParams(this.fileSystemName, dumpSchedule);
            TraceUtil.trace3("Set dump params = " + dumpSchedule);
            this.forwardToTargetPage(true);
        }
        catch (SamFSException e) {
            SamUtil.processException((Exception)((Object)e), ((Object)((Object)this)).getClass(), "handleSaveButtonRequest()", "Unable to save snapshot schedule", this.serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), CHILD_ALERT, "FSScheduleDump.save.error", e.getSAMerrno(), e.getMessage(), this.serverName);
            this.getParentViewBean().forwardTo(this.getRequestContext());
        }
        TraceUtil.trace3("Exiting");
    }

    public DumpSched getUserInput(boolean skipValidation) {
        TraceUtil.trace3("Entering");
        String namePrefix = (String)this.getDisplayFieldValue("namePrefixValue");
        String compress = (String)this.getDisplayFieldValue("compressionValue");
        CCFileChooserWindow folderChooser = (CCFileChooserWindow)this.getChild(CHILD_FOLDER_CHOOSER);
        String location = (String)folderChooser.getDisplayFieldValue("browsetextfield");
        CCFileChooserWindow preScriptChooser = (CCFileChooserWindow)this.getChild(CHILD_PRESCRIPT_CHOOSER);
        String preScript = (String)preScriptChooser.getDisplayFieldValue("browsetextfield");
        CCFileChooserWindow postScriptChooser = (CCFileChooserWindow)this.getChild(CHILD_POSTSCRIPT_CHOOSER);
        String postScript = (String)postScriptChooser.getDisplayFieldValue("browsetextfield");
        CCFileChooserWindow logFileChooser = (CCFileChooserWindow)this.getChild(CHILD_LOGFILE_CHOOSER);
        String logFile = (String)logFileChooser.getDisplayFieldValue("browsetextfield");
        Boolean autoIndex = null;
        Boolean enableSchedule = null;
        Boolean preScriptSkip = null;
        DumpSchedRetention retentionSchema = null;
        String excludeDirList = null;
        if (this.version45.isAPICompatibleWithUI()) {
            autoIndex = new Boolean(this.getDisplayFieldBooleanValue(CHILD_AUTO_INDEX_VAL));
            enableSchedule = new Boolean(this.getDisplayFieldBooleanValue(CHILD_ENABLE_SCHED_VAL));
            preScriptSkip = preScript != null && preScript.length() > 0 ? new Boolean(this.getDisplayFieldBooleanValue(CHILD_PRESCRIPT_SKIP)) : Boolean.FALSE;
            String retentionType = this.getDisplayFieldStringValue(CHILD_RETENTION_TYPE);
            if (retentionType.equals(RETENTION_TYPE_UNTIL)) {
                int retValue = -1;
                try {
                    retValue = Integer.parseInt(this.getDisplayFieldStringValue(CHILD_RETENTION_VAL));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                if (retValue <= 0) {
                    SamFSException samEx = new SamFSException();
                    SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), CHILD_ALERT, SamUtil.getResourceString("FSScheduleDump.retention.error", SamUtil.getResourceString("FSScheduleDump.retention.always")), samEx.getSAMerrno(), samEx.getMessage());
                    return null;
                }
                retentionSchema = new DumpSchedRetention(retValue, this.getDisplayFieldStringValue(CHILD_RETENTION_UNIT));
            }
            excludeDirList = (String)this.getParentViewBean().getPageSessionAttribute(EXCLUDE_DIRS);
        }
        FSScheduleDateTime datetime = (FSScheduleDateTime)this.getChild(CHILD_SCHEDULE_CALENDAR);
        if (!skipValidation && !datetime.validateDataInput()) {
            return null;
        }
        DumpSchedDateTimeModel model = (DumpSchedDateTimeModel)datetime.getModel();
        long startTime = model.getStartDateTime().getTime();
        TraceUtil.trace3("start time = " + startTime);
        long repeat = DumpSchedDateTimeModel.getIntervalUnitFromName(model.getSelectedRepeatIntervalName());
        String namePattern = this.makeNamePattern(namePrefix, repeat);
        DumpSched dumpSchedule = new DumpSched(startTime / 1000L, repeat, preScript, preScriptSkip, postScript, logFile, location, excludeDirList, namePrefix, namePattern, compress, autoIndex, enableSchedule, retentionSchema);
        TraceUtil.trace3("Exiting");
        return dumpSchedule;
    }

    private String makeNamePattern(String namePrefix, long repeatInterval) {
        NonSyncStringBuffer pre = new NonSyncStringBuffer(namePrefix);
        if (namePrefix.indexOf("%Y") == -1) {
            pre.append("-%Y");
        }
        if (namePrefix.indexOf("%m") == -1) {
            pre.append("-%m");
        }
        if (namePrefix.indexOf("%d") == -1) {
            pre.append("-%d");
        }
        if (namePrefix.indexOf("%H") == -1) {
            pre.append("T%H");
        }
        if (namePrefix.indexOf("%M") == -1) {
            pre.append(":%M");
        }
        return pre.toString();
    }

    public void handleResetButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        FSScheduleDateTime dateTime = (FSScheduleDateTime)this.getChild(CHILD_SCHEDULE_CALENDAR);
        dateTime.resetStateData();
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleCancelButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        this.forwardToTargetPage(false);
        TraceUtil.trace3("Exiting");
    }

    private void forwardToTargetPage(boolean showAlert) {
        ViewBean targetView = null;
        String s = null;
        ViewBean vb = this.getParentViewBean();
        Integer[] temp = (Integer[])vb.getPageSessionAttribute("PAGE_PATH");
        Integer[] path = BreadCrumbUtil.getBreadCrumbDisplay(temp);
        int index = path[path.length - 1];
        PageInfo pageInfo = PageInfo.getPageInfo();
        String targetName = pageInfo.getPagePath(index).getCommandField();
        TraceUtil.trace3("target name = " + targetName);
        if (targetName.equals("FileSystemDetailsHref")) {
            targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSDetailsViewBean = FSScheduleDumpView.class$("com.sun.netstorage.samqfs.web.fs.FSDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSDetailsViewBean);
            s = Integer.toString(BreadCrumbUtil.inPagePath(path, index, path.length - 1));
        } else if (targetName.equals("SharedFSDetailsHref")) {
            targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean = FSScheduleDumpView.class$("com.sun.netstorage.samqfs.web.fs.SharedFSDetailsViewBean")) : class$com$sun$netstorage$samqfs$web$fs$SharedFSDetailsViewBean);
            s = Integer.toString(BreadCrumbUtil.inPagePath(path, index, path.length - 1));
        } else if (targetName.equals("FileSystemSummaryHref")) {
            targetView = this.getViewBean(class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean == null ? (class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean = FSScheduleDumpView.class$("com.sun.netstorage.samqfs.web.fs.FSSummaryViewBean")) : class$com$sun$netstorage$samqfs$web$fs$FSSummaryViewBean);
            s = Integer.toString(BreadCrumbUtil.inPagePath(path, index, path.length - 1));
        }
        if (showAlert) {
            this.showAlert(targetView);
        }
        BreadCrumbUtil.breadCrumbPathBackward(vb, PageInfo.getPageInfo().getPageNumber(targetView.getName()), s);
        ((CommonViewBeanBase)vb).forwardTo(targetView);
    }

    private void showAlert(ViewBean targetView) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)targetView, CHILD_ALERT, "success.summary", "FSScheduleDump.save.success", this.serverName);
        TraceUtil.trace3("Exiting");
    }

    private void setPageActionButtonState(String permission) {
        TraceUtil.trace3("Entering");
        if (permission.equals("READ")) {
            ((CCButton)this.getChild("SaveButton")).setDisabled(true);
            ((CCButton)this.getChild("ResetButton")).setDisabled(true);
            ((CCButton)this.getChild("CancelButton")).setDisabled(true);
        }
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

