/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.RequestHandlingViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.fs.FSDumpNowPopUpViewBean;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.DumpSched;
import com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl;
import com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserModel;
import com.sun.netstorage.samqfs.web.util.CommonSecondaryViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import javax.servlet.ServletException;

public class FSDumpNowPopUpView
extends RequestHandlingViewBase {
    public static final String CHILD_PATH_CHOOSER = "pathChooser";
    protected RemoteFileChooserModel pathChooserModel = null;
    protected CCPropertySheetModel propertySheetModel = null;
    protected CCPageTitleModel pageTitleModel = null;
    private boolean newSchedule = true;
    private String serverName = null;
    private String fileSystemName = null;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl;

    public FSDumpNowPopUpView(View parent, String name) {
        super(parent, name);
        TraceUtil.trace3("Entering");
        this.serverName = ((FSDumpNowPopUpViewBean)parent).getServerName();
        this.fileSystemName = ((FSDumpNowPopUpViewBean)parent).getFSName();
        this.createPageTitleModel();
        this.createPropertySheetModel();
        this.createFileChooserModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(CHILD_PATH_CHOOSER, class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl == null ? (class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl = FSDumpNowPopUpView.class$("com.sun.netstorage.samqfs.web.remotefilechooser.RemoteFileChooserControl")) : class$com$sun$netstorage$samqfs$web$remotefilechooser$RemoteFileChooserControl);
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, this.propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3("Entering with name" + name);
        if (name.equals(CHILD_PATH_CHOOSER)) {
            RemoteFileChooserControl child = new RemoteFileChooserControl((ContainerView)this, this.pathChooserModel, name);
            TraceUtil.trace3("Exiting");
            return child;
        }
        if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            return PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        }
        if (PropertySheetUtil.isChildSupported(this.propertySheetModel, name)) {
            TraceUtil.trace3("Exiting");
            return PropertySheetUtil.createChild((ContainerView)this, this.propertySheetModel, name);
        }
        return null;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.pageTitleModel.setPageTitleText(SamUtil.getResourceString("FSDumpNow.title", this.fileSystemName));
        TraceUtil.trace3("Exiting");
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (this.pageTitleModel == null) {
            this.pageTitleModel = PageTitleUtil.createModel("/jsp/fs/FSPopupPageTitle.xml");
            this.pageTitleModel.setValue("Submit", (Object)"common.button.submit");
            this.pageTitleModel.setValue("Cancel", (Object)"common.button.cancel");
        }
        TraceUtil.trace3("Exiting");
        return this.pageTitleModel;
    }

    private CCPropertySheetModel createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (this.propertySheetModel == null) {
            this.propertySheetModel = PropertySheetUtil.createModel("/jsp/fs/FSDumpNowPropertySheet.xml");
        }
        TraceUtil.trace3("Exiting");
        return this.propertySheetModel;
    }

    private void createFileChooserModel() {
        this.pathChooserModel = new RemoteFileChooserModel(this.serverName, 50);
        this.pathChooserModel.setFileListBoxHeight(15);
        this.pathChooserModel.setHomeDirectory("/");
        this.pathChooserModel.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.pathChooserModel.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.pathChooserModel.setPopupMode(true);
    }

    public void loadPropertySheetModel() throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        DumpSched dump = sysModel.getSamQFSSystemFSManager().getMetadataDumpSchedParams(this.fileSystemName);
        if (dump != null) {
            this.newSchedule = false;
            NonSyncStringBuffer defPath = new NonSyncStringBuffer().append(dump.getLocation());
            if (!dump.getLocation().endsWith("/")) {
                defPath.append("/");
            }
            defPath.append(this.fileSystemName);
            GregorianCalendar now = new GregorianCalendar();
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm");
            defPath.append("-").append(fmt.format(now.getTime()));
            RemoteFileChooserControl pathChooser = (RemoteFileChooserControl)this.getChild(CHILD_PATH_CHOOSER);
            pathChooser.setDisplayFieldValue("browsetextfield", defPath.toString());
        } else {
            this.newSchedule = true;
        }
        TraceUtil.trace3("Exiting");
    }

    public void handleSubmitRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        CommonSecondaryViewBeanBase parent = (CommonSecondaryViewBeanBase)this.getParentViewBean();
        String dumpPath = ((ContainerViewBase)this.getChild(CHILD_PATH_CHOOSER)).getDisplayFieldStringValue("browsetextfield");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            LogUtil.info(((Object)((Object)this)).getClass(), "handleSubmitRequest", "Starting backing up metadata for fs " + this.fileSystemName);
            long jobID = sysModel.getSamQFSSystemFSManager().startMetadataDump(this.fileSystemName, dumpPath);
            LogUtil.info(((Object)((Object)this)).getClass(), "handleSubmitRequest", "Done backing up metadata for fs " + this.fileSystemName);
            if (jobID != -1L) {
                StringBuffer href = new StringBuffer();
                href.append("<a href=\"../fs/FSSummary?FSSummary.").append("FileSystemSummaryView.JobIdHref=").append(jobID).append(",").append("Jobs.jobType.dump").append(",Current").append("\" ").append("name=\"FSSummary.FileSystemSummaryView.").append("JobIdHref").append("\" ").append("onclick=\"javascript:").append("var f=document.FSSummaryForm;").append("if (f != null) ").append("{f.action=this.href;f.submit();").append("return false}\">").append(SamUtil.getResourceString("FSRestore.jobIdLink")).append("</a>");
                SamUtil.setInfoAlert((ContainerView)parent, "Alert", "success.summary", SamUtil.getResourceString("FSSummary.dumpMetadataJobStarted", new String[]{this.fileSystemName, String.valueOf(jobID), Long.toString(jobID)}), this.serverName);
            } else {
                SamUtil.setInfoAlert((ContainerView)parent, "Alert", "success.summary", SamUtil.getResourceString("FSSummary.dumpMetadataJobCompleted", this.fileSystemName), this.serverName);
                ((CommonSecondaryViewBeanBase)this.getParentViewBean()).setSubmitSuccessful(true);
            }
        }
        catch (SamFSException ex) {
            SamUtil.setErrorAlert((ContainerView)parent, "Alert", "FSSummary.error.dumpNow", ex.getSAMerrno(), ex.getMessage(), this.serverName);
        }
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

