/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.fs.FSDevicesModel;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCPageTitleModel;
import java.io.Serializable;
import javax.servlet.http.HttpSession;

public class FSDevicesView
extends CommonTableContainerView {
    protected CCPageTitleModel pageTitleModel = null;
    protected String fsName;
    protected String serverName;
    protected FSDevicesModel model;

    public FSDevicesView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.CHILD_ACTION_TABLE = "FSDevicesTable";
        ViewBean vb = this.getParentViewBean();
        this.serverName = (String)vb.getPageSessionAttribute("SERVER_NAME");
        this.fsName = (String)vb.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        TraceUtil.trace2("Got serverName and fsName from page session: " + this.serverName + ", " + this.fsName);
        if (this.serverName == null || this.fsName == null) {
            HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
            this.serverName = (String)session.getAttribute("SERVER_NAME");
            this.fsName = (String)session.getAttribute("FS_NAME");
            vb.setPageSessionAttribute("SERVER_NAME", (Serializable)((Object)this.serverName));
            vb.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)this.fsName));
        }
        this.pageTitleModel = this.createPageTitleModel();
        this.model = new FSDevicesModel(this.serverName, this.fsName);
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        PageTitleUtil.registerChildren((ContainerViewBase)this, this.pageTitleModel);
        super.registerChildren(this.model);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        TraceUtil.trace3("Entering");
        if (PageTitleUtil.isChildSupported(this.pageTitleModel, name)) {
            TraceUtil.trace3("Exiting");
            return PageTitleUtil.createChild((ContainerView)this, this.pageTitleModel, name);
        }
        TraceUtil.trace3("Exiting");
        return super.createChild(this.model, name);
    }

    private CCPageTitleModel createPageTitleModel() {
        TraceUtil.trace3("Entering");
        CCPageTitleModel model = PageTitleUtil.createModel("/jsp/fs/FSDevicesPageTitle.xml");
        model.setPageTitleText(this.fsName + " Devices");
        TraceUtil.trace3("Exiting");
        return model;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.pageTitleModel.setPageTitleText(SamUtil.getResourceString("FSDevices.pageTitle1", this.fsName));
        TraceUtil.trace3("Exiting");
    }

    public void populateData() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.model.initModelRows();
        TraceUtil.trace3("Exiting");
    }
}

