/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.model.media.DiskCache;
import com.sun.netstorage.samqfs.web.model.media.StripedGroup;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;

public final class FSDevicesData
extends ArrayList {
    protected String fsName = null;
    protected String serverName = null;
    public static final String[] headings = new String[]{"FSDevices.heading1", "FSDevices.heading2", "FSDevices.heading3", "FSDevices.heading4", "FSDevices.heading5", "FSDevices.heading6", "FSDevices.heading7"};

    public FSDevicesData(String serverName, String fsName) throws SamFSException {
        int consumed;
        long free;
        int deviceCache;
        int i;
        String type;
        String name;
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.serverName = serverName;
        this.fsName = fsName;
        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
        FileSystem fs2 = sysModel.getSamQFSSystemFSManager().getFileSystem(fsName);
        if (fs2 == null) {
            throw new SamFSException(null, -1000);
        }
        boolean isMounted = fs2.getState() == 0;
        DiskCache[] metaDevices = fs2.getMetadataDevices();
        DiskCache[] dataDevices = fs2.getDataDevices();
        StripedGroup[] group = fs2.getStripedGroups();
        if (metaDevices != null) {
            name = null;
            type = null;
            int eq = 0;
            int consumed2 = 0;
            long cap = 0L;
            long free2 = 0L;
            for (i = 0; i < metaDevices.length; ++i) {
                name = metaDevices[i].getDevicePath();
                eq = metaDevices[i].getEquipOrdinal();
                deviceCache = metaDevices[i].getDiskCacheType();
                if (deviceCache == 1) {
                    type = "FSDevices.devicetype1";
                } else if (deviceCache == 2) {
                    type = "FSDevices.devicetype2";
                } else if (deviceCache == 3) {
                    type = "FSDevices.devicetype3";
                } else if (deviceCache == 0) {
                    type = "FSDevices.devicetype4";
                }
                type = SamUtil.getResourceString(type);
                int temp = metaDevices[i].getNoOfInodesRemaining();
                cap = metaDevices[i].getCapacity();
                free2 = metaDevices[i].getAvailableSpace();
                consumed2 = metaDevices[i].getConsumedSpacePercentage();
                if (isMounted) {
                    super.add(new Object[]{name, type, new Integer(temp), new Integer(eq), new Capacity(cap, 2), new Capacity(free2, 2), new Integer(consumed2)});
                    continue;
                }
                super.add(new Object[]{name, type, new Integer(temp), new Integer(eq), "", "", ""});
            }
        }
        if (dataDevices != null) {
            name = null;
            type = null;
            long cap = 0L;
            free = 0L;
            int eq = 0;
            consumed = 0;
            for (i = 0; i < dataDevices.length; ++i) {
                name = dataDevices[i].getDevicePath();
                eq = dataDevices[i].getEquipOrdinal();
                deviceCache = dataDevices[i].getDiskCacheType();
                if (deviceCache == 1) {
                    type = "FSDevices.devicetype1";
                } else if (deviceCache == 2) {
                    type = "FSDevices.devicetype2";
                } else if (deviceCache == 3) {
                    type = "FSDevices.devicetype3";
                } else if (deviceCache == 0) {
                    type = "FSDevices.devicetype4";
                }
                type = SamUtil.getResourceString(type);
                String inode = "";
                cap = dataDevices[i].getCapacity();
                free = dataDevices[i].getAvailableSpace();
                consumed = dataDevices[i].getConsumedSpacePercentage();
                if (isMounted) {
                    super.add(new Object[]{name, type, inode, new Integer(eq), new Capacity(cap, 2), new Capacity(free, 2), new Integer(consumed)});
                    continue;
                }
                super.add(new Object[]{name, type, inode, new Integer(eq), "", "", ""});
            }
        }
        if (group != null) {
            type = null;
            long cap = 0L;
            free = 0L;
            int eq = 0;
            consumed = 0;
            String inode = "";
            for (int i2 = 0; i2 < group.length; ++i2) {
                type = group[i2].getName();
                DiskCache[] members = group[i2].getMembers();
                if (members == null) continue;
                for (int j = 0; j < members.length; ++j) {
                    name = members[j].getDevicePath();
                    eq = members[j].getEquipOrdinal();
                    cap = members[j].getCapacity();
                    free = members[j].getAvailableSpace();
                    consumed = members[j].getConsumedSpacePercentage();
                    if (isMounted) {
                        super.add(new Object[]{name, type, inode, new Integer(eq), new Capacity(cap, 2), new Capacity(free, 2), new Integer(consumed)});
                        continue;
                    }
                    super.add(new Object[]{name, type, inode, new Integer(eq), "", "", ""});
                }
            }
        }
        TraceUtil.trace3("Exiting");
    }
}

