/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.HtmlUtil;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.BasicCommandField;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.ViewBean;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.wizards.NewPolicyWizardImpl;
import com.sun.netstorage.samqfs.web.fs.FSArchivePoliciesModel;
import com.sun.netstorage.samqfs.web.fs.FSArchivePoliciesTiledView;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.CommonTableContainerView;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.html.CCHref;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

public class FSArchivePoliciesView
extends CommonTableContainerView {
    protected FSArchivePoliciesModel model;
    public static final String CHILD_ADD_POLICY_BUTTON = "SamQFSWizardNewPolicyButton";
    public static final String CHILD_ADD_CRITERIA_BUTTON = "AddCriteriaButton";
    public static final String CHILD_REORDER_BUTTON = "ReorderButton";
    public static final String CHILD_REMOVE_BUTTON = "RemoveButton";
    public static final String CHILD_ADD_CRITERIA_HIDDEN_FIELD = "AddCriteriaHiddenField";
    public static final String CHILD_ADD_CRITERIA_HREF = "AddCriteriaHref";
    public static final String CHILD_REORDER_NEWORDER_HIDDEN_FIELD = "ReorderNewOrderHiddenField";
    public static final String CHILD_REORDER_SAVEDIR_HIDDEN_FIELD = "ReorderSaveDirectoryHiddenField";
    public static final String CHILD_REORDER_POLICIES_HREF = "ReorderPoliciesHref";
    public static final String CHILD_REORDER_MODELSIZE_HIDDEN_FIELD = "ModelSizeHiddenField";
    public static final String CHILD_CANCEL_HREF = "CancelHref";
    public static final String CHILD_TILED_VIEW = "FSArchivePoliciesTiledView";
    public static String WIZARD_FORWARDTO = "policyForwardToVB";
    public static String CHILD_ARFRWD_TO_CMDCHILD = "policyForwardToVB";
    public static String UNREORDERABLE_CRITERIA = "unreorderableCriteria";
    private CCWizardWindowModel policyWizardWindowModel = null;
    private boolean newPolicyWizardRunning = false;
    private boolean writeRole = false;
    protected String serverName;
    protected String fsName;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHref;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesTiledView;
    static /* synthetic */ Class class$com$iplanet$jato$view$BasicCommandField;

    public FSArchivePoliciesView(View parent, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        ViewBean vb = this.getParentViewBean();
        this.serverName = (String)vb.getPageSessionAttribute("SERVER_NAME");
        this.fsName = (String)vb.getPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME");
        TraceUtil.trace2("Got serverName and fsName from page session: " + this.serverName + ", " + this.fsName);
        if (this.serverName == null || this.fsName == null) {
            HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
            this.serverName = (String)session.getAttribute("SERVER_NAME");
            this.fsName = (String)session.getAttribute("FS_NAME");
            vb.setPageSessionAttribute("SERVER_NAME", (Serializable)((Object)this.serverName));
            vb.setPageSessionAttribute("SAMQFS_FILE_SYSTEM_NAME", (Serializable)((Object)this.fsName));
        }
        this.CHILD_ACTION_TABLE = "FSArchivePoliciesTable";
        this.model = new FSArchivePoliciesModel(this.serverName, this.fsName);
        this.initializeNewPolicyWizard();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    public void registerChildren() {
        TraceUtil.trace3("Entering");
        this.registerChild(CHILD_ADD_CRITERIA_HIDDEN_FIELD, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSArchivePoliciesView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_REORDER_NEWORDER_HIDDEN_FIELD, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSArchivePoliciesView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_REORDER_SAVEDIR_HIDDEN_FIELD, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSArchivePoliciesView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_REORDER_MODELSIZE_HIDDEN_FIELD, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSArchivePoliciesView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        this.registerChild(CHILD_ADD_CRITERIA_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = FSArchivePoliciesView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_REORDER_POLICIES_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = FSArchivePoliciesView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_CANCEL_HREF, class$com$sun$web$ui$view$html$CCHref == null ? (class$com$sun$web$ui$view$html$CCHref = FSArchivePoliciesView.class$("com.sun.web.ui.view.html.CCHref")) : class$com$sun$web$ui$view$html$CCHref);
        this.registerChild(CHILD_TILED_VIEW, class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesTiledView == null ? (class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesTiledView = FSArchivePoliciesView.class$("com.sun.netstorage.samqfs.web.fs.FSArchivePoliciesTiledView")) : class$com$sun$netstorage$samqfs$web$fs$FSArchivePoliciesTiledView);
        this.registerChild(WIZARD_FORWARDTO, class$com$iplanet$jato$view$BasicCommandField == null ? (class$com$iplanet$jato$view$BasicCommandField = FSArchivePoliciesView.class$("com.iplanet.jato.view.BasicCommandField")) : class$com$iplanet$jato$view$BasicCommandField);
        super.registerChildren(this.model);
        this.registerChild(UNREORDERABLE_CRITERIA, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = FSArchivePoliciesView.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        TraceUtil.trace3("Exiting");
    }

    public View createChild(String name) {
        if (name.equals(CHILD_ADD_CRITERIA_HIDDEN_FIELD) || name.equals(CHILD_REORDER_NEWORDER_HIDDEN_FIELD) || name.equals(CHILD_REORDER_SAVEDIR_HIDDEN_FIELD) || name.equals(CHILD_REORDER_MODELSIZE_HIDDEN_FIELD) || name.equals(UNREORDERABLE_CRITERIA)) {
            return new CCHiddenField((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_ADD_CRITERIA_HREF) || name.equals(CHILD_REORDER_POLICIES_HREF) || name.equals(CHILD_CANCEL_HREF)) {
            return new CCHref((ContainerView)this, name, null);
        }
        if (name.equals(CHILD_TILED_VIEW)) {
            return new FSArchivePoliciesTiledView((View)this, this.model, name);
        }
        if (name.equals(WIZARD_FORWARDTO)) {
            return new BasicCommandField((View)this, name);
        }
        return super.createChild(this.model, name, CHILD_TILED_VIEW);
    }

    public void handleSamQFSWizardNewPolicyButtonRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        this.newPolicyWizardRunning = true;
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handlePolicyForwardToVBRequest(RequestInvocationEvent rie) throws ServletException, IOException {
        this.newPolicyWizardRunning = false;
        this.getParentViewBean().forwardTo(this.getRequestContext());
    }

    public void handleRemoveButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        String policyName = null;
        int criteriaNumber = -1;
        try {
            int selectedRowIndex = this.getSelectedRowIndex();
            this.model.setRowIndex(selectedRowIndex);
            policyName = (String)this.model.getValue("PolicyNameHiddenField");
            criteriaNumber = Integer.parseInt((String)this.model.getValue("CriteriaNumberHiddenField"));
        }
        catch (ModelControlException modEx) {
            SamUtil.processException((Exception)((Object)modEx), ((Object)((Object)this)).getClass(), "handleRemoveButtonRequest()", "Exception occurred within framework", this.serverName);
            throw modEx;
        }
        catch (NumberFormatException nfe) {
            TraceUtil.trace2("Got NumberFormatException!" + nfe);
        }
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            FileSystem fs2 = sysModel.getSamQFSSystemFSManager().getFileSystem(this.fsName);
            if (fs2 == null) {
                throw new SamFSException(null, -1000);
            }
            ArchivePolicy policy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(policyName);
            if (policy == null) {
                throw new SamFSException(null, -1001);
            }
            ArchivePolCriteria policyCriteria = policy.getArchivePolCriteria(criteriaNumber);
            if (policyCriteria == null) {
                throw new SamFSException(null, -1001);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleRemoveButtonRequest", "Start removing policyCriteria " + policyName + "," + criteriaNumber);
            fs2.removePolCriteria(new ArchivePolCriteria[]{policyCriteria});
            LogUtil.info(((Object)((Object)this)).getClass(), "handleRemoveButtonRequest", "Done removing policyCriteria " + policyName + "," + criteriaNumber);
            this.showAlert("FSArchivePolicies.msg.deletePolicyCriteria", policyName + "," + criteriaNumber);
        }
        catch (SamFSException ex) {
            String processMsg = null;
            String errMsg = null;
            String errCause = null;
            boolean warning = false;
            if (ex instanceof SamFSMultiMsgException) {
                processMsg = "Error in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.error.detail";
            } else if (ex instanceof SamFSWarnings) {
                warning = true;
                processMsg = "Warning in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.warning.detail";
            } else {
                processMsg = "Failed to remove policy";
                errMsg = "FSArchivePolicies.error.delete";
                errCause = ex.getMessage();
            }
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleRemoveButtonRequest()", processMsg, this.serverName);
            if (!warning) {
                SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", errMsg, ex.getSAMerrno(), errCause, this.serverName);
            }
            SamUtil.setWarningAlert((ContainerView)this.getParentViewBean(), "Alert", errMsg, errCause);
        }
        this.refreshModel();
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleReorderButtonRequest(RequestInvocationEvent event) throws ServletException, IOException, ModelControlException {
        TraceUtil.trace3("Entering");
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.model.setRowSelected(false);
        int size = this.model.getNumRows();
        ((CCHiddenField)this.getChild(CHILD_REORDER_MODELSIZE_HIDDEN_FIELD)).setValue((Object)Integer.toString(size));
        String policyCriteriaString = this.model.getReorderCriteriaString();
        ((CCHiddenField)this.getChild(CHILD_REORDER_NEWORDER_HIDDEN_FIELD)).setValue((Object)policyCriteriaString);
        this.setDisplayFieldValue(UNREORDERABLE_CRITERIA, this.model.getNonReorderCriteriaString());
        if (SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.CONFIG)) {
            if (this.newPolicyWizardRunning) {
                ((CCButton)this.getChild(CHILD_ADD_POLICY_BUTTON)).setDisabled(true);
            } else {
                ((CCButton)this.getChild(CHILD_ADD_POLICY_BUTTON)).setDisabled(false);
            }
            ((CCButton)this.getChild(CHILD_ADD_CRITERIA_BUTTON)).setDisabled(false);
            if (this.model.getNumReorderCriteria() > 1) {
                ((CCButton)this.getChild(CHILD_REORDER_BUTTON)).setDisabled(false);
            } else {
                ((CCButton)this.getChild(CHILD_REORDER_BUTTON)).setDisabled(true);
            }
            ((CCButton)this.getChild(CHILD_REMOVE_BUTTON)).setDisabled(false);
        } else {
            ((CCButton)this.getChild(CHILD_ADD_POLICY_BUTTON)).setDisabled(true);
            ((CCButton)this.getChild(CHILD_ADD_CRITERIA_BUTTON)).setDisabled(true);
            ((CCButton)this.getChild(CHILD_REORDER_BUTTON)).setDisabled(true);
            ((CCButton)this.getChild(CHILD_REMOVE_BUTTON)).setDisabled(true);
            this.model.setSelectionType("none");
        }
        TraceUtil.trace3("Exiting");
    }

    private int getSelectedRowIndex() throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = -1;
        CCActionTable child = (CCActionTable)this.getChild(this.CHILD_ACTION_TABLE);
        child.restoreStateData();
        this.model.beforeFirst();
        while (this.model.next()) {
            if (!this.model.isRowSelected()) continue;
            index = this.model.getRowIndex();
        }
        TraceUtil.trace3("Exiting");
        return index;
    }

    private void refreshModel() {
        TraceUtil.trace3("Entering");
        try {
            this.model.initModelRows();
        }
        catch (SamFSException smfex) {
            this.model.clear();
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "refreshModel()", "Failed to populate archive policy", this.serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "FSArchivePolicies.error.populatePolicyCriteria", smfex.getSAMerrno(), smfex.getMessage(), this.serverName);
        }
        TraceUtil.trace3("Exiting");
    }

    public void handleReorderPoliciesHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        boolean reorder = true;
        boolean dumpOn = false;
        String location = "";
        String newPolicyOrder = (String)this.getDisplayFieldValue(CHILD_REORDER_NEWORDER_HIDDEN_FIELD);
        String saveFile = (String)this.getDisplayFieldValue(CHILD_REORDER_SAVEDIR_HIDDEN_FIELD);
        TraceUtil.trace2("Reorder string = " + newPolicyOrder);
        TraceUtil.trace2("Reorder saveDir = " + saveFile);
        try {
            SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
            if (appModel == null) {
                throw new SamFSException(null, -1004);
            }
            dumpOn = appModel.isDumpOn();
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleReorderPoliciesHrefRequest()", "Failed to retrieve the model", this.serverName);
            SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", "FSArchivePolicies.error.reorderPolicyCriteria", ex.getSAMerrno(), ex.getMessage(), this.serverName);
        }
        if (dumpOn) {
            StringTokenizer order = new StringTokenizer(saveFile, ", ");
            int number = order.countTokens();
            String[] temp = new String[number];
            for (int i = 0; i < number; ++i) {
                temp[i] = order.nextToken();
            }
            if (!temp[0].equals("reorder")) {
                reorder = false;
                location = temp[1];
                TraceUtil.trace2("Dump locaiton = " + location);
            }
        }
        StringTokenizer tokens1 = new StringTokenizer(newPolicyOrder, ",");
        int count1 = tokens1.countTokens();
        String nonReorderString = this.model.getNonReorderCriteriaString();
        StringTokenizer tokens2 = new StringTokenizer(nonReorderString, ",");
        int count2 = tokens2.countTokens();
        String[] policyNames = new String[count1 + count2];
        int[] criteriaNumbers = new int[count1 + count2];
        for (int ii = 0; ii < count1; ++ii) {
            String token = tokens1.nextToken();
            int index = token.indexOf(58);
            policyNames[ii] = token.substring(0, index);
            criteriaNumbers[ii] = Integer.parseInt(token.substring(index + 1));
        }
        for (int jj = 0; jj < count2; ++jj) {
            String token = tokens2.nextToken();
            int index = token.indexOf(58);
            policyNames[ii + jj] = token.substring(0, index);
            criteriaNumbers[ii + jj] = Integer.parseInt(token.substring(index + 1));
        }
        int count = count1 + count2;
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            FileSystem fs2 = sysModel.getSamQFSSystemFSManager().getFileSystem(this.fsName);
            if (fs2 == null) {
                throw new SamFSException(null, -1000);
            }
            ArchivePolCriteria[] policyCriteria = new ArchivePolCriteria[count];
            for (int i = 0; i < count; ++i) {
                ArchivePolicy policy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(policyNames[i]);
                if (policy == null) {
                    throw new SamFSException(null, -1001);
                }
                policyCriteria[i] = policy.getArchivePolCriteria(criteriaNumbers[i]);
                if (policyCriteria[i] != null) continue;
                throw new SamFSException(null, -1001);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleReorderPoliciesHrefRequest", "Start reordering policy criteria");
            if (!reorder) {
                sysModel.setDumpPath(location);
            }
            fs2.reorderPolCriteria(policyCriteria);
            LogUtil.info(((Object)((Object)this)).getClass(), "handleReorderPoliciesHrefRequest", "Done reordering policy criteria");
            if (reorder) {
                this.showAlert("FSArchivePolicies.msg.reorderPolicyCriteria", "");
            } else {
                this.showAlert("FSArchivePolicies.msg.reordersavePolicyCriteria", "");
            }
        }
        catch (SamFSException ex) {
            String processMsg = null;
            String errMsg = null;
            String errCause = null;
            boolean warning = false;
            if (ex instanceof SamFSMultiMsgException) {
                processMsg = "Error in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.error.detail";
            } else if (ex instanceof SamFSWarnings) {
                warning = true;
                processMsg = "Warning in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.warning.detail";
            } else {
                processMsg = "Failed to reorder policy";
                errMsg = "FSArchivePolicies.error.reorder";
                errCause = ex.getMessage();
            }
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleReorderPoliciesHrefRequest()", processMsg, this.serverName);
            if (!warning) {
                SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", errMsg, ex.getSAMerrno(), errCause, this.serverName);
            }
            SamUtil.setWarningAlert((ContainerView)this.getParentViewBean(), "Alert", errMsg, errCause);
        }
        this.refreshModel();
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleAddCriteriaHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        String policyCriteriaString = (String)this.getDisplayFieldValue(CHILD_ADD_CRITERIA_HIDDEN_FIELD);
        TraceUtil.trace2("Got new policy criteria: " + policyCriteriaString);
        StringTokenizer tokens = new StringTokenizer(policyCriteriaString, ",");
        int count = tokens.countTokens();
        String[] policyNames = new String[count];
        int[] criteriaNumbers = new int[count];
        for (int i = 0; i < count; ++i) {
            String token = tokens.nextToken();
            int index = token.indexOf(58);
            policyNames[i] = token.substring(0, index);
            criteriaNumbers[i] = Integer.parseInt(token.substring(index + 1));
        }
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            FileSystem fs2 = sysModel.getSamQFSSystemFSManager().getFileSystem(this.fsName);
            if (fs2 == null) {
                throw new SamFSException(null, -1000);
            }
            ArchivePolCriteria[] policyCriteria = new ArchivePolCriteria[count];
            for (int i = 0; i < count; ++i) {
                ArchivePolicy policy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(policyNames[i]);
                if (policy == null) {
                    throw new SamFSException(null, -1001);
                }
                policyCriteria[i] = policy.getArchivePolCriteria(criteriaNumbers[i]);
                if (policyCriteria[i] != null) continue;
                throw new SamFSException(null, -1001);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleAddCriteriaHrefRequest", "Start adding policy criteria");
            fs2.addPolCriteria(policyCriteria);
            LogUtil.info(((Object)((Object)this)).getClass(), "handleAddCriteriaHrefRequest", "Done adding policy criteria");
            this.showAlert("FSArchivePolicies.msg.addPolicyCriteria", "");
        }
        catch (SamFSException ex) {
            String processMsg = null;
            String errMsg = null;
            String errCause = null;
            boolean warning = false;
            if (ex instanceof SamFSMultiMsgException) {
                processMsg = "Error in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.error.detail";
            } else if (ex instanceof SamFSWarnings) {
                warning = true;
                processMsg = "Warning in archiver configuration";
                errMsg = "ArchiveConfig.error";
                errCause = "ArchiveConfig.warning.detail";
            } else {
                processMsg = "Failed to add policy criteria";
                errMsg = "FSArchivePolicies.error.addPolicyCriteria";
                errCause = ex.getMessage();
            }
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleAddCriteriaHrefRequest()", processMsg, this.serverName);
            if (!warning) {
                SamUtil.setErrorAlert((ContainerView)this.getParentViewBean(), "Alert", errMsg, ex.getSAMerrno(), errCause, this.serverName);
            }
            SamUtil.setWarningAlert((ContainerView)this.getParentViewBean(), "Alert", errMsg, errCause);
        }
        this.refreshModel();
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleCancelHrefRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        this.getParentViewBean().forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private void showAlert(String operation, String key) {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this.getParentViewBean(), "Alert", "success.summary", SamUtil.getResourceString(operation, key), this.serverName);
        TraceUtil.trace3("Exiting");
    }

    public void populateData() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.model.initModelRows();
        TraceUtil.trace3("Exiting");
    }

    private void initializeNewPolicyWizard() {
        TraceUtil.trace3("Entering");
        CommonViewBeanBase view = (CommonViewBeanBase)this.getParentViewBean();
        NonSyncStringBuffer cmdChild = new NonSyncStringBuffer().append(view.getQualifiedName()).append(".").append("FSArchivePoliciesView.").append(WIZARD_FORWARDTO);
        this.policyWizardWindowModel = NewPolicyWizardImpl.createModel(cmdChild.toString());
        this.model.setModel(CHILD_ADD_POLICY_BUTTON, this.policyWizardWindowModel);
        this.policyWizardWindowModel.setValue(CHILD_ADD_POLICY_BUTTON, (Object)"FSArchivePolicies.button.AddPolicy");
        this.policyWizardWindowModel.setValue("SERVER_NAME", (Object)this.serverName);
        TraceUtil.trace3("Exiting");
    }

    private void setWizardState() {
        TraceUtil.trace3("Entering");
        CommonViewBeanBase view = (CommonViewBeanBase)this.getParentViewBean();
        String temp = (String)view.getPageSessionAttribute("NewPolicyPageModelName");
        String modelName = (String)view.getPageSessionAttribute("NewPolicyPageModelName");
        String implName = (String)view.getPageSessionAttribute("NewPolicyWizardImpl");
        if (modelName == null) {
            modelName = "WizardModel_" + HtmlUtil.getUniqueValue();
            view.setPageSessionAttribute("NewPolicyPageModelName", (Serializable)((Object)modelName));
        }
        if (implName == null) {
            implName = "WizardImpl_" + HtmlUtil.getUniqueValue();
            view.setPageSessionAttribute("NewPolicyWizardImpl", (Serializable)((Object)implName));
        }
        this.policyWizardWindowModel.setValue("NewPolicyPageModelName", (Object)modelName);
        this.policyWizardWindowModel.setValue("wizName", (Object)implName);
        this.policyWizardWindowModel.setValue("SERVER_NAME", (Object)this.serverName);
        TraceUtil.trace3("Exiting");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

