/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;
import java.util.ArrayList;

public final class FSArchivePoliciesModel
extends CCActionTableModel {
    protected String serverName;
    protected String fsName;
    private String reorderCriteriaString = "";
    private String nonReorderCriteriaString = "";
    private int numReorderCriteria = 0;

    public FSArchivePoliciesModel(String serverName, String fsName) {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/fs/FSArchivePoliciesTable.xml");
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.serverName = serverName;
        this.fsName = fsName;
        this.initModel();
        this.initProductName();
        TraceUtil.trace3("Exiting");
    }

    private void initModel() {
        TraceUtil.trace3("Entering");
        this.setActionValue("SamQFSWizardNewPolicyButton", "FSArchivePolicies.button.AddPolicy");
        this.setActionValue("AddCriteriaButton", "FSArchivePolicies.button.AddCriteria");
        this.setActionValue("RemoveButton", "FSArchivePolicies.button.Remove");
        this.setActionValue("ReorderButton", "FSArchivePolicies.button.Reorder");
        this.setActionValue("PositionColumn", "FSArchivePolicies.heading.Position");
        this.setActionValue("PolicyNameColumn", "FSArchivePolicies.heading.PolicyName");
        this.setActionValue("StartingDirectoryColumn", "FSArchivePolicies.heading.StartingDirectory");
        this.setActionValue("NameColumn", "FSArchivePolicies.heading.Name");
        this.setActionValue("OwnerColumn", "FSArchivePolicies.heading.Owner");
        this.setActionValue("GroupColumn", "FSArchivePolicies.heading.Group");
        this.setActionValue("MinSizeColumn", "FSArchivePolicies.heading.MinSize");
        this.setActionValue("MaxSizeColumn", "FSArchivePolicies.heading.MaxSize");
        this.setActionValue("AccessAgeColumn", "FSArchivePolicies.heading.AccessAge");
        this.setActionValue("ArchiveAgeColumn", "FSArchivePolicies.heading.ArchiveAge");
        this.setActionValue("MediaTypeColumn", "archiving.media.type");
        TraceUtil.trace3("Exiting");
    }

    private void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows() throws SamFSException {
        ArchivePolCriteria[] criteria;
        TraceUtil.trace3("Entering");
        this.clear();
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        FileSystem fs2 = sysModel.getSamQFSSystemFSManager().getFileSystem(this.fsName);
        if (fs2 == null) {
            throw new SamFSException(null, -1000);
        }
        ArchivePolCriteria[] policyCriteria = fs2.getArchivePolCriteriaForFS();
        if (policyCriteria == null) {
            TraceUtil.trace3("Exiting");
            return;
        }
        NonSyncStringBuffer reorderStringBuffer = new NonSyncStringBuffer();
        NonSyncStringBuffer nonReorderStringBuffer = new NonSyncStringBuffer();
        ArrayList<ArchivePolCriteria> globalCriteria = new ArrayList<ArchivePolCriteria>();
        int index = 0;
        for (int i = 0; i < policyCriteria.length; ++i) {
            System.out.print("policy = " + policyCriteria[i].getArchivePolicy().getPolicyName());
            System.out.print("; criteria #= " + policyCriteria[i].getIndex());
            ArchivePolCriteriaProp prop = policyCriteria[i].getArchivePolCriteriaProperties();
            if (prop.isGlobal()) {
                globalCriteria.add(policyCriteria[i]);
                System.out.println("; isGlobal = true");
                continue;
            }
            System.out.println("; isGlobal = false");
            if (index > 0) {
                reorderStringBuffer.append(',');
            }
            String policyCriteriaStr = this.processPolicyCriteria(policyCriteria[i], index++);
            reorderStringBuffer.append(policyCriteriaStr);
        }
        this.reorderCriteriaString = reorderStringBuffer.toString();
        this.numReorderCriteria = index;
        int size = globalCriteria.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                nonReorderStringBuffer.append(',');
            }
            criteria = (ArchivePolCriteria[])globalCriteria.get(i);
            String policyCriteriaStr = this.processPolicyCriteria((ArchivePolCriteria)criteria, index++);
            nonReorderStringBuffer.append(policyCriteriaStr);
        }
        ArchivePolicy defaultPolicy = sysModel.getSamQFSSystemArchiveManager43().getArchivePolicy(this.fsName);
        if (defaultPolicy != null) {
            criteria = defaultPolicy.getArchivePolCriteria();
            for (int i = 0; i < criteria.length; ++i) {
                if (size + i > 0) {
                    nonReorderStringBuffer.append(',');
                }
                String policyCriteriaStr = this.processPolicyCriteria(criteria[i], index++);
                nonReorderStringBuffer.append(policyCriteriaStr);
            }
        }
        this.nonReorderCriteriaString = nonReorderStringBuffer.toString();
        TraceUtil.trace3("Exiting");
    }

    protected String processPolicyCriteria(ArchivePolCriteria policyCriteria, int index) throws SamFSException {
        int policyType;
        String position = null;
        String policyName = null;
        String startingDir = null;
        String name = null;
        String owner = null;
        String group = null;
        int minSizeUnit = 0;
        int maxSizeUnit = 0;
        int accessAgeUnit = 0;
        long minSize = 0L;
        long maxSize = 0L;
        long accessAge = 0L;
        NonSyncStringBuffer archiveAgeBuf = new NonSyncStringBuffer();
        boolean isDefaultPolicy = false;
        boolean isGlobalCriteria = false;
        ArchivePolicy policy = policyCriteria.getArchivePolicy();
        policyName = policy.getPolicyName();
        position = Integer.toString(index + 1);
        ArchivePolCriteriaProp prop = policyCriteria.getArchivePolCriteriaProperties();
        if (prop != null) {
            startingDir = prop.getStartingDir();
            name = prop.getNamePattern();
            owner = prop.getOwner();
            group = prop.getGroup();
            minSize = prop.getMinSize();
            minSizeUnit = prop.getMinSizeUnit();
            maxSize = prop.getMaxSize();
            maxSizeUnit = prop.getMaxSizeUnit();
            accessAge = prop.getAccessAge();
            accessAgeUnit = prop.getAccessAgeUnit();
            isGlobalCriteria = prop.isGlobal();
        }
        isDefaultPolicy = (policyType = policy.getPolicyType()) == 1001;
        int criteriaNumber = policyCriteria.getIndex();
        ArchivePolCriteriaCopy[] copies = policyCriteria.getArchivePolCriteriaCopies();
        if (copies != null) {
            for (int j = 0; j < copies.length; ++j) {
                archiveAgeBuf.append("copy ").append(copies[j].getArchivePolCriteriaCopyNumber()).append(": ").append(copies[j].getArchiveAge()).append(" ").append(SamUtil.getTimeUnitL10NString(copies[j].getArchiveAgeUnit())).append("<br>");
            }
        }
        if (index > 0) {
            this.appendRow();
        }
        String policyCriteriaStr = new NonSyncStringBuffer(policyName).append(':').append(criteriaNumber).toString();
        this.setValue("Position", position);
        if (isDefaultPolicy) {
            this.setValue("GlobalImage", "/samqfsui/images/required.gif");
            this.setValue("DefaultImage", "/samqfsui/images/required.gif");
        } else if (isGlobalCriteria) {
            this.setValue("GlobalImage", "/samqfsui/images/required.gif");
            this.setValue("DefaultImage", "/samqfsui/images/samqfs_blank.gif");
        } else {
            this.setValue("GlobalImage", "/samqfsui/images/samqfs_blank.gif");
            this.setValue("DefaultImage", "/samqfsui/images/samqfs_blank.gif");
        }
        this.setValue("PolicyName", policyName);
        this.setValue("PolicyHref", new NonSyncStringBuffer(policyName).append(':').append(policyType).toString());
        this.setValue("PolicyNameHiddenField", policyName);
        this.setValue("CriteriaNumberHiddenField", new Integer(criteriaNumber));
        this.setValue("IsGlobalCriteriaHiddenField", isGlobalCriteria ? "1" : "0");
        this.setValue("ArchiveAge", archiveAgeBuf.toString());
        if (isDefaultPolicy) {
            this.setValue("StartingDirectory", "");
            this.setValue("Name", "");
            this.setValue("Owner", "");
            this.setValue("Group", "");
            this.setValue("MinSize", "");
            this.setValue("MaxSize", "");
            this.setValue("AccessAge", "");
            this.setValue("CriteriaHref", new NonSyncStringBuffer(policyName).append(':').append(policyType).toString());
        } else {
            this.setValue("StartingDirectory", startingDir);
            this.setValue("Name", name);
            this.setValue("Owner", owner);
            this.setValue("Group", group);
            this.setValue("MinSize", PolicyUtil.getSizeString(minSize, minSizeUnit));
            this.setValue("MaxSize", PolicyUtil.getSizeString(maxSize, maxSizeUnit));
            if (accessAge > 0L) {
                this.setValue("AccessAge", new NonSyncStringBuffer().append(accessAge).append(" ").append(SamUtil.getTimeUnitL10NString(accessAgeUnit)));
            } else {
                this.setValue("AccessAge", "");
            }
            this.setValue("CriteriaHref", new NonSyncStringBuffer(policyName).append(':').append(policyType).append(':').append(criteriaNumber).toString());
        }
        this.setValue("MediaType", PolicyUtil.getMediaTypeString(policyCriteria));
        return policyCriteriaStr;
    }

    public String getReorderCriteriaString() {
        return this.reorderCriteriaString;
    }

    public String getNonReorderCriteriaString() {
        return this.nonReorderCriteriaString;
    }

    public int getNumReorderCriteria() {
        return this.numReorderCriteria;
    }
}

