/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.fs;

import com.iplanet.jato.RequestManager;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteria;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolicy;
import com.sun.netstorage.samqfs.web.model.fs.FileSystem;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModel;

public final class FSAddPoliciesModel
extends CCActionTableModel {
    private int numRows = 0;
    protected String fsName = null;
    protected String serverName = null;

    public FSAddPoliciesModel(String serverName, String fsName) {
        super(RequestManager.getRequestContext().getServletContext(), "/jsp/fs/FSAddPoliciesTable.xml");
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.serverName = serverName;
        this.fsName = fsName;
        this.initModel();
        this.initProductName();
        TraceUtil.trace3("Exiting");
    }

    private void initModel() {
        TraceUtil.trace3("Entering");
        this.setActionValue("PolicyNameColumn", "FSArchivePolicies.heading.PolicyName");
        this.setActionValue("StartingDirectoryColumn", "FSArchivePolicies.heading.StartingDirectory");
        this.setActionValue("NameColumn", "FSArchivePolicies.heading.Name");
        this.setActionValue("OwnerColumn", "FSArchivePolicies.heading.Owner");
        this.setActionValue("GroupColumn", "FSArchivePolicies.heading.Group");
        this.setActionValue("MinSizeColumn", "FSArchivePolicies.heading.MinSize");
        this.setActionValue("MaxSizeColumn", "FSArchivePolicies.heading.MaxSize");
        this.setActionValue("AccessAgeColumn", "FSArchivePolicies.heading.AccessAge");
        this.setActionValue("ArchiveAgeColumn", "FSArchivePolicies.heading.ArchiveAge");
        this.setActionValue("MediaTypeColumn", "archiving.media.type");
        TraceUtil.trace3("Exiting");
    }

    private void initProductName() {
        TraceUtil.trace3("Entering");
        this.setProductNameAlt("secondaryMasthead.productNameAlt");
        this.setProductNameSrc("secondaryMasthead.productNameSrc");
        this.setProductNameHeight("20");
        this.setProductNameWidth("170");
        TraceUtil.trace3("Exiting");
    }

    public void initModelRows() throws SamFSException {
        TraceUtil.trace3("Entering");
        this.clear();
        SamQFSSystemModel sysModel = SamUtil.getModel(this.serverName);
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        FileSystem fs2 = sysModel.getSamQFSSystemFSManager().getFileSystem(this.fsName);
        if (fs2 == null) {
            throw new SamFSException(null, -1000);
        }
        ArchivePolCriteria[] policyCriteria = sysModel.getSamQFSSystemFSManager().getAllAvailablePolCriteria(fs2);
        if (policyCriteria == null) {
            TraceUtil.trace3("Exiting");
            return;
        }
        for (int i = 0; i < policyCriteria.length; ++i) {
            String policyName = null;
            String startingDir = null;
            String name = null;
            String owner = null;
            String group = null;
            NonSyncStringBuffer archiveAgeBuf = new NonSyncStringBuffer();
            ArchivePolicy policy = policyCriteria[i].getArchivePolicy();
            policyName = policy.getPolicyName();
            if (policyName == null || "".equals(policyName)) continue;
            ArchivePolCriteriaProp prop = policyCriteria[i].getArchivePolCriteriaProperties();
            startingDir = prop.getStartingDir();
            name = prop.getNamePattern();
            owner = prop.getOwner();
            group = prop.getGroup();
            long minSize = prop.getMinSize();
            int minSizeUnit = prop.getMinSizeUnit();
            long maxSize = prop.getMaxSize();
            int maxSizeUnit = prop.getMaxSizeUnit();
            long accessAge = prop.getAccessAge();
            int accessAgeUnit = prop.getAccessAgeUnit();
            int criteriaNumber = policyCriteria[i].getIndex();
            ArchivePolCriteriaCopy[] copies = policyCriteria[i].getArchivePolCriteriaCopies();
            if (copies != null) {
                for (int j = 0; j < copies.length; ++j) {
                    archiveAgeBuf.append("copy ").append(copies[j].getArchivePolCriteriaCopyNumber()).append(": ").append(copies[j].getArchiveAge()).append(" ").append(SamUtil.getTimeUnitL10NString(copies[j].getArchiveAgeUnit())).append("<br>");
                }
            }
            if (i > 0) {
                this.appendRow();
            }
            String policyCriteriaStr = new NonSyncStringBuffer(policyName).append(':').append(criteriaNumber).toString();
            this.setValue("PolicyName", policyName);
            this.setValue("PolicyNameHiddenField", policyName);
            this.setValue("CriteriaNumberHiddenField", new Integer(criteriaNumber));
            this.setValue("StartingDirectory", startingDir);
            this.setValue("Name", name);
            this.setValue("Owner", owner);
            this.setValue("Group", group);
            this.setValue("MinSize", PolicyUtil.getSizeString(minSize, minSizeUnit));
            this.setValue("MaxSize", PolicyUtil.getSizeString(maxSize, maxSizeUnit));
            this.setValue("MediaType", PolicyUtil.getMediaTypeString(policyCriteria[i]));
            String accessage = "";
            if (accessAge > 0L) {
                accessage = new NonSyncStringBuffer().append(accessAge).append(" ").append(SamUtil.getTimeUnitL10NString(accessAgeUnit)).toString();
            }
            this.setValue("AccessAge", accessage);
            this.setValue("ArchiveAge", archiveAgeBuf.toString());
        }
        TraceUtil.trace3("Exiting");
    }
}

