/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive.wizards;

import com.iplanet.jato.RequestContext;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.mgmt.SamFSMultiMsgException;
import com.sun.netstorage.samqfs.mgmt.SamFSWarnings;
import com.sun.netstorage.samqfs.web.archive.PolicyUtil;
import com.sun.netstorage.samqfs.web.archive.ReservationMethodHelper;
import com.sun.netstorage.samqfs.web.archive.SelectableGroupHelper;
import com.sun.netstorage.samqfs.web.archive.wizards.CopyInfo;
import com.sun.netstorage.samqfs.web.archive.wizards.CopyMediaValidator;
import com.sun.netstorage.samqfs.web.archive.wizards.NewCopyDiskVSNParametersBean;
import com.sun.netstorage.samqfs.web.archive.wizards.NewPolicyWizardApplyToFSView;
import com.sun.netstorage.samqfs.web.archive.wizards.NewPolicyWizardImplData;
import com.sun.netstorage.samqfs.web.model.SamQFSAppModel;
import com.sun.netstorage.samqfs.web.model.SamQFSFactory;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemArchiveManager43;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveCopyGUIWrapper;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaCopy;
import com.sun.netstorage.samqfs.web.model.archive43.ArchivePolCriteriaProp;
import com.sun.netstorage.samqfs.web.model.archive43.ArchiveVSNMap;
import com.sun.netstorage.samqfs.web.model.archive43.VSNPool;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.netstorage.samqfs.web.wizard.SamWizardImpl;
import com.sun.web.ui.model.CCActionTableModel;
import com.sun.web.ui.model.CCWizardWindowModel;
import com.sun.web.ui.model.wizard.WizardEvent;
import com.sun.web.ui.model.wizard.WizardInterface;
import com.sun.web.ui.view.table.CCActionTable;
import java.util.HashMap;

public class NewPolicyWizardImpl
extends SamWizardImpl {
    public static final String WIZARDPAGEMODELNAME = "NewPolicyPageModelName";
    public static final String WIZARDPAGEMODELNAME_PREFIX = "WizardModel";
    public static final String WIZARDIMPLNAME = "NewPolicyWizardImpl";
    public static final String WIZARDIMPLNAME_PREFIX = "WizardImpl";
    public static final String WIZARDCLASSNAME = "com.sun.netstorage.samqfs.web.archive.wizards.NewPolicyWizardImpl";
    public static final String NO_ARCHIVE_EXISTS = "NoArchiveExists";
    public static final String CRITERIA_PROPERTIES = "CriteriaProperties";
    public static final String COPY_HASHMAP = "CopyHashMap";
    public static final String ARCHIVE_TYPE = "ArchiveType";
    public static final String NO_ARCHIVE = "NoArchive";
    public static final String ARCHIVE = "Archive";
    public static final String DISK_BASE = "DiskBase";
    public static final String TAPE_BASE = "TapeBase";
    private static String TOTAL_COPIES = "total_copies";
    private HashMap copyNumberHashMap = new HashMap();
    public static String SELECTED_FS_LIST = "selectedFileSystems";
    private boolean dumpOn = false;
    private String dumpPath = null;
    private boolean wizardInitialized = false;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$wizards$CopyMediaParametersView;

    public static WizardInterface create(RequestContext requestContext) {
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        return new NewPolicyWizardImpl(requestContext);
    }

    public NewPolicyWizardImpl(RequestContext requestContext) {
        super(requestContext, WIZARDPAGEMODELNAME);
        String serverName = requestContext.getRequest().getParameter("SERVER_NAME");
        TraceUtil.trace3(new NonSyncStringBuffer("WizardImpl Const' serverName is ").append(serverName).toString());
        this.wizardModel.setValue("SERVER_NAME", serverName);
        this.wizardModel.setValue(NO_ARCHIVE_EXISTS, Boolean.toString(PolicyUtil.policyExists(serverName, "no_archive")));
        String selectedFSName = requestContext.getRequest().getParameter("fsNameParam");
        this.wizardModel.setValue(SELECTED_FS_LIST, selectedFSName == null ? "" : selectedFSName);
        this.initializeWizard();
        this.initializeWizardControl(requestContext);
        try {
            String version = SamUtil.getAPIVersion(serverName);
            this.wizardModel.setValue("SERVER_VERSION", version);
        }
        catch (SamFSException sfe) {
            SamUtil.processException((Exception)((Object)sfe), this.getClass(), WIZARDIMPLNAME, "unable to retrieve server version", serverName);
        }
    }

    private void initializeWizard() {
        TraceUtil.trace3("Entering");
        this.wizardName = WIZARDIMPLNAME;
        this.wizardTitle = "NewArchivePolWizard.title";
        this.pageClass = NewPolicyWizardImplData.pageClass;
        this.pageTitle = NewPolicyWizardImplData.pageTitle;
        this.stepHelp = NewPolicyWizardImplData.stepHelp;
        this.stepText = NewPolicyWizardImplData.stepText;
        this.stepInstruction = NewPolicyWizardImplData.stepInstruction;
        this.cancelMsg = NewPolicyWizardImplData.cancelMsg;
        try {
            this.getDumpValue();
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "NewPolicyWizardImpl()", "Failed to get preferences status", this.getServerName());
            this.setWizardModelErrorMessage(ex.getMessage(), ex.getSAMerrno());
        }
        this.wizardModel.setValue(COPY_HASHMAP, this.copyNumberHashMap);
        this.wizardModel.setValue(TOTAL_COPIES, new Integer(0));
        String selectedFS = (String)this.wizardModel.getValue(SELECTED_FS_LIST);
        if (selectedFS == null || selectedFS.length() == 0) {
            this.wizardModel.setValue(SELECTED_FS_LIST, "");
        }
        this.setShowResultsPage(true);
        if (this.dumpOn) {
            this.pages = NewPolicyWizardImplData.NoArchivePrefOnPages;
        } else {
            this.pages = NewPolicyWizardImplData.NoArchivePrefOffPages;
            this.wizardModel.setValue("saveValue", SamUtil.getResourceString("NewArchivePolWizard.page7.commit"));
        }
        this.initializeWizardPages(this.pages);
        try {
            ArchivePolCriteriaProp criteriaProperties = PolicyUtil.getArchiveManager(this.getServerName()).getDefaultArchivePolCriteriaProperties();
            this.wizardModel.setValue(CRITERIA_PROPERTIES, criteriaProperties);
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), this.getClass(), "NewPolicyWizardImpl()", "Failed to get preferences status", this.getServerName());
            this.setWizardModelErrorMessage(ex.getMessage(), ex.getSAMerrno());
        }
        TraceUtil.trace3("Exiting");
    }

    public static CCWizardWindowModel createModel(String cmdChild) {
        return NewPolicyWizardImpl.getWizardWindowModel(WIZARDIMPLNAME, "NewArchivePolWizard.title", WIZARDCLASSNAME, cmdChild);
    }

    public boolean cancelStep(WizardEvent wizardEvent) {
        super.cancelStep(wizardEvent);
        SamUtil.doPrint("Start clearing wizard Model ...");
        this.wizardModel.clear();
        SamUtil.doPrint("Done clearing wizard Model ...");
        return true;
    }

    public void closeStep(WizardEvent wizardEvent) {
        SamUtil.doPrint("Start clearing wizard Model ...");
        this.wizardModel.clear();
        SamUtil.doPrint("Done clearing wizard Model ...");
    }

    public String[] getFuturePages(String currentPageId) {
        TraceUtil.trace3(new NonSyncStringBuffer("Entering getFuturePages(): currentPageId is ").append(currentPageId).toString());
        int page = this.pageIdToPage(currentPageId) + 1;
        int totalCopyNumber = (Integer)this.wizardModel.getValue(TOTAL_COPIES);
        String[] futurePages = null;
        if (this.pages[page - 1] == 0) {
            futurePages = new String[]{};
        } else if (this.pages[page - 1] == 1) {
            futurePages = new String[]{Integer.toString(page)};
        } else if (this.isPageCopyParameters(page - 1)) {
            futurePages = new String[]{};
        } else if (this.isPageDiskOrTapeCopyOption(page - 1)) {
            futurePages = new String[]{Integer.toString(page)};
        } else {
            int howMany = this.pages.length - page;
            futurePages = new String[howMany];
            for (int i = 0; i < howMany; ++i) {
                futurePages[i] = Integer.toString(page + i);
            }
        }
        TraceUtil.trace3("Exiting");
        return futurePages;
    }

    public String[] getFutureSteps(String currentPageId) {
        TraceUtil.trace3("Entering getFutureSteps()");
        int page = this.pageIdToPage(currentPageId);
        String[] futureSteps = null;
        int totalCopyNumber = (Integer)this.wizardModel.getValue(TOTAL_COPIES);
        if (this.pages[page] == 0) {
            futureSteps = new String[]{};
        } else if (this.pages[page] == 1) {
            String futureStepText = SamUtil.getResourceString(this.stepText[2], new String[]{Integer.toString(this.getCopyNumberForCopyMediaParametersPage(page + 1))});
            futureSteps = new String[]{futureStepText};
        } else if (this.isPageCopyParameters(page)) {
            futureSteps = new String[]{};
        } else if (this.isPageDiskOrTapeCopyOption(page)) {
            String futureStepText = SamUtil.getResourceString(this.stepText[2], new String[]{Integer.toString(this.getCopyNumberForCopyMediaParametersPage(page + 1))});
            futureSteps = new String[]{futureStepText};
        } else {
            int howMany = this.pages.length - page - 1;
            futureSteps = new String[howMany];
            for (int i = 0; i < howMany; ++i) {
                int futureStep = page + 1 + i;
                int futurePage = this.pages[futureStep];
                futureSteps[i] = this.stepText[futurePage];
            }
        }
        TraceUtil.trace3("Exiting");
        return futureSteps;
    }

    public String getStepInstruction(String pageId) {
        TraceUtil.trace2(new NonSyncStringBuffer("Entered with pageID = ").append(pageId).toString());
        if (this.pages[this.pageIdToPage(pageId)] == 0 && this.noArchiveExists()) {
            return "NewPolicyWizard.defineType.instruction.noradio";
        }
        return this.stepInstruction[this.pages[this.pageIdToPage(pageId)]];
    }

    public Class getPageClass(String pageId) {
        TraceUtil.trace3(new NonSyncStringBuffer().append("Entered with pageID = ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        if (this.pages[page] == 2) {
            this.wizardModel.setValue("copyNumber", new Integer(this.getCopyNumberForCopyMediaParametersPage(page)));
            TraceUtil.trace2("This is Copy # " + this.getCopyNumberForCopyMediaParametersPage(page));
        } else if (this.pages[page] == 4 || this.pages[page] == 3) {
            this.wizardModel.setValue("copyNumber", new Integer(this.getCopyNumberForCopyOptionPage(page)));
            TraceUtil.trace2("This is Copy # " + this.getCopyNumberForCopyOptionPage(page));
        }
        if (this.wizardInitialized) {
            this.wizardModel.setValue("ERROR", "No");
        }
        String version = (String)this.wizardModel.getValue("SERVER_VERSION");
        if (this.pages[page] == 2 && "1.3".compareTo(version) <= 0) {
            return class$com$sun$netstorage$samqfs$web$archive$wizards$CopyMediaParametersView == null ? (class$com$sun$netstorage$samqfs$web$archive$wizards$CopyMediaParametersView = NewPolicyWizardImpl.class$("com.sun.netstorage.samqfs.web.archive.wizards.CopyMediaParametersView")) : class$com$sun$netstorage$samqfs$web$archive$wizards$CopyMediaParametersView;
        }
        return super.getPageClass(pageId);
    }

    public String getStepText(String pageId) {
        TraceUtil.trace2(new NonSyncStringBuffer("Entered with pageID = ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        String text = null;
        text = this.pages[page] == 2 ? SamUtil.getResourceString(this.stepText[this.pages[page]], new String[]{Integer.toString(this.getCopyNumberForCopyMediaParametersPage(page))}) : (this.pages[page] == 4 || this.pages[page] == 3 ? SamUtil.getResourceString(this.stepText[this.pages[page]], new String[]{Integer.toString(this.getCopyNumberForCopyOptionPage(page))}) : (this.pages[page] == 0 && this.noArchiveExists() ? "NewPolicyWizard.defineType.title.noradio" : this.stepText[this.pages[page]]));
        return text;
    }

    private int getCopyNumberForCopyMediaParametersPage(int page) {
        int totalCopies = (Integer)this.wizardModel.getValue(TOTAL_COPIES);
        if (page < totalCopies * 2 + 1) {
            for (int i = 0; i < totalCopies; ++i) {
                if (page != 2 + i * 2) continue;
                return i + 1;
            }
        }
        return -1;
    }

    private int getCopyNumberForCopyOptionPage(int page) {
        int totalCopies = (Integer)this.wizardModel.getValue(TOTAL_COPIES);
        if (page < totalCopies * 2 + 2) {
            for (int i = 0; i < totalCopies; ++i) {
                if (page != 3 + i * 2) continue;
                return i + 1;
            }
        }
        return -1;
    }

    public String getStepTitle(String pageId) {
        TraceUtil.trace2(new NonSyncStringBuffer("Entered with pageID = ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        String title = null;
        title = this.pages[page] == 2 ? SamUtil.getResourceString(this.pageTitle[this.pages[page]], new String[]{Integer.toString(this.getCopyNumberForCopyMediaParametersPage(page))}) : (this.pages[page] == 4 || this.pages[page] == 3 ? SamUtil.getResourceString(this.pageTitle[this.pages[page]], new String[]{Integer.toString(this.getCopyNumberForCopyOptionPage(page))}) : (this.pages[page] == 0 && this.noArchiveExists() ? "NewPolicyWizard.defineType.title.noradio" : this.pageTitle[this.pages[page]]));
        return title;
    }

    public String[] getStepHelp(String pageId) {
        TraceUtil.trace2(new NonSyncStringBuffer("Entered with pageID = ").append(pageId).toString());
        if (this.pages[this.pageIdToPage(pageId)] == 0 && this.noArchiveExists()) {
            String[] helpNoRadio = new String[]{"NewPolicyWizard.definetype.help2", "NewPolicyWizard.definetype.help3", "NewPolicyWizard.definetype.help4", "NewPolicyWizard.definetype.help5", "NewPolicyWizard.definetype.help6", "NewPolicyWizard.definetype.help7", "NewPolicyWizard.definetype.help8"};
            return helpNoRadio;
        }
        return this.stepHelp[this.pages[this.pageIdToPage(pageId)]];
    }

    public boolean nextStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering nextStep()");
        super.nextStep(wizardEvent);
        this.wizardInitialized = true;
        String pageId = wizardEvent.getPageId();
        boolean result = true;
        TraceUtil.trace3(new NonSyncStringBuffer().append("nextStep() pageID: ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        switch (this.pages[page]) {
            case 0: {
                result = this.processSelectTypePage(wizardEvent);
                break;
            }
            case 1: {
                result = this.processFileMatchCriteriaPage(wizardEvent);
                break;
            }
            case 2: {
                result = this.processCopyParametersPage(wizardEvent);
                break;
            }
            case 3: {
                result = this.processTapeCopyOptionPage(wizardEvent);
                break;
            }
            case 4: {
                result = this.processDiskCopyOptionPage(wizardEvent);
                break;
            }
            case 5: {
                result = this.processApplyToFSPage(wizardEvent, true);
                break;
            }
            case 6: {
                result = this.processSavePage(wizardEvent, true);
            }
        }
        TraceUtil.trace3("Exiting");
        return result;
    }

    public boolean previousStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Calling previousStep");
        super.previousStep(wizardEvent);
        String pageId = wizardEvent.getPageId();
        boolean result = true;
        TraceUtil.trace3(new NonSyncStringBuffer().append("previousStep() pageID: ").append(pageId).toString());
        int page = this.pageIdToPage(pageId);
        switch (this.pages[page]) {
            case 2: {
                result = this.processCopyParametersPage(wizardEvent);
                break;
            }
            case 3: {
                result = this.processTapeCopyOptionPage(wizardEvent);
                break;
            }
            case 4: {
                result = this.processDiskCopyOptionPage(wizardEvent);
                break;
            }
            case 5: {
                result = this.processApplyToFSPage(wizardEvent, false);
                break;
            }
            case 6: {
                result = this.processSavePage(wizardEvent, false);
            }
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean finishStep(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        boolean returnValue = true;
        boolean warningException = false;
        String errMsg = null;
        String errCode = null;
        String warningSummary = null;
        if (!super.finishStep(wizardEvent)) {
            return true;
        }
        String policyName = (String)this.wizardModel.getValue("PolicyNameTextField");
        int totalCopies = (Integer)this.wizardModel.getValue(TOTAL_COPIES);
        String[] selectedFSArray = ((String)this.wizardModel.getValue(SELECTED_FS_LIST)).split("<br>");
        ArchiveCopyGUIWrapper[] wrapperArray = new ArchiveCopyGUIWrapper[totalCopies];
        ArchivePolCriteriaProp criteriaProperties = this.getCriteriaProperties();
        try {
            int i;
            for (int i2 = 0; i2 < totalCopies; ++i2) {
                wrapperArray[i2] = this.getCopyGUIWrapper(i2 + 1);
            }
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            String savePreference = (String)this.wizardModel.getValue("DUMP");
            if (savePreference.equals("on")) {
                String dumpPath = (String)this.wizardModel.getValue("LOCATION");
                sysModel.setDumpPath(dumpPath);
            } else {
                sysModel.setDumpPath(null);
            }
            SamQFSSystemArchiveManager43 archive43Manager = sysModel.getSamQFSSystemArchiveManager43();
            if (archive43Manager == null) {
                throw new SamFSException(null, -2001);
            }
            LogUtil.info(this.getClass(), "finishStep", new NonSyncStringBuffer("Start creating new archive policy ").append(policyName).toString());
            for (i = 0; i < wrapperArray.length; ++i) {
                String key = "new_disk_vsn_key." + (1 + i);
                NewCopyDiskVSNParametersBean bean = (NewCopyDiskVSNParametersBean)this.wizardModel.getValue(key);
                if (bean == null) continue;
                String serverName = (String)this.wizardModel.getValue("SERVER_NAME");
                String host = serverName.equals(bean.getHost()) ? null : bean.getHost();
                sysModel.getSamQFSSystemMediaManager().createDiskVSN(bean.getName(), host, bean.getPath());
                wrapperArray[i].getArchiveCopy().getArchiveVSNMap().setMapExpression(bean.getName());
            }
            for (i = 0; i < wrapperArray.length; ++i) {
                wrapperArray[i].getArchiveCopy().getArchiveVSNMap().setWillBeSaved(true);
            }
            archive43Manager.createArchivePolicy(policyName, criteriaProperties, wrapperArray, selectedFSArray);
            LogUtil.info(this.getClass(), "finishStep", new NonSyncStringBuffer("Done creating new archive policy ").append(policyName).toString());
        }
        catch (SamFSWarnings sfw) {
            returnValue = false;
            warningException = true;
            warningSummary = "ArchiveConfig.error";
            errMsg = "ArchiveConfig.warning.detail";
        }
        catch (SamFSMultiMsgException sfme) {
            returnValue = false;
            warningException = true;
            warningSummary = "ArchiveConfig.error";
            errMsg = "ArchiveConfig.warning.detail";
        }
        catch (SamFSException samEx) {
            returnValue = false;
            TraceUtil.trace1(new NonSyncStringBuffer("Exception caught in finishStep: Reason:").append(samEx.getMessage()).toString());
            SamUtil.processException((Exception)((Object)samEx), this.getClass(), "finishStep", "Failed to create new copy", this.getServerName());
            errMsg = samEx.getMessage();
            errCode = Integer.toString(samEx.getSAMerrno());
        }
        if (returnValue) {
            SamUtil.doPrint(new NonSyncStringBuffer("Successfully creating new archive policy ").append(policyName).toString());
            this.wizardModel.setValue("Finish_result", "successful");
            this.wizardModel.setValue("WizardResultAlertSummary", "success.summary");
            this.wizardModel.setValue("WizardResultAlertDetail", SamUtil.getResourceString("ArchivePolSummary.msg.create", policyName));
        } else if (warningException) {
            SamUtil.doPrint(new NonSyncStringBuffer("Successfully creating new archive policy ").append(policyName).append(", but warning is caught.").toString());
            this.wizardModel.setValue("Finish_result", "Warning");
            this.wizardModel.setValue("WizardResultAlertSummary", warningSummary);
            this.wizardModel.setValue("WizardResultAlertDetail", errMsg);
        } else {
            this.wizardModel.setValue("Finish_result", "Failed");
            this.wizardModel.setValue("WizardResultAlertSummary", "ArchivePolSummary.error.failedCreatePolicy");
            this.wizardModel.setValue("WizardResultAlertDetail", errMsg);
            this.wizardModel.setValue("Detail_code", errCode);
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private void getDumpValue() throws SamFSException {
        TraceUtil.trace3("Entering");
        SamQFSAppModel appModel = SamQFSFactory.getSamQFSAppModel();
        if (appModel == null) {
            throw new SamFSException(null, -2501);
        }
        this.dumpOn = appModel.isDumpOn();
        if (this.dumpOn) {
            this.wizardModel.setValue("DUMP", "on");
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            this.wizardModel.setValue("LOCATION", sysModel.getDefaultDumpPath());
        } else {
            this.wizardModel.setValue("DUMP", "off");
        }
        TraceUtil.trace3("Exiting");
    }

    private void setErrorMessage(WizardEvent wizardEvent, String errMsg) {
        wizardEvent.setSeverity(0);
        wizardEvent.setErrorMessage(errMsg);
    }

    private void setWizardModelErrorMessage(String message, int errorCode) {
        this.wizardModel.setValue("ERROR", "Yes");
        this.wizardModel.setValue("ERROR_MSGS", message);
        this.wizardModel.setValue("ERROR_CODE", Integer.toString(errorCode));
    }

    boolean processSelectTypePage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        String archiveRadio = (String)this.wizardModel.getValue("ArchiveRadio");
        if (archiveRadio == null) {
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page1.errMsg1");
            return false;
        }
        if (archiveRadio.equals(NO_ARCHIVE)) {
            this.pages = this.dumpOn ? NewPolicyWizardImplData.NoArchivePrefOnPages : NewPolicyWizardImplData.NoArchivePrefOffPages;
            this.wizardModel.setValue(ARCHIVE_TYPE, NO_ARCHIVE);
            this.wizardModel.setValue(TOTAL_COPIES, new Integer(0));
            this.wizardModel.setValue("PolicyNameTextField", "no_archive");
            this.wizardModel.setValue("NumCopiesTextField", "0");
        } else {
            String archiveType = (String)this.wizardModel.getValue(ARCHIVE_TYPE);
            String string = archiveType = archiveType == null ? "" : archiveType;
            if (archiveType.equals(NO_ARCHIVE)) {
                this.wizardModel.setValue("PolicyNameTextField", "");
            }
            this.wizardModel.setValue(ARCHIVE_TYPE, ARCHIVE);
            this.pages = new int[]{0, 1, 2, 3, 7, 8};
        }
        this.initializeWizardPages(this.pages);
        ArchivePolCriteriaProp criteriaProperties = this.getCriteriaProperties();
        String startingDirectory = (String)this.wizardModel.getValue("StartingDirTextField");
        String string = startingDirectory = startingDirectory != null ? startingDirectory.trim() : "";
        if (startingDirectory.equals("")) {
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page1.errMsg3");
            return false;
        }
        if (startingDirectory.indexOf(" ") != -1) {
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page1.errMsg7");
            return false;
        }
        if (startingDirectory.startsWith("/")) {
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page1.errMsg10");
            return false;
        }
        criteriaProperties.setStartingDir(startingDirectory);
        String minSize = (String)this.wizardModel.getValue("MinSizeTextField");
        String minSizeDropDown = (String)this.wizardModel.getValue("MinSizeDropDown");
        String maxSize = (String)this.wizardModel.getValue("MaxSizeTextField");
        String maxSizeDropDown = (String)this.wizardModel.getValue("MaxSizeDropDown");
        String namePattern = (String)this.wizardModel.getValue("NamePatternTextField");
        String owner = (String)this.wizardModel.getValue("OwnerTextField");
        String group = (String)this.wizardModel.getValue("GroupTextField");
        String accessAge = (String)this.wizardModel.getValue("AccessAgeTextField");
        String accessAgeUnit = (String)this.wizardModel.getValue("AccessAgeDropDown");
        minSize = minSize != null ? minSize.trim() : "";
        minSizeDropDown = minSizeDropDown != null ? minSizeDropDown.trim() : "";
        maxSize = maxSize != null ? maxSize.trim() : "";
        maxSizeDropDown = maxSizeDropDown != null ? maxSizeDropDown.trim() : "";
        accessAge = accessAge != null ? accessAge.trim() : "";
        accessAgeUnit = accessAgeUnit != null ? accessAgeUnit.trim() : "";
        namePattern = namePattern != null ? namePattern.trim() : "";
        owner = owner != null ? owner.trim() : "";
        String string2 = group = group != null ? group.trim() : "";
        if (!minSize.equals("") && minSizeDropDown.equals(SelectableGroupHelper.NOVAL)) {
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page2.errMsgMinSizeDropDown");
            return false;
        }
        if (!maxSize.equals("") && maxSizeDropDown.equals(SelectableGroupHelper.NOVAL)) {
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page2.errMsgMaxSizeDropDown");
            return false;
        }
        long minimumSize = -1L;
        long maximumSize = -1L;
        try {
            if (!minSize.equals("") && (minimumSize = Long.parseLong(minSize)) < 0L) {
                this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page2.errMsgMinSizeNegInt");
                return false;
            }
        }
        catch (NumberFormatException numEx) {
            TraceUtil.trace1("Minimum Size is not an integer");
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page2.errMsgMinSize");
            return false;
        }
        try {
            if (!maxSize.equals("") && (maximumSize = Long.parseLong(maxSize)) < 0L) {
                this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page2.errMsgMaxSizeNegInt");
                return false;
            }
        }
        catch (NumberFormatException numEx) {
            TraceUtil.trace1("Maximum Size is not an integer");
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page2.errMsgMaxSize");
            return false;
        }
        if (!(minSize.equals("") || maxSize.equals("") || PolicyUtil.isMaxGreaterThanMin(minimumSize, Integer.parseInt(minSizeDropDown), maximumSize, Integer.parseInt(maxSizeDropDown)))) {
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page2.errMsgMinMaxSize");
            return false;
        }
        try {
            criteriaProperties.setMinSize(minimumSize);
            criteriaProperties.setMinSizeUnit(Integer.parseInt(minSizeDropDown));
            criteriaProperties.setMaxSize(maximumSize);
            criteriaProperties.setMaxSizeUnit(Integer.parseInt(maxSizeDropDown));
        }
        catch (NumberFormatException numEx) {
            TraceUtil.trace1("Internal fatal error. Number exception caught!");
            this.setWizardModelErrorMessage(numEx.getMessage(), 8001234);
            return true;
        }
        try {
            if (!minSize.equals("")) {
                this.wizardModel.setValue("MinimumSizeTextField", new NonSyncStringBuffer(minSize).append(" ").append(SamUtil.getSizeUnitL10NString(Integer.parseInt(minSizeDropDown))));
            }
            if (!maxSize.equals("")) {
                this.wizardModel.setValue("MaximumSizeTextField", new NonSyncStringBuffer(maxSize).append(" ").append(SamUtil.getSizeUnitL10NString(Integer.parseInt(maxSizeDropDown))));
            }
        }
        catch (NumberFormatException numEx) {
            TraceUtil.trace1("Internal fatal error. Number exception caught!");
        }
        if (namePattern.indexOf(" ") != -1 || !PolicyUtil.isValidNamePattern(namePattern)) {
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page2.errNamePattern");
            return false;
        }
        criteriaProperties.setNamePattern(namePattern);
        if (owner.indexOf(" ") != -1 || !PolicyUtil.isUserValid(owner, this.getServerName()) && !owner.equals("")) {
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page2.errOwner");
            return false;
        }
        criteriaProperties.setOwner(owner);
        if (group.indexOf(" ") != -1) {
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page2.errGroup");
            return false;
        }
        if (!PolicyUtil.isGroupValid(group, this.getServerName()) && !group.equals("")) {
            this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page2.errGroupExist");
            return false;
        }
        criteriaProperties.setGroup(group);
        if (!accessAge.equals("")) {
            long accessAgeValue = -1L;
            if (accessAgeUnit.equals(SelectableGroupHelper.NOVAL)) {
                this.setErrorMessage(wizardEvent, "NewCriteriaWizard.matchCriteriaPage.error.accessAgeUnit");
                return false;
            }
            try {
                accessAgeValue = Long.parseLong(accessAge);
                if (accessAgeValue <= 0L) {
                    this.setErrorMessage(wizardEvent, "NewCriteriaWizard.matchCriteriaPage.error.accessAge");
                    return false;
                }
            }
            catch (NumberFormatException nfe) {
                this.setErrorMessage(wizardEvent, "NewCriteriaWizard.matchCriteriaPage.error.accessAge");
                return false;
            }
            criteriaProperties.setAccessAge(accessAgeValue);
            criteriaProperties.setAccessAgeUnit(Integer.parseInt(accessAgeUnit));
            this.wizardModel.setValue("AccessAgeTextFieldWithUnits", new NonSyncStringBuffer().append(accessAge).append(" ").append(SamUtil.getTimeUnitL10NString(Integer.parseInt(accessAgeUnit))).toString());
        } else {
            criteriaProperties.setAccessAge(-1L);
            criteriaProperties.setAccessAgeUnit(-1);
            this.wizardModel.setValue("AccessAgeTextFieldWithUnits", "");
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processFileMatchCriteriaPage(WizardEvent wizardEvent) {
        TraceUtil.trace3("Entering");
        ArchivePolCriteriaProp criteriaProperty = this.getCriteriaProperties();
        String archiveType = (String)this.wizardModel.getValue(ARCHIVE_TYPE);
        if (archiveType.equals(ARCHIVE)) {
            String policyName = (String)this.wizardModel.getValue("PolicyNameTextField");
            String string = policyName = policyName != null ? policyName.trim() : "";
            if (policyName.equals("")) {
                this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page1.errMsg14");
                return false;
            }
            if (policyName.indexOf(" ") != -1 || !Character.isLetter(policyName.charAt(0)) || !SamUtil.isValidLetterOrDigitString(policyName)) {
                this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page1.errMsg8");
                return false;
            }
            if (policyName.endsWith("*")) {
                this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page1.errMsg13");
                return false;
            }
            if (policyName.equals("no_archive")) {
                this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page1.errMsg15");
                return false;
            }
            try {
                if (this.isPolicyNameInUsed(policyName)) {
                    this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page1.errMsg11");
                    return false;
                }
            }
            catch (SamFSException samEx) {
                SamUtil.processException((Exception)((Object)samEx), this.getClass(), "processSelectTypePage", "Failed to retrieve existing policy information", this.getServerName());
                this.setWizardModelErrorMessage(samEx.getMessage(), samEx.getSAMerrno());
                return true;
            }
            String numOfCopies = (String)this.wizardModel.getValue("CopiesDropDown");
            this.wizardModel.setValue(TOTAL_COPIES, Integer.valueOf(numOfCopies));
            this.wizardModel.setValue("NumCopiesTextField", Integer.valueOf(numOfCopies));
            String stageAttributes = (String)this.wizardModel.getValue("StageDropDown");
            String releaseAttributes = (String)this.wizardModel.getValue("ReleaseDropDown");
            try {
                if (!releaseAttributes.equals(SelectableGroupHelper.NOVAL)) {
                    this.wizardModel.setValue("ReleaseAttTextField", PolicyUtil.getReleasingOptionString(Integer.parseInt(releaseAttributes)));
                    criteriaProperty.setReleaseAttributes(Integer.parseInt(releaseAttributes));
                }
                if (!stageAttributes.equals(SelectableGroupHelper.NOVAL)) {
                    this.wizardModel.setValue("StageAttTextField", PolicyUtil.getStagingOptionString(Integer.parseInt(stageAttributes)));
                    criteriaProperty.setStageAttributes(Integer.parseInt(stageAttributes));
                }
            }
            catch (NumberFormatException numEx) {
                TraceUtil.trace1("Internal fatal error. Number exception caught!");
            }
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processCopyParametersPage(WizardEvent wizardEvent) {
        ArchiveCopyGUIWrapper myWrapper;
        String errorMessage;
        String mediaRadio;
        int currentCopyNumber;
        block51: {
            TraceUtil.trace3("Entering");
            int page = this.pageIdToPage(wizardEvent.getPageId());
            currentCopyNumber = this.getCopyNumberForCopyMediaParametersPage(page);
            mediaRadio = null;
            errorMessage = null;
            myWrapper = null;
            try {
                myWrapper = this.getCopyGUIWrapper(currentCopyNumber);
            }
            catch (SamFSException samEx) {
                TraceUtil.trace1("Exception caught while retrieving copy wrapper");
                this.setWizardModelErrorMessage(samEx.getMessage(), samEx.getSAMerrno());
                return true;
            }
            ArchiveCopy archiveCopy = myWrapper.getArchiveCopy();
            ArchivePolCriteriaCopy criteriaCopy = myWrapper.getArchivePolCriteriaCopy();
            String version = (String)this.wizardModel.getValue("SERVER_VERSION");
            if ("1.3".compareTo(version) <= 0) {
                CopyMediaValidator validator = new CopyMediaValidator(this.wizardModel, wizardEvent, myWrapper, currentCopyNumber);
                boolean result = validator.validate();
                String archiveType = validator.getMediaType() == 133 ? DISK_BASE : TAPE_BASE;
                this.updateHashMap(currentCopyNumber, archiveType, myWrapper);
                this.updateWizardSteps();
                return result;
            }
            String archiveAge = (String)this.wizardModel.getValue("ArchiveAgeTextField");
            String ageUnit = (String)this.wizardModel.getValue("ArchiveAgeDropDown");
            archiveAge = archiveAge != null ? archiveAge.trim() : "";
            ageUnit = ageUnit != null ? ageUnit.trim() : "";
            long age = -1L;
            if (archiveAge.equals("")) {
                mediaRadio = this.saveCopyMediaRadioButtonSetting();
                errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errArchiveAge" : errorMessage;
            } else {
                try {
                    age = Long.parseLong(archiveAge);
                    if (age < 0L) {
                        errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errArchiveAgeNegInt" : errorMessage;
                    } else {
                        criteriaCopy.setArchiveAge(age);
                    }
                }
                catch (NumberFormatException nfe) {
                    mediaRadio = this.saveCopyMediaRadioButtonSetting();
                    String string = errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errArchiveAge" : errorMessage;
                }
            }
            if (SelectableGroupHelper.NOVAL.equals(ageUnit)) {
                mediaRadio = this.saveCopyMediaRadioButtonSetting();
                errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errArchiveAgeDropDown" : errorMessage;
            } else {
                criteriaCopy.setArchiveAgeUnit(Integer.parseInt(ageUnit));
            }
            mediaRadio = (String)this.wizardModel.getValue("MedTypeRadio1");
            if (mediaRadio == null || mediaRadio.equals("")) {
                errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errMsg1" : errorMessage;
            } else if (mediaRadio.equals(DISK_BASE)) {
                String diskVolume = (String)this.wizardModel.getValue("DiskVolumeNameTextField");
                String string = diskVolume = diskVolume != null ? diskVolume.trim() : "";
                if (diskVolume.equals("")) {
                    errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errDiskParam" : errorMessage;
                } else if (diskVolume.indexOf(" ") != -1) {
                    errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errInvalidDiskVolumeName" : errorMessage;
                } else {
                    archiveCopy.setDiskArchiveVSN(diskVolume);
                }
                String diskDevice = (String)this.wizardModel.getValue("DiskDeviceTextField");
                String string2 = diskDevice = diskDevice != null ? diskDevice.trim() : "";
                if (diskDevice.equals("")) {
                    errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errDiskParam" : errorMessage;
                } else if (!SamUtil.isWellFormedPath(diskDevice)) {
                    errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errInvalidDiskDeviceName" : errorMessage;
                } else if (diskDevice.charAt(0) != '/') {
                    errorMessage = errorMessage == null ? new NonSyncStringBuffer("NewArchivePolWizard.page3.").append("errInvalidAbsoluteDiskDeviceName").toString() : errorMessage;
                } else {
                    String createPath = (String)this.wizardModel.getValue("createPath");
                    String serverName = this.getServerName();
                    try {
                        SamQFSSystemModel sysModel = SamUtil.getModel(serverName);
                        if (!createPath.equals("true") && !sysModel.doesFileExist(diskDevice)) {
                            if (errorMessage == null) {
                                errorMessage = "archiving.diskvsn.newvsn.error.pathnonexistent";
                            }
                            break block51;
                        }
                        archiveCopy.setDiskArchiveVSNPath(diskDevice);
                    }
                    catch (SamFSException sfe) {
                        TraceUtil.trace1("SamFSException caught while retrieving vsn path");
                        SamUtil.processException((Exception)((Object)sfe), this.getClass(), "processCopyMediaParameters", "Error retrieving disk vsn path", serverName);
                        this.wizardModel.setValue("ERROR", "Yes");
                        this.wizardModel.setValue("ERROR_MSGS", sfe.getMessage());
                        this.wizardModel.setValue("ERROR_CODE", Integer.toString(sfe.getSAMerrno()));
                    }
                }
            } else if (mediaRadio.equals(TAPE_BASE)) {
                String rmFS;
                String rmPolicy;
                ArchiveVSNMap archiveVSNMap = archiveCopy.getArchiveVSNMap();
                String mediaType = (String)this.wizardModel.getValue("TapeDropDown");
                String string = mediaType = mediaType != null ? mediaType.trim() : "";
                if (mediaType.equals(SelectableGroupHelper.NOVAL)) {
                    errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errMediaType" : errorMessage;
                } else {
                    archiveVSNMap.setArchiveMediaType(SamUtil.getMediaType(mediaType));
                }
                String vsnPool = (String)this.wizardModel.getValue("VSNPoolDropDownMenu");
                vsnPool = vsnPool != null ? vsnPool.trim() : "";
                String startVSN = (String)this.wizardModel.getValue("StartTextField");
                startVSN = startVSN != null ? startVSN.trim() : "";
                String endVSN = (String)this.wizardModel.getValue("EndTextField");
                endVSN = endVSN != null ? endVSN.trim() : "";
                String vsnRange = (String)this.wizardModel.getValue("RangeTextField");
                String string3 = vsnRange = vsnRange != null ? vsnRange.trim() : "";
                if (vsnPool.equals(SelectableGroupHelper.NOVAL) && (startVSN.equals("") || endVSN.equals("")) && vsnRange.equals("")) {
                    this.setErrorMessage(wizardEvent, errorMessage == null ? "NewArchivePolWizard.page3.errMediaTypeParam" : errorMessage);
                    return false;
                }
                boolean vpool = false;
                boolean sevsn = false;
                boolean rvsn = false;
                if (!vsnPool.equals(SelectableGroupHelper.NOVAL)) {
                    try {
                        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
                        VSNPool pool = PolicyUtil.getArchiveManager(this.getServerName()).getVSNPool(vsnPool);
                        if (pool.getMediaType() != SamUtil.getMediaType(mediaType)) {
                            errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errVSNPoolMediaType" : errorMessage;
                        } else {
                            archiveVSNMap.setPoolExpression(vsnPool);
                            vpool = true;
                        }
                    }
                    catch (SamFSException samEx) {
                        TraceUtil.trace1("SamFSException caught when retrieving Pool information");
                        SamUtil.processException((Exception)((Object)samEx), this.getClass(), "processCopyParametersView", "Retrieving Pool information", this.getServerName());
                        this.setWizardModelErrorMessage(samEx.getMessage(), samEx.getSAMerrno());
                        return true;
                    }
                }
                if (!startVSN.equals("") && !endVSN.equals("")) {
                    if (SamUtil.isValidVSNString(startVSN) && SamUtil.isValidVSNString(endVSN)) {
                        sevsn = true;
                        archiveVSNMap.setMapExpressionStartVSN(startVSN);
                        archiveVSNMap.setMapExpressionEndVSN(endVSN);
                    } else if (!SamUtil.isValidVSNString(startVSN)) {
                        errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errStartInvalidVSN" : errorMessage;
                    } else {
                        String string4 = errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errEndInvalidVSN" : errorMessage;
                    }
                }
                if (!vsnRange.equals("")) {
                    if (!SamUtil.isValidString(vsnRange)) {
                        errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errVSNRange" : errorMessage;
                    } else {
                        archiveVSNMap.setMapExpression(vsnRange);
                        rvsn = true;
                    }
                }
                if (!(vpool || sevsn || rvsn)) {
                    errorMessage = errorMessage == null ? "NewArchivePolWizard.page3.errMediaTypeParam" : errorMessage;
                }
                archiveCopy.setDiskArchiveVSN("");
                archiveCopy.setDiskArchiveVSNPath("");
                archiveCopy.setDiskArchiveVSNHost("");
                archiveCopy.setArchiveVSNMap(archiveVSNMap);
                ReservationMethodHelper rmh = new ReservationMethodHelper();
                String rmAttributes = (String)this.wizardModel.getValue("rmAttributes");
                if (!SelectableGroupHelper.NOVAL.equals(rmAttributes)) {
                    rmh.setAttributes(Integer.parseInt(rmAttributes));
                }
                if ("true".equals(rmPolicy = (String)this.wizardModel.getValue("rmPolicy"))) {
                    rmh.setSet(1);
                }
                if ("true".equals(rmFS = (String)this.wizardModel.getValue("rmFS"))) {
                    rmh.setFS(4);
                }
                archiveCopy.setReservationMethod(rmh.getValue());
            }
        }
        this.updateHashMap(currentCopyNumber, mediaRadio, myWrapper);
        this.updateWizardSteps();
        if (errorMessage != null) {
            this.setErrorMessage(wizardEvent, errorMessage);
            TraceUtil.trace3("Exiting");
            return false;
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processTapeCopyOptionPage(WizardEvent wizardEvent) {
        ArchiveCopy archiveCopy;
        ArchiveCopyGUIWrapper myWrapper;
        int currentCopyNumber;
        String errorMessage;
        block57: {
            block55: {
                String bufferSize;
                block54: {
                    TraceUtil.trace3("Entering");
                    errorMessage = null;
                    int page = this.pageIdToPage(wizardEvent.getPageId());
                    currentCopyNumber = this.getCopyNumberForCopyOptionPage(page);
                    myWrapper = null;
                    try {
                        myWrapper = this.getCopyGUIWrapper(currentCopyNumber);
                    }
                    catch (SamFSException samEx) {
                        TraceUtil.trace1("Exception caught while retrieving copy wrapper.");
                        this.setWizardModelErrorMessage(samEx.getMessage(), samEx.getSAMerrno());
                        return true;
                    }
                    archiveCopy = myWrapper.getArchiveCopy();
                    String offlineCopyString = (String)this.wizardModel.getValue("OfflineCopyDropDown");
                    if (!SelectableGroupHelper.NOVAL.equals(offlineCopyString)) {
                        archiveCopy.setOfflineCopyMethod(Integer.parseInt(offlineCopyString));
                    } else {
                        archiveCopy.setOfflineCopyMethod(-1);
                    }
                    String drives = (String)this.wizardModel.getValue("DrivesTextField");
                    String string = drives = drives != null ? drives.trim() : "";
                    if (!drives.equals("")) {
                        try {
                            int d = Integer.parseInt(drives);
                            if (d < 0) {
                                errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.drives" : errorMessage;
                                break block54;
                            }
                            archiveCopy.setDrives(d);
                        }
                        catch (NumberFormatException nfe) {
                            errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.drives" : errorMessage;
                        }
                    } else {
                        archiveCopy.setDrives(-1);
                    }
                }
                String drivesMin = (String)this.wizardModel.getValue("DrivesMinTextField");
                String drivesMax = (String)this.wizardModel.getValue("DrivesMaxTextField");
                String drivesMinUnit = (String)this.wizardModel.getValue("DrivesMinSizeDropDown");
                String drivesMaxUnit = (String)this.wizardModel.getValue("DrivesMaxSizeDropDown");
                drivesMin = drivesMin != null ? drivesMin.trim() : "";
                String string = drivesMax = drivesMax != null ? drivesMax.trim() : "";
                if (!drivesMin.equals("") && drivesMax.equals("")) {
                    errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.minmaxeither" : errorMessage;
                } else if (drivesMin.equals("") && !drivesMax.equals("")) {
                    errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.minmaxeither" : errorMessage;
                } else if (!drivesMin.equals("") && drivesMinUnit.equals(SelectableGroupHelper.NOVAL)) {
                    errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.mindrivesunit" : errorMessage;
                } else if (!drivesMax.equals("") && drivesMaxUnit.equals(SelectableGroupHelper.NOVAL)) {
                    errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.maxdrivesunit" : errorMessage;
                }
                long drivesMinimum = -1L;
                long drivesMaximum = -1L;
                try {
                    if (!drivesMin.equals("") && (drivesMinimum = Long.parseLong(drivesMin)) < 0L) {
                        errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.mindrives" : errorMessage;
                    }
                }
                catch (NumberFormatException numEx) {
                    TraceUtil.trace1("Drive Minimum Size is not an integer");
                    errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.mindrives" : errorMessage;
                }
                try {
                    if (!drivesMax.equals("") && (drivesMaximum = Long.parseLong(drivesMax)) < 0L) {
                        errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.maxdrives" : errorMessage;
                    }
                }
                catch (NumberFormatException numEx) {
                    TraceUtil.trace1("Drive Maximum Size is not an integer");
                    String string2 = errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.maxdrives" : errorMessage;
                }
                if (!(drivesMin.equals("") || drivesMax.equals("") || PolicyUtil.isMaxGreaterThanMin(drivesMinimum, Integer.parseInt(drivesMinUnit), drivesMaximum, Integer.parseInt(drivesMaxUnit)))) {
                    String string3 = errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.mingreaterthanmax" : errorMessage;
                }
                if (errorMessage == null) {
                    if (!drivesMin.equals("")) {
                        archiveCopy.setMinDrives(drivesMinimum);
                        archiveCopy.setMinDrivesUnit(Integer.parseInt(drivesMinUnit));
                        archiveCopy.setMaxDrives(drivesMaximum);
                        archiveCopy.setMaxDrivesUnit(Integer.parseInt(drivesMaxUnit));
                    } else {
                        archiveCopy.setMinDrives(-1L);
                        archiveCopy.setMinDrivesUnit(-1);
                        archiveCopy.setMaxDrives(-1L);
                        archiveCopy.setMaxDrivesUnit(-1);
                    }
                }
                String string4 = bufferSize = (bufferSize = (String)this.wizardModel.getValue("BufferSizeTextField")) != null ? bufferSize.trim() : "";
                if (!bufferSize.equals("")) {
                    try {
                        int size = Integer.parseInt(bufferSize);
                        if (size < 2 || size > 1024) {
                            errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.buffersize" : errorMessage;
                            break block55;
                        }
                        archiveCopy.setBufferSize(size);
                    }
                    catch (NumberFormatException numEx) {
                        errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.buffersize" : errorMessage;
                    }
                } else {
                    archiveCopy.setBufferSize(-1);
                }
            }
            String lockCheckBox = (String)this.wizardModel.getValue("LockCheckBox");
            boolean locked = lockCheckBox.equals("true");
            archiveCopy.setBufferLocked(locked);
            String startAge = (String)this.wizardModel.getValue("StartAgeTextField");
            String startAgeUnit = (String)this.wizardModel.getValue("StartAgeDropDown");
            String string = startAge = startAge != null ? startAge.trim() : "";
            if (!startAge.equals("")) {
                try {
                    long age = Long.parseLong(startAge);
                    int ageUnit = Integer.parseInt(startAgeUnit);
                    if (age >= 0L && !startAgeUnit.equals(SelectableGroupHelper.NOVAL)) {
                        archiveCopy.setStartAge(age);
                        archiveCopy.setStartAgeUnit(ageUnit);
                    } else if (age < 0L) {
                        errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startage" : errorMessage;
                    } else if (startAgeUnit.equals(SelectableGroupHelper.NOVAL)) {
                        errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startageunit" : errorMessage;
                    }
                }
                catch (NumberFormatException numEx) {
                    errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startage" : errorMessage;
                }
            } else {
                archiveCopy.setStartAge(-1L);
                archiveCopy.setStartAgeUnit(-1);
            }
            String startCount = (String)this.wizardModel.getValue("StartCountTextField");
            String string5 = startCount = startCount != null ? startCount.trim() : "";
            if (!startCount.equals("")) {
                try {
                    int count = Integer.parseInt(startCount);
                    if (count < 0) {
                        errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startcount" : errorMessage;
                        break block57;
                    }
                    archiveCopy.setStartCount(count);
                }
                catch (NumberFormatException numEx) {
                    errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startcount" : errorMessage;
                }
            } else {
                archiveCopy.setStartCount(-1);
            }
        }
        String startSize = (String)this.wizardModel.getValue("StartSizeTextField");
        String startSizeUnit = (String)this.wizardModel.getValue("StartSizeDropDown");
        String string = startSize = startSize != null ? startSize.trim() : "";
        if (!startSize.equals("")) {
            try {
                long size = Long.parseLong(startSize);
                int sizeUnit = Integer.parseInt(startSizeUnit);
                if (size >= 0L && !startSizeUnit.equals(SelectableGroupHelper.NOVAL)) {
                    archiveCopy.setStartSize(size);
                    archiveCopy.setStartSizeUnit(sizeUnit);
                } else {
                    if (size < 0L) {
                        String string6 = errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startsize" : errorMessage;
                    }
                    if (startSizeUnit.equals(SelectableGroupHelper.NOVAL)) {
                        errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startsizeunit" : errorMessage;
                    }
                }
            }
            catch (NumberFormatException numEx) {
                errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startsize" : errorMessage;
            }
        } else {
            archiveCopy.setStartSize(-1L);
            archiveCopy.setStartSizeUnit(-1);
        }
        this.updateHashMap(currentCopyNumber, this.getCopyType(new Integer(currentCopyNumber)), myWrapper);
        if (errorMessage != null) {
            this.setErrorMessage(wizardEvent, errorMessage);
            TraceUtil.trace3("Exiting");
            return false;
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processDiskCopyOptionPage(WizardEvent wizardEvent) {
        ArchiveCopyGUIWrapper myWrapper;
        int currentCopyNumber;
        String errorMessage;
        block50: {
            ArchiveCopy archiveCopy;
            block49: {
                block47: {
                    block45: {
                        TraceUtil.trace3("Entering");
                        errorMessage = null;
                        int page = this.pageIdToPage(wizardEvent.getPageId());
                        currentCopyNumber = this.getCopyNumberForCopyOptionPage(page);
                        myWrapper = null;
                        try {
                            myWrapper = this.getCopyGUIWrapper(currentCopyNumber);
                        }
                        catch (SamFSException samEx) {
                            TraceUtil.trace1("Exception caught while retrieving copy wrapper.");
                            this.setWizardModelErrorMessage(samEx.getMessage(), samEx.getSAMerrno());
                            return true;
                        }
                        archiveCopy = myWrapper.getArchiveCopy();
                        String offlineCopyString = (String)this.wizardModel.getValue("OfflineCopyDropDown");
                        if (!offlineCopyString.equals(SelectableGroupHelper.NOVAL)) {
                            int ocMethod = Integer.parseInt(offlineCopyString);
                            archiveCopy.setOfflineCopyMethod(ocMethod);
                        } else {
                            archiveCopy.setOfflineCopyMethod(-1);
                        }
                        String bufferSize = (String)this.wizardModel.getValue("BufferSizeTextField");
                        String string = bufferSize = bufferSize != null ? bufferSize.trim() : "";
                        if (!bufferSize.equals("")) {
                            try {
                                int size = Integer.parseInt(bufferSize);
                                if (size < 2 || size > 1024) {
                                    errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.buffersize" : errorMessage;
                                    break block45;
                                }
                                archiveCopy.setBufferSize(size);
                            }
                            catch (NumberFormatException numEx) {
                                errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.buffersize" : errorMessage;
                            }
                        } else {
                            archiveCopy.setBufferSize(-1);
                        }
                    }
                    String lockCheckBox = (String)this.wizardModel.getValue("LockCheckBox");
                    boolean locked = lockCheckBox.equals("true");
                    archiveCopy.setBufferLocked(locked);
                    String startAge = (String)this.wizardModel.getValue("StartAgeTextField");
                    String startAgeUnit = (String)this.wizardModel.getValue("StartAgeDropDown");
                    String string = startAge = startAge != null ? startAge.trim() : "";
                    if (!startAge.equals("")) {
                        try {
                            long age = Long.parseLong(startAge);
                            if (age >= 0L && !startAgeUnit.equals(SelectableGroupHelper.NOVAL)) {
                                int ageUnit = Integer.parseInt(startAgeUnit);
                                archiveCopy.setStartAge(age);
                                archiveCopy.setStartAgeUnit(ageUnit);
                            } else if (age < 0L) {
                                errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startage" : errorMessage;
                            } else if (startAgeUnit.equals(SelectableGroupHelper.NOVAL)) {
                                errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startageunit" : errorMessage;
                            }
                        }
                        catch (NumberFormatException numEx) {
                            errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startage" : errorMessage;
                        }
                    } else {
                        archiveCopy.setStartAge(-1L);
                        archiveCopy.setStartAgeUnit(-1);
                    }
                    String startCount = (String)this.wizardModel.getValue("StartCountTextField");
                    String string2 = startCount = startCount != null ? startCount.trim() : "";
                    if (!startCount.equals("")) {
                        try {
                            int count = Integer.parseInt(startCount);
                            if (count < 0) {
                                errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startcount" : errorMessage;
                                break block47;
                            }
                            archiveCopy.setStartCount(count);
                        }
                        catch (NumberFormatException numEx) {
                            errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startcoun" : errorMessage;
                        }
                    } else {
                        archiveCopy.setStartCount(-1);
                    }
                }
                String startSize = (String)this.wizardModel.getValue("StartSizeTextField");
                String startSizeUnit = (String)this.wizardModel.getValue("StartSizeDropDown");
                String string = startSize = startSize != null ? startSize.trim() : "";
                if (!startSize.equals("")) {
                    try {
                        long size = Long.parseLong(startSize);
                        if (size >= 0L && !startSizeUnit.equals(SelectableGroupHelper.NOVAL)) {
                            int sizeUnit = Integer.parseInt(startSizeUnit);
                            archiveCopy.setStartSize(size);
                            archiveCopy.setStartSizeUnit(sizeUnit);
                        } else if (size < 0L) {
                            errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startsize" : errorMessage;
                        } else if (startSizeUnit.equals(SelectableGroupHelper.NOVAL)) {
                            errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startsizeunit" : errorMessage;
                        }
                    }
                    catch (NumberFormatException numEx) {
                        errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.startsize" : errorMessage;
                    }
                } else {
                    archiveCopy.setStartSize(-1L);
                    archiveCopy.setStartSizeUnit(-1);
                }
                String recycleHwm = (String)this.wizardModel.getValue("RecycleHwmTextField");
                String string3 = recycleHwm = recycleHwm != null ? recycleHwm.trim() : "";
                if (!recycleHwm.equals("")) {
                    try {
                        int hwm = Integer.parseInt(recycleHwm);
                        if (hwm > 100 || hwm < 0) {
                            errorMessage = errorMessage == null ? "NewArchivePolWizard.page5.errRecycleHwm" : errorMessage;
                            break block49;
                        }
                        archiveCopy.setRecycleHWM(hwm);
                    }
                    catch (NumberFormatException numEx) {
                        errorMessage = errorMessage == null ? "NewArchivePolWizard.page5.errRecycleHwm" : errorMessage;
                    }
                } else {
                    archiveCopy.setRecycleHWM(-1);
                }
            }
            String ignoreRecycling = (String)this.wizardModel.getValue("IgnoreRecyclingCheckBox");
            boolean isIgnore = ignoreRecycling.equals("true");
            archiveCopy.setIgnoreRecycle(isIgnore);
            String mailAddress = (String)this.wizardModel.getValue("mailAddress");
            String string = mailAddress = mailAddress != null ? mailAddress.trim() : "";
            if (mailAddress.indexOf(" ") != -1) {
                errorMessage = errorMessage == null ? "NewArchivePolWizard.page5.errMailingAddress" : errorMessage;
            } else {
                archiveCopy.setNotificationAddress(mailAddress);
            }
            String minGain = (String)this.wizardModel.getValue("MinGainTextField");
            String string4 = minGain = minGain != null ? minGain.trim() : "";
            if (!minGain.equals("")) {
                try {
                    int gain = Integer.parseInt(minGain);
                    if (gain > 100 || gain < 0) {
                        errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.mingain" : errorMessage;
                        break block50;
                    }
                    archiveCopy.setMinGain(gain);
                }
                catch (NumberFormatException numEx) {
                    errorMessage = errorMessage == null ? "NewPolicyWizard.copyoption.error.mingain" : errorMessage;
                }
            } else {
                archiveCopy.setMinGain(-1);
            }
        }
        this.updateHashMap(currentCopyNumber, this.getCopyType(new Integer(currentCopyNumber)), myWrapper);
        if (errorMessage != null) {
            this.setErrorMessage(wizardEvent, errorMessage);
            TraceUtil.trace3("Exiting");
            return false;
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processApplyToFSPage(WizardEvent wizardEvent, boolean isNextStep) {
        TraceUtil.trace3("Entering");
        try {
            NewPolicyWizardApplyToFSView pageView = (NewPolicyWizardApplyToFSView)wizardEvent.getView();
            CCActionTable actionTable = (CCActionTable)pageView.getChild("ApplyToFSTable");
            actionTable.restoreStateData();
            CCActionTableModel fsModel = (CCActionTableModel)actionTable.getModel();
            Integer[] selectedRows = fsModel.getSelectedRows();
            if (selectedRows.length == 0 && isNextStep) {
                this.setErrorMessage(wizardEvent, "Reservation.page2.errMsg");
                return false;
            }
            NonSyncStringBuffer selectedFSList = new NonSyncStringBuffer();
            for (int i = 0; i < selectedRows.length; ++i) {
                if (i != 0) {
                    selectedFSList.append("<br>");
                }
                fsModel.setRowIndex(selectedRows[i].intValue());
                String fsName = (String)fsModel.getValue("NameText");
                selectedFSList.append(fsName);
            }
            this.wizardModel.setValue(SELECTED_FS_LIST, selectedFSList.toString());
        }
        catch (ModelControlException mcex) {
            SamUtil.processException((Exception)((Object)mcex), this.getClass(), "processApplyToFSPage", "Failed to save file system selections", this.getServerName());
            this.setWizardModelErrorMessage(mcex.getMessage(), 8001234);
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    boolean processSavePage(WizardEvent wizardEvent, boolean isNextStep) {
        TraceUtil.trace3("Entering");
        String saveRadio = (String)this.wizardModel.getValue("SaveRadioButton");
        String dumpPath = (String)this.wizardModel.getValue("SaveTextField");
        String string = dumpPath = dumpPath != null ? dumpPath.trim() : "";
        if (!isNextStep) {
            if (saveRadio != null) {
                if (saveRadio.equals("NewArchivePolWizard.page7.commit")) {
                    this.wizardModel.setValue("DUMP", "off");
                } else {
                    this.wizardModel.setValue("DUMP", "on");
                    this.wizardModel.setValue("LOCATION", dumpPath);
                }
            }
        } else {
            if (saveRadio == null) {
                this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page7.errMsg2");
                return false;
            }
            if (saveRadio.equals("NewArchivePolWizard.page7.commit")) {
                this.wizardModel.setValue("DUMP", "off");
                this.wizardModel.setValue("saveValue", SamUtil.getResourceString("NewArchivePolWizard.page7.commit"));
            } else {
                if (dumpPath.equals("")) {
                    this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page7.errMsg1");
                    return false;
                }
                if (!SamUtil.isValidNonSpecialCharString(dumpPath)) {
                    this.setErrorMessage(wizardEvent, "NewArchivePolWizard.page7.errMsg3");
                    return false;
                }
                this.wizardModel.setValue("DUMP", "on");
                this.wizardModel.setValue("LOCATION", dumpPath);
                this.wizardModel.setValue("saveValue", new NonSyncStringBuffer(SamUtil.getResourceString("NewArchivePolWizard.page7.save")).append(" ").append(dumpPath));
            }
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private ArchivePolCriteriaProp getCriteriaProperties() {
        return (ArchivePolCriteriaProp)this.wizardModel.getValue(CRITERIA_PROPERTIES);
    }

    public ArchiveCopyGUIWrapper getCopyGUIWrapper(int copyNumber2) throws SamFSException {
        CopyInfo info = (CopyInfo)this.copyNumberHashMap.get(new Integer(copyNumber2));
        if (info == null) {
            SamUtil.doPrint("HashMap contains null CopyInfo object!");
            SamUtil.doPrint("Getting default wrapper, create CopyInfo and insert to map");
            ArchiveCopyGUIWrapper defaultWrapper = this.getDefaultWrapper();
            this.copyNumberHashMap.put(new Integer(copyNumber2), new CopyInfo(DISK_BASE, defaultWrapper));
            this.wizardModel.setValue(COPY_HASHMAP, this.copyNumberHashMap);
            return defaultWrapper;
        }
        return info.getCopyWrapper();
    }

    public ArchiveCopyGUIWrapper getDefaultWrapper() throws SamFSException {
        SamUtil.doPrint("getDefaultWrapper called");
        ArchiveCopyGUIWrapper wrapper = PolicyUtil.getArchiveManager(this.getServerName()).getArchiveCopyGUIWrapper();
        if (wrapper == null) {
            throw new SamFSException(null, -2023);
        }
        return wrapper;
    }

    private String saveCopyMediaRadioButtonSetting() {
        String mediaRadio = (String)this.wizardModel.getValue("MedTypeRadio1");
        if (mediaRadio == null) {
            return TAPE_BASE;
        }
        return mediaRadio;
    }

    private boolean isPolicyNameInUsed(String policyName) throws SamFSException {
        TraceUtil.trace3("Entering");
        String[] existingPolicyNames = PolicyUtil.getArchiveManager(this.getServerName()).getAllArchivePolicyNames();
        for (int i = 0; i < existingPolicyNames.length; ++i) {
            if (!policyName.equals(existingPolicyNames[i])) continue;
            SamUtil.doPrint(new NonSyncStringBuffer("PolicyName ").append(policyName).append(" is in used!").toString());
            return true;
        }
        return false;
    }

    private void updateWizardSteps() {
        int totalPages = -1;
        int numOfCopies = (Integer)this.wizardModel.getValue(TOTAL_COPIES);
        int currentHashMapSize = this.getCopyNumberHashMapSize();
        totalPages = this.dumpOn ? 6 + 2 * numOfCopies : 5 + 2 * numOfCopies;
        this.pages = new int[totalPages];
        this.pages[0] = 0;
        this.pages[1] = 1;
        for (int i = 0; i < numOfCopies; ++i) {
            this.pages[2 + i * 2] = 2;
            if (currentHashMapSize > i) {
                String copyType = this.getCopyType(new Integer(i + 1));
                if (copyType.equals(TAPE_BASE)) {
                    this.pages[3 + i * 2] = 3;
                    continue;
                }
                this.pages[3 + i * 2] = 4;
                continue;
            }
            this.pages[3 + i * 2] = 3;
        }
        this.pages[2 + numOfCopies * 2] = 5;
        if (this.dumpOn) {
            this.pages[3 + numOfCopies * 2] = 6;
            this.pages[4 + numOfCopies * 2] = 7;
            this.pages[5 + numOfCopies * 2] = 8;
        } else {
            this.pages[3 + numOfCopies * 2] = 7;
            this.pages[4 + numOfCopies * 2] = 8;
        }
        this.initializeWizardPages(this.pages);
    }

    private void updateHashMap(int copyNumber2, String type, ArchiveCopyGUIWrapper myWrapper) {
        this.copyNumberHashMap.put(new Integer(copyNumber2), new CopyInfo(type, myWrapper));
        this.wizardModel.setValue(COPY_HASHMAP, this.copyNumberHashMap);
    }

    private int getCopyNumberHashMapSize() {
        return this.copyNumberHashMap.size();
    }

    private String getCopyType(Integer number) {
        String copyType = "";
        CopyInfo info = (CopyInfo)this.copyNumberHashMap.get(number);
        if (info != null) {
            copyType = info.getCopyType();
        }
        return copyType;
    }

    private boolean isPageCopyParameters(int page) {
        int totalCopies = (Integer)this.wizardModel.getValue(TOTAL_COPIES);
        if (page < totalCopies * 2 + 1) {
            for (int i = 0; i < totalCopies; ++i) {
                if (page != 2 + i * 2) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPageDiskOrTapeCopyOption(int page) {
        int totalCopies = (Integer)this.wizardModel.getValue(TOTAL_COPIES) - 1;
        if (page < totalCopies * 2 + 2) {
            for (int i = 0; i < totalCopies; ++i) {
                if (page != 4 + i * 2 && page != 3 + i * 2) continue;
                return true;
            }
        }
        return false;
    }

    private String getServerName() {
        String serverName = (String)this.wizardModel.getValue("SERVER_NAME");
        return serverName == null ? "" : serverName;
    }

    private boolean noArchiveExists() {
        return Boolean.valueOf((String)this.wizardModel.getValue(NO_ARCHIVE_EXISTS));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

