/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.RequestManager;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.VSNPool;
import com.sun.netstorage.samqfs.web.util.Capacity;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import java.util.ArrayList;
import javax.servlet.http.HttpSession;

public final class VSNPoolSummaryData
extends ArrayList {
    public static final String[] headings = new String[]{"VSNPoolSummary.heading1", "VSNPoolSummary.heading2", "VSNPoolSummary.heading3", "VSNPoolSummary.heading4"};
    public static final String[] buttons = new String[]{"VSNPoolSummary.button1", "VSNPoolSummary.button2", "VSNPoolSummary.button3"};

    public VSNPoolSummaryData() throws SamFSException {
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        HttpSession session = RequestManager.getRequestContext().getRequest().getSession();
        SamQFSSystemModel sysModel = SamUtil.getModel();
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        VSNPool[] vsnpool = sysModel.getSamQFSSystemArchiveManager43().getAllVSNPools();
        if (vsnpool == null) {
            return;
        }
        for (int i = 0; i < vsnpool.length; ++i) {
            String poolName = vsnpool[i].getPoolName();
            String poolStatus = sysModel.getSamQFSSystemArchiveManager43().isPoolInUse(poolName) ? new String("true") : new String("false");
            super.add(new Object[]{poolName, SamUtil.getMediaTypeString(vsnpool[i].getMediaType()), new Integer(vsnpool[i].getNoOfVSNsInPool()), new Capacity(vsnpool[i].getSpaceAvailable(), 2), poolStatus});
        }
        TraceUtil.trace3("Exiting");
    }
}

