/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.util.NonSyncStringBuffer;
import com.iplanet.jato.view.ContainerView;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.DisplayEvent;
import com.iplanet.jato.view.event.RequestInvocationEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.RecyclerTableModel;
import com.sun.netstorage.samqfs.web.archive.RecyclerTableTiledView;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.RecycleParams;
import com.sun.netstorage.samqfs.web.util.Authorization;
import com.sun.netstorage.samqfs.web.util.CommonViewBeanBase;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.PageTitleUtil;
import com.sun.netstorage.samqfs.web.util.PropertySheetUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.SecurityManagerFactory;
import com.sun.netstorage.samqfs.web.util.ServerInfo;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.model.CCActionTableModelInterface;
import com.sun.web.ui.model.CCPageTitleModel;
import com.sun.web.ui.model.CCPropertySheetModel;
import com.sun.web.ui.view.alert.CCAlertInline;
import com.sun.web.ui.view.html.CCButton;
import com.sun.web.ui.view.html.CCHiddenField;
import com.sun.web.ui.view.table.CCActionTable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class RecyclerViewBean
extends CommonViewBeanBase {
    private static final String PAGE_NAME = "Recycler";
    private static final String DEFAULT_DISPLAY_URL = "/jsp/archive/Recycler.jsp";
    private static final int TAB_NAME = 18;
    public static final String CHILD_ALERT = "Alert";
    public static final String CHILD_RECYCLERTILED_VIEW = "RecyclerTableTiledView";
    public static final String CHILD_RECYCLER_TABLE = "recyclerTable";
    public static final String CHILD_LIB_SIZE = "libNumber";
    public static final String CHILD_HIDDEN_MESSAGES = "HiddenMessages";
    private static CCPageTitleModel pageTitleModel = null;
    private static CCPropertySheetModel propertySheetModel = null;
    private RecyclerTableModel recyclerTableModel;
    static /* synthetic */ Class class$com$sun$web$ui$view$table$CCActionTable;
    static /* synthetic */ Class class$com$sun$netstorage$samqfs$web$archive$RecyclerTableTiledView;
    static /* synthetic */ Class class$com$sun$web$ui$view$alert$CCAlertInline;
    static /* synthetic */ Class class$com$sun$web$ui$view$html$CCHiddenField;

    public RecyclerViewBean() {
        super(PAGE_NAME, DEFAULT_DISPLAY_URL, 18);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.createPageTitleModel();
        this.createPropertySheetModel();
        this.registerChildren();
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        super.registerChildren();
        this.registerChild(CHILD_RECYCLER_TABLE, class$com$sun$web$ui$view$table$CCActionTable == null ? (class$com$sun$web$ui$view$table$CCActionTable = RecyclerViewBean.class$("com.sun.web.ui.view.table.CCActionTable")) : class$com$sun$web$ui$view$table$CCActionTable);
        this.registerChild(CHILD_RECYCLERTILED_VIEW, class$com$sun$netstorage$samqfs$web$archive$RecyclerTableTiledView == null ? (class$com$sun$netstorage$samqfs$web$archive$RecyclerTableTiledView = RecyclerViewBean.class$("com.sun.netstorage.samqfs.web.archive.RecyclerTableTiledView")) : class$com$sun$netstorage$samqfs$web$archive$RecyclerTableTiledView);
        this.registerChild(CHILD_ALERT, class$com$sun$web$ui$view$alert$CCAlertInline == null ? (class$com$sun$web$ui$view$alert$CCAlertInline = RecyclerViewBean.class$("com.sun.web.ui.view.alert.CCAlertInline")) : class$com$sun$web$ui$view$alert$CCAlertInline);
        this.registerChild(CHILD_HIDDEN_MESSAGES, class$com$sun$web$ui$view$html$CCHiddenField == null ? (class$com$sun$web$ui$view$html$CCHiddenField = RecyclerViewBean.class$("com.sun.web.ui.view.html.CCHiddenField")) : class$com$sun$web$ui$view$html$CCHiddenField);
        PageTitleUtil.registerChildren((ContainerViewBase)this, pageTitleModel);
        PropertySheetUtil.registerChildren((ContainerViewBase)this, propertySheetModel);
        TraceUtil.trace3("Exiting");
    }

    public void mapRequestParameters(HttpServletRequest request) throws ModelControlException {
        SamUtil.doPrint("BEFORE SUPER");
        super.mapRequestParameters(request);
        SamUtil.doPrint("AFTER SUPER");
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering");
        Object child = null;
        if (super.isChildSupported(name)) {
            child = super.createChild(name);
        } else if (name.equals(CHILD_ALERT)) {
            CCAlertInline myChild = new CCAlertInline((ContainerView)this, name, null);
            myChild.setValue((Object)"info");
            child = myChild;
        } else if (name.equals(CHILD_RECYCLERTILED_VIEW)) {
            child = new RecyclerTableTiledView((View)this, this.recyclerTableModel, name);
        } else if (name.equals(CHILD_RECYCLER_TABLE)) {
            CCActionTable myChild = new CCActionTable((ContainerView)this, (CCActionTableModelInterface)this.recyclerTableModel, name);
            myChild.setTiledView((ContainerView)this.getChild(CHILD_RECYCLERTILED_VIEW));
            propertySheetModel.setModel(CHILD_RECYCLER_TABLE, (Object)this.recyclerTableModel);
            child = myChild;
        } else if (name.equals(CHILD_LIB_SIZE)) {
            child = new CCHiddenField((ContainerView)this, name, null);
        } else if (name.equals(CHILD_HIDDEN_MESSAGES)) {
            child = new CCHiddenField((ContainerView)this, name, (Object)this.getMessageString());
        } else if (PageTitleUtil.isChildSupported(pageTitleModel, name)) {
            child = PageTitleUtil.createChild((ContainerView)this, pageTitleModel, name);
        } else if (PropertySheetUtil.isChildSupported(propertySheetModel, name)) {
            child = PropertySheetUtil.createChild((ContainerView)this, propertySheetModel, name);
        } else {
            throw new IllegalArgumentException("Invalid child name [" + name + "]");
        }
        TraceUtil.trace3("Exiting");
        return child;
    }

    public void beginDisplay(DisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        this.loadPropertySheetModel();
        this.loadAllTables();
        if (!SecurityManagerFactory.getSecurityManager().hasAuthorization(Authorization.SAM_CONTROL)) {
            ((CCButton)this.getChild("SavePageButton")).setDisabled(true);
            ((CCButton)this.getChild("ResetPageButton")).setDisabled(true);
        } else {
            ((CCButton)this.getChild("SavePageButton")).setDisabled(false);
        }
        ((CCHiddenField)this.getChild(CHILD_LIB_SIZE)).setValue((Object)Integer.toString(this.recyclerTableModel.getNumRows()));
        TraceUtil.trace3("Exiting");
    }

    private void createPageTitleModel() {
        TraceUtil.trace3("Entering");
        if (pageTitleModel == null) {
            pageTitleModel = PageTitleUtil.createModel("/jsp/archive/RecyclerPageTitle.xml");
        }
        TraceUtil.trace3("Exiting");
    }

    private void createPropertySheetModel() {
        TraceUtil.trace3("Entering");
        if (propertySheetModel == null) {
            propertySheetModel = PropertySheetUtil.createModel("jsp/archive/RecyclerPropSheet.xml");
        }
        if (this.recyclerTableModel == null) {
            this.recyclerTableModel = new RecyclerTableModel();
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadPropertySheetModel() {
        TraceUtil.trace3("Entering");
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            String recyclerLog = sysModel.getSamQFSSystemArchiveManager43().getRecyclerLogFile();
            propertySheetModel.setValue("recyclerlogValue", (Object)recyclerLog);
            if (sysModel.getSamQFSSystemArchiveManager43().getPostRecycle() == 0) {
                propertySheetModel.setValue("postrecyclerValue", (Object)"relabel");
            } else if (sysModel.getSamQFSSystemArchiveManager43().getPostRecycle() == 1) {
                propertySheetModel.setValue("postrecyclerValue", (Object)"export");
            }
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "loadPropertySheetModel", "Failed to retrieve model", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "AdminSetup.error.failedPopulate", ex.getSAMerrno(), ex.getMessage(), this.getServerName());
        }
        TraceUtil.trace3("Exiting");
    }

    private void showAlert() {
        TraceUtil.trace3("Entering");
        SamUtil.setInfoAlert((ContainerView)this, CHILD_ALERT, "success.summary", SamUtil.getResourceString("success.details", "AdminSetup.save"));
        TraceUtil.trace3("Exiting");
    }

    public void handleSavePageButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        ServerInfo serverInfo;
        TraceUtil.trace3("Entering");
        String samfsServerAPIVersion = "1.1";
        boolean shouldCall = false;
        HttpSession session = event.getRequestContext().getRequest().getSession();
        Hashtable serverTable = (Hashtable)session.getAttribute("SAMFS_SERVER_INFO");
        String hostName = (String)session.getAttribute("SERVER_NAME");
        if (serverTable != null && hostName != null && (serverInfo = (ServerInfo)serverTable.get(hostName)) != null) {
            samfsServerAPIVersion = serverInfo.getSamfsServerAPIVersion();
        }
        TraceUtil.trace2("samfsServerAPIVersion = " + samfsServerAPIVersion);
        if (samfsServerAPIVersion.compareTo("1.2") >= 0) {
            shouldCall = true;
        }
        try {
            SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
            if (sysModel == null) {
                throw new SamFSException(null, -2001);
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleSavePageButtonRequest", "Start saving the configuration");
            this.saveRecycler(sysModel);
            String recyclerLog = ((String)this.getDisplayFieldValue("recyclerlogValue")).trim();
            if (recyclerLog.equals("") && !sysModel.getSamQFSSystemArchiveManager43().getRecyclerLogFile().equals("")) {
                sysModel.getSamQFSSystemArchiveManager43().setRecyclerLogFile("");
            } else if (!recyclerLog.equals(sysModel.getSamQFSSystemArchiveManager43().getRecyclerLogFile())) {
                sysModel.getSamQFSSystemArchiveManager43().setRecyclerLogFile(recyclerLog);
            } else if (shouldCall && !sysModel.doesFileExist(recyclerLog)) {
                TraceUtil.trace3("recycler file doesn't exist");
                sysModel.getSamQFSSystemArchiveManager43().setRecyclerLogFile(recyclerLog);
            }
            String postRecycler = (String)this.getDisplayFieldValue("postrecyclerValue");
            if (postRecycler != null) {
                if (postRecycler.equals("relabel")) {
                    if (sysModel.getSamQFSSystemArchiveManager43().getPostRecycle() != 0) {
                        sysModel.getSamQFSSystemArchiveManager43().setPostRecycle(0);
                    }
                } else if (postRecycler.equals("export") && sysModel.getSamQFSSystemArchiveManager43().getPostRecycle() != 1) {
                    sysModel.getSamQFSSystemArchiveManager43().setPostRecycle(1);
                }
            }
            LogUtil.info(((Object)((Object)this)).getClass(), "handleSavePageButtonRequest", "Done saving the configuration");
            this.showAlert();
        }
        catch (SamFSException ex) {
            SamUtil.processException((Exception)((Object)ex), ((Object)((Object)this)).getClass(), "handleSavePageButtonRequest", "Failed to save configuration", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "AdminSetup.error.save", ex.getSAMerrno(), ex.getMessage(), this.getServerName());
        }
        this.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    public void handleCancelPageButtonRequest(RequestInvocationEvent event) throws ServletException, IOException {
        TraceUtil.trace3("Entering");
        this.forwardTo(this.getRequestContext());
        TraceUtil.trace3("Exiting");
    }

    private void saveRecycler(SamQFSSystemModel sysModel) throws SamFSException {
        TraceUtil.trace3("Entering");
        RecycleParams[] recyclers = sysModel.getSamQFSSystemArchiveManager43().getRecycleParams();
        int size = recyclers.length;
        int tableSize = this.recyclerTableModel.getNumRows();
        for (int i = 0; i < tableSize && size > 0; ++i) {
            this.recyclerTableModel.setRowIndex(i);
            String libName = (String)this.recyclerTableModel.getValue("LibNameHiddenField");
            int hwm = -1;
            int gain = -1;
            int vsn = -1;
            int unit = -1;
            long sizeLimit = -1L;
            String hwmString = (String)this.recyclerTableModel.getValue("hwm");
            String gainString = (String)this.recyclerTableModel.getValue("minigain");
            String vsnString = (String)this.recyclerTableModel.getValue("vsnlimit");
            String sizelimitString = (String)this.recyclerTableModel.getValue("sizelimit");
            String sizeUnit = (String)this.recyclerTableModel.getValue("sizeunit");
            if (hwmString != null && !hwmString.equals("")) {
                try {
                    hwm = Integer.parseInt(hwmString.trim());
                }
                catch (NumberFormatException nfex) {
                    SamUtil.doPrint("NumberFormatException caught (hwmString)");
                    hwm = -1;
                }
            }
            if (gainString != null && !gainString.equals("")) {
                try {
                    gain = Integer.parseInt(gainString.trim());
                }
                catch (NumberFormatException nfex) {
                    SamUtil.doPrint("NumberFormatException caught (gainString)");
                    gain = -1;
                }
            }
            if (vsnString != null && !vsnString.equals("")) {
                try {
                    vsn = Integer.parseInt(vsnString.trim());
                }
                catch (NumberFormatException nfex) {
                    SamUtil.doPrint("NumberFormatException caught (vsnString)");
                    vsn = -1;
                }
            }
            if (sizelimitString != null && !sizelimitString.equals("")) {
                try {
                    sizeLimit = Long.parseLong(sizelimitString.trim());
                }
                catch (NumberFormatException nfex) {
                    SamUtil.doPrint("NumberFormatException caught (sizelimitString)");
                    sizeLimit = -1L;
                }
            }
            if (!sizeUnit.equals("dash")) {
                unit = SamUtil.getSizeUnit(sizeUnit);
            }
            String perform = (String)this.recyclerTableModel.getValue("report");
            RecycleParams recycler = null;
            for (int j = 0; j < size; ++j) {
                String lname = recyclers[j].getLibraryName();
                if (!lname.equals(libName)) continue;
                recycler = recyclers[j];
            }
            if (hwm != recycler.getHWM()) {
                recycler.setHWM(hwm);
            }
            if (gain != recycler.getMinGain()) {
                recycler.setMinGain(gain);
            }
            if (vsn != recycler.getVSNLimit()) {
                recycler.setVSNLimit(vsn);
            }
            if (sizeLimit != recycler.getSizeLimit()) {
                recycler.setSizeLimit(sizeLimit);
            }
            if (unit != recycler.getSizeUnit()) {
                recycler.setSizeUnit(unit);
            }
            if (perform.equals("true") && !recycler.isPerform()) {
                recycler.setPerform(true);
            } else if (perform.equals("false") && recycler.isPerform()) {
                recycler.setPerform(false);
            }
            sysModel.getSamQFSSystemArchiveManager43().changeRecycleParams(recycler);
        }
        TraceUtil.trace3("Exiting");
    }

    private void loadAllTables() {
        this.recyclerTableModel.clear();
        try {
            this.recyclerTableModel.initModelRows(this.getServerName());
            this.setPageSessionAttribute("RECYCLER_NUMBER", (Serializable)((Object)Integer.toString(this.recyclerTableModel.getNumRows())));
        }
        catch (SamFSException smfex) {
            SamUtil.processException((Exception)((Object)smfex), ((Object)((Object)this)).getClass(), "createPropertySheetModel", "Failed to populate recycler table", this.getServerName());
            SamUtil.setErrorAlert((ContainerView)this, CHILD_ALERT, "AdminSetup.error.recyclertable", smfex.getSAMerrno(), smfex.getMessage(), this.getServerName());
            this.setPageSessionAttribute("RECYCLER_NUMBER", (Serializable)((Object)"0"));
        }
    }

    private String getMessageString() {
        return new NonSyncStringBuffer(SamUtil.getResourceString("Recycler.error.hwmempty")).append("###").append(SamUtil.getResourceString("Recycler.error.hwmrange")).append("###").append(SamUtil.getResourceString("Recycler.error.gainempty")).append("###").append(SamUtil.getResourceString("Recycler.error.gainrange")).append("###").append(SamUtil.getResourceString("AdminSetup.error.vsnempty")).append("###").append(SamUtil.getResourceString("AdminSetup.error.vsnrange")).append("###").append(SamUtil.getResourceString("AdminSetup.error.sizeempty")).append("###").append(SamUtil.getResourceString("AdminSetup.error.sizerange")).append("###").append(SamUtil.getResourceString("AdminSetup.error.recycler")).append("###").append(SamUtil.getResourceString("AdminSetup.error.recyclerspace")).append("###").append(SamUtil.getResourceString("AdminSetup.error.sizeunitdash")).append("###").append(SamUtil.getResourceString("AdminSetup.error.sizeunitnodash")).append("###").append(SamUtil.getResourceString("AdminSetup.error.hwmgain")).toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

