/*
 * Decompiled with CFR 0.152.
 */
package com.sun.netstorage.samqfs.web.archive;

import com.iplanet.jato.model.DatasetModel;
import com.iplanet.jato.model.ModelControlException;
import com.iplanet.jato.view.ContainerViewBase;
import com.iplanet.jato.view.RequestHandlingTiledViewBase;
import com.iplanet.jato.view.View;
import com.iplanet.jato.view.event.ChildDisplayEvent;
import com.sun.netstorage.samqfs.mgmt.SamFSException;
import com.sun.netstorage.samqfs.web.archive.RecyclerTableModel;
import com.sun.netstorage.samqfs.web.model.SamQFSSystemModel;
import com.sun.netstorage.samqfs.web.model.archive43.RecycleParams;
import com.sun.netstorage.samqfs.web.util.LogUtil;
import com.sun.netstorage.samqfs.web.util.SamUtil;
import com.sun.netstorage.samqfs.web.util.TraceUtil;
import com.sun.web.ui.view.html.CCCheckBox;
import com.sun.web.ui.view.html.CCDropDownMenu;
import com.sun.web.ui.view.html.CCTextField;
import javax.servlet.http.HttpServletRequest;

public class RecyclerTableTiledView
extends RequestHandlingTiledViewBase {
    private RecyclerTableModel model;

    public RecyclerTableTiledView(View parent, RecyclerTableModel model, String name) {
        super(parent, name);
        TraceUtil.initTrace();
        TraceUtil.trace3("Entering");
        this.model = model;
        this.registerChildren();
        this.setPrimaryModel((DatasetModel)model);
        TraceUtil.trace3("Exiting");
    }

    protected void registerChildren() {
        TraceUtil.trace3("Entering");
        this.model.registerChildren((ContainerViewBase)this);
        TraceUtil.trace3("Exiting");
    }

    public void mapRequestParameters(HttpServletRequest request) throws ModelControlException {
        String numRows = (String)this.getParentViewBean().getPageSessionAttribute("RECYCLER_NUMBER");
        if (!numRows.equals("0")) {
            super.mapRequestParameters(request);
        }
    }

    protected View createChild(String name) {
        TraceUtil.trace3("Entering");
        if (this.model.isChildSupported(name)) {
            TraceUtil.trace3("Exiting");
            return this.model.createChild((View)this, name);
        }
        throw new IllegalArgumentException("Invalid child name [" + name + "]");
    }

    public boolean beginReportDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        try {
            ((CCCheckBox)this.getChild("report", index)).setValue((Object)this.getEditableValue("report", index));
        }
        catch (Exception smfex) {
            SamUtil.processException(smfex, ((Object)((Object)this)).getClass(), "beginReportDisplay", "Failed to retrieve recycler parameters", this.getServerName());
            throw new ModelControlException(smfex.getMessage());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginHwmDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        CCTextField hwm = (CCTextField)this.getChild("hwm", index);
        try {
            String hwmValue = this.getEditableValue("hwm", index);
            if (!hwmValue.equals("-1")) {
                hwm.setValue((Object)hwmValue);
            }
        }
        catch (Exception smfex) {
            SamUtil.processException(smfex, ((Object)((Object)this)).getClass(), "beginHwmDisplay", "Failed to retrieve recycler parameters", this.getServerName());
            throw new ModelControlException(smfex.getMessage());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginMinigainDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        try {
            String minigainValue = this.getEditableValue("mini", index);
            if (!minigainValue.equals("-1")) {
                ((CCTextField)this.getChild("minigain", index)).setValue((Object)minigainValue);
            }
        }
        catch (Exception smfex) {
            SamUtil.processException(smfex, ((Object)((Object)this)).getClass(), "beginMinigainDisplay", "Failed to retrieve recycler parameters", this.getServerName());
            throw new ModelControlException(smfex.getMessage());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginVsnlimitDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        try {
            String vsnLimitValue = this.getEditableValue("vsn", index);
            if (!vsnLimitValue.equals("-1")) {
                ((CCTextField)this.getChild("vsnlimit", index)).setValue((Object)vsnLimitValue);
            }
        }
        catch (Exception smfex) {
            SamUtil.processException(smfex, ((Object)((Object)this)).getClass(), "beginVsnlimitDisplay", "Failed to retrieve recycler parameters", this.getServerName());
            throw new ModelControlException(smfex.getMessage());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginSizelimitDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        try {
            String sizeValue = this.getEditableValue("size", index);
            if (!sizeValue.equals("-1")) {
                ((CCTextField)this.getChild("sizelimit", index)).setValue((Object)sizeValue);
            }
        }
        catch (Exception smfex) {
            SamUtil.processException(smfex, ((Object)((Object)this)).getClass(), "beginSizelimitDisplay", "Failed to retrieve recycler parameters", this.getServerName());
            throw new ModelControlException(smfex.getMessage());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    public boolean beginSizeunitDisplay(ChildDisplayEvent event) throws ModelControlException {
        TraceUtil.trace3("Entering");
        int index = this.model.getRowIndex();
        try {
            ((CCDropDownMenu)this.getChild("sizeunit", index)).setValue((Object)this.getEditableValue("sizeunit", index));
        }
        catch (Exception smfex) {
            SamUtil.processException(smfex, ((Object)((Object)this)).getClass(), "beginSizeunitDisplay", "Failed to retrieve recycler parameters", this.getServerName());
            TraceUtil.trace1("Exception occurred: " + (smfex.getMessage() != null ? smfex.getMessage() : "Failed to retrieve model"));
            LogUtil.error(((Object)((Object)this)).getClass(), "beginSizeunitDisplay", smfex.getMessage() != null ? smfex.getMessage() : "Failed to retrieve model");
            throw new ModelControlException(smfex.getMessage());
        }
        TraceUtil.trace3("Exiting");
        return true;
    }

    private String getEditableValue(String type, int index) throws SamFSException {
        TraceUtil.trace3("Entering");
        String value = null;
        SamQFSSystemModel sysModel = SamUtil.getModel(this.getServerName());
        if (sysModel == null) {
            throw new SamFSException(null, -2001);
        }
        RecycleParams[] recyclers = sysModel.getSamQFSSystemArchiveManager43().getRecycleParams();
        if (recyclers.length == 0) {
            if (type.equals("report")) {
                return "false";
            }
            return "";
        }
        RecycleParams recycler = recyclers[index];
        if (type.equals("report")) {
            value = recycler.isPerform() ? "true" : "false";
        } else if (type.equals("hwm")) {
            value = Integer.toString(recycler.getHWM());
        } else if (type.equals("mini")) {
            value = Integer.toString(recycler.getMinGain());
        } else if (type.equals("vsn")) {
            value = Integer.toString(recycler.getVSNLimit());
        } else if (type.equals("size")) {
            value = Long.toString(recycler.getSizeLimit());
        } else if (type.equals("sizeunit")) {
            int unit = recycler.getSizeUnit();
            value = unit == -1 ? "dash" : SamUtil.getSizeUnitString(unit);
        }
        TraceUtil.trace3("Exiting");
        return value;
    }

    private String getServerName() {
        return (String)this.getParentViewBean().getPageSessionAttribute("SERVER_NAME");
    }
}

